# @(#)$Mu: make/sys.mpras-gcc.mk,v 1.20 $
##
## sys.mpras-gcc.mk
##	system makefile for AT&T MP-RAS with gcc 2.7.2
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

sysname    = UNIX_SV 3.0 (gcc)
sys        = SY_MPRAS
mk-cde     = no
mk-putenv  = no
mk-xpm     = yes
mk-xnt     = no
mk-libhelp = no

##
## if you want to use the libXpm.a that comes with the system,
## you'll have to get strcasecmp() from somewhere (probably -lucb);
## I solved the problem by recompiling libXpm to avoid getting
## symbols out of the ucb lib that really should be coming from
## libc.
##
cc       = gcc
perl     = /usr/local/bin/perl
warn     = -ansi -pedantic -Wall -Werror -Wmissing-prototypes
defs     = -D$(sys) -D_POSIX_SOURCE -D_XOPEN_SOURCE
opt      = -O
incl     = -I. -I/usr/local/include
ldflags  = -s $(opt) -L/usr/local/lib
xlibs    = -lXm -lXpm -lXmu -lXt -lXext -lX11 -lm -lnsl -lsocket -lgen
hlibs    = -lhlpclient
ar       = ar
arflags  = r
m4       = $(top)/tools/p4 -P

defs_socket = -DBUSTED_SYS_TYPES

dep    = makedepend
dflags = -f-

mkdir    = mkdirhier
install  = $(top)/tools/mutstall
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
docdir   = /usr/local/lib/$(projname)
docflags = -o bin -g bin -m 644
addir    = $(docdir)
adflags  = $(docflags)
