# @(#)$Mu: make/sys.hpux-c89.mk,v 1.35 $
##
## sys.hpux-c89.mk
##	System dependent makefile for HP-UX 9.05 with c89.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

sysname    = HP-UX 9.05 (c89)
sys        = SY_HPUX
mk-cde     = no
mk-putenv  = yes
mk-xpm     = yes
mk-xnt     = no
mk-libhelp = no

cc       = c89
perl     = /usr/local/bin/perl
purify   = purify -chain-length="10"
quantify = quantify
cover    = purecov
warn     = -z +w2
defs     = -D$(sys) -D_POSIX_SOURCE -D_HPUX_SOURCE
opt      = -O
incl     = -I. -I/usr/local/include -I/usr/include/Motif1.2 -I/usr/X11/include
ldflags  = -s $(opt) -L/usr/local/lib -L/usr/lib/X11R5 -L/usr/lib/Motif1.2
xlibs    = -lXm -lXpm -lXmu -lXt -lX11 -lm
hlibs    = -lhlpclient
ar       = ar
arflags  = r
m4       = $(top)/tools/p4 -P

dep    = makedepend
dflags = -f-

mkdir    = mkdirhier
install  = $(top)/tools/mutstall
bindir   = /usr/local/bin
binflags = -o bin -g bin -m 755
mandir   = /usr/local/man/man1
manflags = -o bin -g bin -m 644
docdir   = /usr/local/lib/$(projname)
docflags = $(manflags)
addir    = $(docdir)
adflags  = $(docflags)
