# @(#)$Mu: make/sys.TEMPLATE.mk,v 1.41 $
##
## sys.TEMPLATE.mk
##	Boiler plate system makefile for mu's makefiles.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

##
## system dependent variables:
##
##	addir		where to install the app-defaults file
##	adflags		install flags for app-defaults files
##	ar		archive maker
##	arflags		flags for ar
##	bindir		where to install the binaries
##	binflags	install flags for binaries
##	cc		what compiler to use
##	cover		purecov from Pure Software (if you have it)
##	defs		any extra preprocessor macros that you need
##	dep		dependency generator
##	defs_socket	extra macro stuff for getting the various socket
##			headers to work properly in a POSIXish environment
##	dflags		flags for dep
##	docdir		where to install the documentation
##	docflags	install flags for the documentation
##	incl		include paths
##	install		bsd-ish install program (GNU install works)
##	ldflags		linker flags
##	xlibs		X and system libraries to link in
##	hlibs		libhelp libraries, you can set this to either
##			"-lhlpclient" or "-lhelp -lButtFace -lhtmlw"
##	mandir		where to install the man pages
##	manflags	install flags for man pages
##	mkdir		somethat that will create whole directories trees
##			without complaining if they are already there,
##			mkdirhier from the X distribution should work
##	opt		optimization/debugging flags
##	perl		full path to your perl5 interpreter; most of the
##			time you won't have to care about this (I try to
##			limit my perl usage to things that only I will need
##			(i.e. things that are not needed to build/install
##			programs)).
##	m4		the m4 macro processor (this is not needed unless
##			you're hacking the documentation or the .ad.in
##			file), if you don't have a real (i.e. GNU) m4,
##			you can use the dumb stupid $(top)/tools/p4
##			emulator (this is just enough to deal with the
##			m4 that I'm using, don't expect very much).
##	purify		purify from Pure Software (if you have it)
##	quantify	quantify from Pure Software (if you have it)
##	sys		system identifier
##	sysname		system name
##	warn		warning flags for the compiler
##
## If you want to added -D's just for certain files, then you can
## define defs_xxx where xxx is the source file (without extension)
## of interest.
##
## If you have CDE, set mk-cde to yes; if you don't have Xpm,
## set mk-xpm to no and remove -lXpm from libs.  If you have Xnt
## from the eXode project (the url should go here,,,), then set
## mk-xnt to yes.  If you have libhelp, set mk-libhelp to yes.
## SGI, CDE, Xnt, and libhelp help are not yet supported but they
## will be eventually.
##
## You can get more information about XntHelp from:
##
##	http://www.xs4all.nl/~ripley
##
## and libhelp from
##
##	http://www.informatik.uni-stuttgart.de/ipvr/bv/personen/mache/libhelp
##
## If you are having problems with socket things (wlib/dirtysocks.c
## for example), then try various combinations of
##
##	-U_POSIX_SOURCE, -U_XOPEN_SOURCE
##	-DBUSTED_SYS_TYPES, -DFDOPEN_BY_HAND
##
## in defs_socket to make things work.  The existing sys.XXX.mk files
## provide some examples.
##
## You shouldn't have to modify anything else.
##

##
## operating system and version/compiler
##
sysname    = operating system and version
sys        = SY_
mk-cde     = no
mk-putenv  = no
mk-xpm     = yes
mk-xnt     = no
mk-libhelp = no

cc       =
perl     =
purify   =
quantify =
cover    =
warn     = 
defs     = -D$(sys)
opt      =
incl     = -I.
ldflags  =
xlibs    = -lXm -lXpm -lXmu -lXt -lX11 -lm
hlibs    = -lhlpclient
ar       =
arflags  =
m4       = $(top)/tools/p4 -P

dep    =
dflags =

defs_socket =

mkdir    =
install  =
bindir   =
binflags =
mandir   =
manflags =
docdir   = /usr/local/lib/$(projname)
docflags = $(manflags)
addir    = $(docdir)
adflags  = $(docflags)
