# @(#)$Mu: make/executable.mk,v 1.8 $
##
## executable.mk
##	Auxillary make rules for mu's makefiles.
##
## Copyright (C) 1996  Eric A. Howe
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##   Authors:	Matthew D. Francey
##		Eric A. Howe (mu@echo-on.net)
##

##
## This Makefile requires GNU Make
##

all:: $(exe)

ifeq ($(mk-libhelp), no)
hlibs =
endif
libs = $($(exe)-libs) $(hlibs) $(xlibs)

##
## generate $(exe)_bld_.o
##
verprefix = bld_
define mkver
    $(top)/tools/mkver '$(verprefix)' '$(version)' '$(verstatus)' \
        '$(sysname)' '$(MAKE)' '$(defs)' '$(libs)' '$(ldflags)' \
        '$(warn)' '$(opt)' '$(cc)' '$(incl)'
endef

##
## build the executable
##
rclean += $(exe)
$(exe):: $(objs) $($(exe)-deps)
	@$(mkver)
	$(cc) $(ldflags) -o $(exe) $(objs) _$(verprefix).o $(libs)
	@rm -f _$(verprefix).o

##
## build a purified executable (if you don't have purify available,
## then I pity you)
##
ifdef purify
rclean += $(exe)_p
pure:: purify
purify:: $(exe)_p $($(exe)_deps)
$(exe)_p:: $(objs)
	@$(mkver)
	$(purify) $(cc) $(ldflags) -o $(exe)_p $(objs) _$(verprefix).o $(libs)
	@rm -f _$(verprefix).o
endif

##
## build a quantified executable
##
ifdef quantify
rclean += $(exe)_q
quant:: quantify
quantify:: $(exe)_q $($(exe)_deps)
$(exe)_q:: $(OBJS)
	@$(mkver)
	$(quantify) $(cc) $(ldflags) -o $(exe)_q $(objs) _$(verprefix).o $(libs)
	@rm -f _$(verprefix).o
endif

##
## build a covered executable
##
ifdef cover
rclean += $(exe)_c
cover:: $(exe)_c $($(exe)_deps)
$(exe)_c:: $(objs)
	@$(mkver)
	$(cover) $(cc) $(ldflags) -o $(exe)_c $(objs) _$(verprefix).o $(libs)
	@rm -f _$(verprefix).o
endif

##
## install binaries
##
install-bin:: $(exe)
	$(mkdir) $(bindir)
	$(install) $(binflags) $(exe) $(bindir)/$(exe)

install-man::
	$(mkdir) $(mandir)
	$(install) $(manflags) $(exe).1 $(mandir)/$(exe).1
