/*
 * help.c
 *	Help menu callbacks for mgv.
 *
 * Copyright (C) 1996  Eric A. Howe
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Authors:	Matthew D. Francey
 *		Eric A. Howe (mu@echo-on.net)
 */
#include	<wlib/rcs.h>
MU_ID("$Mu: mgv/help.c,v 1.72 $")

#include	<assert.h>

#include	<wlib/wlib.h>
#include	<wlib/build.h>
#include	<wlib/icons.h>
#include	<mine/mgv.h>
#include	<mine/help.h>

static String cpright =
	"MGv %s/%s\n"
	"A Motif user interface for ghostscript.\n"
	"Copyright (C) 1996,1997 Eric A. Howe, Matthew D. Francey";
static String authors =
	"Authors:\n"
	"Eric A. Howe (mu@echo-on.net, http://www.echo-on.net/~mu)\n"
	"Matthew D. Francey\n"
	"\n"
	"Based on work by:\n"
	"Tim Theisen (tim@cs.wisc.edu) (Ghostview 1.5)\n"
	"and\n"
	"Johannes Plass (plass@dipmza.physik.uni-mainz.de)\n"
	"(Ghostview-VMS 2.3)";

/*
 * help->about
 */
void
mgv_help_about(Widget w, XtPointer closure, XtPointer call)
{
	MGV	*m = (MGV *)closure;
	char	buf[256];
	USEUP(w); USEUP(call);
	assert(MgvOK(m));

	if(m->about == NULL) {
		sprintf(buf, cpright, bld_verstring, bld_sysname);
		m->about = wl_about(m->main, buf, authors, NULL, wl_icon, NULL);
	}
	wl_dlg_popup(m->about);
}
