/*****************************************************************************

        smterm.h

        Environment:    Unix R40V3/Solaris2/Linux.


        Revision history:       @(#)smterm.h       1.1     97/06/23


        DESCRIPTION: Part of the Mdb Application.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)smterm.h      1.1		97/06/23"

static Widget		Top;
static XtAppContext	App;
static char		Class[] = "Smterm";


#ifdef TTYMON
#include "ListTree.h"

static String fall_back_res[] = {
	/*
	 * File actions.
	 */
	"*fileAction-0:			.tar tar xvof",
	"*fileAction-1:			.gz gunzip",
	"*fileAction-2:			.Z uncompress",
	"*fileAction-3:			.uu uudecode",
	"*fileAction-4:			.html netscape &",
	"*fileAction-5:			.xpm sxpm &",
	"*fileAction-6:			.gif xv &",
	"*fileAction-7:			.bmp xv &",
	"*fileAction-8:			.xbm xv &",
	"*fileAction-9:			.jpg xv &",
	"*fileAction-10:		.rle xv &",
	"*fileAction-11:		.man nroff -u0 -Tlp -man | more -s",
	"*fileAction-12:		.au play",
	"*fileAction-13:		.wav play",
	"*fileAction-14:		.mid playmidi",
	/*
	 * Other options.
	 */
	"*autoLs:			True",
	"*lsCmd:			ls -xF",
	"*matchDots:			False",
	"*defaultPrinter:		laser",
	"*mpPaper:			-a4",
	/*
	 * General X-resources.
	 */
	"*borderWidth:			0",
	"*blinkRate:			0",
	"*dragInitiatorProtocolStyle:	DRAG_NONE",
	"*dragReceiverProtocolStyle:	DRAG_NONE",
	"*cmdText.FontList:		9x15bold",
	"*XmMessageBox.labelFontList:	*-bold-r-normal--13-*",
	"*listTree*font:		*-medium-i-normal--15-*",
	"*foreground:			black",
	"*background:			gray75",
	"*borderColor:			gray75",
	"*topShadowColor:		gray82",
	"*listTree.foreground:		blue",
	"*panedWin*paneMinimum:		100",
	"*cmdText.background:		AntiqueWhite3",
	"*scrolledWindowMarginHeight:	6",
	"*scrolledWindowMarginWidth:	6",
	"*cmdText.shadowThickness:	4",
	"*cmdText.highlightOnEnter:	False",
	"*cmdText.scrollHorizontal:	False",
	"*cmdText.editable:		True",
	"*cmdText.wordWrap:		True",
	"*cmdText.editMode:		XmMULTI_LINE_EDIT",
	"*cmdText.columns:		80",
	"*cmdText.rows:			24",
	"*listTree.shadowThickness:	4",
	"*XmScrollBar.highlightOnEnter:	False",
	"*XmScrollBar.width:		25",
	"*XmScrollBar.shadowThickness:	4",
	"*listTree.height:		150",
	"*listTree.horizontalSpacing:	3",
	"*listTree.verticalSpacing:	3",
	"*listTree.highlightPath:	False",
	"*listTree.indent:		30",
	"*errorDialog.dialogTitle:	Error",
	"*infoDialog.dialogTitle:	Info",
	"*XmLabel.highlightOnEnter:	False",
	"*XmLabelGadget.highlightOnEnter: False",
	"*cancelButton.labelString:	Quit",
	"*newButton.labelString:	New",
	"*makeButton.labelString:	Make",
	"*editButton.labelString:	Edit",
	"*srcsButton.labelString:	Srcs",
	"*printButton.labelString:	Print",
	"*autoButton.labelString:	Auto",
	"*noAutoButton.labelString:	NoAuto",
	NULL
};

XtActionProc
keyUp(Widget w, XEvent *event, String *args, Cardinal *num_args),
keyDown(Widget w, XEvent *event, String *args, Cardinal *num_args),
keyBackSpace(Widget w, XEvent *event, String *args, Cardinal *num_args),
keyLeft(Widget w, XEvent *event, String *args, Cardinal *num_args),
keyRight(Widget w, XEvent *event, String *args, Cardinal *num_args),
keyEsacpe(Widget w, XEvent *event, String *args, Cardinal *num_args),
btn1Up(Widget w, XEvent *event, String *args, Cardinal *num_args),
keyNop(Widget w, XEvent *event, String *args, Cardinal *num_args);

XtActionsRec actions [] = {
	{ "keyUp",		(XtActionProc)keyUp },
	{ "keyDown",		(XtActionProc)keyDown },
	{ "keyBackSpace",	(XtActionProc)keyBackSpace },
	{ "keyLeft",		(XtActionProc)keyLeft },
	{ "keyRight",		(XtActionProc)keyRight },
	{ "keyEsacpe",		(XtActionProc)keyEsacpe },
	{ "btn1Up",		(XtActionProc)btn1Up },
	{ "keyNop",		(XtActionProc)keyNop },
};

static char extraTranslations[] =
	"<Key>osfUp:		keyUp()\n"
	"<Key>osfDown:		keyDown()\n"
	"<Key>osfBackSpace:	keyBackSpace()\n"
	"<Key>osfDelete:	keyBackSpace()\n"
	"<Key>osfLeft:		keyLeft()\n"
	"<Key>osfRight:		keyRight()\n"
	"<Key>osfCancel:	keyEsacpe()\n"
	"<Btn1Up>:		btn1Up()\n"
	"<Key>osfBeginLine:	keyNop()\n"
	"<Key>osfEndLine:	keyNop()\n"
	"<Key>osfPageUp:	keyNop()\n"
	"<Key>osfPageDown:	keyNop()\n"
	"<Key>osfInsert:	keyNop()\n"
	"<Key>osfCopy:		keyNop()\n"
	"<Key>osfCut:		keyNop()\n"
	"<Key>osfPaste:		keyNop()\n"
;

#define EDIT	8910
#define MAKE	8911
#define SELECT	8912
#define SRCS	8913
#define NEW	8914
#define AUTO	8915
#define INIT	8916

/*
 * Forward declarations.
 */
void main_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs );
static int scanDirs( Widget w, String root, ListTreeItem *lvl, Boolean init );
static void activate_cb( Widget w, XtPointer client_data, XtPointer cbs );

#if XmVERSION >= 2
extern void _XmOSGetDirEntries( 
                        String qualifiedDir,
                        String matchPattern,
                        unsigned char fileType,
                        Boolean matchDotsLiterally,
                        Boolean listWithFullPath,
			String **pEntries,
                        unsigned int *pNumEntries,
                        unsigned int *pNumAlloc) ;
#endif

#endif /* TTYMON */
/*
 * Called from misc.c
 */
XtAppContext GetAppContext(void)
{
	return(App);
}

Widget GetTopWidget(void)
{
	return(Top);
}

char *GetAppClass(void)
{
	return(Class);
}

unsigned char GetAppOrientation(void)
{
	return(XmVERTICAL);
}

/*ARGSUSED*/
void AddHelp( Widget w, String name, String help )
{
}

/*ARGSUSED*/
void close_cb( Widget top, Widget w, XmAnyCallbackStruct *cbs )
{
}

#ifndef TTYMON
void main( int argc, char *argv[] )
{
	/*
	 * Just so that we can compile.
	 */
	(void)fprintf( stderr, "%s: ptty not supported\n", argv[0] );
	exit(1);
}

void main_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
}
#endif
