/*****************************************************************************

	save.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)save.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Save and Delete db items.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)save.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Externals.
 */
extern long	NextPos;


/*
 * Delete db Item.
 */
static void delete(void)
{

	extern void copyp_close(Widget top);
	char *dbuff;
	int i;
	long ret;

	if ( (i = db_access( DB_WRITE, DB_DELETE, &ret, DB_EXACT )) < 0 ) {
		(void)xpmsg( NULL, "error: can't delete" );
		NextPos =  0;
		return;
	}

	dbuff = xread( GetKeyItem() );

	if ( ! i ) {
		(void)xpmsg( NULL, dbuff, "error: \"%s\" Not found", dbuff );
		return;
	}

	dbuff = xread( GetKeyItem() );
	(void)xpmsg( NULL, "info: \"%s\" Deleted", dbuff );

	for( i = 0; i < GetMaxItems(); i++ )
		xwrite( "", i );

	PrvSens( False );
	(void)GchSens( False );
	(void)copyp_close( (Widget)NULL );
}


/*
 * Save / Update db Item.
 */
/*ARGSUSED*/
void save( int val )
{
	char *dbuff;
	int i, pos;
	long ret;

	if ( val == DEL ) {
		delete();
		return;
	}

	if ( (pos = db_access( DB_WRITE, 0, &ret, DB_EXACT )) == -1 ) {

		(void)xpmsg( NULL, "error: can't save" );

		for( i = 0; i < GetMaxItems(); i++ )
			xwrite( "", i );

		NextPos =  0;
		return;
	}

	dbuff = xread( GetKeyItem() );

	if ( pos )
		(void)xpmsg( NULL, "info: \"%s\" Updated", dbuff );
	else
		(void)xpmsg( NULL, "info: \"%s\" Saved", dbuff );

}
