/*****************************************************************************

	print.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)print.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
		Launch the Print Dialog.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)print.c      1.9		97/06/23"

#define PR
#include "mdb.h"

/*
 * Externals.
 */
extern items	Item[];

/*
 * Local Variables.
 */
static struct	print_options Pr;
static int	Copies;
static int	TotItems;
static int	Totalloc;
static int	MPoptInd;
static int	LActive;
static int	PreSetButt = 0;
static Boolean	Fullp;
static Boolean	Label;
static Boolean	Phone;
static Boolean	Qprint;
static Boolean	InUse = False;
static Boolean	OptInUse = False;
static Boolean	*Ppend;

static char	MpOpt[80];
static char	*Sortedbf;
static char	*Pitems[MAXITEMS];
static char	*MpPaper = NULL;
static Boolean	Pcat[MAXITEMS];

static XmString	*Plist;

static Widget	PrPopUp;
static Widget	OpPopUp;
static Widget	FiltText;
static Widget	List_w;
static Widget	Copies_w;
static Widget	Printer_w;
static Widget	Hsp1_w;
static Widget	Hsp2_w;
static Widget	Hsp3_w;
static Widget	Vsp1_w;
static Widget	Vsp2_w;
static Widget	Fz_w;
static Widget	Nrow_w;
static Widget	Limit_w;
static Widget	Fm_w;
static Widget	Fmp_w;
static Widget	OpL_w;
static Widget	OptM_w;
static Widget	OptMP_w;
static Widget	Opt_w[6];
static Widget	MPopt_w[20];
static Widget	PWitem[MAXITEMS];
static Widget	LActive_w[10];
static Widget	PrtB_w;
static Widget	MpPaper_w;

/*
 * Forward declarations.
 */
static void	label_print(Widget top, Boolean stat);
static void	phoneb_print(Widget top, Boolean stat);
static void	initPrint();

static void
	setopt_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs),
	option_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs),
	preset_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs),
	preset1_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs),
	print_cb(Widget w, int cd, XmPushButtonCallbackStruct *cbs),
	qprint_cb(Widget w, int cd, XmListCallbackStruct *cbs),
	new_cb(void), ready_cb(void);

static void	wactive(Boolean stat);
static void	option_pop(void);
#if !defined(GROFF)
static void	els( char str[], int cnt );
#endif
static Widget	working(Widget top, Boolean stat);

#define QAPPL	20
#define FULLP	100
#define LABEL	101
#define PHONE	102

#define WORKCOUNT	10

#define MAXLINE ((GetMaxNameLen()+10)*2)


/*
 * The Main Action Area:
 *      LabelString:            Callback:       cbValue:        Sens:   Help:
 */
static ActionAreaItem action_items[] = {
	{ "doprintButton",	(XtCP)print_cb,		GO,	0,	QUICK },
	{ "applyButton",	(XtCP)print_cb,		APPL,	0,	HAP },
	{ "optionButton",	(XtCP)setopt_cb,	GO,	0,	HPO },
	{ "resetButton",	(XtCP)print_cb,		RESET,	0,	HRE },
	{ "saveButton",		(XtCP)print_cb,		SAVE,	0,	QUICK },
	{ "cancelButton",	(XtCP)print_cb,		QUIT,	0,	HCA },
	{ "helpButton",		(XtCP)print_cb,		HELP,	0,	QUICK },
};

/*
 * Action Area Print Options.
 */
static ActionAreaItem action1_items[] = {
	{ "saveButton",		(XtCP)setopt_cb,	SAVE,	0,	QUICK },
	{ "cancelButton",	(XtCP)setopt_cb,	QUIT,	0,	HCA },
	{ "helpButton",		(XtCP)setopt_cb,	HELP,	0,	QUICK },
};


/*
 * Launch the print Dialog.
 */
/*ARGSUSED*/
void mdbprint( Widget parent )
{

	Widget frame_w, mainform_w;
	Widget parent_w, rowcol2_w;
	Widget rowcol3_w, rowcol4_w;
	Widget form_w, form1_w;
	Widget tmp_w, *wptr;

	Boolean type_used;
	Boolean sel1_used;
	Boolean sel2_used;

	int pitem;
	int i, pos, item, n, max, size, nopt;
	char *ptr, *ptrn, dbuff[1024], dbuff1[1024];
	char *class, *fparent, *opt;
	Arg args[20];

	if ( InUse == True ) {
		(void)xpmsg( PrPopUp, "info: in use" );
		return;
	}

	/*
	 * Initialize print options.
	 */
	initPrint();

	/*
	 * Create and map the print Dialog.
	 */
	PrPopUp = CreateDialog( parent, "printWin" );
	InUse = True;

        n = 0;
        if ( XDefaultDepth( XtDisplay(GetTopWidget()), 0 ) == MONOCH ) {
		XtSetArg(args[n], XmNmarginWidth,	5); n++;
		XtSetArg(args[n], XmNmarginHeight,	5); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNborderWidth,	0); n++;
        }
	
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM ); n++;
	frame_w = XmCreateFrame( PrPopUp, "frameWin", args, n );

	n = 0;
	XtSetArg(args[n], XmNborderWidth,	1); n++;
	mainform_w = XmCreateForm( frame_w, "printMainWin", args, n );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM ); n++;
	form_w = XmCreateForm( mainform_w, "printTogglebox", args, n );

	rowcol2_w = CreateRowColumn( form_w, "typeWin", XmVERTICAL, 0 );
	(void)CreateLabel( rowcol2_w, "typeLabel" );

	rowcol3_w = CreateRowColumn( form_w, "sel1Win", XmVERTICAL, 0 );
	(void)CreateLabel( rowcol3_w, "sel1Label" );

	rowcol4_w = CreateRowColumn( form_w, "sel2Win", XmVERTICAL, 0 );
	(void)CreateLabel( rowcol4_w, "sel2Label" );

	bzero( Pitems, sizeof(Pitems) );
	bzero( Pcat, sizeof(Pcat) );
	bzero( PWitem, sizeof(PWitem) );
	pitem =  0;
	type_used = sel1_used = sel2_used = False;

	/*
	 * Build the toggle button Panel.
	 */
	for ( item = 0; item < GetMaxItems(); item++ ) {

		class = GetRes( "*Item%d.class", item );

		if ( strcmp(class, TOGGLE) && strcmp(class, RADIO) )
			continue;

		fparent = GetRes( "*Item%d.parent", item );

		switch ( atoi( fparent ) ) {
			case 2: parent_w = rowcol2_w;
				Pcat[pitem] = True;
				type_used = True;
				break;
			case 3: parent_w = rowcol3_w;
				sel1_used = True;
				break;
			case 4: parent_w = rowcol4_w;
				sel2_used = True;
				break;
			default:
				continue;
		}

		n = 0;
		XtSetArg(args[n], XmNhighlightThickness,1); n++;
		XtSetArg(args[n], XmNhighlightOnEnter,  True); n++;
		XtSetArg(args[n], XmNmarginHeight,      0); n++;
		XtSetArg(args[n], XmNshadowThickness,   0); n++;

		if ( ! strcmp( class, RADIO ) ) {

			/*
			 * Unpack the Radio Field -> Toggles.
			 */
			opt = GetRes( "*Item%d.options", item );
			(void)strcpy( dbuff1, opt );

			ptr = dbuff1;
			nopt = 1;

			while((ptr=strchr( ptr, ' ' )+1) != (char *)1 ) nopt++;
			nopt = nopt > MAXRB ? MAXRB : nopt;

			ptr = dbuff1;

			for( i = 0; i < nopt; i++ ) {

				if ( (ptrn = strchr( ptr, ' ' )) != NULL )
					*ptrn = '\0';

				PWitem[pitem] = CreateToggleButton( parent_w,
						ptr, (XtCP)NULL, 0, NULL );

				XtSetValues( PWitem[pitem], args, n );

				if ( atoi( fparent ) == 2 )
					Pcat[pitem] = True;

				Pitems[pitem] = (char *)XtMalloc(80);

				(void)sprintf( Pitems[pitem++],
						"\t%03d\t%s", item, ptr );

				ptr = ++ptrn;
			}

			continue;
		}

		(void)sprintf( dbuff, "Item%d", item );
		PWitem[pitem] = CreateToggleButton( parent_w,
				dbuff, (XtCP)NULL, 0, NULL );
		XtSetValues( PWitem[pitem], args, n );

		Pitems[pitem] = (char *)XtMalloc(80);

		(void)sprintf( Pitems[pitem++], "\t%03d\t%c", item, ACTIVE );

	}

	pos = 0;
	if ( (type_used==True) || (sel1_used==True) || (sel2_used==True) ) {

		if ( type_used == True ) {
			XtVaSetValues( rowcol2_w,
				XmNleftAttachment,	XmATTACH_POSITION,
				XmNleftPosition,	pos++,
				XmNleftOffset,		8,
				NULL );

			XtManageChild(rowcol2_w);
		}

		if ( sel1_used == True ) {
			XtVaSetValues( rowcol3_w,
				XmNleftAttachment,	XmATTACH_POSITION,
				XmNleftPosition,	pos++,
				NULL );

			XtManageChild(rowcol3_w);
		}

		if ( sel2_used == True ) {
			XtVaSetValues( rowcol4_w,
				XmNleftAttachment,	XmATTACH_POSITION,
				XmNleftPosition,	pos++,
				NULL );

			XtManageChild(rowcol4_w);
		}

		XtVaSetValues( form_w, XmNfractionBase, pos, NULL );
		XtManageChild(form_w);
	}


	XtVaSetValues( tmp_w = CreateSeparator( mainform_w, 0 ),
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		form_w,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL );

	form1_w = XtVaCreateWidget( "formPWin", xmFormWidgetClass,
			mainform_w,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		tmp_w,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNbottomOffset,	42,
			NULL );

	XtManageChild(form1_w);

	tmp_w = XtVaCreateManagedWidget( "printType", xmLabelGadgetClass,
			form1_w,
			XmNy,			5,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	62,
			NULL );

	OpL_w = XtVaCreateManagedWidget( Ptype[0], xmLabelGadgetClass,
			form1_w,
			XmNy,			5,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		tmp_w,
			XmNleftOffset,		10,
			XmNwidth,		110,
			XmNalignment,		XmALIGNMENT_BEGINNING,
			NULL );

	tmp_w = XtVaCreateManagedWidget( "filterLabel", xmLabelGadgetClass,
			form1_w,
			XmNy,			40,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	62,
			NULL );

	FiltText = CreateText( form1_w, "nameFilter", QUICK );
	XtVaSetValues( FiltText,
			XmNy,			40,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftWidget,		tmp_w,
			XmNleftOffset,		10,
			XmNrightOffset,		5,
			NULL );

	tmp_w = XtVaCreateManagedWidget( "copiesLabel", xmLabelGadgetClass,
			form1_w,
			XmNy,			80,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	62,
			NULL );

	Copies_w = CreateText( form1_w, "copiesText", QUICK );
	XtVaSetValues( Copies_w,
			XmNy,			80,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		tmp_w,
			XmNleftOffset,		10,
			XmNwidth,		50,
			NULL );
	XmTextSetString( Copies_w, "1" );

	tmp_w = XtVaCreateManagedWidget( "printerLabel", xmLabelGadgetClass,
			form1_w,
			XmNy,			120,
			XmNleftAttachment,	XmATTACH_POSITION,
			XmNleftPosition,	62,
			NULL );

	Printer_w = CreateText( form1_w, "printerText", QUICK );
	XtVaSetValues( Printer_w,
			XmNy,			120,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		tmp_w,
			XmNleftOffset,		10,
			XmNwidth,		100,
			NULL );

	if ( (ptr = GetPrinter()) != NULL )
		XmTextSetString( Printer_w, ptr );

	XtVaCreateManagedWidget( "MDB", xmLabelWidgetClass,
			form1_w,
			XmNlabelType, GetMdbPixmap() ? XmPIXMAP : XmSTRING,
			XmNlabelPixmap,		GetMdbPixmap(),
			XmNhighlightOnEnter,	False,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		FiltText,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL );


	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_POSITION ); n++;
	XtSetArg(args[n], XmNrightPosition,	61); n++;
	XtSetValues( CreateSeparator( form1_w, 1 ), args, n );

	XtSetArg(args[n], XmNrightPosition,	60); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftOffset,	3); n++;
	XtSetArg(args[n], XmNselectionPolicy,	XmEXTENDED_SELECT); n++;
	XtSetArg(args[n], XmNlistSizePolicy,	XmCONSTANT); n++;
	List_w = XmCreateScrolledList( form1_w, "printListWin", args, n );
	AddHelp( List_w, "listWin", QUICK );

	XtAddCallback(List_w, XmNdefaultActionCallback, (XtCP)qprint_cb, NULL);
	XtAddCallback(List_w, XmNextendedSelectionCallback, (XtCP)new_cb, NULL);
	XtAddCallback(List_w, XmNsingleSelectionCallback, (XtCP)new_cb, NULL);

	wptr = (Widget *)XtMalloc( XtNumber(action_items) * sizeof(Widget) );

	XtVaSetValues( CreateActionArea( mainform_w, action_items,
			XtNumber(action_items), NULL, NULL, wptr, True ),
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			NULL );

	/*
	 * Pick out Print - OK button.
	 */
	PrtB_w = wptr[0];

	XtFree( (char *) wptr );

	XtManageChild(List_w);
	XtManageChild(mainform_w);
	XtManageChild(frame_w);

	MapDialog( parent, PrPopUp, 0, 100 );

	size = db_folderitems();
	max = MAXLINE;
	Plist = (XmString *)XtMalloc( sizeof(XmString) * size );
	Sortedbf = (char *)XtMalloc( size * max );

	Label = Phone = Qprint = False;
	Fullp = True;
	new_cb();
	MPoptInd = -1;
	Totalloc = 0;

	Ppend = (Boolean *)XtMalloc(sizeof(Boolean));
	*Ppend = False;

	if ( MpPaper == NULL )
		if( (MpPaper = GetRes( MPPAPER )) == NULL )
			MpPaper = MPA4;

	(void)sprintf( MpOpt, "%s -s %s", Popt[1], db_foldername() );
}


/*
 * Used by qsort.
 */
/*ARGSUSED*/
static int compar( char *s1, char *s2 )
{
	return(strcmp( s1, s2 ));
}

/*ARGSUSED*/
void print_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PrPopUp == top)))
		print_cb( NULL, QUIT, NULL );
}

/*ARGSUSED*/
void printOpt_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (OptInUse && ! top) || (OptInUse && (OpPopUp == top)))
		setopt_cb( NULL, QUIT, NULL );
}


/*
 * Action callback.
 */
/*ARGSUSED*/
static void
print_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	Widget wrk_w;
	int tot = 0;
	int how, f_type, f_all_t;
	int fatal = 0;
	int intr = 0;
	int work, n, cnt, i, first;
	int  ncopy, pitem, pos, max;
	long ret;
	char *ptr;
	char *file;
	char dbuff[1024];
	char dbuff1[1024];
	char *pitems[MAXITEMS];
	XmString str, *stp;
	FILE *pfd, *fd;
	Arg args[10];

	if ( client_data == QUIT ) {

		xpmsg_close();

		/*
		 * Any pending messages from
		 * lp must now be directed
		 * to the main window.
		 */
		if ( *Ppend == False )
			XtFree(Ppend);
		else
			*Ppend = False;

		if ( OptInUse == True )
			setopt_cb( NULL, QUIT, NULL );

		InUse = False;
		DestroyDialog(PrPopUp);

		for( i = 0; i < Totalloc; i++ )
			XmStringFree(Plist[i]);

		XtFree((char *)Plist);
		XtFree(Sortedbf);

		pitem = 0;
		while( Pitems[pitem] != NULL )
			XtFree(Pitems[pitem++]);

		return;
	}

	if ( (client_data == APPL) || (client_data == QAPPL) ) {

		label_print( PrPopUp, False );
		phoneb_print( PrPopUp, False );

		if ( client_data == QAPPL ) {
			ready_cb();
			return;
		}

		/*
		 * First check if the user has
		 * selected items from an already
		 * created list.
		 */
		XtVaGetValues( List_w, XmNselectedItems, &stp,
				XmNselectedItemCount, &tot, NULL );

		max = MAXLINE;

		for( i = 0; i < tot; i++ ) {
			XmStringGetLtoR(stp[i], XmSTRING_DEFAULT_CHARSET, &ptr);
			(void)strcpy( &Sortedbf[ i * max ], ptr );
			XtFree(ptr);
		}

		if ( tot ) {
			TotItems = tot;
			ready_cb();
			(void)xpmsg( PrPopUp,
				     "info: %d Selected Item(s) found", tot );
			return;
		}

		/*
		 * Get the state of all toggles and call
		 * db_itemlist() to get the list accordingly.
		 */
		bzero( pitems, sizeof(pitems) );
		f_type = f_all_t = pitem = 0;

		while( Pitems[pitem] != NULL ) {

			pitems[pitem] = (char *)XtMalloc(80);

			pitems[pitem][0] = '\0';

			if ( XmToggleButtonGetState(PWitem[pitem]) == True ) {

				(void)strcpy( pitems[pitem], Pitems[pitem] );

				if ( Pcat[pitem] == True )
					f_type = 1;
				else
					f_all_t = 1;

			}

			pitem++;
		}

		/*
		 * how = 0;     Find all items.
		 * how = 1;     Find all by type.
		 * how = 2;     Find all by type and items.
		 * Everyting has to pass the filter.
		 */
		how = f_type ? f_type + f_all_t : 0;
		ptr = XmTextGetString( FiltText );

		/*
		 * Fecth the list.
		 */
		if ( ( pfd = db_itemlist( pitems[0] ? pitems : NULL,
					ptr[0] ? ptr : NULL,
					how, &max )) == NULL ) {

			(void)xpmsg( PrPopUp, "error: open itemlist" );
			XtFree(ptr);
			return;
		}

		XtFree(ptr);

		pitem = 0;
		while( pitems[pitem] != NULL )
			XtFree( pitems[pitem++] );

		max = MAXLINE;
	        TotItems = tot = 0;

		/*
		 * Read and sort the list.
		 */
	        while(fgets( &Sortedbf[ tot * max ], max-1 , pfd ) != NULL) {
	                Sortedbf[(tot*max)+strlen(&Sortedbf[tot*max])-1] = '\0';
			tot++;
		}

		(void)fclose(pfd);

		if ( tot )
			(void)qsort( Sortedbf, tot, max, (sortProc)compar );

		TotItems = tot;

		/*
		 * Free any used XmStrings.
		 */
		for( i = 0; i < Totalloc; i++ )
			XmStringFree(Plist[i]);

		for( i = 0; i < tot; i++ ) {
			Plist[i] = XmStringCreateLtoR( &Sortedbf[ i * max ],
				XmSTRING_DEFAULT_CHARSET );
		}

		Totalloc = tot;

		if ( tot ) {
			ready_cb();
			(void)xpmsg( PrPopUp, "info: %d Item(s) found", tot );
			n = 0;
			XtSetArg (args[n], XmNitems, Plist ); n++;
			XtSetArg (args[n], XmNitemCount, tot ); n++;
			XtSetValues( List_w, args, n );
		} else {

			if ( ! *strcpy( dbuff, xread( GetKeyItem() ) ) ) {
				new_cb();
				n = 0;
				XtSetArg (args[n], XmNitems, (XmString)0 ); n++;
				XtSetArg (args[n], XmNitemCount, 0 ); n++;
				XtSetValues( List_w, args, n );
				errno = 0;
				(void)xpmsg( PrPopUp, "error: %s",
				"Nothing found. Check selections and filter" );
				return;
			} else {
				ready_cb();
				TotItems = 1;
				(void)xpmsg( PrPopUp,
					"info: %s fetched from main window",
					dbuff );

				/*
				 * Fetch the item on the main screen.
				 */
				if ( GetSKeyItem() ) {
					(void)sprintf( Sortedbf, "%s [%s]",
						dbuff, xread( GetSKeyItem()) );
				} else
					(void)sprintf( Sortedbf, "%s", dbuff );

				str = XmStringCreateLtoR( Sortedbf,
						XmSTRING_DEFAULT_CHARSET );

				n = 0;
				XtSetArg (args[n], XmNitems, &str ); n++;
				XtSetArg (args[n], XmNitemCount, 1 ); n++;
				XtSetValues( List_w, args, n );
			}
		}
		return;
	}

	if ( client_data == GO ) {

		new_cb();

		if ( *( ptr = XmTextGetString( Printer_w ) ) == '\0' ) {
			errno = 0;
			(void)xpmsg( Printer_w, "error: Printer Field empty" );
			XtFree(ptr);
			return;
		}
		XtFree(ptr);


		if ( !  (Copies = atoi( ptr = XmTextGetString( Copies_w ) )) ) {
			errno = 0;
			(void)xpmsg( Copies_w, "error: no copies ??" );
			XtFree( ptr );
			return;
		}
		XtFree( ptr );


 		XmListDeselectAllItems(List_w);

		/*
		 * Label, Phone or full print ?.
		 */
		if ( Label ) {
			label_print( PrPopUp, True );
			return;
		}

		if ( Phone ) {
			phoneb_print( PrPopUp, True );
			return;
		}

		/*
		 * Full print.
		 */

		wrk_w = working( PrPopUp, True );

		if ( (fd = fopen( file = GetTempFile(1), "w" )) == NULL ) {
			fatal = errno;
			(void)working( PrPopUp, False);
			errno = fatal;
			(void)xpmsg( PrPopUp, "error: open tmpfile for write" );
			return;
		}

		db_silent(True);
		first = 1;
		max = MAXLINE;
		work = 0;

		for( cnt = 0; cnt < TotItems; cnt++ ) {

			if ( work++ >= WORKCOUNT ) {
				work = 1;
				(void)sprintf(dbuff, "%d/%d", cnt, TotItems );
				str = XmStringCreateSimple( dbuff );
				XtVaSetValues(wrk_w, XmNmessageString,str,NULL);
				XmStringFree(str);
			}

			if ( CheckForInterrupt(WORKCOUNT) ) {
				intr = 1;
				break;
			}

			setitem( &Sortedbf[ cnt * max ] );

			if ( ( pos = db_access( DB_READ, 0,
						&ret, DB_EXACT )) == -1 ) {
				fatal = errno;
				break;
			}

			if ( ! pos ) {
				fatal = errno;
				break;
			}

			ncopy = Copies;
			while( ncopy-- ) {

				ptr = xread( GetKeyItem() );

				if ( ! first )
					(void)fprintf( fd, "%c%s\n", '\014',
							ptr );
				else
					(void)fprintf( fd, "%s\n", ptr );

				for( i = 0; i < GetMaxItems(); i++ ) {

					if ( ! *(ptr = xread(i)) )
						continue;

					memset( dbuff1, ' ',
							sizeof(dbuff1) );
					(void)strcpy(
					   &dbuff1[20-strlen(Item[i].title)],
					   Item[i].title );
					(void)fprintf( fd, "%s  %s\n",
						dbuff1, ptr );
				}
	
				first = 0;

			}

		}

		db_silent(False);
		(void)fclose(fd);
		(void)working( PrPopUp, False );

		if ( fatal ) {
			errno = fatal;
			(void)xpmsg( PrPopUp, "error: db access" );
			return;
		}

		if ( intr ) {
			(void)xpmsg( PrPopUp, "info: - INTERRUPTED" );
			return;
		}

		PrintCommand( PrPopUp, MPPRINT,
			ptr = XmTextGetString(Printer_w),
			file, MpOpt, MpPaper, 1, Ppend );

		XtFree(ptr);
		XmTextSetString( Copies_w, "1" );
		return;
	}

	if ( client_data == RESET ) {

		new_cb();

		TotItems = 0;

		xpmsg_close();

 		XmListDeselectAllItems(List_w);

		XtVaSetValues( List_w, XmNitemCount, 0, NULL );

		XmTextSetString( FiltText, "" );
		XmTextSetString( Copies_w, "1" );

		if ( (ptr = GetPrinter()) != NULL )
			XmTextSetString( Printer_w, ptr );

		for( i = 0; i < Totalloc; i++ )
			XmStringFree(Plist[i]);
		Totalloc = 0;

		pitem = 0;
		while( PWitem[pitem] != NULL )
			XmToggleButtonSetState( PWitem[pitem++], False, False );

		return;
	}

	if ( client_data == SAVE ) {

		new_cb();

		if ( *(ptr = XmTextGetString( Printer_w )) == '\0' ) {
			errno = 0;
			(void)xpmsg( Printer_w, "error: Printer Field empty" );
			XtFree(ptr);
			return;
		} else {
			if ( SetRes( DEFAULTPRINTER, ptr ) == NULL ) {
				(void)xpmsg( Printer_w,
					     "error: Save printer failed" );
				XtFree(ptr);
				return;
			}
		}
		XtFree(ptr);

		if ( ( ptr = getenv( "PRINTER" )) != NULL ) {
				(void)xpmsg( Printer_w,
					"info: PRINTER=%s in environment", ptr);
		}
		return;
	}

	if ( client_data == HELP ) {
		help( PrPopUp, HINDX, HPR );
	}
}


/*
 * Print Phoone Book.
 */
/*ARGSUSED*/
static void phoneb_print( Widget w, Boolean print )
{
	Widget wrk_w;
	char *ptr, *ptr1, *ptr2;
	char form[80];
	char *dbuff, dbuff1[1024];
	char *file;
	int work, i, j, pos;
	int posp = 0;
	int tabs, max;
	int marg = 5;
	int totf = 1;
	int fatal = 0;
	int intr = 0;
	int ack = 1;
	long item, ret;
	size_t len;
	XmString str;
	FILE *fd;

	bzero( form, sizeof(form) );

	if ( OptInUse == True ) {
		ptr = XmTextGetString( Fmp_w );
		(void)strcpy( form, ptr );
		(void)strcpy( Pr.phformat, ptr );
		XtFree( ptr );
	} else 
		(void)strcpy( form, Pr.phformat );
	/*
	 * Apply only.
	 */
	if ( print == False )
		return;

	if ( ! strlen( form ) ) {
		errno = 0;
		(void)xpmsg( w, "error: missing phone Format items" );
		return;
	}

	if ( (ptr = strrchr( form, '-' )) == NULL ) {
		errno = 0;
		(void)xpmsg( w, "error: missing phone Format TAB item" );
		return;
	}

	*ptr++ = '\0';
	tabs = atoi( ptr );
	if ( !tabs ) tabs = 20;

	if ( (fd = fopen( file = GetTempFile(1), "w" )) == NULL ) {
		fatal = errno;
		errno = fatal;
		(void)xpmsg( w, "error: open tmpfile for write" );
		return;
	}

	ptr = form;
	while( (ptr = strchr( ptr, ' ' )+1) != (char *)1 ) totf++;

	max = MAXLINE;
	work = 0;

	db_silent(True);
	wrk_w = working( PrPopUp, True );

	for( i = 0; i < TotItems; i++ ) {

		if ( work++ >= WORKCOUNT ) {
			work = 1;
			(void)sprintf( dbuff1, "%d/%d", i, TotItems );
			str = XmStringCreateSimple( dbuff1 );
			XtVaSetValues(wrk_w, XmNmessageString, str, NULL);
			XmStringFree(str);
		}

		if ( CheckForInterrupt(WORKCOUNT) ) {
			intr = 1;
			break;
		}

		setitem( &Sortedbf[ i * max ] );

		if ( ( pos = db_access( DB_READ, 0, &ret, DB_EXACT )) == -1 ) {
			fatal = errno;
			break;
		}

		if ( ! pos ) {
			fatal = errno;
			break;
		}

		ptr = form;
		pos = marg;	/* add a small left margin */
		memset( dbuff1, ' ', sizeof(dbuff1) );

		for( j = 0; j < totf; j++ ) {

			do {
				item = strtol( ptr, &ptr1, 0 );

				if ( Item[item].type == STEXTW )
					dbuff = "";
				else
					dbuff = xread( (int)item );

				if ( (len = strlen(dbuff)) >= tabs-2 ) {
					dbuff[tabs-2] = '\0';
					if ( (ptr2 = strrchr( dbuff,
							' ' )) != NULL )
						*ptr2 = '\0';

					len = strlen(dbuff);
				}
				(void)strncpy( &dbuff1[pos], dbuff, len );
				posp = pos+len;
				pos += tabs;
				ptr = &ptr1[1];
			} while ( *ptr1 == ',' );

			if ( *ptr1 == '|') {
				item = strtol( ptr, &ptr1, 0 );
				if ( ! len ) {
					pos -= tabs;

					if ( Item[item].type == STEXTW )
						dbuff = "";
					else
						dbuff = xread( (int)item );

					if ( (len = strlen(dbuff)) >= tabs-2 ) {
						dbuff[tabs-2] = '\0';
						if ( (ptr2 = strrchr( dbuff,
								' ' )) != NULL )
							*ptr2 = '\0';

						len = strlen(dbuff);
					}
					(void)strncpy(&dbuff1[pos], dbuff, len);
					posp = pos+len;
					pos += tabs;
				}
				ptr = &ptr1[1];
			}

			if ( *ptr1 == ' ' ) {
				dbuff1[posp++] = '\n';
				pos = posp+tabs+marg;
			}
		}

		dbuff1[posp] = '\0';

		(void)fprintf( fd, "%s\n", dbuff1 );
	}

	(void)working( PrPopUp, False);
	db_silent(False);
	(void)fclose(fd);

	if ( fatal ) {
		errno = fatal;
		(void)xpmsg( w, "error: db access" );
		return;
	}

	if ( intr ) {
		(void)xpmsg( w, "info: - INTERRUPTED" );
		return;
	}

	while( Copies-- ) {
		PrintCommand( PrPopUp, MPPRINT,
			ptr = XmTextGetString(Printer_w),
			file, MpOpt, MpPaper, ack--, Ppend);
		XtFree(ptr);
	}
	XmTextSetString( Copies_w, "1" );
}


/*
 * Addressing Label Print.
 */
/*ARGSUSED*/
static void label_print( Widget w, Boolean print )
{

	Widget wrk_w;
	double sp1, sp2, sp3, vsp1, vsp2;
	int ncopy, nrow, cnt;
	int work, fz, limit, i, j;
	int pos, max, val, bfind, rcnt;
	int totf = 1;
	int col = 0;
	int first = 1;
	int fatal = 0;
	int intr = 0;
	long item, ret;
	char *ptr, *ptr1;
	char *file;
	char *dbuff;
	char b1[200], b2[200], b3[200];
	char header[100];
	char tail[100];
	char newpage[100];
	char *str[3];
	char form[80];
	char wrkbuff[60];
	char *buf[4];
	XmString str1;
	FILE *fd;

	/*
	 * This routine prepares for label print
	 * through troff/groff in metric style.
	 */

	sp1 = sp2 = sp3 = vsp1 = vsp2 = fz = nrow = 0;
	bzero( form, sizeof(form) );

	if ( OptInUse == True ) {

		XmScaleGetValue( Hsp1_w, &val );
		sp1 = val / 10.0;
		Pr.hsp1val = val;
		if ( PreSetButt ) Pr.hsp1valB = val; else Pr.hsp1valA = val;

		XmScaleGetValue( Hsp2_w, &val );
		sp2 = val / 10.0;
		Pr.hsp2val = val;
		if ( PreSetButt ) Pr.hsp2valB = val; else Pr.hsp2valA = val;

		XmScaleGetValue( Hsp3_w, &val );
		sp3 = val / 10.0;
		Pr.hsp3val = val;
		if ( PreSetButt ) Pr.hsp3valB = val; else Pr.hsp3valA = val;

		XmScaleGetValue( Vsp1_w, &val );
		vsp1 = val / 10.0;
		Pr.vsp1val = val;
		if ( PreSetButt ) Pr.vsp1valB = val; else Pr.vsp1valA = val;

		XmScaleGetValue( Vsp2_w, &val );
		vsp2 = val / 10.0;
		Pr.vsp2val = val;
		if ( PreSetButt ) Pr.vsp2valB = val; else Pr.vsp2valA = val;

		XmScaleGetValue( Fz_w, &fz );
		Pr.fz = fz;
		if ( PreSetButt ) Pr.fzB = fz; else Pr.fzA = fz; 
		ptr = XmTextGetString( Nrow_w );
		nrow = atoi( ptr );
		(void)strcpy( Pr.nrow, ptr );
		(void)strcpy( PreSetButt ? Pr.nrowB : Pr.nrowA, ptr );
		XtFree( ptr );

		ptr = XmTextGetString( Limit_w );
		limit = atoi( ptr );
		(void)strcpy( Pr.climit, ptr );
		(void)strcpy( PreSetButt ? Pr.climitB : Pr.climitA, ptr );
		XtFree( ptr );

		ptr = XmTextGetString( Fm_w );
		(void)strcpy( form, ptr );
		(void)strcpy( Pr.lformat, ptr );
		XtFree( ptr );

	} else {
		sp1  = Pr.hsp1val / 10.0;
		sp2  = Pr.hsp2val / 10.0;
		sp3  = Pr.hsp3val / 10.0;
		vsp1 = Pr.vsp1val / 10.0;
		vsp2 = Pr.vsp2val / 10.0;
		fz = Pr.fz;
		nrow = atoi( Pr.nrow );
		limit = atoi( Pr.climit );
		(void)strcpy( form, Pr.lformat );
	}

	/*
	 * Apply only.
	 */
	if ( print == False )
		return;

	if ( ! strlen( form ) ) {
		errno = 0;
		(void)xpmsg( w, "error: missing label Format items" );
		return;
	}

	if ( ! (sp1+sp2+sp3+vsp1+vsp2+nrow) ) {
		errno = 0;
		(void)xpmsg( w, "error: missing label Hsp/Vsp values" );
		return;
	}

	if ( sp1 ) col++; if ( sp2 ) col++; if ( sp3 ) col++;

	if ( (fd = fopen( file = GetTempFile(1), "w" )) == NULL ) {
		fatal = errno;
		errno = fatal;
		(void)xpmsg( w, "error: open tmpfile for write" );
		return;
	}

	ptr = form;
	while( (ptr = strchr( ptr, ' ' )+1) != (char *)1 ) totf++;

	/*
	 * 5.0 = .vs = vertical line space.
	 * Do not change without check
	 * .vs in LPRINTHEADER.
	 */
	vsp2 = vsp2 - (5.0 * totf)/10.0;

	bzero( buf, sizeof(buf) );

	for( i = 0; i < col; i++ ) {
		buf[i] = (char *)XtMalloc( MAXLINE * totf );
		bzero( buf[i], MAXLINE * totf );
	}

	str[0] = b1; str[1] = b2; str[2] = b3;
	b1[0] = b2[0] = b3[0] = 0;


	/*
	 * If the LANG is set to non us, then the `.' decimal
	 * point will be replaced with `,' to upset troff.
	 * We have to restore the dots.
	 */
	if ( ! strcmp( MpPaper, MPA4 ) )
		(void)sprintf( header, LPRINTHEADERA4, sp1,sp2,sp3, vsp1, fz );
	else
		(void)sprintf( header, LPRINTHEADERUS, sp1,sp2,sp3, vsp1, fz );

	j = strlen( header );
	for( i = 0; i <j; i++ )
		if ( header[i] == ',' )
			header[i] = '.';

	(void)sprintf( tail, LPVSPACE, vsp2 );
	j = strlen( tail );
	for( i = 0; i <j; i++ )
		if ( tail[i] == ',' )
			tail[i] = '.';

	(void)sprintf( newpage, LPVBREAK, vsp1 );
	j = strlen( newpage );
	for( i = 0; i <j; i++ )
		if ( newpage[i] == ',' )
			newpage[i] = '.';

	(void)fprintf( fd, header );

	bfind = 0;
	rcnt = 0;
	max = MAXLINE;
	work = 0;
	db_silent(True);
	wrk_w = working( PrPopUp, True );

	for( cnt = 0; cnt < TotItems; cnt++ ) {

		if ( work++ >= WORKCOUNT ) {
			work = 1;
			(void)sprintf( wrkbuff, "%d/%d", cnt, TotItems );
			str1 = XmStringCreateSimple( wrkbuff );
			XtVaSetValues(wrk_w, XmNmessageString, str1, NULL);
			XmStringFree(str1);
		}

		if ( CheckForInterrupt(WORKCOUNT) ) {
			intr = 1;
			break;
		}

		setitem( &Sortedbf[ cnt * max ] );

		if ( ( pos = db_access( DB_READ, 0, &ret, DB_EXACT )) == -1 ) {
			fatal = errno;
			break;
		}

		if ( ! pos ) {
			fatal = errno;
			break;
		}


		ncopy = Copies;

		while( ncopy-- ) {

			ptr = form;
			for( j = 0; j < totf; j++ ) {

				buf[ bfind ][ j * MAXLINE ] = '\0';

				/*
				 * Group field together.
				 */
				do {
					item = strtol( ptr, &ptr1, 0 );

					if ( Item[item].type == STEXTW )
						dbuff = "";
					else {
						dbuff = xread( (int)item );
						dbuff[limit] = '\0';
					}
#if !defined(GROFF)
					els( dbuff, strlen(dbuff) );
#endif
					(void)strcat(&buf[bfind][ j * MAXLINE],
							dbuff );
					(void)strcat( &buf[bfind][ j * MAXLINE],
							" " );
					ptr = &ptr1[1];
				} while ( *ptr1 == ',' );


			}

			if ( ++bfind >= col ) {

				if ( !rcnt++ ) {
					if ( first )
						first = 0;
					else
						(void)fprintf( fd, newpage );

				}

				if ( rcnt == nrow )
					rcnt = 0;

				/*
				 * Write a line for 'col' columns.
				 */
				bfind = 0;
				for ( j = 0; j < totf; j ++ ) {
					for( i = 0; i < col; i++ )
						(void)strcpy( str[i],
							&buf[i][ j * MAXLINE] );

					(void)fprintf(fd,
							"\t%s\t%s\t%s\n.sp 0\n",
							str[0], str[1], str[2]);
				}
				if ( rcnt )
					(void)fprintf( fd, tail );
			}
		}

	}

	db_silent(False);

	if ( bfind ) {

		/*
		 * The remaining.
		 */

		for( i = bfind; i < col; i++ )
			*str[i] = '\0';

		col = bfind;

		/*
		 * Write a line for 'col' columns.
		 */
		for ( j = 0; j < totf; j ++ ) {
			for( i = 0; i < col; i++ )
				(void)strcpy( str[i], &buf[i][ j * MAXLINE] );

			(void)fprintf(fd, "\t%s\t%s\t%s\n.sp 0\n",
						str[0], str[1], str[2]);
		}
		(void)fprintf( fd, tail );
	}

	(void)fclose(fd);
	(void)working( PrPopUp, False);

	i = 0;
	while( buf[i] != NULL )
		XtFree( buf[i++] );

	if ( fatal ) {
		errno = fatal;
		(void)xpmsg( w, "error: db access" );
		return;
	}

	if ( intr ) {
		(void)xpmsg( w, "info: - INTERRUPTED" );
		return;
	}

	PrintCommand( PrPopUp, LABELPRINT,
			ptr = XmTextGetString(Printer_w),
			file, "", "", 1, Ppend );
	XtFree(ptr);
	XmTextSetString( Copies_w, "1" );
}


/*
 * Add Swedish characters.
 */
#if !defined(GROFF)
/*ARGSUSED*/
static void els( char str[], int cnt )
{
	char dbuff[1024];
	int i;
	int j = 0;

	/*
	 * R40 troff does not let 8-bit chars through, but
	 * they can be reproduced by means of escape sequences.
	 */
	dbuff[0] = '\0';

	for( i = 0; i < cnt; i++ ) {
	switch( (unsigned char)str[i] ) {
		case aring:	(void)strcat( dbuff, Raring );     j +=4; break;
		case adieresis:	(void)strcat( dbuff, Radieresis ); j +=4; break;
		case odieresis:	(void)strcat( dbuff, Rodieresis ); j +=4; break;
		case Aring:	(void)strcat( dbuff, RAring );     j +=4; break;
		case Adieresis:	(void)strcat( dbuff, RAdieresis ); j +=4; break;
		case Odieresis:	(void)strcat( dbuff, ROdieresis ); j +=4; break;
		default:	dbuff[j++] = str[i];	dbuff[j] = 0; break;
		}
	}
	(void)strcpy( str, dbuff );

}
#endif


/*
 * Launch the Print Options Dialog.
 */
static void option_pop(void)
{

	Widget frame_w, paned_w, paned1_w;
	Widget form_w, form1_w;
	Widget rowcol_w, rowcol1_w;
	Widget menub_w, radio_w, tmp_w;
	Widget prA_w, prB_w;
	Widget mpA4_w, mpUS_w;
	XmPushButtonCallbackStruct cbs;
	int n, i, witem;
	char *ptr;
	Arg args[10];

	bzero( LActive_w, sizeof(LActive_w) );
	LActive = 0;

	OpPopUp = CreateDialog( PrPopUp, "printOptWin" );
	OptInUse = True;

        n = 0;
        if ( XDefaultDepth( XtDisplay(GetTopWidget()), 0 ) == MONOCH ) {
		XtSetArg(args[n], XmNmarginWidth,	5); n++;
		XtSetArg(args[n], XmNmarginHeight,	5); n++;
		XtSetArg(args[n], XmNshadowThickness,	0); n++;
		XtSetArg(args[n], XmNborderWidth,	0); n++;
        }
	frame_w = XmCreateFrame( OpPopUp, "frameWin", args, n );

	paned_w = CreateRowColumn( frame_w, "printOptMainWin", XmVERTICAL, 1 );

	form_w = XmCreateForm( paned_w, "printScaleCWin", NULL, 0 );
	LActive_w[LActive++] = form_w;

	paned1_w = CreateRowColumn( form_w, "printScaleWin", XmVERTICAL, 0 );
	n = 0;
	XtSetArg( args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNbottomAttachment, XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNrightAttachment,	XmATTACH_POSITION ); n++;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftOffset,	3 ); n++;
	XtSetArg( args[n], XmNrightPosition,	50 ); n++;
	XtSetValues( paned1_w, args, n );

	rowcol_w = CreateRowColumn(form_w, "printScaleVWin", XmHORIZONTAL, 0);
	n = 0;
	XtSetArg( args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNtopOffset,	3 ); n++;
	XtSetArg( args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNbottomOffset,	3 ); n++;
	XtSetArg( args[n], XmNrightAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_POSITION ); n++;
	XtSetArg( args[n], XmNleftPosition,	54 ); n++;
	XtSetArg( args[n], XmNspacing,		6 ); n++;
	XtSetValues( rowcol_w, args, n );

	(void)CreateSeparator( paned_w, 0 );

	form1_w = XmCreateForm( paned_w, "printScaleDWin", NULL, 0 );
	LActive_w[LActive++] = form1_w;

	Hsp1_w = XtVaCreateWidget("hsp1Scale",
			xmScaleWidgetClass, paned1_w,
			XmNminimum,		5,
			XmNmaximum,		200,
			XmNscaleMultiple,	1,
			XmNshowValue,		True,
			XmNorientation,		XmHORIZONTAL,
			NULL );
	AddHelp( Hsp1_w, "hsp1Scale", QUICK );
	XtManageChild(Hsp1_w);

	(void)CreateSeparator( paned1_w, 0 );
	Hsp2_w = XtVaCreateWidget("hsp2Scale",
			xmScaleWidgetClass, paned1_w,
			XmNminimum,		5,
			XmNmaximum,		200,
			XmNscaleMultiple,	1,
			XmNshowValue,		True,
			XmNorientation,		XmHORIZONTAL,
			NULL );
	AddHelp( Hsp2_w, "hsp2Scale", QUICK );
	XtManageChild(Hsp2_w);

	(void)CreateSeparator( paned1_w, 0 );
	Hsp3_w = XtVaCreateWidget("hsp3Scale",
			xmScaleWidgetClass, paned1_w,
			XmNminimum,		5,
			XmNmaximum,		200,
			XmNscaleMultiple,	1,
			XmNshowValue,		True,
			XmNorientation,		XmHORIZONTAL,
			NULL );
	AddHelp( Hsp3_w, "hsp3Scale", QUICK );
	XtManageChild(Hsp3_w);

	(void)CreateSeparator(rowcol_w,1);

	Vsp1_w = XtVaCreateWidget("vsp1Scale",
			xmScaleWidgetClass, rowcol_w,
			XmNminimum,		2,
			XmNmaximum,		60,
			XmNscaleMultiple,	1,
			XmNshowValue,		True,
			XmNorientation,		XmVERTICAL,
			XmNprocessingDirection,	XmMAX_ON_BOTTOM,
			NULL );
	AddHelp( Vsp1_w, "vsp1Scale", QUICK );
	XtManageChild(Vsp1_w);

	(void)CreateSeparator(rowcol_w,1);

	Vsp2_w = XtVaCreateWidget("vsp2Scale",
			xmScaleWidgetClass, rowcol_w,
			XmNminimum,		2,
			XmNmaximum,		60,
			XmNscaleMultiple,	1,
			XmNshowValue,		True,
			XmNorientation,		XmVERTICAL,
			XmNprocessingDirection,	XmMAX_ON_BOTTOM,
			NULL );
	AddHelp( Vsp2_w, "vsp2Scale", QUICK );
	XtManageChild(Vsp2_w);

	(void)CreateSeparator(rowcol_w,1);

	Fz_w = XtVaCreateWidget("fzScale",
			xmScaleWidgetClass, rowcol_w,
			XmNminimum,		8,
			XmNmaximum,		14,
			XmNscaleMultiple,	1,
			XmNshowValue,		True,
			XmNorientation,		XmVERTICAL,
			XmNprocessingDirection,	XmMAX_ON_BOTTOM,
			NULL );
	AddHelp( Fz_w, "fzScale", QUICK );
	XtManageChild(Fz_w);

	tmp_w = CreateLabel( form1_w, "nrowLabel" );
	n = 0;
	XtSetArg( args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftOffset,	3 ); n++;
	XtSetValues( tmp_w, args, n);

	n = 0;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_WIDGET ); n++;
	XtSetArg( args[n], XmNleftWidget,	tmp_w ); n++;
	XtSetArg( args[n], XmNleftOffset,	6 ); n++;
	XtSetArg( args[n], XmNwidth,		40 ); n++;
	Nrow_w = CreateText( form1_w, "nrowLabel", NULL );
	XtSetValues( Nrow_w, args, n);

	tmp_w = CreateLabel( form1_w, "limitLabel" );
	n = 0;
	XtSetArg( args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_WIDGET ); n++;
	XtSetArg( args[n], XmNleftWidget,	Nrow_w ); n++;
	XtSetArg( args[n], XmNleftOffset,	6 ); n++;
	XtSetValues( tmp_w, args, n);

	n = 0;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_WIDGET ); n++;
	XtSetArg( args[n], XmNleftWidget,	tmp_w ); n++;
	XtSetArg( args[n], XmNleftOffset,	6 ); n++;
	XtSetArg( args[n], XmNwidth,		40 ); n++;
	Limit_w = CreateText( form1_w, "limitLabel", QUICK );
	XtSetValues( Limit_w, args, n);

	tmp_w = CreateLabel( form1_w, "formatLabel" );
	n = 0;
	XtSetArg( args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_WIDGET ); n++;
	XtSetArg( args[n], XmNleftWidget,	Limit_w ); n++;
	XtSetArg( args[n], XmNleftOffset,	6 ); n++;
	XtSetValues( tmp_w, args, n);

	n = 0;
	XtSetArg( args[n], XmNrightAttachment,	XmATTACH_POSITION ); n++;
	XtSetArg( args[n], XmNrightPosition,	69 ); n++;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_WIDGET ); n++;
	XtSetArg( args[n], XmNleftWidget,	tmp_w ); n++;
	XtSetArg( args[n], XmNleftOffset,	6 ); n++;
	Fm_w = CreateText( form1_w, "formatText", HFR );
	XtSetValues( Fm_w, args, n);
	XmTextSetString( Fm_w, Pr.lformat );

	n = 0;
	XtSetArg( args[n], XmNleftAttachment,	XmATTACH_POSITION ); n++;
	XtSetArg( args[n], XmNleftPosition,	70 ); n++;
	XtSetArg( args[n], XmNrightAttachment,	XmATTACH_FORM ); n++;
	XtSetArg( args[n], XmNborderWidth,	0 ); n++;
	XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
	XtSetArg( args[n], XmNspacing,		8); n++;
	radio_w = XmCreateRadioBox( form1_w,	"printRdPrstWin", args, n );
	XtManageChild(radio_w);

	prA_w = CreateToggleButton( radio_w, "presetButtonA",
			(XtCP)preset_cb, 0, QUICK );

	prB_w = CreateToggleButton( radio_w, "presetButtonB",
			(XtCP)preset_cb, 1, QUICK );

	XtVaSetValues( PreSetButt ? prB_w : prA_w, XmNset, True, NULL );

	cbs.event = (XEvent *)1;
	preset_cb( NULL, PreSetButt, &cbs );

	(void)CreateSeparator( paned_w, 0 );

	rowcol1_w = CreateRowColumn( paned_w, "printOpt1Win", XmHORIZONTAL, 0 );

	menub_w = XmCreatePulldownMenu( rowcol1_w, "printoptPane", NULL, 0 );

	n = 0;
	XtSetArg (args[n], XmNsubMenuId,	menub_w ); n++;
	OptM_w = XmCreateOptionMenu( rowcol1_w, "printOption", args, n );
	XtManageChild( OptM_w );

	witem = 0;
	Opt_w[witem] = CreatePushButton( menub_w,
			Ptype[witem], (XtCP)option_cb, FULLP, QUICK );
	witem++;

	Opt_w[witem] = CreatePushButton( menub_w,
			Ptype[witem], (XtCP)option_cb, LABEL, QUICK );
	witem++;

	Opt_w[witem] = CreatePushButton( menub_w,
			Ptype[witem], (XtCP)option_cb, PHONE, QUICK );

	menub_w = XmCreatePulldownMenu( rowcol1_w, "printopt1Pane", NULL, 0 );

	n = 0;
	XtSetArg (args[n], XmNsubMenuId,	menub_w ); n++;
	OptMP_w = XmCreateOptionMenu( rowcol1_w, "printOption", args, n );
	XtManageChild( OptMP_w );

	i = 0;
	while( Popt[i] != NULL ) {
		MPopt_w[i+1] =
			CreatePushButton( menub_w, Popt[i],
				(XtCP)option_cb,i+1, QUICK );
		i += 2;
	}

	(void)CreateLabel( rowcol1_w, "formatLabel" );

	n = 0;
	XtSetArg( args[n], XmNwidth,	130 ); n++;
	Fmp_w = CreateText( rowcol1_w, "formatText", HFR );
	XtSetValues( Fmp_w, args, n );
	XmTextSetString( Fmp_w, Pr.phformat );

	n = 0;
	XtSetArg( args[n], XmNspacing,		1); n++;
	XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
	MpPaper_w = XmCreateRadioBox( rowcol1_w,"mpPaperWin", args, n );
	XtManageChild(MpPaper_w);

	mpA4_w = CreateToggleButton( MpPaper_w, "mpPaperButtonA4",
			(XtCP)preset1_cb, 0, QUICK );

	mpUS_w = CreateToggleButton( MpPaper_w, "mpPaperButtonUS",
			(XtCP)preset1_cb, 1, QUICK );

	if ( MpPaper == NULL )
		ptr = GetRes( MPPAPER );
	else
		ptr = MpPaper;

	if ( ptr != NULL ) {
		if ( ! strcmp( ptr, MPA4 ) ) {
			XtVaSetValues( mpA4_w, XmNset, True, NULL );
			MpPaper = MPA4;
		} else {
			XtVaSetValues( mpUS_w, XmNset, True, NULL );
			MpPaper = MPUS;
		}
	} else {
		XtVaSetValues( mpA4_w, XmNset, True, NULL );
		MpPaper = MPA4;
	}

	(void)CreateActionArea( paned_w, action1_items,
			XtNumber(action1_items), NULL, NULL, NULL, True );

	wactive( False );

	XtManageChild(form_w);
	XtManageChild(form1_w);
	XtManageChild(paned_w);
	XtManageChild(paned1_w);
	XtManageChild(rowcol_w);
	XtManageChild(rowcol1_w);
	XtManageChild(frame_w);

	MapDialog( PrPopUp, OpPopUp, 0, 0 );
}


/*
 * Apply options.
 */
/*ARGSUSED*/
static void
setopt_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	char dbuff[20];

	if ( client_data == GO ) {

		if ( OptInUse == True ) {
			(void)xpmsg( OpPopUp, "info: in use" );
			return;
		}

		option_pop();

		if ( Fullp == True )
			option_cb( NULL, FULLP, NULL );
		if ( Label == True )
			option_cb( NULL, LABEL, NULL );
		if ( Phone == True )
			option_cb( NULL, PHONE, NULL );
		return;
	} 

	if ( client_data == QUIT ) {
		label_print( OpPopUp, False );
		phoneb_print( OpPopUp, False );
		OptInUse = False;
		DestroyDialog( OpPopUp );
		return;
	}

	if ( client_data == HELP ) {
		help( OpPopUp, HINDX, HPO );
		return;
	}

	if ( client_data == SAVE ) {

		label_print( NULL, False );

		if ( ! PreSetButt ) {

			(void)sprintf( dbuff, "%d", Pr.hsp1val );
			(void)SetRes( "*printHsp1A", dbuff );

			(void)sprintf( dbuff, "%d", Pr.hsp2val );
			(void)SetRes( "*printHsp2A", dbuff );

			(void)sprintf( dbuff, "%d", Pr.hsp3val );
			(void)SetRes( "*printHsp3A" , dbuff );

			(void)sprintf( dbuff, "%d", Pr.vsp1val );
			(void)SetRes( "*printVsp1A", dbuff );

			(void)sprintf( dbuff, "%d", Pr.vsp2val );
			(void)SetRes( "*printVsp2A", dbuff );

			(void)sprintf( dbuff, "%d", Pr.fz );
			(void)SetRes( "*printFzA", dbuff );

			(void)SetRes( "*printNrowA", Pr.nrow );

			(void)SetRes( "*printLimitA", Pr.climit );

		} else {

			(void)sprintf( dbuff, "%d", Pr.hsp1val );
			(void)SetRes( "*printHsp1B", dbuff );

			(void)sprintf( dbuff, "%d", Pr.hsp2val );
			(void)SetRes( "*printHsp2B", dbuff );

			(void)sprintf( dbuff, "%d", Pr.hsp3val );
			(void)SetRes( "*printHsp3B", dbuff );

			(void)sprintf( dbuff, "%d", Pr.vsp1val );
			(void)SetRes( "*printVsp1B", dbuff );

			(void)sprintf( dbuff, "%d", Pr.vsp2val );
			(void)SetRes( "*printVsp2B", dbuff );

			(void)sprintf( dbuff, "%d", Pr.fz );
			(void)SetRes( "*printFzB", dbuff );

			(void)SetRes( "*printNrowB", Pr.nrow );

			(void)SetRes( "*printLimitB", Pr.climit );
		}

		(void)SetRes( "*printlFormat", Pr.lformat );

		phoneb_print( NULL, False );
		(void)SetRes( "*printpFormat", Pr.phformat );
		(void)SetRes( MPPAPER, MpPaper );

		return;
	}
}


/*
 * Perform a quick print of a selected list item.
 */
/*ARGSUSED*/
static void qprint_cb( Widget w, int client_data, XmListCallbackStruct *cbs )
{

        char *ptr;

	XmStringGetLtoR(cbs->item, XmSTRING_DEFAULT_CHARSET, &ptr);

	TotItems = 1;
	(void)strcpy( Sortedbf, ptr );

	(void)xpmsg( PrPopUp, "info: quickprint of \"%s\"", ptr );
	Wait(2);

	XtFree(ptr);

	Qprint = True;
	print_cb(NULL, QAPPL, NULL);
	print_cb(NULL, GO, NULL);
}


/*
 * A new <apply> required.
 */
static void new_cb(void)
{
	XtSetSensitive( PrtB_w, False );
	xpmsg_close();
}
/*
 * Ready for print.
 */
static void ready_cb(void)
{
	XtSetSensitive( PrtB_w, True );
	xpmsg_close();
}


/*
 * Apply option changes.
 */
/*ARGSUSED*/
static void
option_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	XmString str;
	Arg args[1];

	switch( client_data ) {
		case FULLP: Fullp = True;	Label = Phone = False;	break;
		case LABEL: Label = True;	Phone = Fullp = False;	break;
		case PHONE: Phone = True;	Label = Fullp = False;	break;
	}

	if ( (client_data >= FULLP) && (client_data <= PHONE) ) {

		wactive(Label);

		XtSetSensitive( OptMP_w, Phone || Fullp );
		XtSetSensitive( Fmp_w, Phone );

		XtSetArg (args[0], XmNmenuHistory, Opt_w[client_data-FULLP] );
		XtSetValues( OptM_w, args, 1 );

		XtSetArg (args[0], XmNlabelString, &str );
		XtGetValues( Opt_w[client_data-FULLP], args, 1 );

		XtSetArg (args[0], XmNlabelString, str );
		XtSetValues( OpL_w, args, 1 );
		XmStringFree(str);

	}

	if ( client_data < FULLP ) {
		(void)sprintf( MpOpt, "%s -s %s",
			       Popt[client_data], db_foldername() );
		MPoptInd = client_data;
	}

	if ( MPoptInd != -1 ) {
		XtSetArg (args[0], XmNmenuHistory, MPopt_w[MPoptInd] );
		XtSetValues( OptMP_w, args, 1 );
	}
}


/*
 * Toggle field sensitive.
 */
/*ARGSUSED*/
static void wactive( Boolean stat )
{

	int i = 0;

	while( LActive_w[i] != NULL )
		XtSetSensitive( LActive_w[i++], stat );
}


/*
 * Restore pre-defined Addressing Label Print parameters.
 */
/*ARGSUSED*/
static void
preset_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	if ( !cbs->event )
		return;

	if ( cbs->event != (XEvent *)1 )
		label_print( NULL, False );

	PreSetButt = client_data;

	if ( ! client_data ) {
		Pr.hsp1val = Pr.hsp1valA;
		Pr.hsp2val = Pr.hsp2valA;
		Pr.hsp3val = Pr.hsp3valA;
		Pr.vsp1val = Pr.vsp1valA;
		Pr.vsp2val = Pr.vsp2valA;
		Pr.fz      = Pr.fzA;
		(void)strcpy( Pr.nrow, Pr.nrowA );
		(void)strcpy( Pr.climit, Pr.climitA );
	} else {
		Pr.hsp1val = Pr.hsp1valB;
		Pr.hsp2val = Pr.hsp2valB;
		Pr.hsp3val = Pr.hsp3valB;
		Pr.vsp1val = Pr.vsp1valB;
		Pr.vsp2val = Pr.vsp2valB;
		Pr.fz      = Pr.fzB;
		(void)strcpy( Pr.nrow, Pr.nrowB );
		(void)strcpy( Pr.climit, Pr.climitB );
	}

	XmScaleSetValue( Hsp1_w, Pr.hsp1val );

	XmScaleSetValue( Hsp2_w, Pr.hsp2val );

	XmScaleSetValue( Hsp3_w, Pr.hsp3val );

	XmScaleSetValue( Vsp1_w, Pr.vsp1val );

	XmScaleSetValue( Vsp2_w, Pr.vsp2val );

	XmScaleSetValue( Fz_w, Pr.fz );

	XmTextSetString( Nrow_w, Pr.nrow );

	XmTextSetString( Limit_w, Pr.climit );
}



/*
 * Set paper format - US/A4
 */
/*ARGSUSED*/
static void
preset1_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	if ( !cbs->event )
		return;

	if ( client_data )
		MpPaper = MPUS;
	else
		MpPaper = MPA4;
}


/*
 * Launch the work Dialog.
 */
/*ARGSUSED*/
static Widget working( Widget w, Boolean stat )
{

	if ( Qprint == True ) {
		Qprint = False;
		return(PrPopUp);
	}

	if ( TotItems < WORKCOUNT ) {
		if ( stat == True )
			xpmsg_close();
		return(PrPopUp);
	}

	if ( stat == True )
		return( xpmsg( w, "work: Please Wait..." ) );
	else
		(void)xpmsg( w, "work:" );

	return(PrPopUp);
}


/*
 * Initialize the default Print variables.
 */
static void initPrint(void)
{

	/*
	 * Initlialize Label Print Variables.
	 */

	Pr.hsp1valA = atoi( GetRes( "*printHsp1A" ) );

	Pr.hsp2valA = atoi( GetRes( "*printHsp2A" ) );

	Pr.hsp3valA = atoi( GetRes( "*printHsp3A" ) );

	Pr.vsp1valA = atoi( GetRes( "*printVsp1A" ) );

	Pr.vsp2valA = atoi( GetRes( "*printVsp2A" ) );

	Pr.fzA = atoi( GetRes( "*printFzA" ) );

	(void)strcpy( Pr.nrowA, GetRes( "*printNrowA" ) );

	(void)strcpy( Pr.climitA, GetRes( "*printLimitA" ) );

	Pr.hsp1valB = atoi( GetRes( "*printHsp1B" ) );

	Pr.hsp2valB = atoi( GetRes( "*printHsp2B" ) );

	Pr.hsp3valB = atoi( GetRes( "*printHsp3B" ) );

	Pr.vsp1valB = atoi( GetRes( "*printVsp1B" ) );

	Pr.vsp2valB = atoi( GetRes( "*printVsp2B" ) );

	Pr.fzB = atoi( GetRes( "*printFzB" ) );

	(void)strcpy( Pr.nrowB, GetRes( "*printNrowB" ) );

	(void)strcpy( Pr.climitB, GetRes( "*printLimitB" ) );

	(void)strcpy( Pr.lformat, GetRes( "*printlFormat" ) );

	(void)strcpy( Pr.phformat, GetRes( "*printpFormat" ) );

	if ( ! PreSetButt ) {
		Pr.hsp1val = Pr.hsp1valA;
		Pr.hsp2val = Pr.hsp2valA;
		Pr.hsp3val = Pr.hsp3valA;
		Pr.vsp1val = Pr.vsp1valA;
		Pr.vsp2val = Pr.vsp2valA;
		Pr.fz      = Pr.fzA;

		(void)strcpy( Pr.nrow, Pr.nrowA );
		(void)strcpy( Pr.climit, Pr.climitA );
	} else {
		Pr.hsp1val = Pr.hsp1valB;
		Pr.hsp2val = Pr.hsp2valB;
		Pr.hsp3val = Pr.hsp3valB;
		Pr.vsp1val = Pr.vsp1valB;
		Pr.vsp2val = Pr.vsp2valB;
		Pr.fz      = Pr.fzB;

		(void)strcpy( Pr.nrow, Pr.nrowB );
		(void)strcpy( Pr.climit, Pr.climitB );
	}
}

