/*****************************************************************************

	mail.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)mail.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
		     Launch the mdb mail program.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)mail.c      1.9		97/06/23"

#include "mdb.h"

/*
 * See comments in edit.c
 * about this switch.
 */
#define SHARED_SOURCE

/*
 * Local Variables.
 */
static Widget	PopUp;
static Widget	PopUp1;
static Widget	PopUp2;
static Widget	PopUp3;
static Widget	MsgWin_w;
static Widget	Msg_w;
static Widget	To_w;
static Widget	Cc_w;
static Widget	Subj_w;
static Widget	Fs_w[5];
static Widget	Filt_w;
static int	Totalloc;
static Boolean	InUse = False;
static Boolean	InUse1 = False;
static Boolean	InUse2 = False;
static Boolean	InUse3 = False;
static Boolean	InUse4 = False;
static Boolean	Spon = True;
static Boolean	*Mpend;
static Boolean	*Ppend;
static XmString	*Lbuff;
static char	ToList[1024];
static char	OrgTo[100];
static char	Filter[100];

#ifdef TTYMON
static CFILE *Cfd;
static XmTextPosition	Pofs = 1;
static Widget	Sp_w;
#endif

#define CC		4002
#define	UPDCC		4003
#define CHECKENV	4004

#define UUENC		5000
#define CPENC		5001

#define MAILF0		"Subject: %s\nTo: %s\n"
#define MAILF1		"X-Mailer: MDB [version 1.9]\n"
#if defined(linux)
#define DEF_MDB_MAIL	"/bin/mail -v"
#else
#define MAILX
#define DEF_MDB_MAIL	"/usr/bin/mailx -t"
#define MDB_MAIL	"MDB_MAIL"
#endif
#define MOTION		747

#ifdef	SHARED_SOURCE
static Widget		Msg1_w;
static Boolean		Splitted = False;
#define SPLIT		746
#endif

/*
 * Header messages for encoded files.
 */
#if !defined(lint) && !defined(__lint)
static char *uumsg = {"\n\
-------------------------------------------------------------\n\
This  is  an  uuencoded  attachment.  Save  the  contents  to\n\
a <file>, and then run the command uudecode <file> to extract\n\
the file %s.\n\
-- Cut Here -------------------------------------------------\n\
"};
static char *cpmsg = {"\n\
-------------------------------------------------------------\n\
This  is  a compressed  and  uuencoded  attachment.  Save the\n\
contents to a <file> and then run the command uudecode <file>\n\
followed by uncompress %s.Z to extract the file %s.\n\
-- Cut Here -------------------------------------------------\n\
"};
static
char *noPrt = {"\
There is no default printer defined.\n\
Use the \"Print\" Dialog to define a Printer.\
"};
#endif

/*
 * Forward Declararions.
 */
static void
	mail1_cb( Widget w, int cd, XmAnyCallbackStruct *cbs ),
	cc_cb( Widget w, int cd, XmPushButtonCallbackStruct *cbs ),
	list_cb( Widget w, int cd, XmPushButtonCallbackStruct *cbs ),
	saves_cb( Widget w, int cd, XmPushButtonCallbackStruct *cbs ),
	saves1_cb( Widget w, int cd, XmFileSelectionBoxCallbackStruct *cbs ),
	print_msg( char *cc );
/*
 * Hera we are avoiding the usual
 * QUIT since CreateActionArea()
 * will make the QUIT button the
 * dialog's default button, and
 * we don't want that here.
 */
#define DONE	745

/*
 * The Main Action Area:
 *      LabelString:            Callback:       cbValue:        Sens:   Help:
 */
static ActionAreaItem action_items[] = {
	{ "sendButton",		(XtCP)mail1_cb, OK,		0,	QUICK },
	{ "ccButton",		(XtCP)cc_cb,    CC,		0,	QUICK },
#ifdef SHARED_SOURCE
	{ "splitButton",	(XtCP)mail1_cb, SPLIT,		0,	QUICK },
#endif
	{ "resetButton",	(XtCP)mail1_cb, RESET,		0,	HRE },
	{ "cancelButton",	(XtCP)mail1_cb,	DONE,		0,	HCA },
	{ "helpButton",		(XtCP)mail1_cb,	HELP,		0,	QUICK },
};


static ActionAreaItem action_items1[] = {
	{ "filterButton",	(XtCP)list_cb,	GO,		0,	QUICK },
	{ "cancelButton",	(XtCP)list_cb,	QUIT,		0,	HCA },
	{ "helpButton",		(XtCP)list_cb,	HELP,		0,	QUICK },
};

static MenuItem FileItems[] = {
	{ "openButton",	  (XtCP)mail1_cb, OPEN,	1,	0,	0,	QUICK },
	{ "savesButton",  (XtCP)saves_cb, SAVE,	1,	0,	0,	QUICK },
	{ "mprintButton", (XtCP)mail1_cb, PRINT,1,	0,	0,	QUICK },
	{ "tsearchButton",(XtCP)mail1_cb,SEARCH,1,	0,	0,	QUICK },
	{ "doneButton",   (XtCP)mail1_cb, DONE,	1,	0,	0,	HCA },
};


/*
 * Include file callback.
 */
/*ARGSUSED*/
static void
incfile_cb( Widget w, int client_data, XmFileSelectionBoxCallbackStruct *cbs )
{
	Boolean spon, uu, cp;
	char *path, *file, *ptr;
	char *in;
	XmTextPosition pos = XmTextGetInsertionPosition(Msg_w);
	char cmd[PATH_MAX*3];
	char fname[PATH_MAX];
	char tmpf[PATH_MAX];
	struct stat sbuf;
	FILE *fd;

	xpmsg_close();

	if ( client_data == QUIT ) {

		if ( ! InUse3 )
			return;

		InUse3 = False;
		XtDestroyWidget(PopUp3);
		return;
	}

	if ( client_data != OK )
		return;


	if ( ! XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &path) )
		return;
 
	if ( stat( path, &sbuf ) < 0 ) {
		(void)xpmsg( w, "error: %s", path );
		XtFree(path);
		return;
	}
	if ( (sbuf.st_mode & S_IFMT) != S_IFREG ) {
		XtFree(path);
		return;
	}

	if ( (ptr = strrchr( path, '/' )) != NULL )
		(void)strcpy( fname, ++ptr );
	else
		(void)strcpy( fname, path );

	*tmpf = '\0';

	XtVaGetValues( Fs_w[2], XmNset, &uu, NULL );
	XtVaGetValues( Fs_w[3], XmNset, &cp, NULL );

	file = path;

	if ( uu == True ) {
		/*
		 * uuencode file.
		 */
		(void)sprintf( tmpf, "/usr/tmp/%s", fname );
		(void)sprintf(cmd, "uuencode %s %s >%s", path, fname, tmpf);
		file = tmpf;

		if ( system( cmd ) ) {
			XtFree(path);
			(void)unlink(tmpf);
			InUse3 = False;
			XtDestroyWidget(PopUp3);
			(void)xpmsg( PopUp, "error: %s failed", cmd );
			return;
		}
		spon = Spon;
		Spon = False;
#if !defined(lint) && !defined(__lint)
		(void)sprintf( cmd, uumsg, fname );
#endif
		XmTextInsert( Msg_w, pos, cmd );
		Spon = spon;
	}

	if ( cp == True ) {
		/*
		 * compress and uuencode file.
		 */
		(void)sprintf( tmpf, "/usr/tmp/%s", fname );
		(void)sprintf( cmd, "%s.Z", tmpf );
		(void)unlink(cmd);
		(void)sprintf( cmd, "cp %s %s; compress %s 2>/dev/null",
			       path, tmpf, tmpf );
		(void)system( cmd );
		(void)sprintf( cmd, "uuencode %s.Z %s.Z >%s.uu",
			      tmpf, fname, tmpf);
		if ( system( cmd ) ) {
			XtFree(path);
			(void)unlink(tmpf);
			InUse3 = False;
			XtDestroyWidget(PopUp3);
			(void)xpmsg( PopUp, "error: %s failed", cmd );
			return;
		}
		(void)unlink(tmpf);
		(void)sprintf( cmd, "%s.Z", tmpf );
		(void)unlink(cmd);
		(void)strcat( tmpf, ".uu" );
		file = tmpf;
		spon = Spon;
		Spon = False;
#if !defined(lint) && !defined(__lint)
		(void)sprintf( cmd, cpmsg, fname, fname );
#endif
		XmTextInsert( Msg_w, pos, cmd );
		Spon = spon;
	}

	if ( stat( file, &sbuf ) < 0 ) {
		(void)xpmsg( w, "error: %s", file );
		XtFree(path);
		if ( *tmpf )
			(void)unlink(tmpf);
		return;
	}

	if ( (fd = fopen( file, "r" )) == NULL ) {
		(void)xpmsg( PopUp, "error: %s", file );
		XtFree(path);
		if ( *tmpf )
			(void)unlink(tmpf);
		return;
	}

	in = XtMalloc( sbuf.st_size );

	if ( fread( in, sizeof(char), sbuf.st_size, fd ) != sbuf.st_size ) {
		(void)xpmsg( PopUp, "error: %s", file );
		XtFree( in );
		XtFree(path);
		(void)fclose(fd);
		if ( *tmpf )
			(void)unlink(tmpf);
		return;
	}

	XtFree(path);
	(void)fclose(fd);
	if ( *tmpf )
		(void)unlink(tmpf);
	in[sbuf.st_size] = '\0';

	/*
	 * Inhibit spell check
	 * while loading text.
	 */
	spon = Spon;
	Spon = False;
	XmTextInsert( Msg_w, XmTextGetInsertionPosition(Msg_w), in );
	XmTextSetInsertionPosition( Msg_w, pos );
	XtFree( in );
	Spon = spon;

	InUse3 = False;
	XtDestroyWidget(PopUp3);
}


/*
 * Schedule a message for
 * mail service provider.
 */
/*ARGSUSED*/
static void send_msg( char *recv, char *cc )
{

	int stat = 0;
	int ofd, ifd;
	char *ptr, *ptr1, *subj, *tmpfi, *tmpfo;
	char cmd[sizeof(ToList)+200];
#if defined(MAILX)
	char *mdb_mail, to[400];
#endif
	childStat *pst;
	FILE *fd;

#if defined(MAILX)

	/*
	 * Default is to use mailx -t, i.e, mailx
	 * will read the message and scan for
	 * To: and Cc: lines, so in  this case
	 * we do not add the receivers to the
	 * command line.
	 */
	mdb_mail = getenv( MDB_MAIL );
	(void)strcpy( cmd, mdb_mail != NULL ? mdb_mail : DEF_MDB_MAIL );

	if ( mdb_mail != NULL ) {
		(void)strcat( cmd, recv );
		(void)strcpy( to, ptr1 = XmTextGetString(To_w) );
	} else {
		/*
		 * Here we use the feature of mailx
		 * to add the `pipe' user to save
		 * outgoing messages to `mailSent'.
		 */
		if ( ((ptr = GetRes( "*mailSent" )) != NULL) && *ptr ) {
			(void)sprintf( to, "%s, | cat >> %s",
				       ptr1 = XmTextGetString(To_w), ptr );
		} else
			(void)strcpy( to, ptr1 = XmTextGetString(To_w) );
	}
	XtFree(ptr1);

	if ( (fd = fopen( tmpfi = GetTempFile(1), "w" )) == NULL ) {
		(void)xpmsg( PopUp, "error: %s", cmd );
	} else {

		(void)fprintf( fd, MAILF0, subj = XmTextGetString(Subj_w), to );
		XtFree(subj);

		if ( *cc )
			(void)fputs( cc, fd );

		(void)fprintf( fd, MAILF1 );
#else
	/*
	 * Use linux mail.
	 */
	subj = XmTextGetString(Subj_w);
	(void)sprintf( cmd, "%s \"-s %s\" ", DEF_MDB_MAIL, subj );
	XtFree(subj);

	if ( *cc )
		(void)sprintf( &cmd[strlen(cmd)], "\"-c %s\" ", cc );

	(void)sprintf( &cmd[strlen(cmd)], "\"%s\"", recv );

	if ( (fd = fopen( tmpfi = GetTempFile(1), "w" )) == NULL ) {
		(void)xpmsg( PopUp, "error: %s", cmd );
	} else {

#endif


		ptr = XmTextGetString(Msg_w);
		ptr1 = GetRes( "*mailText.columns" );
		LineBreak((size_t)atoi( ptr1 == NULL ? "80" : ptr1), ptr );

		if ( fputs( ptr, fd ) == EOF ) {
			(void)xpmsg( PopUp, "error: %s", cmd );
			stat++;
		} else
			(void)fputs( "\n", fd );

		XtFree(ptr);

		if ( fclose(fd) ) {
			stat++;
			(void)xpmsg( PopUp, "error: %s", cmd );
			return;
		}


		if ( (ifd = open( tmpfi , O_RDONLY, 0400 )) < 0 ) {
			(void)xpmsg( PopUp, "error: %s", cmd );
			return;
		}

#if ! defined(linux) /* Since we using mail -v */
		(void)xpmsg( PopUp, "info: mail sent" );
#endif

		ofd = open( tmpfo = GetTempFile(1) , O_CREAT | O_WRONLY, 0600 );

		if ( (stat = ofd) == -1 ) {
			/*
			 * No ACK to GUI.
			 */
			ofd = STDOUT_FILENO;
		}

		pst = (childStat *)XtMalloc(sizeof(childStat));

		if ( (pst->pid = fork()) == 0 ) {
			(void)dup2( ifd, STDIN_FILENO );
			(void)dup2( ofd, STDOUT_FILENO );
			(void)dup2( ofd, STDERR_FILENO );
			(void)execl( "/bin/sh", "sh", "-c", cmd, NULL );
			_exit(1);
		}
		(void)close(ifd);

		if ( pst->pid == -1 ) {
			(void)xpmsg( PopUp, "error: %s", cmd );
			XtFree( (char *)pst );
			if ( stat != -1 )
				(void)close(ofd);
			(void)unlink(tmpfi);
			(void)unlink(tmpfo);
			return;
		}

		if ( stat == -1 )
			return;

		pst->w = PopUp;
		pst->retry = 1000;
		*Mpend = True; pst->pend = Mpend;
		(void)strcpy( pst->file, tmpfo );
		(void)strcpy( pst->file1, tmpfi );

		(void)XtAppAddInput( GetAppContext(), ofd,
			(XtPointer)XtInputReadMask,
			(XtInputCallbackProc)childDone, (XtPointer)pst );
	}
}


/*
 * Main Callbacks
 */
/*ARGSUSED*/
static void
mail1_cb( Widget w, int client_data, XmAnyCallbackStruct *cbs )
{

#ifdef TTYMON
	static Widget lastMsg_w;
#endif
	int i, cnt;
	Boolean spon;
	char *ptr;
	char *to, *subj;
	char recv[sizeof(ToList)+200];
	char cc[sizeof(ToList)+200];
	static char dbuff[1024];
	FILE *fd;

	if ( client_data == DONE ) {

		/*
		 * Any pending messages from
		 * mail(x) or print must now be
		 * directed to the main window.
		 */
		if ( *Mpend == False )
			XtFree(Mpend);
		else
			*Mpend = False;

		if ( *Ppend == False )
			XtFree(Ppend);
		else
			*Ppend = False;
		/*
		 * Take down any active dialogues.
		 */
		list_cb( NULL, QUIT, NULL );
		incfile_cb( NULL, QUIT, NULL );
		saves1_cb( NULL, QUIT, NULL );
#ifdef TTYMON
		detachChild(Cfd);
#endif

		InUse = False;
		DestroyDialog(PopUp);

		return;
	}

#ifdef TTYMON
	if ( client_data >= SPELLCHECK ) {
		SpellCheck( w, lastMsg_w, client_data, Cfd, &Spon, Pofs );
		return;
	}
#endif

	xpmsg_close();

	if ( client_data == UPDCC ) {
		/*
		 * The user writes data
		 * to the cc Textwidget.
		 */
		(void)strcpy( ToList, ptr = XmTextGetString(w) );
		XtFree(ptr);
		return;
	}

	/*
	 * Launch a file selection Dialog.
	 */
	if ( client_data == OPEN ) {
		Widget rc_w;
		Arg args[10];
		int n;

		if ( InUse3 == True ) {
			(void)xpmsg( PopUp3, "info: in use" );
			return;
		}

		InUse3 = True;

		PopUp3 = XmCreateFileSelectionDialog( PopUp,
				"mailIncludeFile", NULL, 0 );

		AddHelp( PopUp3, "mailIncludeFile", QUICK ); 

		XtUnmanageChild(XmFileSelectionBoxGetChild( PopUp3,
				XmDIALOG_HELP_BUTTON) );

		XtAddCallback( PopUp3, XmNcancelCallback, (XtCP)incfile_cb,
				(XtPointer)QUIT );

		XtAddCallback( PopUp3, XmNokCallback, (XtCP)incfile_cb,
				(XtPointer)OK );

		AddHelp( XmFileSelectionBoxGetChild( PopUp3,
				XmDIALOG_CANCEL_BUTTON), "", HCA );

		AddHelp( XmFileSelectionBoxGetChild( PopUp3,
				XmDIALOG_OK_BUTTON), "", HOK );

		n = 0;
		XtSetArg( args[n], XmNborderWidth,	1 ); n++;
		XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
		rc_w = XmCreateRadioBox( PopUp3,	"mailORCWin", args, n );
		XtManageChild(rc_w);

		XtVaSetValues( CreateToggleButton( rc_w, "mailNOEnc",
				(XtCP)NULL, 0, NULL ), XmNset, True, NULL );
		Fs_w[2] = CreateToggleButton( rc_w, "mailUUEnc",
				(XtCP)NULL, 0, NULL );
		Fs_w[3] = CreateToggleButton( rc_w, "mailCPEnc",
				(XtCP)NULL, 0, NULL );

		XtVaSetValues( Fs_w[2], XmNhighlightOnEnter, True, NULL );
		XtVaSetValues( Fs_w[3], XmNhighlightOnEnter, True, NULL );

		XtManageChild( rc_w );

		XtManageChild( PopUp3 );
	}

	/*
	 * Format message for send.
	 */
	if ( (client_data == OK) || (client_data == PRINT) ) {
		char *msg;

		msg = "";

		if ( client_data == OK )
			msg = "not sent";
		else if ( client_data == PRINT )
			msg = "not printed";

		if ( ! *( subj = XmTextGetString( Subj_w )) ) {
			errno = 0;
			(void)xpmsg(PopUp, "error: missing Subject, %s", msg );
			XtFree(subj);
			return;
		}
		XtFree(subj);

		if ( ! *( to = XmTextGetString( To_w )) ) {
			errno = 0;
			(void)xpmsg( PopUp, "error: missing To, %s", msg );
			XtFree(to);
			return;
		}
		XtFree(to);


		/*
		 * Refresh ToList. Make sure
		 * we end with a newline.
		 */
		(void)strcpy( ToList, ptr = XmTextGetString(Cc_w) );
		XtFree(ptr);
		if ( *ToList ) {
			if ( ToList[strlen(ToList)-1] != '\n' ) {
				(void)strcat( ToList, "\n" );
				XmTextSetString( Cc_w, ToList );
			}
			XtVaSetValues( Cc_w,
				XmNcursorPosition, strlen(ToList), NULL );
		}

#if defined(MAILX)

		/*
		 * Make a CC list.
		 */

		to = ptr = ToList;
		cnt = 0;
		*cc = '\0';
		if ( *ToList ) {
			(void)strcat( cc, "Cc: " );

			for ( i = 0; i < strlen(ToList); i++ ) {
				/*
				 * Make sure everything is
				 * properly terminated.
				 */
				if ( ToList[i] == ',' )
					ToList[i] = '\n';
			}

			/*
			 * Skip blanks.
			 */
			while( *ptr == '\n' ) ptr++;

			while( *ptr ) {

				ptr = strchr( ptr, '\n' );
				*ptr++ = '\0';
				if ( strlen(&cc[cnt]) + strlen(to) > 79 ) {
					(void)strcat( cc, "\n    " );
					cnt = strlen(cc);
				}
				(void)strcat( cc, to );
				while( *ptr == '\n' ) ptr++;
				to = ptr;
				if ( *to )
					(void)strcat( cc, ", " );
			}

			(void)strcat( cc, "\n" );
			/*
			 * Restore To list since
			 * we have 0 terminated items.
			 */
			(void)strcpy( ToList, ptr = XmTextGetString(Cc_w) );
			XtFree(ptr);
		}
#else

		/*
		 * Make a CC list.
		 */

		to = ptr = ToList;
		*cc = '\0';

		if ( *ToList ) {
			for ( i = 0; i < strlen(ToList); i++ ) {
				/*
				 * Make sure everything is
				 * properly terminated.
				 */
				if ( ToList[i] == '\n' )
					ToList[i] = ',';
			}

			/*
			 * Skip blanks.
			 */
			while( *ptr == ',' ) ptr++;

			while( *ptr ) {
				ptr = strchr( ptr, ',' );
				*ptr++ = '\0';

				(void)strcat( cc, to );
				while( *ptr == ',' ) ptr++;
				to = ptr;
				if ( *to )
					(void)strcat( cc, "," );
			}

			/*
			 * Restore To list since
			 * we have ',' terminated items.
			 */
			(void)strcpy( ToList, ptr = XmTextGetString(Cc_w) );
			XtFree(ptr);
		}
#endif


#if defined(MAILX)

		/*
		 * Make a comma separated list of
		 * receivers, the `To' receiver(s)
		 * will be appended last.
		 */
		(void)sprintf( dbuff, " %s\n", to = XmTextGetString(To_w) );
		XtFree(to);

		(void)strcat( ToList, dbuff );

		for ( i = 0; i < strlen(ToList); i++ ) {
			if ( ToList[i] == ',' )
				ToList[i] = '\n';
		}

		to = ptr = ToList;

		(void)strcpy( recv, " " );

		while( *ptr == '\n' ) ptr++;

		while( *ptr ) {
			char *ptr1;

			*(ptr = strchr( ptr, '\n' )) = '\0';
			ptr++;

			if ( (ptr1 = strchr( to, '(' )) != NULL ) {
				if ( isspace(*--ptr1) )
					*ptr1 = '\0';
				else
					*++ptr1 = '\0';
			}

			(void)strcat( recv, to );

			while( *ptr == '\n' ) ptr++;
			to = ptr;
			if ( *to )
				(void)strcat( recv, ", " );

		}
#else
		(void)strcpy( recv, to = XmTextGetString(To_w) );
		XtFree(to);
#endif

		/*
		 * Refresh ToList.
		 */
		(void)strcpy( ToList, ptr = XmTextGetString(Cc_w) );
		XtFree(ptr);

		if ( client_data == OK )
			(void)send_msg( recv, cc );
		else if ( client_data == PRINT )
			(void)print_msg( cc );

	}

	/*
	 * Reset to initial state.
	 */
	if ( client_data == RESET ) {

		spon = Spon;
		Spon = False;
#ifdef TTYMON
		XmTextSetString( Sp_w, "" );
#endif
		XmTextSetString( Cc_w, "" );
		XmTextSetString( Subj_w, "" );
		XmTextSetString( To_w, OrgTo );
		*ToList = '\0';
		*Filter = '\0';

#ifdef SHARED_SOURCE
		if ( Splitted )
			mail1_cb( NULL, SPLIT, 0 );
#endif

		/*
		 * Restore the signature file.
		 */
		(void)strcpy( dbuff, "\n--\n" );
		if ( ((ptr = GetRes( "*mailSignature" )) != NULL) && *ptr ) {
			if ( (fd = fopen( ptr, "r" )) != NULL ) {
				if ( (cnt = fread( &dbuff[4], 1,
						sizeof(dbuff)-4, fd )) > 0 ) {
					dbuff[cnt+4] = '\0';
					XmTextSetString( Msg_w, dbuff );
				}
				(void)fclose(fd);
			} else
				XmTextSetString( Msg_w, "" );
		} else 
			XmTextSetString( Msg_w, "" );

		Spon = spon;
	}

#ifdef SHARED_SOURCE
	if ( client_data == SPLIT ) {
		Dimension height, height1;
		int n;
		Arg args[10];

		/*
		 * Create / Destroy the
		 * extra Text widget.
		 */

		if ( Splitted == True ) {

			XtVaGetValues( Msg1_w, XmNheight, &height1, NULL );
			XtDestroyWidget(Msg1_w);
			/*
			 * Resize this shell to the
			 * size - sizeof deleted widget.
			 */
			XtVaGetValues( XtParent(PopUp),
					XmNheight, &height, NULL );
			XtVaSetValues( XtParent(PopUp),
					XmNheight, height-height1, NULL );
			Splitted = False;
			return;
		}

		Splitted = True;

		n = 0;
		XtSetArg(args[n], XmNsource,   	XmTextGetSource(Msg_w)); n++;
		XtSetArg(args[n], XmNscrollHorizontal,	False); n++;
		XtSetArg(args[n], XmNeditable,		True); n++;
		XtSetArg(args[n], XmNwordWrap,		True); n++;
		XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT); n++;
		Msg1_w = XmCreateScrolledText( MsgWin_w, "mailText", args, n );
		AddHelp( Msg1_w, "mailText", QUICK );
		XtManageChild(Msg1_w);

#ifdef TTYMON
		XtAddCallback( Msg1_w, XmNvalueChangedCallback,
			(XtCP)mail1_cb, (XtPointer)SPELLWORD );
		XtAddCallback( Msg1_w, XmNmotionVerifyCallback,
			(XtCP)mail1_cb, (XtPointer)MOTION );
#endif
		/*
		 * Resize shell to give space
		 * for our new Text widget.
		 */
		XtVaGetValues( XtParent(PopUp), XmNheight, &height, NULL );
		XtVaGetValues( Msg_w, XmNheight, &height1, NULL );
		XtVaSetValues(XtParent(PopUp), XmNheight, height+height1, NULL);

		return;
	}
#endif

#ifdef TTYMON
	if ( client_data == MOTION ) {
		lastMsg_w = w;
		return;
	}
#endif

	if ( client_data == SEARCH ) {
		if ( InUse4 )
			return;
		TextSearch( PopUp, Msg_w, &InUse4 );
		return;
	}

	if ( client_data == HELP )
		help( PopUp, HINDX, HQM );
}


/*ARGSUSED*/
static void print_msg( char *cc )
{
	int err;
	size_t cnt;
	char *prt, *mpp, *ptr, *ptr1;
	char *file;
	FILE *fd;

	if ( ( prt = GetPrinter()) == NULL ) {
		errno = 0;
#if !defined(lint) && !defined(__lint)
		(void)xpmsg( PopUp, "error: %s", noPrt );
#endif
		return;
	}

	if ( (fd = fopen( file = GetTempFile(1), "w" )) == NULL ) {
		errno = 0;
		(void)xpmsg( PopUp, "error: open tmpfile" );
		return;
	}

	ptr = XmTextGetString(To_w);
	ptr1 = XmTextGetString(Subj_w);
	(void)fprintf( fd, MAILF0, ptr1, ptr );
	XtFree(ptr); XtFree(ptr1);

	if ( *cc )
		(void)fputs( cc, fd );

	ptr = XmTextGetString( Msg_w );
	(void)fprintf( fd, "\n" );
	cnt = fwrite( ptr, sizeof(char), strlen(ptr), fd );
	err = errno;
	XtFree(ptr);
	(void)fclose(fd);
	if ( ! cnt ) {
		errno = err;
		(void)xpmsg( PopUp, "error: print not done" );
		return;
	}

	/*
	 * mp print command,
	 */
	if ( (mpp = GetRes( MPPAPER )) == NULL )
		mpp = MPUS;

	PrintCommand( PopUp, MPPRINT, prt, file,
			"mp -elm -folder", mpp, 1, Ppend );
}

/*ARGSUSED*/
void mail_close(Widget top, Boolean all)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top))) {
		if ( all == True )
			mail1_cb( NULL, DONE, NULL );
		else
			list_cb( NULL, QUIT, NULL );
	}
}


/*
 * Launch the Quick Mail Dialog.
 */
/*ARGSUSED*/
void mail( Widget parent )
{
	Widget main_w, form_w, tmp_w;
	Widget rowcol_w, spForm_w;
	Widget menub_w;
	Boolean spon = Spon;
	char *ptr;
	char dbuff[1024];
#ifdef TTYMON
	Dimension width;
	char *spell, *prompt;
	XmString str;
#endif
	int n;
	Arg args[20];
	FILE *fd;

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	if ( ( n = GetMailItem()) < 0 ) {
		/*
		 * Should not happen.
		 */
		errno = 0;
		(void)xpmsg( parent, "error: No Mail Item defined" );
		return;
	}
	if ( ! *xread(n) ) {
		errno = 0;
		(void)xpmsg( parent, "error: No Mail Address" );
		return;
	}

	PopUp = CreateDialog( parent, "mailWin" );
	InUse = True;
	ToList[0] = '\0';

	main_w = XmCreateForm( PopUp, "mailMainWin", NULL, 0 );

	XtVaSetValues( menub_w = CreateMenuBar( main_w ),
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			NULL );

	(void)CreatePulldownMenu( menub_w, "fileMenuLabel",
		FileItems, XtNumber(FileItems), NULL, NULL );

	XtVaSetValues( rowcol_w = CreateRowColumn( main_w,
				"mailRcWin", XmVERTICAL, 0 ),
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		menub_w,
			XmNtopOffset,		5,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			XmNspacing,		3,
			NULL );

	form_w = XtVaCreateWidget( "formWin",
			xmFormWidgetClass, rowcol_w,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		rowcol_w,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		rowcol_w,
			XmNrightAttachment,	XmATTACH_WIDGET,
			XmNrightWidget,		rowcol_w,
			NULL );


	XtVaSetValues( tmp_w = CreateLabel( form_w, "toLabel" ),
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_POSITION,
			XmNbottomPosition,	48,
			XmNwidth,		30,
			NULL );

	XtVaSetValues( To_w = CreateText( form_w, "toLabel", NULL ),
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		tmp_w,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	50,
			XmNbottomAttachment,	XmATTACH_POSITION,
			XmNbottomPosition,	48,
			NULL );

	/*
	 * Get item with Full Name.
	 */
	n = atoi( GetMailFormat() );
	if ( *xread( n ) )
		(void)sprintf( dbuff, "%s (%s)",
			       xread(GetMailItem()), xread( n ) );
	else
		(void)sprintf( dbuff, "%s", xread(GetMailItem()) );

	/*
	 * Restore if modified by verify callback.
	 */
	if ( (ptr = strchr( dbuff, '{' )) != NULL )
		*ptr = '(';
	if ( (ptr = strchr( dbuff, '}' )) != NULL )
		*ptr = ')';

	XmTextSetString( To_w, dbuff );
	(void)strcpy( OrgTo, dbuff );

	XtVaSetValues( tmp_w = CreateLabel( form_w, "subjLabel" ),
			XmNtopAttachment,	XmATTACH_POSITION,
			XmNtopPosition,		52,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNwidth,		30,
			NULL );

	XtVaSetValues( Subj_w = CreateText( form_w, "subjLabel", NULL ),
			XmNtopAttachment,	XmATTACH_POSITION,
			XmNtopPosition,		52,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		tmp_w,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_POSITION,
			XmNrightPosition,	50,
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL );

	XtVaSetValues( tmp_w = CreateLabel( form_w, "ccLabel" ),
			XmNtopAttachment,	XmATTACH_FORM,
			XmNleftAttachment,	XmATTACH_WIDGET,
			XmNleftWidget,		To_w,
			XmNleftOffset,		5,
			XmNbottomAttachment,	XmATTACH_POSITION,
			XmNbottomPosition,	48,
			NULL );

	n = 0;
	XtSetArg(args[n], XmNeditable,		True); n++;
	XtSetArg(args[n], XmNwordWrap,		False); n++;
	XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNrows,		3); n++;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_WIDGET); n++;
	XtSetArg(args[n], XmNleftWidget,	tmp_w); n++;
	XtSetArg(args[n], XmNleftOffset,	5); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;
	Cc_w = XmCreateScrolledText( form_w, "ccLabel", args, n );
	AddHelp( Cc_w, "ccLabel", QUICK );
	XtAddCallback( Cc_w, XmNvalueChangedCallback,
			(XtCP)mail1_cb, (XtPointer)UPDCC );
	XtManageChild(Cc_w);

	(void)CreateSeparator( rowcol_w, 0 );

#ifdef TTYMON
	spForm_w = XmCreateForm( rowcol_w, "spellFormWin", NULL, 0 );
#else
	spForm_w = form_w;
#endif
	MsgWin_w = XtVaCreateWidget( "mailPanedWin",
			xmPanedWindowWidgetClass, main_w,
			XmNtopAttachment,	XmATTACH_WIDGET,
			XmNtopWidget,		spForm_w,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNleftOffset,		5,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			XmNrightOffset,		5,
			XmNbottomOffset,	42,
			NULL );

	n = 0;
	XtSetArg(args[n], XmNscrollHorizontal,	False); n++;
	XtSetArg(args[n], XmNeditable,		True); n++;
	XtSetArg(args[n], XmNwordWrap,		True); n++;
	XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT); n++;
	Msg_w = XmCreateScrolledText( MsgWin_w, "mailText", args, n );
	AddHelp( Msg_w, "mailText", QUICK );
	XtManageChild(Msg_w);

#ifdef TTYMON
	if ( (spell = GetRes( "*spellProgram" )) &&
			(prompt = GetRes( "*spellPrompt" )) ) {


		tmp_w = CreateToggleButton( spForm_w, "spellButton",
				mail1_cb, SPELLON, NULL );

		if ( (ptr = strchr( spell, ' ' )) != NULL )
			*ptr = '\0';

		(void)sprintf( dbuff, "(%s) %s", spell, prompt );
		str = XmStringCreateSimple( dbuff );
		XtVaSetValues( tmp_w,
				XmNlabelString,		str,
				XmNset,			Spon,
				XmNtopAttachment,	XmATTACH_FORM,
				XmNtopOffset,		4,
				XmNleftAttachment,	XmATTACH_FORM,
				NULL );
		XmStringFree(str);
		XtVaGetValues( tmp_w, XmNwidth, &width, NULL );
		if ( ptr != NULL )
			*ptr = ' ';

		spon = Spon;
		Spon = False;

		/*
		 * The output window for spell program.
		 */
		Sp_w = CreateText( spForm_w, "spellText", NULL );

		XtVaSetValues( Sp_w, XmNeditable, False,
				XmNcursorPositionVisible, False,
				XmNleftAttachment,	XmATTACH_WIDGET,
				XmNleftWidget,		tmp_w,
				XmNleftOffset,		5,
				XmNrightAttachment,	XmATTACH_FORM,
				XmNrightOffset,		width,
				NULL );

		if ( (Cfd = attachChild( PopUp,
				spell, prompt, False, Sp_w )) != NULL ) {
			/*
			 * Activate the source window.
			 */
			XtAddCallback( Msg_w, XmNvalueChangedCallback,
				(XtCP)mail1_cb, (XtPointer)SPELLWORD );

			/*
			 * To decide which window
			 * to be spell checked.
			 */
			XtAddCallback( Msg_w, XmNmotionVerifyCallback,
				(XtCP)mail1_cb, (XtPointer)MOTION );
			/*
			 * Activate primary selection on spellText so
			 * that the user can auto correct from there.
			 */
			XtAddCallback( Sp_w, XmNgainPrimaryCallback,
				(XtCP)mail1_cb, (XtPointer)SPELLWREP );

			SpellInit( Sp_w, spell );

			/*
			 * This is to compensate for a difference
			 * in motif versions where the position
			 * is updated pre/post an insert.
			 */
			XmTextInsert( Cc_w, 0, "0" );
			Pofs = XmTextGetInsertionPosition(Cc_w);
			XmTextSetString( Cc_w, "" );
		} else {
			(void)sprintf( dbuff, "%s command FALIED", spell );
			XmTextSetString( Sp_w, dbuff );
			XtSetSensitive( spForm_w, False );
			Spon = False;
			XtVaSetValues( tmp_w, XmNset, Spon, NULL );
		}
		XtManageChild(spForm_w);
	}
#endif
	/*
	 * Add signature file.
	 */
	(void)strcpy( dbuff, "\n--\n" );
	if ( ((ptr = GetRes( "*mailSignature" )) != NULL) && *ptr ) {
		if ( (fd = fopen( ptr, "r" )) != NULL ) {
			if ( (n = fread( &dbuff[4], 1,
					sizeof(dbuff)-4, fd )) > 0 ) {
				dbuff[n+4] = '\0';
				XmTextSetString( Msg_w, dbuff );
			}
			(void)fclose(fd);
		}
	}

	tmp_w = CreateActionArea( main_w, action_items,
		XtNumber(action_items), NULL, NULL, NULL, True );
	XtVaSetValues( tmp_w,
			XmNleftAttachment,	XmATTACH_FORM,
			XmNrightAttachment,	XmATTACH_FORM,
			XmNbottomAttachment,	XmATTACH_FORM,
			NULL );

	*Filter = '\0';
	Mpend = (Boolean *)XtMalloc(sizeof(Boolean));
	*Mpend = False;
	Ppend = (Boolean *)XtMalloc(sizeof(Boolean));
	*Ppend = False;

	InUse4 = False;

	XtManageChild(rowcol_w);
	XtManageChild(MsgWin_w);
	XtManageChild(form_w);
	XtManageChild(main_w);

	MapDialog( parent, PopUp, 0, 0 );


#ifdef SHARED_SOURCE
	if ( Splitted == True ) {
		/*
		 * Restore splitted mode.
		 */
		Splitted = False;
		mail1_cb( NULL, SPLIT, 0 );
	}
#endif
	Spon = spon;

}


/*ARGSUSED*/
static void
list_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{
	int i;
	char *ptr;

	xpmsg_close();

	if ( client_data == QUIT ) {

		if ( ! InUse1 )
			return;

		InUse1 = False;
		DestroyDialog(PopUp1);

		for( i = 0; i < Totalloc; i++ )
			XmStringFree(Lbuff[i]);

		XtFree((char *)Lbuff);
		return;
	}

	if ( client_data == GO ) {
		/*
		 * Rescan with new filter.
		 */
		(void)strcpy( Filter, ptr = XmTextGetString(Filt_w) );
		XtFree(ptr);
		(void)fclose( db_itemlist( NULL,
					   *Filter ? Filter : NULL, 0, &i));
		if ( ! i ) {
			errno = 0;
			(void)xpmsg( PopUp, "info: no items found" );
			return;
		}

		list_cb( NULL, QUIT, NULL );
		cc_cb( PopUp, 0, NULL );
		return;
	}

	if ( client_data == HELP )
		help( PopUp1, HINDX, HLI );
}


/*ARGSUSED*/
static void select_cb(Widget w, int client_data, XmListCallbackStruct *cb )
{

	int n;
	char *ptr;
	char dbuff[100];

	xpmsg_close();

	XmStringGetLtoR(cb->item, XmSTRING_DEFAULT_CHARSET, &ptr);
	
	/*
	 * Show item on main screen.
	 */
	setitem(ptr);
	search_cb((Widget)NULL, GO, NULL );
	XtFree(ptr);

	/*
	 * Pick up the new mail address.
	 */
	ptr = xread( GetMailItem() );

	if ( ! *ptr ) {
		(void)xpmsg(PopUp1, "info: Sorry, no mail address registered");
		return;
	}

	/*
	 * Get item with Full Name.
	 */
	n = atoi( GetMailFormat() );
	if ( *xread( n ) )
		(void)sprintf( dbuff, "%s (%s)\n", ptr, xread( n ) );
	else
		(void)sprintf( dbuff, "%s\n", ptr );

	(void)strcat( ToList, dbuff );

	XmTextSetString( Cc_w, ToList );
	XtVaSetValues( Cc_w, XmNcursorPosition, strlen(ToList), NULL );
}


#define ERR_ENV "info: Won't work since you have\n$MDB_MAIL in environment"

/*ARGSUSED*/
static void
saves1_cb( Widget w, int client_data, XmFileSelectionBoxCallbackStruct *cbs )
{

	struct stat sbuf;
	long val = 0;
	char *ptr, *fname;

	xpmsg_close();

	if ( client_data == QUIT ) {

		if ( ! InUse2 )
			return;

		InUse2 = False;
		XtDestroyWidget(PopUp2);
	}

#if defined(MAILX)
	if ( (client_data == CHECKENV) && (XmToggleButtonGadgetGetState(w)) ) {
		if ( getenv( MDB_MAIL ) != NULL ) {
			(void)xpmsg( PopUp2, ERR_ENV );
		}
		return;
	}
#endif

	if ( client_data != OK )
		return;

	if ( ! XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &fname) )
		return;

	if ( stat( fname, &sbuf ) < 0 ) {
		(void)xpmsg( PopUp2, "error: %s", fname );
		XtFree(fname);
		return;
	}

	if ( (sbuf.st_mode & S_IFMT) != S_IFREG ) {
		errno = 0;
		(void)xpmsg( PopUp2, "error: %s: not a text file", fname );
		XtFree(fname);
		return;
	}

	XtVaGetValues( Fs_w[0], XmNset, &val, NULL );
	if ( val )
		ptr = SetRes( "*mailSignature", fname );
	else {

#if defined(linux)
		char cmd[200];
		char *tmpf;

		if ( (ptr = getenv( "HOME" )) != NULL ) {
			(void)sprintf( cmd,
			   "grep -s -v \"set record\" %s/.mailrc > %s",
			   ptr, tmpf = GetTempFile(1) );
			(void)system( cmd );

			(void)sprintf( cmd, "mv %s %s/.mailrc", tmpf, ptr );
			(void)system( cmd );

			(void)sprintf( cmd,
			   "echo \"set record=%s\" >> %s/.mailrc", fname, ptr );
			(void)system( cmd );

			(void)SetRes( "*mailSent", fname );
		}
#else
		ptr = SetRes( "*mailSent", fname );
#endif
	}

	XtFree(fname);

	InUse2 = False;
	XtDestroyWidget(PopUp2);

	if ( ptr == NULL )
		(void)xpmsg( PopUp, "error: Save Option failed" );
	else
		(void)xpmsg( PopUp, "info: Option saved. Push Reset" );

}


/*
 * Launch the Save State Dialog.
 */
/*ARGSUSED*/
static void saves_cb( Widget w, int cd, XmPushButtonCallbackStruct *cbs )
{

	Widget rowcol;
	int n;
	Arg args[10];

	xpmsg_close();

	if ( InUse2 == True ) {
		(void)xpmsg( PopUp2, "info: in use" );
		return;
	}

	PopUp2 = XmCreateFileSelectionDialog( PopUp, "saveMailWin", NULL, 0);
	InUse2 = True;

	AddHelp( PopUp2, "saveMailWin", QUICK );

	XtAddCallback( PopUp2,
		XmNokCallback, (XtCP)saves1_cb, (XtPointer)OK );

	XtAddCallback( PopUp2,
		XmNcancelCallback, (XtCP)saves1_cb,  (XtPointer)QUIT );

	AddHelp( XmFileSelectionBoxGetChild( PopUp2,
		XmDIALOG_CANCEL_BUTTON ), "", HCA );

	AddHelp( XmFileSelectionBoxGetChild( PopUp2,
		XmDIALOG_OK_BUTTON ), "", HOK );

	XtUnmanageChild( XmFileSelectionBoxGetChild( PopUp2,
			XmDIALOG_HELP_BUTTON ) );

	n = 0;
	XtSetArg( args[n], XmNspacing,		8 ); n++;
	XtSetArg( args[n], XmNborderWidth,	1 ); n++;
	XtSetArg( args[n], XmNorientation,	XmHORIZONTAL ); n++;
	rowcol = XmCreateRadioBox( PopUp2,	"rowcolRWin", args, n );
	XtManageChild(rowcol);

	Fs_w[0] = CreateToggleButton( rowcol,
			"signButton", (XtCP)NULL, 0, NULL );
	Fs_w[1] = CreateToggleButton( rowcol,
			"saveOutButton", (XtCP)saves1_cb, CHECKENV, NULL );

	XtVaSetValues( Fs_w[0], XmNset, True, NULL );

	XtVaSetValues( Fs_w[0], XmNhighlightOnEnter, True, NULL );
	XtVaSetValues( Fs_w[1], XmNhighlightOnEnter, True, NULL );

	XtManageChild( PopUp2 );
}


/*
 * Used by qsort.
 */
/*ARGSUSED*/
static int compar( char *s1, char *s2 )
{
        return(strcmp( s1, s2 ));
}

/*
 * Launch a (sorted) List Dialog.
 */
/*ARGSUSED*/
static void cc_cb( Widget w, int cd, XmPushButtonCallbackStruct *cbs )
{

	Widget main_w, list_w;
	Widget rowcol_w, rowcol1_w;
	int n, i, tot, size, max;
	char *ptr;
	Arg args[20];
	FILE *fd;

	xpmsg_close();

	if ( InUse1 == True ) {
		(void)xpmsg( PopUp1, "info: in use" );
		return;
	}

	if ( ( fd = db_itemlist( NULL, *Filter ? Filter : NULL,
						0, &size)) == NULL ) {
		(void)xpmsg( PopUp, "error: open itemlist" );
		return;
	}

	if ( ! size ) {
		errno = 0;
		(void)xpmsg( PopUp, "info: folder empty" );
		(void)fclose(fd);
		return;
	}

	InUse1 = True;

	max = (GetMaxNameLen()+10) * 2;

	Lbuff = (XmString *)XtMalloc( sizeof(XmString) * size );
	ptr = (char *)XtMalloc( size * max );


	tot = 0;
	while( fgets( &ptr[ tot * max ], max-1 , fd ) != NULL ) {
		ptr[ (tot * max)+strlen(&ptr[tot * max])-1 ] = '\0';
		tot++;
	}

	(void)qsort( ptr, tot, max, (sortProc)compar );

	for( i = 0; i < tot; i++ ) {
		Lbuff[i] = XmStringCreateLtoR( &ptr[ i * max ],
				XmSTRING_DEFAULT_CHARSET );
	}

	Totalloc = tot;

	(void)fclose(fd);
	XtFree(ptr);

	PopUp1 = CreateDialog( PopUp, "ccListllWin" );
	main_w = XmCreateForm( PopUp1, "listForm", NULL, 0 );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNbottomOffset,	85 ); n++;
	XtSetArg(args[n], XmNtopOffset,		5 ); n++;
	XtSetArg(args[n], XmNleftOffset,	5 ); n++;
	XtSetArg(args[n], XmNrightOffset,	5 ); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM ); n++;
	XtSetArg(args[n], XmNlistSizePolicy,	XmCONSTANT); n++;
	XtSetArg(args[n], XmNselectionPolicy,	XmSINGLE_SELECT); n++;
	XtSetArg(args[n], XmNvisibleItemCount,	tot > 20 ? 20 : tot+2); n++;
	list_w = XmCreateScrolledList( main_w, "listWin", args, n );
	AddHelp( list_w, "listWin", QUICK );
	
	XtAddCallback( list_w,
		XmNsingleSelectionCallback, (XtCP)select_cb, NULL );

	XtVaSetValues( XtParent(PopUp1), XtNtitle, "CC", NULL );

	rowcol_w = CreateRowColumn( main_w, "listRcWin", XmVERTICAL, 0 );
	XtVaSetValues( rowcol_w,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNrightAttachment,	XmATTACH_FORM,
		XmNrightOffset,		5,
		XmNleftAttachment,	XmATTACH_FORM,
		XmNleftOffset,		5,
		XmNspacing,		3,
		NULL );
	(void)CreateSeparator( rowcol_w, 0 );

	rowcol1_w = CreateRowColumn ( rowcol_w, "filterWin", XmHORIZONTAL, 0 );
	(void)CreateLabel( rowcol1_w, "filterLabel" );
	Filt_w = CreateText( rowcol1_w, "nameFilter", NULL );
	XmTextSetString( Filt_w, Filter );

	(void)CreateActionArea( rowcol_w, action_items1,
		XtNumber(action_items1), NULL, 0, NULL, True );

	XtManageChild(rowcol_w);
	XtManageChild(rowcol1_w);
	XtManageChild(list_w);
	XtManageChild(main_w);

	XtVaSetValues( list_w, XmNitems, Lbuff, XmNitemCount, tot, NULL );

	MapDialog( PopUp, PopUp1, 0, 0 );

}
