/*****************************************************************************

	edit.c

	Environment:    Unix R40V3/Solaris2/Linux.

	Revision history:	@(#)edit.c	1.9	97/06/23


	DESCRIPTION: Part of the Mdb Application.
			Launch an editor for the remarks field.

        COPYRIGHT NOTICE:
        Permission to use,  copy,  modify,  and  distribute  this
        software  and  its    documentation   is  hereby  granted
        without fee, provided that  the  above  copyright  notice
        appear  in all copies and that both that copyright notice
        and  this  permission   notice   appear   in   supporting
        documentation.  The   author  makes  no   representations
        about   the   suitability   of   this  software  for  any
        purpose.  It  is  provided  "as  is"  without  express or
        implied warranty.

        THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD  TO  THIS
        SOFTWARE,    INCLUDING    ALL   IMPLIED   WARRANTIES   OF
        MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHOR
        BE  LIABLE  FOR  ANY  SPECIAL,  INDIRECT OR CONSEQUENTIAL
        DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS  OF
        USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
        NEGLIGENCE  OR  OTHER  TORTIOUS   ACTION,   ARISING   OUT
        OF   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
        SOFTWARE.

******************************************************************************/
/******************************************************************************/
#pragma ident "@(#)edit.c      1.9		97/06/23"

#include "mdb.h"

/*
 * Older motif libraries does not like
 * Mutli sourced edit here since it will
 * crash mdb when the Dialog is dissmissed.
 * This has been observed on Solaris
 * library libXm.so.2. Motif Version 1.2.2.
 * Undef SHARED_SOURCE if you have that problem.
 * See also mail.c
 */
#define SHARED_SOURCE

/*
 * Externals.
 */
extern Boolean	Debug;
extern items	Item[];
extern XmTextPosition GetPofs(void);

#ifdef TTYMON
static CFILE *Cfd;
#endif

#ifndef SHARED_SOURCE
static char	*StartItem;
#endif

static Widget	PopUp;
static Widget	PopUp1;
static Widget	Ed_w;
static int	EdItem;
static Boolean	Spon = True;
static Boolean	InUse = False;
static Boolean	InUse1 = False;
static Boolean	InUse2 = False;

#define TAB	"   "

typedef struct {
	Widget textw;
	Widget self;
	Widget repw;
	XmTextPosition start;
	XmTextPosition end;
	Boolean restart;
	Boolean *inuse;
	char lastString[200];
} textSearch;

/*
 * Forward Declararions.
 */
static void edit1_cb( Widget w, int cd, XmPushButtonCallbackStruct *cbs );

static MenuItem FileItems[] = {
   { "openButton",   (XtCP)edit1_cb,	OPEN,	1,	0,	0,	QUICK },
   { "tsearchButton",(XtCP)edit1_cb,	SEARCH,	1,	0,	0,	QUICK },
   { "closeButton",  (XtCP)edit1_cb,	QUIT,	1,	0,	0,	QUICK },
};

static ActionAreaItem action_items[] = {
   { "nextButton",    0,	0,	0,	NULL },
   { "replaceButton", 0,	0,	0,	NULL },
   { "cancelButton",  0,	0,	0,	HCA },
};


/*
 * Include file callback.
 */

/*ARGSUSED*/
static void
incfile_cb( Widget w, int client_data, XmFileSelectionBoxCallbackStruct *cbs )
{
	struct stat sbuf;
	char *file, *path, *outbase;
	char *in, *out;
	XmTextPosition pos = XmTextGetInsertionPosition(Ed_w);
	size_t i, j, cnt;
	Boolean spon;
	FILE *fd;

	if ( client_data != OK )
		return;

	if ( ! XmStringGetLtoR(cbs->value, XmSTRING_DEFAULT_CHARSET, &path) )
		return;

	if ( (file = strrchr(path, '/')) == NULL )
		file = path;
	else
		file++;
 
	if (  stat( path, &sbuf ) < 0 ) {
		(void)xpmsg( PopUp1, "error: %s", file );
		XtFree(path);
		return;
	}

	if ( (sbuf.st_mode & S_IFMT) != S_IFREG ) {
		XtFree(path);
		return;
	}

	if ( (fd = fopen( path, "r" )) == NULL ) {
		(void)xpmsg( PopUp1, "error: %s", file );
		XtFree(path);
		return;
	}

	XtFree(path);

	j = (size_t)XmTextGetLastPosition(Ed_w);

	in = (char *)XtMalloc( Item[EdItem].len );
	out = outbase = (char *)XtMalloc( Item[EdItem].len + 20 );
	cnt = fread( in, sizeof(char), Item[EdItem].len-(j+1), fd );

	in[cnt] = '\0';

	(void)fclose(fd);

	if ( cnt == (Item[EdItem].len-(j+1)) ) {
		(void)xpmsg( Ed_w, "info: text truncated to %d bytes",
			Item[EdItem].len );
	}

	j = Item[EdItem].len -4;
	/*
	 * Although we filter TABs when quiting, we
	 * remove them here so that the screen wiil
	 * reflect what will be the true look of it.
	 */
	for( i = 0; i < j; i++ ) {

		/*
		 * Check that we don't grow out
		 * of buffer limit since we get
		 * extra ' ' for each tab.
		 */
		if ( ! cnt-- )
			break;

		if ( in[i] == '\t' ) {
			(void)strcpy( out, TAB );
			out += sizeof(TAB)-1;
			j -= sizeof(TAB)-2;
			continue;
		}
		*out++ = in[i];
	}
	*out = '\0';

	spon = Spon;
	Spon = False;
	XmTextInsert( Ed_w, XmTextGetInsertionPosition(Ed_w), outbase );
	XmTextSetInsertionPosition( Ed_w, pos );
	Spon = spon;

	XtFree(in);
	XtFree(outbase);
	InUse1 = False;
	XtDestroyWidget(PopUp1);
}


/*
 * Callback for Open, Quit and Clear.
 */
/*ARGSUSED*/
static void
edit1_cb( Widget w, int client_data, XmPushButtonCallbackStruct *cbs )
{

	int i, j, cnt;
	char *in, *out, *outbase;

	if ( client_data == QUIT ) {

#ifdef TTYMON
		detachChild(Cfd);
#endif
		out = outbase = (char *)XtMalloc( Item[EdItem].len + 20 );
		in = XmTextGetString(Ed_w);
		cnt = XmTextGetLastPosition(Ed_w);

		/*
		 * We don't want any true tabs in the database.
		 */
		j = Item[EdItem].len -4;
		for( i = 0; i < j; i++ ) {

			if ( ! cnt-- )
				break;

			if ( in[i] == '\t' ) {
				(void)strcpy( out, TAB );
				out += sizeof(TAB)-1;
				j -= sizeof(TAB)-2;
				continue;
			}
			*out++ = in[i];
		}
		*out = '\0';

		if ( XmTextGetLastPosition(Ed_w) ) {
			if ( *--out == '\n' )
				*out = '\0';
		}


#ifndef SHARED_SOURCE
		/*
		 * Since we are allowed to search while
		 * this dialogue is running we must make
		 * sure that we deposit the text to right
		 * item. With shared text we don't have
		 * to worry since they are practically
		 * the same widget/buffer.
		 */
		setitem(StartItem);
		search_cb((Widget)NULL, GO, NULL );
		XtFree(StartItem);
#endif
		in = GetRes( "*editText.columns" );
		LineBreak((size_t)atoi( in == NULL ? "80" : in), outbase );

		XmTextSetString( Item[EdItem].w, outbase );
		/*
		 * Restore edit mode to False since we
		 * have alterred the mode for the source
		 * widget (Remarks) as well.
		 */
		XtVaSetValues( Ed_w, XmNeditable,  False, NULL );

		XtFree(in);
		XtFree(outbase);

		if (InUse1) {
			InUse1 = False;
			XtDestroyWidget(PopUp1);
		}

		InUse = False;
		DestroyDialog(PopUp);
		return;
	}

#ifdef TTYMON
	if ( client_data >= SPELLCHECK ) {
		SpellCheck( w, Ed_w, client_data, Cfd, &Spon, GetPofs() );
		return;
	}
#endif

	/*
	 * Launch a file selection Dialog.
	 */
	if ( client_data == OPEN ) {

		if ( InUse1 == True ) {
			(void)xpmsg( PopUp, "info: in use" );
			return;
		}
		InUse1 = True;

		PopUp1= XmCreateFileSelectionDialog( Ed_w,
				"editInclude", NULL, 0 );

		XtUnmanageChild( XmFileSelectionBoxGetChild( PopUp1,
				XmDIALOG_HELP_BUTTON) );

		XtAddCallback( PopUp1, XmNcancelCallback,
				(XtCP)edit1_cb, (XtPointer)ABORT );

		XtAddCallback( PopUp1, XmNokCallback, (XtCP)incfile_cb,
				(XtPointer)OK );

		AddHelp( XmFileSelectionBoxGetChild( PopUp1,
				XmDIALOG_CANCEL_BUTTON), "", HCA );

		AddHelp( XmFileSelectionBoxGetChild( PopUp1,
				XmDIALOG_OK_BUTTON), "", HOK );
		/*
		 * Could not find the Filter Button ??.
		 */

		XtManageChild(PopUp1);
		return;
	}

	if ( client_data == ABORT ) {
		XtDestroyWidget(PopUp1);
		InUse1 = False;
		return;
	}

	if ( client_data == SEARCH ) {
		if ( InUse2 )
			return;

		TextSearch( PopUp, Ed_w, &InUse2 );
		return;
	}

}

/*ARGSUSED*/
void edit_close(Widget top)
{
	/*
	 * External close request.
	 */
	if ( (InUse && ! top) || (InUse && (PopUp == top)))
		edit1_cb( NULL, QUIT, NULL );
}

/*
 * Launch an editor.
 */
/*ARGSUSED*/
void edit( Widget parent, int item )
{

#ifdef TTYMON
	Widget spForm_w, sp_w, tmp_w;
	Dimension width;
	char *ptr, *spell, *prompt;
	char dbuff[80];
	XmString str;
#endif

	Widget main_w, menub_w;
	Arg args[20];
	int n;

	if ( InUse == True ) {
		(void)xpmsg( PopUp, "info: in use" );
		return;
	}

	if ( ! Debug ) {
		if ( ! *xread( GetKeyItem() ) ) {
			errno = 0;
			(void)xpmsg( parent, "error: nothing to edit" );
			return;
		}
	}

#ifndef SHARED_SOURCE
	StartItem = XtMalloc( (GetMaxFieldLen()*2)+10 );
	if ( ( GetSKeyItem() ) && (*xread( GetSKeyItem() )) )
		(void)sprintf( StartItem, "%s [%s]",
			       xread( GetKeyItem() ), xread( GetSKeyItem() ) );
	else
		(void)strcpy( StartItem, xread( GetKeyItem() ) );
#endif

	PopUp = CreateDialog( parent, "editWin" );
	InUse = True;
	EdItem = item;

	n = 0;
	XtSetArg(args[n], XmNseparatorOn,		False); n++;
	XtSetArg(args[n], XmNsashHeight,		1); n++;
	XtSetArg(args[n], XmNsashWidth,			1); n++;
	XtSetArg(args[n], XmNsashShadowThickness,	1); n++;
	XtSetArg(args[n], XmNseparatorOn,		False); n++;
	XtSetArg(args[n], XmNspacing,			4); n++;
	main_w = XmCreatePanedWindow( PopUp, "editMainWin", args, n );

	menub_w = CreateMenuBar( main_w );
	(void)CreatePulldownMenu( menub_w, "fileMenuLabel",
		FileItems, XtNumber(FileItems), NULL, NULL );

#ifdef TTYMON

	if ( (spell = GetRes( "*spellProgram" )) &&
				(prompt = GetRes( "*spellPrompt" )) ) {

		spForm_w = XmCreateForm( main_w, "spellFormWin", NULL, 0 );

		tmp_w = CreateToggleButton( spForm_w, "spellButton",
				edit1_cb, SPELLON, QUICK );

		if ( (ptr = strchr( spell, ' ' )) != NULL )
			*ptr = '\0';

		(void)sprintf( dbuff, "(%s) %s", spell, prompt );
		str = XmStringCreateSimple( dbuff );
		XtVaSetValues( tmp_w,
				XmNlabelString,		str,
				XmNset,			Spon,
				XmNtopAttachment,	XmATTACH_FORM,
				XmNtopOffset,		4,
				XmNleftAttachment,	XmATTACH_FORM,
				NULL );
		XmStringFree(str);
		XtVaGetValues( tmp_w, XmNwidth, &width, NULL );

		if ( ptr != NULL )
			*ptr = ' ';

		/*
		 * The output window for spell program.
		 */
		XtVaSetValues( sp_w =CreateText( spForm_w, "spellText", QUICK ),
				XmNcursorPositionVisible, False,
				XmNeditable,		False,
				XmNleftAttachment,	XmATTACH_WIDGET,
				XmNleftWidget,		tmp_w,
				XmNleftOffset,		5,
				XmNrightAttachment,	XmATTACH_FORM,
				XmNrightOffset,		width,
				NULL );

		if ( (Cfd = attachChild(PopUp, spell,
					prompt, False, sp_w)) != NULL ) {
			/*
			 * Activate primary selection on spellText so
			 * that the user can auto correct from there.
			 */
			XtAddCallback( sp_w, XmNgainPrimaryCallback,
				(XtCP)edit1_cb, (XtPointer)SPELLWREP );

			SpellInit( sp_w, spell );

		} else {
			(void)sprintf( dbuff, "%s command FALIED", spell );
			XmTextSetString( sp_w, dbuff );
			XtSetSensitive( spForm_w, False );
			Spon = False;
			XtVaSetValues( tmp_w, XmNset, Spon, NULL );
		}
		XtManageChild(spForm_w);
		(void)CreateSeparator( main_w, 0 );
	}
#endif
	n = 0;
#ifdef SHARED_SOURCE
	XtSetArg(args[n], XmNsource,	XmTextGetSource(Item[EdItem].w)); n++;
#endif
	XtSetArg(args[n], XmNscrollHorizontal,	False); n++;
	XtSetArg(args[n], XmNeditable,		True); n++;
	XtSetArg(args[n], XmNwordWrap,		True); n++;
	XtSetArg(args[n], XmNmaxLength,		Item[EdItem].len); n++;
	XtSetArg(args[n], XmNeditMode,		XmMULTI_LINE_EDIT); n++;
	XtSetArg(args[n], XmNcolumns,		80); n++;
	Ed_w = XmCreateScrolledText( main_w, "editText", args, n );
	AddHelp( Ed_w, "editText", QUICK );
#ifdef TTYMON
	/*
	 * Activate the source window.
	*/
	XtAddCallback( Ed_w, XmNvalueChangedCallback,
		(XtCP)edit1_cb, (XtPointer)SPELLWORD );

#endif
	XtManageChild(Ed_w);

#ifndef SHARED_SOURCE
	XmTextSetString( Ed_w, ptr = XmTextGetString( Item[EdItem].w ) );
	XtFree(ptr);
#endif
	XtManageChild(main_w);

	InUse2 = False;

	MapDialog( parent, PopUp, 0, 100 );
}


#ifdef TTYMON
static Boolean SpellRecur = False;
#define ALTS	"how about: "

/*ARGSUSED*/
static void
ispell_cb( Widget w, int client_data, XmAnyCallbackStruct *cbs )
{
	char *ptr, *ptr1;
	char dbuff[400];
	int i;

	/*
	 * Here we are simulating ispell
	 * version 4, regardless of version.
	 */
	if ( SpellRecur == True )
		return;

	ptr = XmTextGetString(w);

	if ( !strncmp( ptr, "& ' a b c d", 11 ) ) {
		/*
		 * This is a hack to
		 * ignore version 4's
		 * response to a \n
		 * and a white space.
		 */
		SpellRecur = True;
		XmTextSetString( w, "ok" );
		SpellRecur = False;
		XtFree(ptr);
		return;
	}

	if ( *ptr == '@' ) {
		/*
		 * V3 is signing on.
		 */
		XtFree(ptr);
		return;
	}

	if ( (*ptr == '*') || (*ptr == '+') ) {
		XtFree(ptr);
		SpellRecur = True;
		XmTextSetString( w, "ok" );
		SpellRecur = False;
		return;
	}

	if ( *ptr == '#' ) {
		XtFree(ptr);
		SpellRecur = True;
		XmTextSetString( w, "not found" );
		SpellRecur = False;
		return;
	}

	if ( *ptr != '&' ) {
		SpellRecur = True;
		XmTextSetString( w, "" );
		SpellRecur = False;
		XtFree(ptr);
		return;
	}

	XBell( XtDisplay(GetTopWidget()), 0 );

	ptr1 = ptr; ptr1++;
	/*
	 * We don't want any commas
	 * (ispell v3) when selecting
	 * for correction.
	 */
	(void)strcpy( dbuff, ALTS );
	i = sizeof(ALTS)-1;
	while( *ptr1++ != '\0' ) {
		if ( *ptr1 == ',' )
			continue;
		if ( *ptr1 == ':' ) {
			i = sizeof(ALTS)-1; ptr1++;
			continue;
		}
		dbuff[i++] = *ptr1;

	}
	dbuff[i] = '\0';
	XtFree(ptr);
	SpellRecur = True;
	XmTextSetString( w, dbuff );
	SpellRecur = False;
	return;
}


/*
 * Initialize post processing
 * of output in the spell Text
 * widget as required. Current
 * support is for ispell Version 3
 * (actually the latest), and the
 * GNU version 4.
 */
/*ARGSUSED*/
void SpellInit( Widget sp_w, char *spellprg )
{
	char *ptr;
	Boolean found = False;

	/*
	 * Check if we are using ispell.
	 */
	if ( (ptr = strrchr( spellprg, '/' )) != NULL )
		ptr++;
	else
		ptr = spellprg;

	if ( ! strncmp( ptr, "ispell", 6 ) ) {

		while( *ptr++ != '\0' ) {
			if ( (ptr[0] == '-') && (ptr[1] == 'a') ) {
				found = True;
				break;
			}
		}
		if ( found == True ) {
			/*
			 * -a mandatory for version 3.
			 * Optional for version 4, but
			 * without it the spell warning
			 * bell will not be activated.
			 */
			XtAddCallback( sp_w, XmNvalueChangedCallback,
				(XtCP)ispell_cb, (XtPointer)NULL );
		}
	}
}


/*
 * Generalized spell check routines.
 * Synopsis:
 * void
 * SpellCheck( Widget w, Widget ed_w, int cmd,
 *		CFILE *cfd, Boolean *spon, XmTextPosition ofs );
 * Where:
 *      w	The text widget used as output from attached child.
 *      ed_w	The text widget being edited.
 *      cmd	SPELLWORD: Check a just completed word, that is, the
 *      	last character entered must be a white space to
 *      	trigger a word check.
 *      	SPELLWREP: Auto replace a just completed word.
 *      	SPELLON:   Toggle spell checking on/off.
 *      cfd	The control data area as returned by attachChild().
 *      spon	A pointer to a Boolean indicating the on/off staus of checking.
 *      ofs	An offset to compensate for a motif version flaw.
 *
 * Caveats:
 *        May interpret word boundaries for non US-ASCII 7-bit characters
 *        incorrectly. See main.c and setlocale().
 * NOTES:
 *      This routine should be entered as an exenstion for the callback
 *      routines for w and ed_w, where:
 *      w:    has an XmNgainPrimaryCallback defined with SPELLWREP as
 *            client_data.
 *      ed_w: has an XmNvalueChangedCallback defined with SPELLWORD as
 *            client_data.
 */
/*ARGSUSED*/
void SpellCheck( Widget w, Widget ed_w, int cmd,
		CFILE *cfd, Boolean *spon, XmTextPosition ofs )
{

	XmTextPosition pos;
	int i;
	char *ptr, *ptr1;

	if ( cmd == SPELLWORD ) {

		if ( *spon == False )
			return;

		/*
		 * Check a new word just entered.
		 * A word is delimited by a white space.
		 */
		ptr = XmTextGetString(w);
		pos = XmTextGetInsertionPosition(w); pos -= ofs;

		if ( isspace(ptr[pos]) ) {
			ptr[pos] = '\0';
			/*
			 * A word is completed, back
			 * off some bytes to find
			 * the start of it, then
			 * pass it \n terminated
			 * to our spell checker.
			 */
			for( i = 1; i < SPELLMAXW; i++ ) {
				if ( pos-i < 0 )
					break;
				if ( (isspace(ptr[pos-i])) || ( pos-i == 0) ) {
					pos = pos-i; if ( pos ) pos++;
					fprintfChild( cfd, "%s\n", &ptr[pos] );
					break;
				}
			}
		}
		XtFree(ptr);
		return;
	}

	if ( cmd == SPELLWREP ) {
		XmTextPosition end, cur;
		Boolean found;

		if ( *spon == False ) {
			XmTextClearSelection( w, CurrentTime );
			return;
		}

		if ( (ptr = XmTextGetSelection(w)) == NULL ) {
			XmTextClearSelection( w, CurrentTime );
			return;
		}

		/*
		 * Auto correct with selected word into
		 * any position pointed to by the user.
		 * We have a last typed word correction
		 * approach here so that the user don't
		 * have to move the insert cursor to the
		 * start of the misspelled word during
		 * fluent typing, just click on the word
		 * and go on typing. Consequently, when
		 * pointing to a word explicity the insert
		 * cursor should be placed at the end of
		 * the word or the word's trailing spaces.
		 */
		ptr1 = XmTextGetString(ed_w);
		cur = end = pos = XmTextGetInsertionPosition(ed_w); pos -= ofs;

		found = False;
		ptr1[pos] = ' ';
		for( i = 0; i < SPELLMAXW; i++ ) {
			if ( pos-i < 0 )
				break;
			/*
			 * Skip repeated spaces to end
			 * of trailing word.
			 */
			if ( (isspace(ptr1[pos-i])) && (found == False) ) {
				if ( pos-i > 0 ) {
					if ( ! isspace(ptr1[pos-(i+1)]) )
						found = True;
				}
				continue;
			}

			if ( (isspace(ptr1[pos-i])) || ( pos-i == 0) ) {
				pos = pos-i; if ( pos ) pos++;
				XmTextSetSelection( ed_w,
						pos, end, CurrentTime );
					*spon = False;
					XmTextCut( ed_w, CurrentTime );
					XmTextInsert( ed_w, pos, ptr );
					/*
					 * The two lines below
					 * are for motif 1.2.2.
					 * For other - harmless.
					 */
					cur = pos + strlen(ptr);
					XmTextSetInsertionPosition( ed_w, cur );
					*spon = True;
					break;
			}
		}
		XtFree(ptr);
		XtFree(ptr1);
		XmTextClearSelection( w, CurrentTime );
		return;
	}

	/*
	 * Toggle spell check on/off.
	 */
	if ( cmd == SPELLON ) {
		*spon = *spon == True ? False : True;
		return;
	}
}
#endif


/*ARGSUSED*/
void LineBreak( size_t limit, char *line )
{

	char c, ct, *save, *nl, *whs;

	for(;;) {
		/*
		 * Since word wrap in text
		 * widgets is just cosmetics,
		 * we make it real here.
		 */
		if ( ! *line )
			break;

		if ( (nl = strchr( line, '\n' )) != NULL ) {
			ct = '\n';
			*nl = '\0';
		} else {
			/*
			 * Last line.
			 */
			nl = &line[strlen(line)];
			ct = '\0';
		}

		if ( strlen( line ) > limit ) {
			save = &line[limit-1];
			c = *save;
			*save = '\0';
			if ( (whs = strrchr( line, ' ')) != NULL ) {
				*whs = '\n';
				line = whs;
			} else
				line = nl;
			*save = c;
	
		} else
			line = nl;
		*nl = ct;

		if ( ! *line++ )
			break;
	}
}


/*ARGSUSED*/
static void uncase( char *buff, XmTextPosition last )
{
	XmTextPosition i;

	for( i = 0; i < last; i++ ) {
#if defined(SYSV) && !defined(SVR4)
	/*
	 * Does not support 8 bit international char. set.
	 */
		if ( buff[i] >= 0x7f )
			continue;
#endif
		buff[i] = tolower( buff[i] );
	}
}


/*ARGSUSED*/
static void tsearch_cb(Widget w, textSearch *ts, XmCommandCallbackStruct *cbs )
{

	XmTextPosition last = XmTextGetLastPosition( ts->textw );
	char *txt = XmTextGetString( ts->textw );
	XmTextPosition i, len;
	Boolean found = False;
	char *val;

	xpmsg_close();
	XmTextSetHighlight( ts->textw, ts->start, ts->end, XmHIGHLIGHT_NORMAL );

	/*
	 * Find text by pattern.
	 */
	if ( ts->restart == True )
		XmStringGetLtoR( cbs->value, XmSTRING_DEFAULT_CHARSET, &val );
	else
		val = ts->lastString;


	if ( ! *val )
		return;

	uncase( val, len = (XmTextPosition)strlen(val) );
	uncase( txt, last );

	if ( (ts->restart == True) || (ts->end >= last) )
		ts->start = ts->end = 0;


	for ( i = ts->end; i < last-(len-1); i++ ) {
		if ( ! strncmp( val, &txt[i], len ) ) {
			XmTextSetHighlight( ts->textw, i, i+len,
				XmHIGHLIGHT_SELECTED );
			ts->start = i;
			ts->end = i+len;
			XmTextSetInsertionPosition( ts->textw, ts->start );
			(void)strcpy( ts->lastString, val );
			found = True;
			break;
		}
	}

	if ( found == False ) {
		(void)xpmsg( ts->self, "info: not found or end of search" );
		ts->start = ts->end = 0;
	}

	if ( ts->restart == True )
		XtFree(val);

	ts->restart = True;
	XtFree(txt);
}


/*ARGSUSED*/
static void
tsearchNext_cb( Widget w, textSearch *ts, XmPushButtonCallbackStruct *cbs )
{
	ts->restart = False;
	tsearch_cb( w, ts, (XmCommandCallbackStruct *)cbs );
}

/*ARGSUSED*/
static void
tsearchRepl_cb( Widget w, textSearch *ts, XmPushButtonCallbackStruct *cbs )
{
	char *ptr = XmTextGetString( ts->repw );
	size_t len = strlen(ptr);

	xpmsg_close();

	XmTextSetHighlight( ts->textw, ts->start, ts->end, XmHIGHLIGHT_NORMAL );

	if ( ! (ts->start + ts->end) )
		return;

	/*
	 * Move cursor to end of
	 * word so that the spell
	 * checker will understand.
	 */
	XmTextSetInsertionPosition( ts->textw, ts->end+1 );
	XmTextReplace( ts->textw, ts->start, ts->end, ptr );
	ts->end = ts->start+len;

	XtFree(ptr);
}

/*ARGSUSED*/
static void
tsearchClose_cb( Widget w, textSearch *ts, XmAnyCallbackStruct *cbs )
{
	if ( cbs == NULL )
		return;
	/*
	 * QUIT
	 */
	xpmsg_close();
	XmTextSetHighlight( ts->textw, ts->start, ts->end, XmHIGHLIGHT_NORMAL );
	*ts->inuse = False;
	DestroyDialog( ts->self );
	XtFree((char *)ts);
}


/*
 * Launch the Global Text Search Dialog.
 */
/*ARGSUSED*/
void TextSearch( Widget parent, Widget textw, Boolean *inuse )
{

	textSearch *ts;
	Widget form_w, cmd_w, butt_w[6];
	Widget tmp_w, tmp1_w;
	int n;
	Arg args[10];

	/*
	 * Launch the Dialog.
	 */
	ts = (textSearch *)XtMalloc(sizeof(textSearch));

	ts->self = CreateTempDialog( parent,
			"tsearchWin", (XtCP)tsearchClose_cb, (XtPointer)ts );

	ts->textw = textw;
	ts->restart = True;
	ts->inuse = inuse;
	*ts->inuse = True;
	form_w = XmCreateForm( ts->self, "formWin", NULL, 0 );

	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM); n++;
	cmd_w = XmCreateCommand( form_w, "textsCmdWin", args, n );
	AddHelp( cmd_w, "textsCmdWin", QUICK );
	XtVaSetValues( cmd_w,
		XmNbottomAttachment,		XmATTACH_FORM,
		XmNbottomOffset,		100,
		NULL );

	XtAddCallback( cmd_w, XmNcommandEnteredCallback,
		(XtCP)tsearch_cb, (XtPointer)ts );


	XtVaSetValues( tmp_w = CreateSeparator( form_w, 0 ),
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			cmd_w,
		XmNleftOffset,			5,
		XmNrightOffset,			5,
		NULL );

	XtVaSetValues( tmp1_w = CreateLabel( form_w, "replaceLabel" ),
		XmNleftAttachment,		XmATTACH_FORM,
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			tmp_w,
		XmNleftOffset,			8,
		XmNrightOffset,			8,
		NULL );

	XtVaSetValues( ts->repw = CreateText( form_w, "replaceLabel", QUICK ),
		XmNtopAttachment,		XmATTACH_WIDGET,
		XmNtopWidget,			tmp1_w,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNleftOffset,			8,
		XmNrightOffset,			8,
		NULL );

	XtVaSetValues( CreateActionArea( form_w, action_items,
			XtNumber(action_items), NULL, NULL, butt_w, True ),
		XmNleftAttachment,		XmATTACH_FORM,
		XmNrightAttachment,		XmATTACH_FORM,
		XmNbottomAttachment,		XmATTACH_FORM,
		XmNleftOffset,			8,
		XmNrightOffset,			8,
		NULL );

		XtAddCallback( butt_w[0], XmNactivateCallback,
			(XtCP)tsearchNext_cb, (XtPointer)ts );
		XtAddCallback( butt_w[1], XmNactivateCallback,
			(XtCP)tsearchRepl_cb, (XtPointer)ts );
		XtAddCallback( butt_w[2], XmNactivateCallback,
			(XtCP)tsearchClose_cb, (XtPointer)ts );

	XtManageChild(cmd_w);
	XtManageChild(form_w);

	MapDialog( parent, ts->self, 100, 140 );

}
