#include <stdio.h>
#include <string.h>
#include <ihm.h>
#include <kmus.h>

static XtIntervalId tempo_slider;

static void el_handler( Widget w, XtPointer call_data, XEvent *event);


/* ------------------------------------------------------------ */
/*		callback functions				*/
/* ------------------------------------------------------------ */

/* toggle button play/pause */
void f_play_song(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 XmToggleButtonCallbackStruct *info = (XmToggleButtonCallbackStruct*)call_data;
 if (info->set==TRUE)
   f_co_send (K_CO_TYPE_C34, C3_START, 0, 0, 0);
 else
   f_co_send (K_CO_TYPE_C34, C3_STOP, 0, 0, 0);
}

void f_speed_arm(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 f_co_send (K_CO_TYPE_C34, C3_SPEED, 20, 0, 0);
}
void f_speed_disarm(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 f_co_send (K_CO_TYPE_C34, C3_SPEED, 100, 0, 0);
}


void f_quit(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 f_co_send (K_CO_TYPE_C34, C3_EXIT, 0, 0, 0);
}


void f_stop_song(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 f_co_send (K_CO_TYPE_C34, C3_STOP, 0, 0, 0);
}


void f_home_song(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 f_kmus_initsong((byte)L_OK);
 f_co_send (K_CO_TYPE_C34, C3_REWIND, 0, 0, 0);
}


void f_kmus_vrt(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 Boolean State;
 XtVaGetValues (widget, XmNset, &State, NULL);
 if (State)
   XtManageChild (form2);
 else
   XtUnmanageChild (form2);
}


void f_act_kmusic(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 ChgIconifyShell(shell_kmusic); 
}

void f_act_kdir(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
 f_co_send (K_CO_TYPE_C12, C2_SHELL, 0, 0, 0);
}

void f_act_klyric(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{

 f_co_send (K_CO_TYPE_C6, C6_SHELL, 0, 0, 0);

}

void f_kmus_time_slider(widget, tag, call_data)
Widget widget;
XtPointer tag;
XtPointer call_data;
{
  int abs,sval;
  char ltime[10];
  unsigned long minute, seconde;
  static unsigned long  sminute, sseconde;

  minute = (p_co_share_tables->SecSinceBegin)/60;
 
  seconde = (p_co_share_tables->SecSinceBegin) - minute * 60;

  if ( (minute!=sminute) || (seconde != sseconde) )
    {
     sminute = minute;
     sseconde = seconde;
     sprintf (ltime, "%ld:%ld", minute, seconde);
     XtVaSetValues (lab_time, XmNlabelString, f_xm_string(ltime), NULL);
    }

  abs = (p_co_share_tables->timeSinceBegin * 100) / (p_co_share_tables->maxTime+1);
  XtVaGetValues(scroll_time,XmNvalue,&sval,NULL);
  if (abs != sval) XtVaSetValues(scroll_time,XmNvalue,abs,NULL);

  tempo_slider = XtAppAddTimeOut(p_kar_ctx,SLIDER_INTERVAL,f_kmus_time_slider,NULL);
}

/* ------------------------------------------------------------ */
/*		enter/leave widget				*/
/* ------------------------------------------------------------ */


void EventLeaveEnterWidgets()
{
EventLeaveEnter(volume);
EventLeaveEnter(rythme);
EventLeaveEnter(trans);
EventLeaveEnter(pluss_r);
EventLeaveEnter(pluss_v);
EventLeaveEnter(pluss_t);
EventLeaveEnter(moinss_v);
EventLeaveEnter(moinss_r);
EventLeaveEnter(moinss_t);
EventLeaveEnter(pb_front_mus);
EventLeaveEnter(pb_front_lyr);
EventLeaveEnter(pb_front_dir);
EventLeaveEnter(pb_home);
EventLeaveEnter(pb_play);
EventLeaveEnter(pb_pdown);
EventLeaveEnter(pb_pup);
EventLeaveEnter(pb_speed);
EventLeaveEnter(pb_quit);
EventLeaveEnter(pb_prev);
EventLeaveEnter(pb_next);
}

void EventLeaveEnter(widget)
Widget widget;
{
 XtAddEventHandler(widget, EnterWindowMask|LeaveWindowMask, False, (XtEventHandler)el_handler, (XtPointer)NULL); 
}



void aff_label(char * llabel)
{
  XtVaSetValues( lab_buttons, XmNlabelString, f_xm_string (llabel), NULL);
}
/* -------------------------------------------------------------------- */
/*                              enter/leave widget                      */
/* -------------------------------------------------------------------- */

static void el_handler(w, call_data, event)
Widget w;
XtPointer call_data;
XEvent *event;
{
        if (event->type == LeaveNotify) XtVaSetValues(

                lab_buttons,
                XmNlabelString, f_xm_string ("..."),
                NULL);
        else
        {
                if((w==rythme)||(w==moinss_r)||(w==pluss_r)) aff_rythme(False);
                else if((w==volume)||(w==moinss_v)||(w==pluss_v)) aff_vol();
                else if((w==trans)||(w==moinss_t)||(w==pluss_t))  aff_transp();
                else if(w==pb_front_mus) aff_label("Window Music"); 
                else if(w==pb_front_lyr) aff_label("Window Lyrics"); 
                else if(w==pb_front_dir) aff_label("Window Selection"); 
                else if(w==pb_home) aff_label("Home"); 
                else if(w==pb_play) aff_label("Play/Pause"); 
                else if(w==pb_pdown) aff_label("Page Up"); 
                else if(w==pb_pup) aff_label("Page Down"); 
                else if(w==pb_speed) aff_label("Speed Music"); 
                else if(w==pb_quit) aff_label("Exit"); 
                else if(w==pb_prev) aff_label("Previews song"); 
                else if(w==pb_next) aff_label("Next Song"); 

        }
}

void ArmDisarmCtrls()
{
/*
        TRANSPOSE
*/

        XtAddCallback (moinss_t, XmNarmCallback,
                (XtCallbackProc)f_transp_moinss_arm, NULL);

        XtAddCallback (moinss_t, XmNdisarmCallback,
                (XtCallbackProc)f_transp_moinss_disarm, NULL);

        XtAddCallback (pluss_t, XmNarmCallback,
                (XtCallbackProc)f_transp_pluss_arm, NULL);

        XtAddCallback (pluss_t, XmNdisarmCallback,
                (XtCallbackProc)f_transp_pluss_disarm, NULL);

        XtAddCallback (trans, XmNactivateCallback, f_transp, NULL);

/*
        RYTHME
*/

        XtAddCallback (moinss_r, XmNarmCallback,
                (XtCallbackProc)f_rythme_moinss_arm, NULL);

        XtAddCallback (moinss_r, XmNdisarmCallback,
                (XtCallbackProc)f_rythme_moinss_disarm, NULL);

        XtAddCallback (pluss_r, XmNarmCallback,
                (XtCallbackProc)f_rythme_pluss_arm, NULL);

        XtAddCallback (pluss_r, XmNdisarmCallback,
                (XtCallbackProc)f_rythme_pluss_disarm, NULL);

        XtAddCallback (rythme, XmNactivateCallback, f_rythme, NULL);
/*
        VOLUME
*/

        XtAddCallback (volume, XmNactivateCallback, f_volume, NULL);

        XtAddCallback (moinss_v, XmNarmCallback,
                (XtCallbackProc)f_vol_moinss_arm, NULL);

        XtAddCallback (moinss_v, XmNdisarmCallback,
                (XtCallbackProc)f_vol_moinss_disarm, NULL);

        XtAddCallback (pluss_v, XmNarmCallback,
                (XtCallbackProc)f_vol_pluss_arm, NULL);

        XtAddCallback (pluss_v, XmNdisarmCallback,
                (XtCallbackProc)f_vol_pluss_disarm, NULL);
}

