#include <ihm.h>
#include <kmus.h>

static void f_kmus_msg_from_kplay();

void (*p_kplay_message)();

static XtInputId        l_kar_kplay_id;

void f_kmus_switch_msg_kplay();


f_kmus_launch_kplay()
{
 int pid_kplay;

 int l_co_socket_srv_c34;

 if ( f_co_dcl_serveur(K_CO_SOCKADDR_C34, &l_co_socket_srv_c34) == False)
   {
    Dprintf (stderr, "\nImpossible de declarer le serveur c34 \n");
    exit (-1);
   }

 pid_kplay = fork();

 if (pid_kplay == 0) /* le fils */
   {
    execlp("kplay", "kplay", (char *)0);
    Dprintf (stderr, "\nKMUSIC :Unable to launch Kplay\n!");
    exit (0);
   }
 else
   {
    l_co_socket_c34 = f_co_get_connexion (l_co_socket_srv_c34);

    p_kplay_message = f_kmus_switch_msg_kplay;
    l_kar_kplay_id = XtAppAddInput(p_kar_ctx, l_co_socket_c34, XtInputReadMask, 
                            f_kmus_msg_from_kplay, NULL);
   }
  
} 

static void f_kmus_msg_from_kplay()
{
 int l_taille_lue;

 l_taille_lue = read(l_co_socket_c34, &a_data, 4);

 if (l_taille_lue == 0)
   {
    Dprintf (stderr, "\nKplay est mort \n");
    exit(0);
   }
 
 if (p_kplay_message)
   (*p_kplay_message)();
}


void f_kmus_switch_msg_kplay()
{

 switch (a_data.code)
   {
    case C4_LOADED :
      f_kmus_initsong(a_data.par1);
      break;

    case C4_IDLE :
      f_kmus_initsong((BYTE)L_OK);
      break;

    case C4_ON :
      f_kmus_on_led(a_data.par1, a_data.par2);
      break;

    case C4_OFF :
      f_kmus_off_led(a_data.par1, a_data.par2);
      break;

    case C4_CTRL :
      f_kmus_chg_ctrl(a_data.par1, a_data.par2, a_data.par3);
      break;

    case C4_PITCH :
      f_kmus_chg_pitch(a_data.par1, a_data.par2, a_data.par3);
      break;

    case C4_PGMCH :
      f_kmus_chg_pgrm(a_data.par1);
      break;

    case C4_BPM :
      f_kmus_chg_bpm(a_data.par1);
      break;

    default : Dprintf (stderr, "\nMsg %d Not yet managed\n", a_data.code);
              break;
   }
}

