#include <ihm.h>
#include <kmus.h>

static void f_kmus_msg_from_klyr();

void (*p_klyr_message)();

static XtInputId        l_kar_klyr_id;

union WIDGET
  {
   char  p[4];
   Widget w;
  };

void f_kmus_switch_msg_klyr();

Widget shell_klyric;

f_kmus_launch_klyr()
{
 int pid_klyr;

 int l_co_socket_srv_c6;

 if ( f_co_dcl_serveur(K_CO_SOCKADDR_C6, &l_co_socket_srv_c6) == False)
   {
    Dprintf (stderr, "\nImpossible de declarer le serveur c6 \n");
    exit (-1);
   }

 pid_klyr = fork();

 if (pid_klyr == 0) /* le fils */
   {
    execlp("klyric", "klyric", (char *)0);
    Dprintf (stderr, "\nKMUSIC :Unable to launch Klyric\n!");
    exit (0);
   }
 else
   {
    l_co_socket_c6 = f_co_get_connexion (l_co_socket_srv_c6);

    p_klyr_message = f_kmus_switch_msg_klyr;
    l_kar_klyr_id = XtAppAddInput(p_kar_ctx, l_co_socket_c6, XtInputReadMask, 
                            f_kmus_msg_from_klyr, NULL);
   }
  
} 

static void f_kmus_msg_from_klyr()
{
 int l_taille_lue;

 l_taille_lue = read(l_co_socket_c6, &a_data, 4);

 if (l_taille_lue == 0)
   {
    Dprintf (stderr, "\nKlyric est mort \n");
    exit(0);
   }
 
 if (p_klyr_message)
   (*p_klyr_message)();
}


void f_kmus_switch_msg_klyr()
{
 
 switch (a_data.code)
   {
    case C6_START : f_kmus_StartIfToggle(); break;

    case C6_READY : XtSetSensitive(top_level, True); break;

    case C6_SHELL : Dprintf (stderr, "\nWaiting for Klyric Shell\n");
			f_kmus_get_shell (&shell_klyric, l_co_socket_c6);
              break;

    default : Dprintf (stderr, "\nMsg %d Not yet managed\n", a_data.code);
              break;
   }
}

f_kmus_StartIfToggle()
{
 Boolean check;

 XtVaGetValues (pb_play, XmNset, &check, NULL);

 if (check)
   f_co_send (K_CO_TYPE_C34, C3_START, 0, 0, 0);
}

f_kmus_get_shell (p_shell, l_socket)
Widget * p_shell;
int l_socket;
{
 int l_taille_lue;
 union WIDGET P;

 Dprintf (stderr, "\nf_kmus_get_shell");
 l_taille_lue = read(l_socket,  P.p, 4);
 if (l_taille_lue != 4)
   exit (0);

 *p_shell = (Widget)P.w;

 Dprintf (stderr, "\nf_kmus_get_shell end");


}

