#include <ihm.h>

#include <kdir.h>

void f_kdir_act_setup_midi();
void f_kdir_exit();

Widget  XmForm01, lab_titre2, file_sel;

char s_path_sb [500], s_path_opl3[500], s_path_gus[500];


Boolean InterfaceKnown = False;

f_kdir_CreateBoard()
{
 XmForm01 = XtVaCreateManagedWidget("XmForm0", xmFormWidgetClass, top_level,
                XmNx, 0,
                XmNy, 0,
                NULL);

 lab_titre2 = XtVaCreateManagedWidget("lab_titre", xmLabelWidgetClass, XmForm01,
                XmNtopAttachment, XmATTACH_FORM,
                XmNleftAttachment, XmATTACH_POSITION,
                XmNrightAttachment, XmATTACH_POSITION,
                XmNleftPosition, 10,
                XmNrightPosition, 90,
                NULL);


 file_sel = XtVaCreateManagedWidget("file_sel", xmFileSelectionBoxWidgetClass, XmForm01,
                XmNleftAttachment, XmATTACH_FORM,
                XmNrightAttachment, XmATTACH_FORM,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, lab_titre2,
		XmNpattern, f_xm_string ("*.[mk][ia][dr]"),
                NULL);


 XtAddCallback (file_sel, XmNokCallback, f_kdir_play, NULL );
 XtAddCallback (file_sel, XmNcancelCallback, f_kdir_exit, NULL );
 XtAddCallback (file_sel, XmNhelpCallback, f_kdir_act_setup_midi, NULL );

 if (access (kdir_ressource_file, R_OK) != 0)
   f_kdir_SetupMidi(top_level);  
 else
   f_kdir_GetInterface();

}

f_kdir_GetInterface()
{
 FILE * fp;
 char opl3[10], interf[10];
 char path[500], file[500];


 InterfaceKnown = True;

 fp = fopen (kdir_ressource_file, "r");

 fscanf (fp, "interface:%s\n", interf);
Dprintf (stderr, "\nInterface [%s]", interf);

/*
	Path GUS
*/
 fscanf (fp, "pathGUS:%s\n", path);
 strcpy (s_path_gus, path);
Dprintf (stderr, "\nPath GUS [%s]", path);
 strcpy (p_co_share_tables->patch_path_gus, path);

/*
	Path SB
*/
 fscanf (fp, "pathSB:%s\n", path);
 strcpy (s_path_sb, path);
 sprintf (file, "%s/std.sb", path);
 strcpy (p_co_share_tables->sb_melodic, file);
 sprintf (file, "%s/drums.sb", path);
 strcpy (p_co_share_tables->sb_drum, file);

Dprintf (stderr, "\nPath SB [%s]", path);

/*
	Path OPL3
*/
 fscanf (fp, "pathOPL3:%s\n", path);
 strcpy (s_path_opl3, path);
 sprintf (file, "%s/std.o3", path);
 strcpy (p_co_share_tables->sb_melodic_o3, file);
 sprintf (file, "%s/drums.o3", path);
 strcpy (p_co_share_tables->sb_drum_o3, file);

Dprintf (stderr, "\nPath OPL3 [%s]", path);

 if (!strcmp (interf, "GUS"))
   {
    p_co_share_tables->typeOutput = GUS;
    return;
   }

 if (!strcmp (interf, "MIDI"))
   {
    p_co_share_tables->typeOutput = MIDI;
    return;
   }

 p_co_share_tables->typeOutput = SB;

 fscanf (fp, "wantOPL3:%s", opl3);
 if (!strcmp (opl3, "TRUE"))
   {
    p_co_share_tables->wantopl3 = TRUE;
   }
 else
    p_co_share_tables->wantopl3 = FALSE;


}

void f_kdir_play (widget_id, tag,  data)
Widget widget_id;
int *tag;
XmAnyCallbackStruct * data;
{
 XmFileSelectionBoxCallbackStruct * cb;
 char * file;

 cb = (XmFileSelectionBoxCallbackStruct *) data;

 XmStringGetLtoR (cb->value, cs, & file);


 strcpy (p_co_share_tables->fileToPlay, file);

 f_co_send (K_CO_TYPE_C12, C1_LOAD, 0, 0, 0);

} 

void f_kdir_act_setup_midi()
{
 f_kdir_SetupMidi(top_level);
}

void f_kdir_exit()
{
 f_co_send (K_CO_TYPE_C12, C1_EXIT, 0, 0, 0);
}
