#include <co.h>

struct SMSG a_data;


/*-----------------------------------------------------------------------*
 *                                                                       *
 *  Nom de la fonction  :  f_co_cnx_srv                                  *
 *                                                                       *
 *  Sequence d'appel    :  socket_number = f_co_cnx_srv(server_path);    *
 *                         if (socket_number <= 0) { erreur ... }        *
 *                                                                       *
 *  Description         :  Demande de connexion a un processus serveur   *
 *                                                                       *
 *-----------------------------------------------------------------------*
 *                                                                       *
 *  Parametres d'entree  : server_path (chaine de caracteres)            *
 *                                                                       *
 *  Parametres d'entree/sortie : Aucun                                   *
 *                                                                       *
 *  Parametres de retour : socket_number (descripteur de fichier)        *
 *                                                                       *
 *  Variables globales   : s_co_readables                                *
 *                                                                       *
 *  Fonctions locales    : -                                             *
 *                                                                       *
 *  Fonctions globales   : -                                             *
 *                                                                       *
 *-----------------------------------------------------------------------*/
int f_co_cnx_srv(a_sockaddr_srv)
char a_sockaddr_srv[];
{
int l_socket;
struct sockaddr_un s_sockaddr_srv;


	bzero ((char *)&s_sockaddr_srv, sizeof (s_sockaddr_srv));

/*
 * Creation de la socket
 */
	l_socket = socket(PF_UNIX, SOCK_STREAM, 0);
	if (l_socket >= 0) {
/*
 * Correction: 0 n'est pas un numero correct pour cette socket
 */
		if (l_socket == 0) {
			l_socket = dup(l_socket);
			close(0);
			if (l_socket < 0) {
				Dprintf(stderr, "f_co_cnx_srv: dup: errno=%d", errno);
				return FALSE;
			}
		}
/*
 * Demande de connexion sur l'adresse voulue
 */
		s_sockaddr_srv.sun_family = AF_UNIX;
		strcpy(s_sockaddr_srv.sun_path, a_sockaddr_srv);
		errno = 0;
		if (!connect(l_socket, (struct sockaddr *) &s_sockaddr_srv,
				       sizeof(s_sockaddr_srv))) {
			return l_socket;
		}
/*
 * Erreur, pas de socket
 */
		close(l_socket);
	}
	return FALSE;
}
