/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: spin.c,v 1.1.1.1 1996/04/16 15:12:05 leon Exp $ */
#include <X11/Intrinsic.h>
#include <Xm/ArrowB.h>


#define REPEAT_RATE 50    /* 50 ms for repeat rate */





static void
TimeoutCB(XtPointer client_data, XtIntervalId *lastid)
{
    Widget w = (Widget)client_data;
    XtIntervalId id;
    id = 
	XtAppAddTimeOut(XtWidgetToApplicationContext(w), 
			REPEAT_RATE, TimeoutCB, w);
    XtVaSetValues(w, XmNuserData, (XtPointer)id, 0);
    XtCallCallbacks(w, XmNarmCallback, 0);
}




/* Starts the spin behavior: installs the intial timeout on the specified
 * button. This must be called on the ArmCallback, only when it is called
 * from the toolkit (ie call_data != 0), else, does nothing
 * returns: 
 */
static void
InstallTimeoutCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    int initial = (int)client_data;
    XtIntervalId id;
    /* if we are called by a timeout proc, return */
    if(NULL == call_data) return;
    id = 
	XtAppAddTimeOut(XtWidgetToApplicationContext(w), 
			initial, TimeoutCB, w);
    XtVaSetValues(w, XmNuserData, (XtPointer)id, 0);
}


/* When the disamCallback is called, we remove the timeout on the spin button
 * 
 * returns: 
 */
static void
RemoveTimeoutCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    XtIntervalId id;
    XtVaGetValues(w, XmNuserData, &id, 0);
    XtRemoveTimeOut(id);
}






/* installs spin behavior on the specified widget. Thsi widget must provide
 * Arm and Disarm callbacks. 
 * Spin behavior provides auto repeat to a button,as defined for a keyboard.
 * auto repeat will start on the arm and will stop on disarm.
 * returns: 
 */
void
InstallSpinBehavior(Widget w,     /* widget that requires the spin behavior */
		    int initial,  /* initial timeout */
		    int next)    /* next timeout UNUSED */
{
    XtAddCallback(w, XmNarmCallback, InstallTimeoutCB, (XtPointer)initial);
    XtAddCallback(w, XmNdisarmCallback, RemoveTimeoutCB, 0);
}

