/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: date.h,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */

#ifndef __DATE_H
#define __DATE_H

#ifdef GCC_SUCKS
#include "gcc_sucks.h"
#endif /* GCC_SUCKS */
#include <sys/types.h>  /* for time_t */


#define NMONTHS 12
#define NWEEKDAYS 7

typedef enum _Month {
    JANUARY = 0,
    FEBRUARY = 1,
    MARCH = 2,
    APRIL = 3,
    MAY = 4,
    JUNE = 5,
    JULY = 6,
    AUGUST = 7,
    SEPTEMBER = 8,
    OCTOBER = 9,
    NOVEMBER = 10,
    DECEMBER = 11
} Month;
    
typedef enum _WeekDay {
    MONDAY = 0,
    TUESDAY = 1,
    WEDNESDAY = 2,
    THURSDAY = 3,
    FRIDAY = 4,
    SATURDAY = 5,
    SUNDAY = 6,
    UNKNOWN_DAY = 99
} WeekDay;


typedef unsigned int Year;
typedef unsigned short Hour;
typedef unsigned short Minute;
typedef unsigned long Days;
typedef unsigned short Day;    /* 1-31 */

typedef struct _Date {
    Year year;
    Month month;
    WeekDay wd;          /* Day Of The Week */
    Day day;
    Hour hour;
    Minute minute;
} Date;

typedef struct _Duration {
    int days;
    int hours;
    int minutes;
} Duration;


extern Day leapyear_months[];
extern Day year_months[];
extern char *monthNames[];
extern char *weekDayNames[];

#define MonthName(month) monthNames[month]
#define WeekDayName(wd) weekDayNames[wd]

#define IsLeap(y) ((((y) % 4) == 0) &&\
		   ((((y) % 100) != 0) || (((y) % 400) == 0)))

#define NumberOfDays(y, m)\
((IsLeap(y)) ? leapyear_months[(m)] :  year_months[(m)])

#define LAST_DAY 32

extern Days
DateToDays(Year year, Month month, Day day);


extern WeekDay
DateToWeekDay(Year year, Month month, Day day);

extern Date
Today();

extern int
SameDay();



#define SameDay(d1, d2)\
     ((d1.day == d2.day) && \
      (d1.month == d2.month) &&\
      (d1.year == d2.year))




#ifndef Create
#define Create(type) ((type *) malloc(sizeof(type)))
#define Destroy(obj) if(0 != obj) {free(obj); obj = 0;}
#endif /* Create */




int
IsAnterior(Date *before, 
	   Date *date);
int
IsPosterior(Date *after, 
	   Date *date);

Date
DateSubDuration(Date date,
		unsigned long minutes);


time_t
DateToTime_t(Date date);

Date
NextDay(Date day);

#endif /* __DATE_H */
