/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: date.c,v 1.2 1996/05/22 14:05:45 leon Exp $ */

#include <sys/types.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include "date.h"

#if defined(__sun)  && defined(SVR4)
void bcopy(char *a1, char *a2, int size) {
    memcpy(a1, a2, 0);
}
#endif


Day leapyear_months[NMONTHS] = {
    31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
};

Day year_months[NMONTHS] = {
    31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31,
};

char *monthNames[NMONTHS] = {
    "january", "february", "march", "april", "may", "june", 
    "july", "august", "september", "october", "november", "december",
};

char *weekDayNames[NWEEKDAYS] = {
    "monday", "tuesday", "wednesday", "thursday", 
    "friday", "saturday", "sunday",
};


/* compute the number of days from 1st january 1970
 * 
 * returns: 
 */
Days
DateToDays(Year year, Month month, Day day)
{
    Year y = 1970, m;
    Day *ym;
    short yleap;
    Days four, days = day - 1;

    if(year < 1970)
	year += 1900;
    if(month >= 12) {
	year += (month / 12);
	month %= 12;
    }
    yleap = IsLeap(year);
    ym = yleap ? leapyear_months : year_months;
    
    for(m = 0; m < month; m++) {
	days += ym[m];
    }

    y = year - 1970;
    four = y /4 ;
    y %= 4;

    days += (365*3 + 366)*four + (y * 365);
    return days;
}

WeekDay
DateToWeekDay(Year year, Month month, Day day)
{
    Days days;
    if(day == LAST_DAY) {
	day = IsLeap(year) ? leapyear_months[month] : year_months[month];
    };
    /* January 1st, 1970, was a THURSDAY */
    days = DateToDays(year, month, day) + THURSDAY;
    
    return (days % 7);

}

Date
Today()
{
    time_t today;
    struct tm *lt;
    Date date;
    
    today = time(0);
    lt = localtime(&today);

    date.year = 1900+lt->tm_year;
    date.month = lt->tm_mon;
    date.wd = lt->tm_wday-1;
    date.day = lt->tm_mday;
    date.hour = lt->tm_hour;
    date.minute = lt->tm_min;
    return date;
}


/* return True if before is <= date
 * 
 * returns: 
 */
int
IsAnterior(Date *before, Date *date)
{
    if(0 == before->year) return 1;
   if(before->year == date->year) {
   /* same year */
       if(before->month == date->month) {
	   /* same year, same month */
	   return (before->day <= date->day);

       }
       else return(before->month < date->month);
   } 
   else return(before->year < date->year);
}

/* return True if after >= date
 * 
 * returns: 
 */
int
IsPosterior(Date *after, Date *date)
{
    if(0 == after->year) return 1;
   if(after->year == date->year) {
   /* same year */
       if(after->month == date->month) {
	   /* same year, same month */
	   return(after->day >= date->day);
       }
       else return(after->month > date->month);
   } 
   else return(after->year > date->year);
}


/* converts Date into the numbers of seconds from 1970, according to timezone
 * 
 * returns: 
 */
time_t
DateToTime_t(Date date)
{
    struct tm tm;
    tm.tm_year = date.year-1900;
    tm.tm_mon = date.month;
    tm.tm_wday = date.wd+1;
    tm.tm_mday = date.day;
    tm.tm_hour = date.hour;
    tm.tm_min = date.minute;
    tm.tm_sec = 0;
    tm.tm_isdst = 0;		/* Solaris 2.3 */
#if defined(__sun)  && ! defined(SVR4) /* sunOS */
    return timelocal(&tm);
#else
    return mktime(&tm);
#endif /* sun */
}


Date
Time_tToDate(time_t length) 
{
    struct tm *lt;
    Date res;
    lt = localtime(&length);
    
    res.year = 1900+lt->tm_year;
    res.month = lt->tm_mon;
    res.wd = lt->tm_wday-1;
    res.day = lt->tm_mday;
    res.hour = lt->tm_hour;
    res.minute = lt->tm_min;
    return res;
}


/* substract dur from date 
 * 
 * returns: date - dur
 */
Date
DateSubDuration(Date date, unsigned long minutes)
{
    time_t length;      /* date converted into seconds */
    struct tm *lt;
    Date res;

    length = DateToTime_t(date);
    length -= (minutes * 60);
    lt = localtime(&length);
    
    res.year = 1900+lt->tm_year;
    res.month = lt->tm_mon;
    res.wd = lt->tm_wday-1;
    res.day = lt->tm_mday;
    res.hour = lt->tm_hour;
    res.minute = lt->tm_min;
    return res;
}




Date
NextDay(Date day)
{
    time_t t;

    t = DateToTime_t(day);
    t += (24 * 3600);
    return Time_tToDate(t);
    
}
