/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: appointment.h,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */
#ifndef __APPOINTMENT_H
#define __APPOINTMENT_H

#include <sys/types.h>
#include <time.h>
#include "date.h"

typedef enum _Repeat {
    R_NONE = 0,
    R_DAYLY = 1,
    R_WEEKLY = 2,
    R_MONTHLY = 3,
    R_YEARLY = 4
} Repeat;



struct AppointmentRec;
typedef struct _AppointmentRec {
    time_t timestamp;
    Date date;
    char *user;
    Date start;
    Date end;
    Duration alarm;
    int every;
    Repeat repeat;
    char *note;
    unsigned short private;
    unsigned long timeout;    /* Xt timeout for alarms */
    struct _AppointmentRec *next;
} AppointmentRec, *Appointment;
typedef Appointment AppointmentId;




Appointment
AppointmentCreate();


int 
AppointmentMatch(Appointment ap, 
		 Date *date);

int 
AppointmentDayMatch(Appointment ap, 
		 Date *date);

void
AppointmentSprint(char *s,
		  Appointment ap);

void
AppointmentSscan(char *s,
		 Appointment ap);




#endif /* __APPOINTMENT_H */
