/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: appointment.c,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */
#include <stdio.h>
#include <string.h>
#include <assert.h>
#ifndef Mips
#include <malloc.h>
#endif /* ! Mips */
#include "cal.h"
#include "misc.h"


/* in order to have one / appointment, we save a note replacing every '\n' with
   a '#'. */
#define NL_CHAR '#'


Appointment
AppointmentCreate()
{
    Appointment ap;
    ap = (Appointment)malloc(sizeof(AppointmentRec));
    memset(ap, sizeof(AppointmentRec), 0);
    return ap;
}






int 
AppointmentMatch(Appointment ap, 
		 Date *date)
{
    switch(ap->repeat) {
    case R_NONE:
	return ((ap->date.hour == date->hour) &&
		(ap->date.day == date->day) &&
		(ap->date.month == date->month) &&
		(ap->date.year == date->year));
    case R_DAYLY:
	return ((ap->date.hour == date->hour) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    case R_WEEKLY:
	return ((ap->date.wd == date->wd) && 
		(ap->date.hour == date->hour) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    case R_MONTHLY:
	return ((ap->date.day == date->day) && 
		(ap->date.hour == date->hour) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    case R_YEARLY:
	return ((ap->date.month == date->month) && 
		(ap->date.day == date->day) && 
		(ap->date.hour == date->hour) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    }
    return 0;
}




int 
AppointmentDayMatch(Appointment ap, 
		    Date *date)
{
    switch(ap->repeat) {
    case R_NONE:
	return ((ap->date.year == date->year) && 
		(ap->date.month == date->month) &&
		(ap->date.day == date->day));
    case R_DAYLY:
	return ((IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    case R_WEEKLY:
	return ((ap->date.wd == date->wd) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    case R_MONTHLY:
	return ((ap->date.day == date->day) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    case R_YEARLY:
	return ((ap->date.month == date->month) && 
		(ap->date.day == date->day) && 
		(IsAnterior(&ap->start, date)) &&
		(IsPosterior(&ap->end, date)));
    }
    return 0;
}




void
AppointmentSprint(char *s, Appointment a)
{
    char *note, *p;

    /* convert every '\n' into <NL_CHAR> */
    note = Strdup(a->note);
    for(p = note; *p != '\0'; p++){
	if('\n' == *p) {
	    *p = NL_CHAR;
	}
    }
    sprintf(s, 
	    "%d %d %d %d %d %d  %d %d %d %d %d   %d %d %d %d %d   %d %d %d %d   %d %lu %d %s %s",
	    a->date.year, a->date.month, a->date.wd, a->date.day, a->date.hour, a->date.minute,
	    a->start.year, a->start.month, a->start.wd, a->start.day, a->start.hour,
	    a->end.year, a->end.month, a->end.wd, a->end.day, a->end.hour, 
	    a->alarm.days, a->alarm.hours, a->alarm.minutes, a->every,
	    a->repeat, a->timestamp, a->private, a->user, 
	    (a->private?"xxxxxx":note));
    free(note);
}


void
AppointmentSscan(char *s, 
		Appointment a)

{
    char notebuf[1024];
    char userbuf[16];
    char *p;
    assert(sizeof(Month) == sizeof(unsigned));
    sscanf(s, "%u %u %u %hu %hu %hu   %u %u %u %hu %hu   %u %u %u %hu %hu   %d %d %d %d   %u %lu %hu %s %[^\n]",
	   &a->date.year, 
	   (unsigned *)&a->date.month, 
	   (unsigned *)&a->date.wd, 
	   &a->date.day, 
	   &a->date.hour,
	   &a->date.minute,

	   &a->start.year, 
	   (unsigned *)&a->start.month, 
	   (unsigned *)&a->start.wd, 
	   &a->start.day, 
	   &a->start.hour,

	   &a->end.year, 
	   (unsigned *)&a->end.month, 
	   (unsigned *)&a->end.wd, 
	   &a->end.day, 
	   &a->end.hour,

	   &a->alarm.days,
	   &a->alarm.hours,
	   &a->alarm.minutes,
	   &a->every,

	   (unsigned *)&a->repeat,
	   &a->timestamp,
	   &a->private,
	   userbuf,
	   notebuf);
    a->user = Strdup(userbuf);
    a->note = Strdup(notebuf);
    /* convert every <NL_CHAR> into '\n' */
    for(p = a->note; *p != '\0'; p++){
	if(NL_CHAR == *p) {
	    *p = '\n';
	}
    }
}


