/* Copyright 1994 GROUPE BULL -- See license conditions in file COPYRIGHT */

/* $Id: agenda.h,v 1.1.1.1 1996/04/16 15:12:04 leon Exp $ */

#ifndef __AGENDA_H
#define __AGENDA_H

#include <X11/Xlib.h>
#include "cal.h"

#define MAXCAL 16

typedef struct _AgendaRec {
    Calendar calendars[MAXCAL];
    int numCals;
    char *user;
} AgendaRec, *Agenda;

typedef int CalendarId;
typedef void (*AgendaIteratorProc)(AppointmentId aid, 
				   CalendarId cid, 
				   void *closure);

typedef void (*EnumerateCalendarsProc)(Calendar cal,
				       void *closure);



Agenda
AgendaCreate(char *user);



int
AgendaOpenCalendar(Agenda ag, 
		   char *name);



AppointmentId
AgendaRegisterAppointment(Agenda ag,
			  char *calName, 
			  Appointment ap,
			  CalendarId *cid);


void
AgendaRemoveAppointment(Agenda ag,
			CalendarId cal,
			AppointmentId id);


void
AgendaEnumerateAppointments(Agenda ag, 
			    Date date, 
			    AgendaIteratorProc proc, 
			    void *closure);


void
AgendaEnumerateAnyAppointments(Agenda ag, 
			    AgendaIteratorProc proc, 
			    void *closure);


void
AgendaEnumerateCalendars(Agenda ag, 
			 EnumerateCalendarsProc proc, 
			 void *closure);


int
AgendaFindDayAppointment(Agenda ag, 
			 Date date);



void
AgendaSave(Agenda ag);

Calendar
AgendaGetCalendar(Agenda ag, char *name);

void
AgendaSetCalendarStatus(Agenda ag, char *name, Bool status);


char *
AgendaGetCalendarName(Agenda ag, CalendarId cal);


int
AgendaUpdate(Agenda ag);

#endif /* __AGENDA_H */
