#include <stdio.h>
#include <stdlib.h>
#include <forms.h>
#include <math.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "feod.h"
#include "fo.h"
#include "foo.h"
#include "warn.h"
#include "help.h"

#define e1 "awk -F \",\" \'$5*1!=0 {printf \"%s\\t%f\\t%f\\t%f\\t%d\\n\", $1, $2, $3, $4, $5}\' "
#define e2 " > tmp.eod"
#define initdir "./data"

class Ceod 
{
 friend int post (FL_OBJECT *ob, int ev, FL_Coord mx, FL_Coord my, int key, void *xenv);
 
 public:
  int initialize (const char *filename);
  int cleanup();
  int init_data (const char *filename);
  int scan_data ();
  int plot_Pob();
  int plot_Vob();
  int plot_MAob(int days);
  int plot_Oob(int top, int bottom);
  int replot_MAob();
  int add_test();
  int cmpr_it(const char *filename);
  FD_Feod *fd_Feod;
  int data_start_point;
  char *symbol, *cmpr_symbol;
  
 private:
  char sdate[2000][8];
  float high[2000], low[2000], close[2000], x[2000], volume[2000];
  int ind, numbs;
  int MA_days[20];
  float  *mov_ave_ptr[20];
  int if_Oob;
  float *mov_os;
  int mov_os_top, mov_os_bottom;
  float *get_move_ave(int days);
  char *getsymbol(const char *instr);
  float cmpr_ratio;
  float cmpr_close[2000];
};

/************        init_data: .csv -> ascii file    ************/
int Ceod::init_data(const char *filename)
{
  char awkex[128];
  
  if(filename == NULL)
    exit(1);
  strcpy(awkex, e1);
  strcat(awkex, filename);
  strcat(awkex, e2);
  
  system(awkex);
}

/************         scan_data: read from asii file   ***********/
Ceod::scan_data()
{
  int i;
  char linein[BUFSIZ];
  FILE *db;
  
  db =fopen("tmp.eod", "r");
  i=1;
  while(fgets(linein, BUFSIZ, db)!=NULL)
    {
      sscanf(linein, "%s\t%f\t%f\t%f\t%f", sdate[i], &high[i], &low[i], &close[i], &volume[i]);
      x[i]=-i;
      i++;
    }
  
  numbs=i-1;
  fclose(db);
  return 0;
}

/***********        initialize: call init_data, scan_data, and setup varibles ***/
int Ceod::initialize(const char *filename)
{
  float x_min, x_max;
  
  init_data(filename);
  scan_data();
  data_start_point=1;
  if_Oob=0;
  cmpr_ratio=0;
  symbol=getsymbol(filename);
  
  fd_Feod=create_form_Feod();
  plot_Pob();
  fl_get_xyplot_xbounds(fd_Feod->Pob, &x_min, &x_max);
  fl_set_xyplot_xbounds(fd_Feod->Pob, x_min, x_max+50.0);
  plot_Vob();
  fl_get_xyplot_xbounds(fd_Feod->Vob, &x_min, &x_max);
  fl_set_xyplot_xbounds(fd_Feod->Vob, x_min, x_max+50.0);
  ind=0;
  fl_set_xyplot_xbounds(fd_Feod->Oob, x_min, x_max+50.0);
  
  fl_set_object_posthandler(fd_Feod->Pob, post);
  fl_set_object_posthandler(fd_Feod->Vob, post);
  fl_set_object_posthandler(fd_Feod->Oob, post);
  fl_show_form(fd_Feod->Feod, FL_PLACE_FREE, FL_FULLBORDER, "EodPlot");
}

/***********            cleanup: delete tmp.eod *****************************/
int Ceod::cleanup()
{
  if(unlink("tmp.eod")<0)
    perror("tmp.eod");
  exit(0);
}

/*************** plot_Pob: plot Price graph *********************************/
int Ceod::plot_Pob()
{
  fl_set_xyplot_ytics(fd_Feod->Pob, 10, 1);
  fl_set_xyplot_data(fd_Feod->Pob, &x[data_start_point], &close[data_start_point], numbs+1-data_start_point, "", "", "");
  return 0;
}

/**************** plot_Vob: plot volume graph *******************************/
int Ceod::plot_Vob()
{
  fl_set_xyplot_ytics(fd_Feod->Vob, -1, -1);
  fl_set_xyplot_data(fd_Feod->Vob, &x[data_start_point], &volume[data_start_point], numbs+1-data_start_point, "", "", "");
  return 0;
}

/**************** plot_MAob: plot moving average ****************************/
int Ceod::plot_MAob(int days)
{
  float *mov_ave, ymin, ymax;
  char over_label[36];
  
  MA_days[ind]=days;
  ind++;
  sprintf(over_label, "------ %d %s", days, "Days Moving Average");
  mov_ave=get_move_ave(days);
  mov_ave_ptr[ind-1]=mov_ave;
  fl_add_xyplot_overlay(fd_Feod->Pob, ind, &x[data_start_point], &mov_ave[data_start_point], numbs-days+1, ind+3);
  fl_set_xyplot_overlay_type(fd_Feod->Pob, ind, FL_NORMAL_XYPLOT);
  
  fl_redraw_object(fd_Feod->Pob);
  
  fl_get_xyplot_ybounds(fd_Feod->Pob, &ymin, &ymax);
  fl_add_xyplot_text(fd_Feod->Pob, -650, ymax*(1.0-ind/30.0), over_label, FL_ALIGN_LEFT, ind+3);
  return 0;
}

/******************** replot_MAob: replot MA, used after add test *************/
int Ceod::replot_MAob()
{
  float *mov_ave;
  int i;
  
  for(i=0;i<ind;i++)
    {
      free(mov_ave_ptr[i]);
      mov_ave=get_move_ave(MA_days[i]);
      mov_ave_ptr[i]=mov_ave;
      fl_add_xyplot_overlay(fd_Feod->Pob, i+1, &x[data_start_point], &mov_ave[data_start_point], numbs-MA_days[i]+1, i+4);
      fl_set_xyplot_overlay_type(fd_Feod->Pob, i+1, FL_NORMAL_XYPLOT);
  
      fl_redraw_object(fd_Feod->Pob);
    }
  return 0;
}

/************* get_mov_ave: get the float array of moving average **************/
float *Ceod::get_move_ave(int days)
{
  float *mov_ave;
  int i, j;
  
  mov_ave=(float *)malloc((numbs-days+2)*sizeof(float));
  
  for (i=numbs-days+1;i>=data_start_point;i--)
    {
      mov_ave[i]=0;
      for(j=i; j<=(i+days-1); j++)
          mov_ave[i]+=close[j];
      mov_ave[i]=mov_ave[i]/days;
    }
  
  return mov_ave;
}

/************** add_test: add a test data **********************************/
int Ceod::add_test()
{
  FD_foo *fd_foo;
  FL_OBJECT *obj;

  fl_deactivate_form(fd_Feod->Feod);
  fd_foo=create_form_foo();
  fl_show_form(fd_foo->foo, FL_PLACE_MOUSE, FL_TRANSIENT, "Question");
  while(obj=fl_do_forms())
    {
      if((obj==fd_foo->volumeI)||(obj==fd_foo->okB))
	{
	  if((atof(fl_get_input(fd_foo->closeI))==0)||(atoi(fl_get_input(fd_foo->volumeI))==0))
	    fl_set_focus_object(fd_foo->foo, fd_foo->closeI);
	  else
	    break;
	}
      if(obj==fd_foo->cancelB)
	{
	  fl_hide_form(fd_foo->foo);
	  fl_free_form(fd_foo->foo);
	  free(fd_foo);
	  fl_activate_form(fd_Feod->Feod);
	  return 0;
	}
    }

  x[0]=0;
  high[0]=atof(fl_get_input(fd_foo->highI));
  low[0]=atof(fl_get_input(fd_foo->lowI));
  close[0]=atof(fl_get_input(fd_foo->closeI));
  volume[0]=atof(fl_get_input(fd_foo->volumeI));
  strcpy(sdate[0], "Testing");
  fl_hide_form(fd_foo->foo);
  fl_free_form(fd_foo->foo);
  free(fd_foo);
  fl_activate_form(fd_Feod->Feod);
  
  data_start_point=0;
  plot_Pob();
  plot_Vob();
  replot_MAob();
  if(if_Oob>0)
    plot_Oob(mov_os_top, mov_os_bottom);
  
  return 0;
}

/********** plot_Oob: plot the Oscillator graph *****************/
int Ceod::plot_Oob(int top, int bottom)
{
  int swap, i;
  float *top_mov_ave, *bottom_mov_ave;
  float zero_line_x[2], zero_line_y[2];
  
  if(bottom < top)
    {
      swap=bottom;
      bottom=top;
      top=swap;
    }
  mov_os_top=top;
  mov_os_bottom=bottom;
  
  if(top<=1)
    top_mov_ave=close;
  else
    {
      for (i=0;i<ind;i++)
	if (top == MA_days[i])
	  break;
      if(i<ind)
	top_mov_ave=mov_ave_ptr[i];
      else
	{
	  plot_MAob(top);
	  top_mov_ave=mov_ave_ptr[ind-1];
	}
    }
  
  if(bottom<=1)
    bottom_mov_ave=close;
  else
    {
      for (i=0;i<ind;i++)
	if (bottom == MA_days[i])
	  break;
      if(i<ind)
	bottom_mov_ave=mov_ave_ptr[i];
      else
	{
	  plot_MAob(bottom);
	  bottom_mov_ave=mov_ave_ptr[ind-1];
	}
    }
  
  if(if_Oob > 0)
    free(mov_os);
  if_Oob=1;
  mov_os=(float *)malloc((numbs-bottom+2)*sizeof(float));
  
  for (i=numbs-bottom+1;i>=data_start_point;i--)
    {
      if((top_mov_ave[i]+bottom_mov_ave[i])==0)
	mov_os[i]=mov_os[i-1];
      else
	mov_os[i]=(top_mov_ave[i]-bottom_mov_ave[i])/(top_mov_ave[i]+bottom_mov_ave[i]);
    }
  
  zero_line_x[0]=25;
  zero_line_x[1]=-numbs;
  zero_line_y[0]=0;
  zero_line_y[1]=0;
  fl_set_xyplot_ytics(fd_Feod->Oob, -1, -1);
  fl_set_xyplot_data(fd_Feod->Oob, &x[data_start_point], &mov_os[data_start_point], numbs-bottom+2-data_start_point,"","","");
  fl_add_xyplot_overlay(fd_Feod->Oob, 1, zero_line_x, zero_line_y, 2, FL_RED);
  fl_set_xyplot_overlay_type(fd_Feod->Oob, 1, FL_NORMAL_XYPLOT);
  fl_redraw_object(fd_Feod->Oob);
  
  return 0;
}

/************* getsymbol: convert ?????/??/ibm.csv -> IBM **************/
char *Ceod::getsymbol(const char *instr)
{
  int i,j;
  char *restr;
  
  restr=(char *)malloc(8*sizeof(char));
  for (i=strlen(instr)-4; i>0; i--)
    if (instr[i]=='.' && instr[i+1]=='c' && instr[i+2]=='s' && instr[i+3]=='v')
      break;
  
  for (j=i; j>=0; j--)
    if (instr[j]==47) 
    {
      j++;
      break;
    }
  
  i=-1;
  for ( ; j<strlen(instr); j++)
    {
      if (instr[j]=='.')
	break;
      i++;
      restr[i]=toupper(instr[j]);
    }
  
  restr[i+1]='\000';
  
  return (restr);
}

/************ cmpr_it: cmpr two price / day curve *************/
int Ceod::cmpr_it(const char *filename)
{
  FILE *db;
  char linein[BUFSIZ];
  float junk, max, cmpr_max;
  char junky[10];
  int i;

  init_data(filename);
  cmpr_symbol=getsymbol(filename);
  
  max=0;
  for(i=1; i<=numbs; i++)
    {
      cmpr_close[i]=0;
      if(max<close[i])
	max=close[i];
    }
  
  db=fopen("tmp.eod", "r");
  i=1;
  cmpr_max=0;
  while(fgets(linein, BUFSIZ, db)!=NULL)
    {
      sscanf(linein, "%s\t%f\t%f\t%f\t%f", junky, &junk, &junk, &cmpr_close[i], &junk);
      if(cmpr_max<cmpr_close[i])
	cmpr_max=cmpr_close[i];
      i++;
    }
  cmpr_ratio=max/cmpr_max;
  
  for(i=1; i<=numbs; i++)
    cmpr_close[i]=cmpr_close[i]*cmpr_ratio;
  
  fl_add_xyplot_overlay(fd_Feod->Pob, 21, x+1, cmpr_close+1, numbs, 24);
  fl_set_xyplot_overlay_type(fd_Feod->Pob, 21, FL_NORMAL_XYPLOT);
  fl_redraw_object(fd_Feod->Pob);
  
  return 0;
}
