/* to compile

    cc -o try try.c -L/usr/lang/SC1.0 -lF77 -lnag -lm
 */

#include <stdio.h>
#include <math.h>

double  *alloc1Ddouble();
double **For2Ddouble();
void createIcosahedron();

#define GetOption() ((*(*argv+2)!='\0')?*argv+2:(argc--,*++argv))

void MAIN_(); 

double **eigenVec, *eigenVal, *meanVec;
double Scalar;

int ParseCommandLine();
void PrintUsage();

int TessLevel=3;
int PrintInfo=0;
int ErrorBars=0;



main(argc, argv)
int  argc;
char **argv;
{
  
   int      i, j, N, ifail;
   double **matrix, *tempVec;

   ParseCommandLine(argc,argv);
  
   while(!feof(stdin)){
   fscanf(stdin,"%d ",&N);

   matrix   = For2Ddouble(N,N);
   eigenVec = For2Ddouble(N,N);
   
   meanVec  = alloc1Ddouble(N);
   tempVec  = alloc1Ddouble(N);
   eigenVal = alloc1Ddouble(N);

   for (i=0; i<N; i++)
      fscanf(stdin,"%lf ",&meanVec[i]);

   for (i=0; i<N; i++)
      for (j=0; j<N; j++)
         fscanf(stdin,"%lf ",&matrix[i][j]);

   if(PrintInfo){
   for (i=0; i<N; i++)
   {
      for (j=0; j<N; j++)
         fprintf(stderr,"%f ", matrix[i][j]);
      fprintf(stderr,"\n");
   }
   }

   f02abf_(matrix[0], &N, &N, eigenVal, eigenVec[0],&N, tempVec, &ifail);

   if ( ifail ) exit (-1);
  
   if(PrintInfo){
   for (i=0; i<N; i++)
      fprintf(stderr,"%f\n",eigenVal[i]);
   }

   /*** eigenVec[i][j] where i-th row is the i-th eigenvector ***/

   if(PrintInfo){
   for (i=0; i<N; i++)
   {
      for (j=0; j<N; j++)
         fprintf(stderr,"%f ", eigenVec[i][j]);
      fprintf(stderr,"\n\n");
   }
   }

   createIcosahedron(TessLevel);  /* tesselation level */
   free(meanVec);
   free(tempVec);
   free(eigenVal);
  }
}

double  *alloc1Ddouble(a)
int  a;
{
  double *Array;
  
  Array = (double*)calloc(a,sizeof(double));
  return(Array);
}

double **For2Ddouble( row, col )
int row,col;
{
    int     i;
    double  **matrix;
    double  *elements;

    matrix = (double **)malloc(row*sizeof(double *));
    elements = (double*)malloc(row*col*sizeof(double));
    for ( i=0; i<row; i++)
    {
       matrix[i] = elements;
       elements += col;
    }
    return(matrix);
}

void MAIN_()
{
  return ;
}


/*
 * icosahedron - generate a polygon mesh approximating a sphere by
 *               recursive subdivision. First approximation is an icosahedron;
 *               each level of refinement increases the number of polygons by
 *
 * Usage: msphere [level]
 *        level is an integer >= 1 setting the recursion level (default 1).
 *
 * Notes: This program was based on Jon Leech (3/24/89) sphere program
 *        In the original program, tesselation was started from an
 *        octahedron    
 *
 *        The mathematic formulation of an icosahedron was extracted from
 *        Korn and Dyer, "3-D multiview object representation" from
 *        Pattern Recognition Vol 20, pp. 91-103, 1987
 */

typedef struct {
    double  x, y, z;
} point;

typedef struct {
    point     pt[3];	/* Vertices of triangle */
    double    area;	/* Unused; might be used for adaptive subdivision */
} triangle;

typedef struct {
    int       npoly;	/* # of polygons in object */
    triangle *poly;	/* Polygons in no particular order */
} object;

/* Twelve vertices of an icosahedron lying on the unit sphere */
#define ZERO                    0.0          
#define FourRootOfFive          1.4953488
#define SquareRootOfGoldenRatio 1.2720196
#define APLUS                   SquareRootOfGoldenRatio / FourRootOfFive
#define AMINUS                  -SquareRootOfGoldenRatio / FourRootOfFive
#define BPLUS                   1. / (SquareRootOfGoldenRatio * FourRootOfFive)
#define BMINUS                  -1. / (SquareRootOfGoldenRatio * FourRootOfFive)

/* Vertices of a unit icosahedron */
double icosahedron_vertices[][3] = {
    {   ZERO,  APLUS,  BPLUS }, /* 1:  0,  a,  b */
    {   ZERO,  APLUS, BMINUS }, /* 2:  0,  a, -b */
    { AMINUS,  BPLUS,   ZERO }, /* 3: -a,  b,  0 */
    { BMINUS,   ZERO, AMINUS }, /* 4: -b,  0, -a */
    { AMINUS, BMINUS,   ZERO }, /* 5: -a, -b,  0 */
    {   ZERO, AMINUS, BMINUS }, /* 6:  0, -a, -b */
    {   ZERO, AMINUS,  BPLUS }, /* 7:  0, -a,  b */
    {  APLUS, BMINUS,   ZERO }, /* 8:  a, -b,  0 */
    {  BPLUS,   ZERO,  APLUS }, /* 9:  b,  0,  a */
    {  APLUS,  BPLUS,   ZERO }, /*10:  a,  b,  0 */
    { BMINUS,   ZERO,  APLUS }, /*11: -b,  0,  a */
    {  BPLUS,   ZERO, AMINUS }, /*12:  b,  0, -a */
};


point *normalize(     /* point *p               */);
point *midpoint(      /* point *a, point *b     */);
void   print_object(  /* object *obj, int level */);
void   print_triangle(/* triangle *t            */);


void createIcosahedron(maxlevels)
int maxlevels;
{
    object  *icosahedron, *old, *new;
    int     i, level;
    int     facet, idx0, idx1, idx2;
    triangle *tmp; 

    /* An icosahedron */
    icosahedron = (object *) malloc(sizeof(object));
    if (icosahedron == NULL) {
        fprintf(stderr, "Out of memory on zero level\n");
        exit(1);
    }

    icosahedron->npoly = 20;
    icosahedron->poly  = (triangle *) 
                          malloc(icosahedron->npoly * sizeof(triangle));
    if (icosahedron->poly == NULL) {
        fprintf(stderr, "Out of memory on zero level\n");
        exit(1);
    }



    for (facet=1; facet <= icosahedron->npoly; facet++) {
        idx0 = ((facet+7) % 10) + 1;
        idx1 = facet -  ( ( facet-1 )/ 10) * 10;
        if ( facet <= 10 )
             idx2 = ((facet+8) % 10) + 1;
        else
             idx2 = 12 - (facet % 2);

	tmp = &icosahedron->poly[facet-1];
        tmp->pt[0].x = icosahedron_vertices[idx0-1][0];
        tmp->pt[0].y = icosahedron_vertices[idx0-1][1];
        tmp->pt[0].z = icosahedron_vertices[idx0-1][2];

        tmp->pt[1].x = icosahedron_vertices[idx1-1][0];
        tmp->pt[1].y = icosahedron_vertices[idx1-1][1];
        tmp->pt[1].z = icosahedron_vertices[idx1-1][2];

        tmp->pt[2].x = icosahedron_vertices[idx2-1][0];
        tmp->pt[2].y = icosahedron_vertices[idx2-1][1];
        tmp->pt[2].z = icosahedron_vertices[idx2-1][2];

        tmp->area  = 0.0; 
    }
    
    old = icosahedron;


    /* Subdivide each starting triangle (maxlevels - 1) times */
    for (level = 1; level < maxlevels; level++) {
	/* Allocate a new object */
	new = (object *)malloc(sizeof(object));
	if (new == NULL) {
	    fprintf(stderr, "Out of memory on subdivision level %d\n", level);
	    exit(1);
	}
	new->npoly = old->npoly * 4;

	/* Allocate 4* the number of points in the current approximation */
	new->poly  = (triangle *)malloc(new->npoly * sizeof(triangle));
	if (new->poly == NULL) {
	    fprintf(stderr, "Out of memory on subdivision level %d\n", level);
	    exit(1);
	}

	/* Subdivide each polygon in the old approximation and normalize
	 *  the new points thus generated to lie on the surface of the unit
	 *  sphere.
	 * Each input triangle with vertices labelled [0,1,2] as shown
	 *  below will be turned into four new triangles:
	 *
	 *			Make new points
	 *			    a = (0+2)/2
	 *			    b = (0+1)/2
	 *			    c = (1+2)/2
	 *        1
	 *       /\             Normalize a, b, c
	 *      /  \
	 *    b/____\ c		Construct new triangles
	 *    /\    /\	        [0,b,a]
	 *   /	\  /  \	        [b,1,c]
	 *  /____\/____\        [a,b,c]
	 * 0	  a     2       [a,c,2]
	 */
	for (i = 0; i < old->npoly; i++) {
	    triangle
		 *oldt = &old->poly[i],
		 *newt = &new->poly[i*4];
	    point a, b, c;

	    a = *normalize(midpoint(&oldt->pt[0], &oldt->pt[2]));
	    b = *normalize(midpoint(&oldt->pt[0], &oldt->pt[1]));
	    c = *normalize(midpoint(&oldt->pt[1], &oldt->pt[2]));

	    newt->pt[0] = oldt->pt[0];
	    newt->pt[1] = b;
	    newt->pt[2] = a;
	    newt++;

	    newt->pt[0] = b;
	    newt->pt[1] = oldt->pt[1];
	    newt->pt[2] = c;
	    newt++;

	    newt->pt[0] = a;
	    newt->pt[1] = b;
	    newt->pt[2] = c;
	    newt++;

	    newt->pt[0] = a;
	    newt->pt[1] = c;
	    newt->pt[2] = oldt->pt[2];
	}

	if (level > 1) {
	    free(old->poly);
	    free(old);
	}

	/* Continue subdividing new triangles */
	old = new;
    }

    /* Print out resulting approximation */
    print_object(old, maxlevels);
}

/* Normalize a point p */
point *normalize(p)
point *p;
{
    static point r;
    double mag;

    r = *p;
    mag = r.x * r.x + r.y * r.y + r.z * r.z;
    if (mag != 0.0) {
	mag = 1.0 / sqrt(mag);
	r.x *= mag;
	r.y *= mag;
	r.z *= mag;
    }

    return &r;
}

/* Return the average of two points */
point *midpoint(a, b)
point *a, *b;
{
    static point r;

    r.x = (a->x + b->x) * 0.5;
    r.y = (a->y + b->y) * 0.5;
    r.z = (a->z + b->z) * 0.5;

    return &r;
}

/* Write out all polygons in an object */
void print_object(obj, level)
object *obj;
int level;
{
    int i;
    float e1,e2,e3;
    e1 = sqrt(eigenVal[0]);
    e2 = sqrt(eigenVal[1]);
    e3 = sqrt(eigenVal[2]);

    printf("@Set sphere\nFormat PolyLine3D\n");

    printf("2 %g %g %g ",meanVec[0],meanVec[1],meanVec[2]);
    printf(" %g %g %g ", (-Scalar * e1 * eigenVec[0][0]) + meanVec[0],
                         (-Scalar * e1 * eigenVec[0][1]) + meanVec[1],
                         (-Scalar * e1 * eigenVec[0][2]) + meanVec[2] );
    printf("\n");

    printf("2 %g %g %g ",meanVec[0],meanVec[1],meanVec[2]);
    printf(" %g %g %g ",  (Scalar * e1 * eigenVec[0][0]) + meanVec[0],
                          (Scalar * e1 * eigenVec[0][1]) + meanVec[1],
                          (Scalar * e1 * eigenVec[0][2]) + meanVec[2] );
    printf("\n");

    printf("2 %g %g %g ",meanVec[0],meanVec[1],meanVec[2]);
    printf(" %g %g %g ", (-Scalar * e2 * eigenVec[1][0]) + meanVec[0],
                         (-Scalar * e2 * eigenVec[1][1]) + meanVec[1],
                         (-Scalar * e2 * eigenVec[1][2]) + meanVec[2] );
    printf("\n");

    printf("2 %g %g %g ",meanVec[0],meanVec[1],meanVec[2]);
    printf(" %g %g %g ",  (Scalar * e2 * eigenVec[1][0]) + meanVec[0],
                          (Scalar * e2 * eigenVec[1][1]) + meanVec[1],
                          (Scalar * e2 * eigenVec[1][2]) + meanVec[2] );
    printf("\n");


    printf("2 %g %g %g ",meanVec[0],meanVec[1],meanVec[2]);
    printf(" %g %g %g ", (-Scalar * e3 * eigenVec[2][0]) + meanVec[0],
                         (-Scalar * e3 * eigenVec[2][1]) + meanVec[1],
                         (-Scalar * e3 * eigenVec[2][2]) + meanVec[2] );
    printf("\n");

    printf("2 %g %g %g ",meanVec[0],meanVec[1],meanVec[2]);
    printf(" %g %g %g ",  (Scalar * e3 * eigenVec[2][0]) + meanVec[0],
                          (Scalar * e3 * eigenVec[2][1]) + meanVec[1],
                          (Scalar * e3 * eigenVec[2][2]) + meanVec[2] );
    printf("\n");

    printf("@\n");

    /* Spit out coordinates for each triangle */
    if(!ErrorBars){
    printf("@Set sphere\nFormat Polygon3D\n");
    for (i = 0; i < obj->npoly; i++)
	print_triangle(&obj->poly[i]);
    printf("@\n");
    }
}

/* Write a single polygon */
void print_triangle(t)
triangle *t;
{
    int i;
    double newX, newY, newZ;
    float e1,e2,e3;
    e1 = sqrt(eigenVal[0]);
    e2 = sqrt(eigenVal[1]);
    e3 = sqrt(eigenVal[2]);

    /* 
     *  Insert code for your output format here.
     *  Triangle vertices are in t->pt[0..2].{x,y,z}
     */

    /* 
     *  eigenVec[i][j] where i-th row is the i-th eigenvector 
     *
     *  the inverse of the matrix formed by stacking the three
     *    eigenvectors together is the rotation matrix
     *
     *  since these vectors are orthogonal, then the transpose 
     *    of the matrix is the inverse matrix
     */

    printf("3 ");
    for (i = 0; i < 3; i++)
    {
        newX = Scalar *eigenVec[0][0] * t->pt[i].x * e1   /* rotation    */
             + Scalar *eigenVec[1][0] * t->pt[i].y * e2 
             + Scalar *eigenVec[2][0] * t->pt[i].z * e3 
             + meanVec[0];                                 /* translation */
        newY = Scalar *eigenVec[0][1] * t->pt[i].x * e1
             + Scalar *eigenVec[1][1] * t->pt[i].y * e2
             + Scalar *eigenVec[2][1] * t->pt[i].z * e3
             + meanVec[1]; 
        newZ = Scalar *eigenVec[0][2] * t->pt[i].x * e1
             + Scalar *eigenVec[1][2] * t->pt[i].y * e2
             + Scalar *eigenVec[2][2] * t->pt[i].z * e3
             + meanVec[2]; 
	printf("%g %g %g ", newX, newY, newZ);
    }
    printf("\n");
}

/*----------------------------------oOo------------------------------------*/
/*|///////////////////////////////////////////////////////////////////////|*/
/*----------------------------------oOo------------------------------------*/
/* Parse the command line */
/*----------------------------------oOo------------------------------------*/
int ParseCommandLine(argc,argv)
int argc;
char **argv;
{

  if (argc<1){
   	PrintUsage();
        exit(0);
 }

  TessLevel=3;
  Scalar=2.0;
  argc-=0; argv+=0;   /* skip over infile and outfile names */

  while ((--argc>0) && ((*++argv)[0] == '-' )) { switch(argv[0][1])
    {
     case 'T': /*  TessLevel */
	       sscanf(GetOption(),"%d",&TessLevel);
               break;
     case 'S': /*  Scalar  */
	       sscanf(GetOption(),"%lf",&Scalar);
               break;
     case 'P': /*  PrintInfo  */
	       PrintInfo=1;
               break;
     case 'u':
     case 'U': /*  Scalar  */
	       PrintUsage();
	       exit(0);
               break;
     case 'E': /* Error Bars */
		ErrorBars =1;	
		break;
     default: 
		fprintf(stderr, "Ellipsoid: bad option -%c\n",argv[0][1]); break;

    }
   }
}

void
PrintUsage()
{
	fprintf(stderr,"usage:\n Ellipsoid < cluster.dat > cluster.gf [options]\n\
          -T : TessLevel\n\
          -S : Scalar\n\
	  -P : PrintInfo\n\
	  -U : Usage\n\
	  -E : ErrorBars\n\
           options:\n");
}

