static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */

/* :1,$ s/NAMEofFORMAT/your new file format name/g */

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include <X11/StringDefs.h>
#include <Xm/Scale.h>
#include "NAMEofFORMAT.h"
#include "Pixmaps.h"
#include "3Droutines.h"
#include "Parse.h"

FILE           *NAMEofFORMATFilePtr;
int 		OutNAMEofFORMAT;
float 		FmSc=100;

#define GROUPID 	1

#ifndef _NO_PROTO 
void MakeOutLineNAMEofFORMAT(XPoint *Pts,int num,int LineWidth);
int SetNAMEofFORMATColour(int Color);
#else 
void MakeOutLineNAMEofFORMAT();
int SetNAMEofFORMATColour();
#endif 



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveNAMEofFORMAT(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving .NAMEofFORMAT  File", SAVE_NAMEofFORMAT_FILE, NAMEofFORMATFIL, "Out.pict", NAMEofFORMATDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputNAMEofFORMAT(fname, Col)
char *fname;
int Col;
{
	OutNAMEofFORMAT=1;
	if ((NAMEofFORMATFilePtr = fopen(fname, "w")) == NULL)
		return ;
	else if (OutNAMEofFORMAT == 1)
		InitNAMEofFORMAT();
	REDRAW_SCREEN;
	if (OutNAMEofFORMAT == 1)
		EndNAMEofFORMAT();
	fclose(NAMEofFORMATFilePtr);
	OutNAMEofFORMAT = 0;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolygonNAMEofFORMAT(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int num;
int fill;
Window TmpWind;
int Color;
int PtType;
int BaseType;
int LineStyle;
int LineWidth;
int FillStyle;
int ShadedVal;
{
	int i;
	int NAMEofFORMATColour = -1;
	int P = DefaultPointSize;
	int NAMEofFORMATFill = 0;

	NAMEofFORMATColour = SetNAMEofFORMATColour(Color);
	fill =  DetermineFillType(fill,num,PtType,FillStyle,BaseType);

	if (Color < 64) {
                NAMEofFORMATColour = 0;
                NAMEofFORMATFill = (int) (((double) Color / 64.0) * 7.0);
        }
	else {
		NAMEofFORMATFill = 0;
	}


	switch (fill) {
	    case DOT:{
		/* Pts[0].x Pts[0].y hold data */
		/* Print using fprintf(NAMEofFORMATFilePtr, ""); */
		/* Pointsize is in P */
		/* num = Number of verticies */
                break;
		}
	    case PLUS:{
                break;
		}
	    case CROSS:{
                break;
		}
	    case BOX:{
                break;
		}
	    case TRI:{
                break;
		}
	    case FILLEDTRI:{
                break;
		}
	    case FILLEDBOX:{
                break;
		}
	    case PTCIRCLE:{
		break;
		}
	    case FILLEDCIRCLE:{
		break;
		}
	    case FILLEDOPAQUE:{/* Polygon and PolyLine */
		break;
		}
	    case COLOUREDOPAQUE:{/* Polygon and PolyLine */
		break;
	    }
	    case FILLEDHIDDENLINE:{
		if(DitherFill){
		NAMEofFORMATFill = (int) (((double) ShadedVal / 64.0) * 7.0);
		}
		MakeOutLineNAMEofFORMAT(Pts,num,LineWidth);
		break;
		}
	    case WHITELINES:{
		NAMEofFORMATColour = 1;
		if (num>2) {fprintf(NAMEofFORMATFilePtr, "<Polygon\n");
		}
		else {fprintf(NAMEofFORMATFilePtr, "<PolyLine\n");
		}
		break;
                }
            case BLACKLINES:{
		NAMEofFORMATColour = 0;
		if (num>2) {fprintf(NAMEofFORMATFilePtr, "<Polygon\n");
		}
		else {fprintf(NAMEofFORMATFilePtr, "<PolyLine\n");
		}
		break;
                }
	    case COLOUREDLINES:
	    case FILLEDCOLOR:{	/* Polygon */
		if(DitherFill){
		NAMEofFORMATFill = (int) (((double) ShadedVal / 64.0) * 7.0);
		}
		MakeOutLineNAMEofFORMAT(Pts,num,LineWidth);
		break;
		}
	    case POINTS_ONLY:{
                break;
		}
	    case TEXTLABEL:{  
		/* NAMEofFORMATColour = Colour */
		/* CurrentString = Text String */
		break;
        }
	    default:{		/* PolyLine */
		break;
		}
	}
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitNAMEofFORMAT()
{
	fprintf(NAMEofFORMATFilePtr, "FormayID for NAMEofFORMAT\n");
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
EndNAMEofFORMAT()
{
	fprintf(NAMEofFORMATFilePtr, "\n");
	return ;
}

void
MakeOutLineNAMEofFORMAT(Pts,num,LineWidth)
XPoint *Pts;
int num;
int LineWidth;
{
    int NAMEofFORMATColour = -1;
    int NAMEofFORMATFill;
    int i;

    if(OutLine){
    NAMEofFORMATColour =SetNAMEofFORMATColour(OutLineColour);
    NAMEofFORMATFill = 0;
	/* Draw an outline */
    }

}

int SetNAMEofFORMATColour(Color)
int Color;
{
        int NAMEofFORMATColour = -1;

        switch (Color) {
            case 64:
                NAMEofFORMATColour = 0; /* Black */
                break;
            case 70:
                NAMEofFORMATColour = 1; /* White */
                break;
            case 65:
                NAMEofFORMATColour = 2; /* Red */
                break;
            case 69:
                NAMEofFORMATColour = 3; /* Green */
                break;
            case 66:
                NAMEofFORMATColour = 4; /* Blue */
                break;
            case 72:
                NAMEofFORMATColour = 5; /* Cyan */
                break;
            case 92:
                NAMEofFORMATColour = 6; /* Magenta */
                break;
            case 67:
                NAMEofFORMATColour = 7; /* Yellow */
                break;
            case -1:
                NAMEofFORMATColour = 0; /* Black */
                break;
            default:
                NAMEofFORMATColour = 0; /* Black */
                break;
            }
        return NAMEofFORMATColour;
}

