static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "Mouse.h"
#include "callbacks.h"
#include "Parse.h"
#include "Menus.h"
#include "3Droutines.h"

#define XMGFSGN(a)          (((a)<0) ? -1 : 0)
int First = 0;

/* #define PHI_NOT_GAMMA */
#define GAMMA_NOT_NOT
#ifndef _NO_PROTO 
void DrawRectangle(int x,int y,int Moux1,int Mouy1);
#else 
void DrawRectangle();
#endif 

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* UpdateScale						       */
/* Mouse based Function called from Button 3 Motion            */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdateScaleCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	int x, y;
	unsigned int mask;
	Window du, du1;
	int wx, wy;
	int dx, dy;
	int step = 10;
	static int sx = 0;
	static int sy = 0;
	int motion_criterion = 2;

	XQueryPointer(theDisplay, w_Orth, &du, &du1, &x, &y, &wx, &wy, &mask);
	dx = sx - wx;
	dy = sy - wy;
	if (dy < -motion_criterion)
		Theta = Theta + step;
	if (dy > motion_criterion)
		Theta = Theta - step;
	if (Theta < 0)
		Theta = 360 + Theta;
	if (Theta >= 360)
		Theta = Theta - 360;
#ifdef PHI_NOT_GAMMA
	if (dx < -motion_criterion)
		Phi = Phi + step;
	if (dx > motion_criterion)
		Phi = Phi - step;
	if (Phi < 0)
		Phi = 360 + Phi;
	if (Phi >= 360)
		Phi = Phi - 360;
#else
	if (dx < -motion_criterion)
		Gamma = Gamma + step;
	if (dx > motion_criterion)
		Gamma = Gamma - step;
	if (Gamma < 0)
		Gamma = 360 + Gamma;
	if (Gamma >= 360)
		Gamma = Gamma - 360;
#endif
	UpdateRotationParms();
	SetScale();
	switch (RotateGuide) {
	    case 0:
		Redraw();
		break;
	    case 1:
		QuickRedraw();
		break;
	}
	sx = wx;
	sy = wy;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* UpdatePosition					       */
/* Mouse based Function called from Button 2 Motion            */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdatePositionCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	UpdatePosition();
}

void
ZoomCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	int x, y;
	int TopX,TopY;
	int OldX,OldY;
        unsigned int mask;
        Window du, du1;
	double Moux1,Mouy1,Moux2,Mouy2;
	short X2,Y2;
	int CropHeight,OCropHeight;
        int wx, wy;
	XEvent event;

	XmgfMessage("Select Zoom Box with middle button");

	while(1){
	 XCheckMaskEvent(theDisplay, ButtonPress,&event);
	 if(event.type==ButtonPress){
			break;
	 }
	}

	XQueryPointer(theDisplay, w_Orth, &du, &du1, &x, &y, &wx, &wy, &mask);
	CropHeight=0;OCropHeight=0;
	TopX=wx;TopY=wy;
	OldX=wx;OldY=wy;
	XmgfMessage("Set Zoom position A\n");
	XSetFunction(theDisplay,theGC,GXcopy);
	DrawRectangle(TopX,TopY,OldX,OldY);

	while(1){
	if (XQueryPointer(theDisplay, w_Orth, &du, &du1, &x, &y, &wx, &wy, &mask)){
	  if (!(mask & Button2Mask)) {
	       /* Undraw */
		XmgfMessage("Set Zoom position B\n");
		CropHeight=50;
		Moux1 =(double)( TopX-CropHeight);
		Mouy1 =(double)( TopY-CropHeight);
		Moux2 =(double)( TopX+CropHeight);
		Mouy2 =(double)( TopY+CropHeight);
/*		FindVisibleInBox(Moux1,Mouy1,Moux2,Mouy2);*/
		FindVisibleInBox(TopX,TopY,wx,wy);
		DrawRectangle(TopX,TopY,wx,wy);
		AutoScaleCMD();
		break; /* Released */
		}
	if (wx!=OldX || wy !=OldY )  {
		X2=wx;Y2=wy;
		XSetFunction(theDisplay,theGC,GXxor);
		DrawRectangle(TopX,TopY,OldX,OldY);
		DrawRectangle(TopX,TopY,X2,Y2);
		XSetFunction(theDisplay,theGC,GXcopy);
		OldX = X2; OldY = Y2;
		}
	}
	}
}

void DrawRectangle(x,y,Moux1,Mouy1)
int x,y,Moux1,Mouy1;
{
	int w,h;

	w = abs(Moux1-x);  h = abs(Mouy1-y);
  	if (x>Moux1) x = Moux1;
  	if (y>Mouy1) y = Mouy1;
	
	XDrawRectangle(theDisplay, (Drawable) w_Orth, theGC, x, y, w, h);
	return ;
}


void
UpdatePosition()
{
	int x, y;
	unsigned int mask;
	Window du, du1;
	int wx, wy;
	static int sx, sy;
	int dx, dy;
	int step = TranslationStep;
	int motion_criterion = 2;

	XQueryPointer(theDisplay, w_Orth, &du, &du1, &x, &y, &wx, &wy, &mask);
	dx = wx - sx;
	dy = wy - sy;
	if (dx < -motion_criterion)
		Ox = Ox - step;
	if (dx > motion_criterion)
		Ox = Ox + step;
	if (dy < -motion_criterion)
		Oy = Oy - step;
	if (dy > motion_criterion)
		Oy = Oy + step;
	UpdateRotationParms();
	SetScale();
	switch (RotateGuide) {
	    case 0:
		Redraw();
		break;
	    case 1:
		QuickRedraw();
		break;
	}

	sx = wx;
	sy = wy;
	return ;
}
