static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "stdio.h"
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include "XmgfStruct.h"
#include "XmgfDefines.h"
#include "XmgfGlobal.h"
#include "InitX.h"
#include "Parse.h"
#include "FillPat.h"

Colormap        theCMap;
Display        *theDisplay;
GC              theGC;
int             theScreen;
Pixmap bbuf;
Drawable theDrawable;
unsigned int theDepth;
int theRootWindow;
int blackpixel;
int maxcolorpixels = 151;
unsigned long colorpixels[151];
int NumColors;
unsigned long colorArray[150];
unsigned long plane_masks[1];
Pixmap   FillTiles[NUMFILLPATS];
Pixmap   SphereTiles[NUMSPHERES];



char *theColorNames[maxPixels + 1] = {
"Black", "Red", "Blue", "Yellow", "Brown", "Green",
"White", "Orange", "Cyan", "Pink", "Purple", "Violet",
"Peach", "Grey", "Turquoise", "Cream", "NavyBlue",
"RoyalBlue", "CadetBlue", "DarkGreen", "PaleGreen", "Chartreuse",
"LimeGreen", "Khaki", "Gold", "Brown", "Chocolate", "Maroon",
"Magenta", "LightBlue", "LightCoral", "LightCyan", "LightGoldenrod",
"LightGoldenrodYellow", "LightGray", "LightGrey", "LightPink", "LightSalmon",
"LightSeaGreen", "LightSkyBlue", "LightSlateBlue", "LightSlateGray",
"LightSlateGrey", "LightSteelBlue", "LightYellow", "LimeGreen", "MediumAquamarine",
"MediumBlue", "MediumOrchid", "MediumPurple", "MediumSeaGreen", "MediumSlateBlue",
"MediumSpringGreen", "MediumTurquoise", "MediumVioletRed", "MidnightBlue",
"MintCream", "MistyRose", "NavajoWhite", "NavyBlue", "OldLace", "OliveDrab",
"OrangeRed", "PaleGoldenrod", "PaleGreen", "PaleTurquoise", "PaleVioletRed",
"PapayaWhip", "PeachPuff", "PowderBlue", "RosyBrown", "RoyalBlue",
"SaddleBrown", "SandyBrown", "SeaGreen", "SkyBlue", "SlateBlue",
"SlateGray", "SlateGrey", "SpringGreen", "SteelBlue", "VioletRed",
"WhiteSmoke", "Yellow", "NavyBlue", "Default"
};

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/********************************************************
*  Routine Name: InitColors()
*  Derived From: Anthony Tai - Xgf - 1991
*  Colour Selection Stages
********************************************************/
void
InitColors()
{
	XColor hwcolor, theRGBColor;
	int status;
	int i;
	int count;
	int allocnum = 0;
	int j;
	
	NumColors = 150;
	theDepth = XDefaultDepth(theDisplay, theScreen);
	theRootWindow = DefaultRootWindow(theDisplay);
	blackpixel = BlackPixel(theDisplay, theScreen);

	if (theDepth > 1) {
#ifndef ALLOCCOLORS
	while (1) {
	if (XAllocColorCells(theDisplay, theCMap, False, plane_masks, 0, colorArray, (unsigned int)NumColors)) break;
	NumColors--;
	if(NumColors<1) {
		fprintf(stderr,"No Colours To Allocate\n");
		break;
		}
	}
#endif
#ifdef DEBUG
		fprintf(stderr, "Allocated %d Colours\n", NumColors);
#endif
		for (i = 0; i < 64; i++) {
			j = 256 * (i * 4);
			hwcolor.red = j;
			hwcolor.green = j;
			hwcolor.blue = j;
#ifdef ALLOCCOLORS
			status = XAllocColor(theDisplay, theCMap, &hwcolor);
#else
			hwcolor.pixel = colorArray[i];
			hwcolor.flags = DoRed | DoGreen | DoBlue;
			if(i<NumColors){
			XStoreColor(theDisplay, theCMap, &hwcolor);
			status = 1;
			}
			else{
			status = 0;
			}
#endif

			if (status != 0) {
				allocnum++;
				colorpixels[i] = hwcolor.pixel;
			} else
				colorpixels[i] = BlackPixel(theDisplay, theScreen);

		}
		count = i;

		for (i = count; i < count + maxPixels; i++) {
			status = XLookupColor(theDisplay, theCMap,
				theColorNames[i - count],
				&theRGBColor,
				&hwcolor);
			if (status != 0) {
#ifdef ALLOCCOLORS
				status = XAllocColor(theDisplay, theCMap, &hwcolor);
#else
				hwcolor.pixel = colorArray[i];
				hwcolor.flags = DoRed | DoGreen | DoBlue;
				if(i<NumColors){
	                        XStoreColor(theDisplay, theCMap, &hwcolor);
				status = 1;
       		                }
                        	else{
                        	status = 0;
                        	}

#endif
				if (status != 0) {
					allocnum++;
					colorpixels[i] = hwcolor.pixel;
				} else
					colorpixels[i] = BlackPixel(theDisplay, theScreen);
			}
		}

		for (i = 148; i < 150; i++) {
			hwcolor.pixel = (unsigned long) i;
			hwcolor.red = 256 * 144;
			hwcolor.green = 256 * 160;
			hwcolor.blue = 256 * 176;
#ifdef ALLOCCOLORS
			status = XAllocColor(theDisplay, theCMap, &hwcolor);
#else
			hwcolor.pixel = colorArray[i];
			hwcolor.flags = DoRed | DoGreen | DoBlue;
			if(i<NumColors){
	                XStoreColor(theDisplay, theCMap, &hwcolor);
			status = 1;
       		        }
                        else{
                        status = 0;
                        }
#endif
			if (status != 0) {
				allocnum++;
				colorpixels[i] = hwcolor.pixel;
			} else
				colorpixels[i] = WhitePixel(theDisplay, theScreen);
		}


	} else {
		for (i = 0; i < 148; i++) {
			colorpixels[i] = BlackPixel(theDisplay, theScreen);
		}
		for (i = 148; i < 150; i++) {
			colorpixels[i] = WhitePixel(theDisplay, theScreen);
		}
	}

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetColor(i)
int i;
{
	static int last_color = 0;

	if (i==last_color) return;
	else last_color=1;
	if (i >= 0 && i <= 150) {
		XSetForeground(theDisplay, theGC, colorpixels[i]);
	} else {
		i = 0;
		XSetForeground(theDisplay, theGC, colorpixels[i]);
	}
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateBuff(win, x, y)
Window win;
int x;
int y;
{
	bbuf = XCreatePixmap(theDisplay, win, (unsigned int )x,(unsigned int ) y, theDepth);
	theDrawable = (Drawable) bbuf;
	ClearBuff(theDrawable, x, y);
	SwapBuff(win, x, y);
	ClearBuff(theDrawable, x, y);
}

void DestroyBuff()
{
	XFreePixmap(theDisplay,bbuf);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SwapBuff(win, x, y)
Window win;
int x;
int y;
{
	XCopyArea(theDisplay, theDrawable, win, theGC, 0, 0,(unsigned int ) x,(unsigned int ) y, 0, 0);
/*	XSync(theDisplay, 0);	*/
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ClearBuff(win, x, y)
Window win;
int x;
int y;
{
	XSetBackground(theDisplay, theGC, colorpixels[BackGroundColour]);
	XSetForeground(theDisplay, theGC, colorpixels[BackGroundColour]);
	CheckDither();
	XFillRectangle(theDisplay, theDrawable, theGC, 0, 0,(unsigned int ) x,(unsigned int ) y);
	ReturnDither();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
XColor
GetRGB(ColourIndex)
int ColourIndex;
{
	XColor hwcolor, theRGBColor;
	int status;

	status = XLookupColor(theDisplay, theCMap,
		theColorNames[ColourIndex],
		&theRGBColor,
		&hwcolor);
	return theRGBColor;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadColourMap(filename, MAPType)
char *filename;
int MAPType;
{
	int i, j, r, g, b, ncolors;
	XColor color;
	FILE *ColourMapFile;
	int	ColourIndex;
	ColourIndex=0;


	/* load the color file */
	ColourMapFile = (FILE *) fopen(filename, "r");
	if (ColourMapFile) {
		fscanf(ColourMapFile, "%d", &ncolors);
		for (i = 0; i < ncolors; i++) {
			fscanf(ColourMapFile, "%d %d %d %d", &j, &r, &g, &b);
			switch (MAPType) {
			    case GREYMAP:
				ColourIndex=i;
				color.red = r;
				color.green = g;
				color.blue = b;
				color.pixel = colorArray[ColourIndex];
				color.flags = DoRed | DoGreen | DoBlue;
				break;
			    case COLOURMAP:
				ColourIndex=i+64;
				color.red = r;
				color.green = g;
				color.blue = b;
				color.pixel = colorArray[ColourIndex];
				color.flags = DoRed | DoGreen | DoBlue;
				break;
			}
			if(ColourIndex<NumColors){
                        XStoreColor(theDisplay, theCMap, &color);
                        }
                        else{
                        colorArray[ColourIndex] = BlackPixel(theDisplay, theScreen);
			}
		}
		fclose(ColourMapFile);
	} else {		/* no color file. */
		fprintf(stderr, "Xmgf Error:- Problem opening color file.\n");
	}
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitTiles()
{
	int i;
	for (i = 0; i < NUMFILLPATS; i++) {
        FillTiles[i] = XCreateBitmapFromData(theDisplay, w_Orth,
                                           (char *) fill_images[i], 32, 32);
	}
	for (i = 0; i < NUMSPHERES; i++) {
        SphereTiles[i] = XCreateBitmapFromData(theDisplay, w_Orth,
                                           (char *) sphere_images[i], (i*2)+8, (i*2)+8);
	}
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeTile(Tile)
int Tile;
{
	static last_tile=0;
	int NewTile;

	if(DitherFill){
	if(last_tile == Tile) return;
	else last_tile = Tile;
	NewTile =(int) ((Tile*21)/64);
	if (NewTile>=0 && NewTile<64)
	  XSetStipple(theDisplay,theGC,FillTiles[NewTile]);
	}
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CheckDither()
{
	if(DitherFill) XSetFillStyle(theDisplay,theGC,FillSolid);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReturnDither()
{
	if(DitherFill) XSetFillStyle(theDisplay,theGC,FillOpaqueStippled);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeSphere(Size)
int Size;
{
	if (Size<4) Size=4;
	if (Size>NUMSPHERES) Size=NUMSPHERES;
	XSetStipple(theDisplay,theGC,SphereTiles[(Size-4)]);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
CheckSphere()
{
	XSetFillStyle(theDisplay,theGC,FillSolid);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ReturnSphere()
{
/*        XSetFillStyle(theDisplay,theGC,FillStippled);*/
        XSetFillStyle(theDisplay,theGC,FillOpaqueStippled);
}




