static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";
/*
 * Copyright (C) 1992, 1993, 1994, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfMalloc.h"

#include "XmgfStruct.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "InitX.h"
#include "BackDrop.h"
#include "Parse.h"
#include "XmError.h"
#include "Compression.h"
#include "XmgfDefines.h"
#include "XmgfGlobal.h"
#include "GUI.h"

void UpdateImage();
char *ScaleImage();
char *RotateImage();

char *BackImage;
char *xim,*ximtmp;
Pixmap ImagePix,ImageDraw;
static int FirstPass = 1;

/* MONO returns total intensity of r,g,b components */
#define MONO(rd,gn,bl) (((rd)*11 + (gn)*16 + (bl)*5) >> 5)	/* .33R+ .5G+ .17B */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
BackDrop(theWindow, LocalGC, x, y, width, height, image)
Window theWindow;
GC LocalGC;
int x;
int y;
int width;
int height;
char *image;
{
	char *imptr;
	int i;
	XImage *xi;
	static Pixmap Im_pp;
	Visual *theVisual;
	int BackDepth;

	imptr = image;
	for (i = 0; i < (width * height); i++) {
		*imptr >>= 1;
		*imptr++ = colorpixels[(int) *imptr];
	}

	BackDepth = XDefaultDepth(theDisplay, theScreen);
#ifdef DEBUG
	fprintf(stderr, "BackDepth = %d\n", BackDepth);
#endif

	if (BackDepth == 1) {
		MyXmgfErr("Image Not possible on this machine");
		XmErr(MONO_SCREEN);
		BackDropImage = 0;
		return;
	} else if (viewtype == VIEW_ORTH || viewtype == VIEW_STEREO) {
		XmErr(NOT_IN_THIS_MODE);
		BackDropImage = 0;
		return;
	} else {
		theVisual = DefaultVisual(theDisplay, theScreen);
		xi = XCreateImage(theDisplay, theVisual, BackDepth, ZPixmap, 0, (char *) image, (unsigned int)width,(unsigned int) height, 16, 0);
		Im_pp = XCreatePixmap(theDisplay, theWindow, DrawingAreaWidth, DrawingAreaHeight,(unsigned int) BackDepth);
		XPutImage(theDisplay, Im_pp, LocalGC, xi, 0, 0, 0, 0, (unsigned int)width, (unsigned int)height);
		if(Im_pp==NULL) fprintf(stderr,"Image Pixmap not here\n");
		XCopyArea(theDisplay, Im_pp, theWindow, LocalGC, 0, 0, (unsigned int)width, (unsigned int)height, 0, 0);
	}

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Pixmap
MakeImage(image, theWindow, width, height, Expand)
char *image;
Window theWindow;
int width;
int height;
int Expand;
{
	char *imptr;
	int i;
	XImage *xi;
	static Pixmap Im_pp;
	Visual *theVisual;
	int BackDepth;
	static LastGamma=-99999;

	if (FirstPass) {
		imptr = image;
		for (i = 0; i < (width * height); i++) {
			*imptr >>= 1;
			*imptr++ = colorpixels[(int) *imptr];
		}
		FirstPass = 0;
	}
	else XmgfFree(xim);

	if (TwoDimSettings){
		if (Gamma!=LastGamma)	{
	 	ximtmp = RotateImage(&width,&height,image,Gamma);
		LastGamma=Gamma;
		}
        }
	else ximtmp = image;

	xim = ScaleImage(&width,&height,ximtmp);
	
	BackDepth = XDefaultDepth(theDisplay, theScreen);
	if (BackDepth > 1) {
		theVisual = DefaultVisual(theDisplay, theScreen);
		xi = XCreateImage(theDisplay, theVisual, BackDepth, ZPixmap, 0, (char *) xim,(unsigned int) width,(unsigned int) height, 16, 0);
		Im_pp = XCreatePixmap(theDisplay, theWindow,(unsigned int) width,(unsigned int) height,(unsigned int) BackDepth);
		XPutImage(theDisplay, Im_pp, theGC, xi, 0, 0, 0, 0,(unsigned int) width,(unsigned int) height);
		}
	else {
		XmErr(MONO_SCREEN);
		Im_pp = 0;
		BackDropImage = 0;
	}

	return Im_pp;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PlaceImage(Imag, theWindow, LocalGC, x, y, width, height)
Pixmap Imag;
Window theWindow;
GC LocalGC;
int x;
int y;
int width;
int height;
{
	int ImageX, ImageY;
	int Width_of_Screen, Height_of_Screen;
	int BackDepth;


	Width_of_Screen = DrawingAreaWidth;
	Height_of_Screen = DrawingAreaHeight;

	ImageX = (Midx-(width/2));
	ImageY = (Midy-(height/2));
	BackDepth = XDefaultDepth(theDisplay, theScreen);

	if (BackDepth >= 8) {
		XCopyArea(theDisplay, Imag, theWindow, LocalGC, 0, 0, (unsigned int)width,(unsigned int) height, ImageX,ImageY);
	} else {
		XmErr(MONO_SCREEN);
		BackDropImage = 0;
	}
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
char *
ReadImage(imagefile, DropWidth, DropHeight)
char *imagefile;
int *DropWidth;
int *DropHeight;
{
	int bufsize;
	long i;
	int maxgrey;
	char *Image;
	unsigned char buf, Red, Green, Blue;
	FILE *fp;
	char *Header;
	char *FileFormat;
	int status;
	char *newfilename;

	Header = (char *) XmgfMalloc(MAX_FILENAME * sizeof(char));
	FileFormat = (char *) XmgfMalloc(10 * sizeof(char));
	newfilename = (char *) XmgfMalloc(MAX_FILENAME * sizeof(char));
	/* Contribution from Merik Bober eep1mb@surrey.ac.uk */
	/* Reading a pgm file with a comment in */
	/* See if file is Compressed */
	status = CompressionTest(imagefile, newfilename);
#ifdef DEBUG
	fprintf(stderr, "- %s - %d \n", newfilename, status);
#endif
	fp = fopen(newfilename, "r");
	if (NULL != fp) {
		fscanf(fp, "%s\n", FileFormat);
		if (1 != fscanf(fp, "%[^\n]\n", Header)) {
			if (WindowOpen) XmErr(IMAGE_FORMAT);
			else MyXmgfErr("I'm couldn't read the header\n");
			return (char *) NULL;
		}
	} else {
		if (WindowOpen) XmErr(FILE_NOT_FOUND);
		else MyXmgfErr("Image file not found\n");
		return (char *) NULL;
	}
	while (Header[0] == '#')
		fscanf(fp, "%[^\n]\n", Header);
	sscanf(Header, "%d %d", DropWidth, DropHeight);
	fscanf(fp, "%[^\n]\n", Header);
	while (Header[0] == '#')
		fscanf(fp, "%[^\n]\n", Header);
	sscanf(Header, "%d", &maxgrey);
	if (!strcasecmp(FileFormat, "P5")) {
		bufsize = (*DropWidth) * (*DropHeight);
		Image = (char *) XmgfMalloc((*DropWidth) * (*DropHeight));
		for (i = 0; i < bufsize; i++) {
			fread(&buf, sizeof(unsigned char), 1, fp);
			Image[i] = (char) (buf / 2);
		}
	} else {
		/* fprintf(stderr,"%s\n",FileFormat); */
		bufsize = (*DropWidth) * (*DropHeight);
		Image = (char *) XmgfMalloc((*DropWidth) * (*DropHeight));
		for (i = 0; i < bufsize; i++) {
			fread(&Red, sizeof(unsigned char), 1, fp);
			fread(&Green, sizeof(unsigned char), 1, fp);
			fread(&Blue, sizeof(unsigned char), 1, fp);
			Image[i] = (char) ((MONO(Red, Green, Blue)) / 2);
		}

	}
	fclose(fp);
	OrBackDropWidth = BackDropWidth;
        OrBackDropHeight = BackDropHeight;
	FirstPass = 1;
	if (status == 1)
		CompressionCleanUp(newfilename);
	return Image;
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void UpdateImage()
{

    ImagePix =
        MakeImage(BackImage, w_Orth, BackDropWidth, BackDropHeight,ExpandImage);
   if (DoubleBuff){
    ImageDraw =
      MakeImage(BackImage, theDrawable, BackDropWidth, BackDropHeight,ExpandImage);
   }
   if (ExpandImage) {
    if (DoubleBuff)
        PlaceImage(ImageDraw, theDrawable,
                        theGC, Ox, Oy, (2*BackDropWidth), (2*BackDropHeight));
    else
        PlaceImage(ImagePix, w_Orth,
                        theGC, Ox, Oy, (2*BackDropWidth), (2*BackDropHeight));
   } else {
    if (DoubleBuff)
        PlaceImage(ImageDraw, theDrawable,
                  theGC, Ox, Oy, BackDropWidth, BackDropHeight);
    else
        PlaceImage(ImagePix, w_Orth, theGC, Ox, Oy, BackDropWidth, BackDropHeight);
   }
}

char *
ScaleImage(oldwidth,oldheight,image)
int *oldwidth;
int *oldheight;
char *image;
{
	char *newimage,*nmpt;
	char *smpt,*impt;
	int    *XIndex;
	int    *YIndex;
	int     ix,iy,imy;
	int	imptr=0;
	int	newwidth,newheight;
	float ratio1,ratio2;
	

	newwidth = (int)(Scale_factor*(*oldwidth));
        newheight = (int)(Scale_factor*(*oldheight));
	if (newwidth%2) newwidth+=1;

	if (newwidth<4) newwidth=4;
	if (newheight<4) newheight=4;

	XIndex = (int *) XmgfMalloc(newwidth*sizeof(int));
	assert(XIndex);
	YIndex = (int *) XmgfMalloc(newwidth*sizeof(int));
	assert(YIndex);

	newimage = (char *) XmgfMalloc(newwidth*newheight*sizeof(char));
	assert(newimage);

	/* PreCalculate rations (its a speed hing again) */
        ratio1 = (float)*oldwidth/(float)newwidth;
        ratio2 = (float)*oldheight/(float)newheight;

	for (ix=0; ix<newwidth; ix++)
	    XIndex[ix] = (int)(ratio1 * ix);
	for (iy=0; iy<newheight; iy++)
	    YIndex[iy] = (*oldwidth)*(int)(ratio2 * iy);

	for (iy=0;  iy<newheight;  iy++) {
         for (ix=0; ix<newwidth;  ix++)
             newimage[imptr++] = image[(YIndex[iy]+XIndex[ix])];
        }

	
	*oldwidth = newwidth;
	*oldheight = newheight;
	BackDropWidth = newwidth;
	BackDropHeight = newheight;
	free(XIndex);
	free(YIndex);
	return newimage;
}

char *
ScaleImageOld(oldwidth,oldheight,image)
int *oldwidth;
int *oldheight;
char *image;
{
        char *newimage;
        int    *XIndex;
        int     ix,iy,imy;
        int     imptr=0;
        int     newwidth,newheight;


        newwidth = (int)(Scale_factor*(*oldwidth));
        newheight = (int)(Scale_factor*(*oldheight));
        if (newwidth%2) newwidth+=1;
        XIndex = (int *) XmgfMalloc(newwidth*sizeof(int));
        assert(XIndex);
        newimage = (char *) XmgfMalloc(newwidth*newheight*sizeof(char));
        assert(newimage);

        for (ix=0; ix<newwidth; ix++)
            XIndex[ix] = (*oldwidth * ix) / newwidth;

        for (iy=0;  iy<newheight;  iy++) {
                imy = (*oldheight * iy) / newheight;
                for (ix=0; ix<newwidth;  ix++)
                   newimage[imptr++] = image[((imy*(*oldwidth))+(XIndex[ix]))];
        }
        *oldwidth = newwidth;
        *oldheight = newheight;
        BackDropWidth = newwidth;
        BackDropHeight = newheight;
        free(XIndex);
        return newimage;
}




#define IMGPOS(x,y) (((y)*width)+(x))
char *
RotateImage(oldwidth,oldheight,image,angle)
int *oldwidth;
int *oldheight;
char *image;
int angle;
{
        char *newimage;
        double theta,ni,nj;
        int ini,inj;
        double x,y;
        double ct,st;
	int width,height;
	int i,j;
	double Dangle;
	int Width2,Height2;
	double mst;

	height = *oldheight;
	width =  *oldwidth;
        newimage = (char *) XmgfMalloc(width*height*sizeof(char));
        assert(newimage);

  	Dangle = (double)-angle-180;      
        theta = (double)Dangle*3.14159/180.0;
        ct = cos(-theta);
        st = sin(-theta);
	Width2 = (int)width/2;
	Height2 = (int)height/2;
	mst = -st;
        for(i=0;i<height;i++){
                y = (double)i-Height2;
          for(j=0;j<width;j++){
                x = (double)j-Width2;
                ini = (int)(mst*x + ct*y) + Height2;
                inj = (int)(ct*x + st*y) + Width2;
                if (ini<0 || ini >height || inj < 0 || inj > width)
		newimage[IMGPOS(j,i)]=0;
                else newimage[IMGPOS(j,i)]=image[IMGPOS(inj,ini)];
          } 
        } 

        *oldwidth = width;
        *oldheight = height;
        BackDropWidth = width;
        BackDropHeight = height;
        return newimage;
}

