/*static char sccsid[]="@(#)%E% P.Hoad@ee.surrey.ac.uk %I% %M%";*/
/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 * 
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <math.h>
#include <stdio.h>
#include "LL.h"
#include "PGLLstand.h"

#include <assert.h>

typedef struct {
  int             IdLineNum;
  int             IdSetNum;
} t_XmgfId;

typedef struct {
  t_LL            ListXmgfSets;
} t_XmgfSets;

typedef struct {
  t_LL            Format;
  t_LL            IDNames;
} t_XmgfFormatStruct;

typedef struct {
  char           *XmgfSetName;
  int             XmgfSetNum;
  int             XmgfLineNum;
  int             IDidentifier;
} t_ID_Info;

typedef struct {
  char            Name[200];
  char            FormatLine[200];
  t_LL            Format;
  t_XmgfFormatStruct XmgfFormat;
  t_LL            ListXmgfLines;
} t_XmgfSet;

typedef struct {
  t_LL            ListXmgfObjects;
  t_LL            ListXmgfIds;	/* List of t_XmgfId */
} t_XmgfLine;

typedef struct {
  t_LL            ListXmgfPolys;
  int             visible;
  t_ID_Info       gfID;
} t_XmgfObject;


typedef struct {
  int             num;
  int             ColNum;
  int             OldColNum;
  int             Ill;
  int             fill;
  int             cull;
  int             LineStyle;
  int             FillStyle;
  int             LineWidth;
  int             z_depth;
  int             PtType;
  int             BaseType;
  int 		  Clipped;
  int		  Font;
  int		  FontSize;
  int 		  FontWeight;
  int		  FontSlant;
  int 		  PtSize;
#ifdef MALLOCTEXT
  char            *Text;
#else
  char            Text[50];
#endif
  t_LL            ListXmgfPts;
} t_XmgfPoly;

typedef struct {
  double           x;
  double           y;
  double           z;
  double	   ax;
  double	   ay;
  double	   az;
} t_XmgfPt;

typedef struct {
  char   *Bits;
  void   *Funct;
  int     ButtType;
  int     Parm;
  char   *MouseMess;
}       t_IconInfo;



#ifndef _NO_PROTO
t_LL            LoadSingleItem (char *SingleLine, int itemType, int *Pos);
t_LL            LoadRepItem (char *SingleLine, int NewItemNumber, int *Pos, int RepNum);
t_LL            ReadGeneral (char *SingleLine, int *Pos, int PrimitiveType);
t_LL            GetData (t_LLSet InSet);
t_XmgfSet      *SelectSet (int *SetNum);
t_XmgfLine     *SelectLine (int *SetNum, int *LineNum);
t_XmgfFormatStruct ExtractFormat (char *FormatLine);
char           *GetName (t_LLSet InSet);
char           *GetFormat (t_LLSet InSet);
int             LoadSets (char *filename);
int             LoadNumItem (char *SingleLine, int *Pos);
int             DrawSets (void);
int             DrawSet (int SetNum);
int             DrawSelectedLine (t_XmgfLine *SelectedLine);
int             PrimtoInt (char *Primitive);
#else
t_LL            LoadSingleItem ();
t_LL            LoadRepItem ();
t_LL            ReadGeneral ();
t_LL            GetData ();
t_XmgfSet      *SelectSet ();
t_XmgfLine     *SelectLine ();
t_XmgfFormatStruct ExtractFormat ();
char           *GetName ();
char           *GetFormat ();
int             LoadSets ();
int             LoadNumItem ();
int             DrawSets ();
int             DrawSet ();
int             DrawSelectedLine ();
int             PrimtoInt ();
#endif

typedef struct {
        char            Text[50];
        int             Font;
        int             FontSize;
        int             FontWeight;
        int             FontSlant;
        t_XmgfPt        Marker;
        } t_XmgfText;

typedef struct {
        int             PtType;
        int             PtSize;
        double          x;
        double          y;
        double          z;
        double          ax;
        double          ay;
        double          az;
        } t_XmgfSinglePt;

typedef struct {
        double   Ill;
        int      LineStyle;
        int      FillStyle;
        int      LineWidth;
        double   z_depth;
        t_LL     ListXmgfPts;
        } t_XmgfPolygon;

typedef struct {
        int      ObjectType;
        int      visible;
        int      ColNum;
        union {
        t_XmgfText     TextObject;
        t_XmgfSinglePt PtObject;
        t_XmgfPolygon  PolygonObject;
        } ObjUnion;
} t_XmgfGenericObj;

