
#include <stdio.h>
#include <string.h>

/* These are the tokens defined for ASCII SLA files */
#define SOLIDNAME     "solid"
#define ENDSOLIDNAME  "endsolid"
#define PATCHNAME     "facet"
#define ENDPATCHNAME  "endfacet"
#define LOOPSTART     "outer"
#define LOOPEND       "endloop"
#define POINT3D       "vertex"
#define SOLIDNAME_U     "SOLID"
#define ENDSOLIDNAME_U  "ENDSOLID"
#define PATCHNAME_U     "FACET"
#define ENDPATCHNAME_U  "ENDFACET"
#define LOOPSTART_U     "OUTER"
#define LOOPEND_U       "ENDLOOP"
#define POINT3D_U       "VERTEX"
#define EXTENSIONCHAR '.'
#define DEF_INPUT_EXTENSION  ".sla"
#define DEF_OUTPUT_EXTENSION ".gf"

#define MAX_LINE_LEN  200
#define MAX_NAME_LEN  100
#define MAX_TOKEN_LEN  20
#define MAX_NUMB_TOKEN  5

FILE *InputFile;
FILE *OutputFile;

#ifdef _NO_PROTO
 void            FormatError ();
 void            WriteOutput ();
 int             OpenInputAndOutput ();
#else
 void            FormatError (int LineNumber);
 void            WriteOutput (char *newstring);
 int             OpenInputAndOutput( int argc, char **argv );
#endif


int main(argc, argv)
int argc; char **argv;
	{
	char GeneralBuffer[MAX_NAME_LEN];
	char SingleLineBuffer[MAX_LINE_LEN];
	char Tokens[MAX_NUMB_TOKEN][MAX_TOKEN_LEN];
	int LineCounter;

	fprintf(stderr,"sla2gf Filter :- D.Johnston 1993-Aug-25\n");

	/* check command line arguments, supply extensions and/or
	output file name if required */
	if( OpenInputAndOutput( argc, argv ) == 0 )
		exit( -1 );

	WriteOutput( ";This file produced from SLA2gf filter\n");
	WriteOutput( ";It contains only one set of Polygon3D objects\n");

	/* Now... we can get to work */
	LineCounter = 0;

	/* we should be able to read the name of the shape from the first line */
	if( fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
		FormatError( LineCounter );
	else
		{
		LineCounter++;
		sscanf( SingleLineBuffer, "%s", Tokens[0]);
		if( strcmp(Tokens[0], SOLIDNAME) == 0 ||
		   strcmp(Tokens[0], SOLIDNAME_U) == 0 )
		   {
		   /* correct format */
                   /* if there is a second argument, use it as the set name,
                    *  else use the input file name
                    */
                    if( strlen(SingleLineBuffer) <=strlen(Tokens[0])+1){
                    /* no second argument */
                    fprintf(stderr,"No SetName. Using Filename\n");
                    sprintf(GeneralBuffer,"@Set %s\nFormat Polygon3D\n",argv[1]);
		    }
                    else
                      {
                      sscanf( SingleLineBuffer, "%s %s", Tokens[0], Tokens[1]);
                      sprintf(GeneralBuffer, "@Set %s\nFormat Polygon3D\n",Tokens[1]);
                      }
                      WriteOutput( GeneralBuffer );
                      }
		else
			/* incorrect format */
			FormatError( LineCounter );
		}

	/* now loop through the rest of the file */
	while( fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) != NULL )
		{
		LineCounter++;
		sscanf( SingleLineBuffer, "%s", Tokens[0]);
		
		/* check for end of input */
		if( strcmp(Tokens[0], ENDSOLIDNAME ) == 0 ||
			strcmp(Tokens[0], ENDSOLIDNAME_U ) == 0 )
			/* no more facets, let us quit out of here */
			break;
		else if( strcmp(Tokens[0], PATCHNAME ) == 0 ||
			strcmp(Tokens[0], PATCHNAME_U ) == 0 )
			/* should be start of a 'facet' loop */
			{
			/* we can throw away this line, gf does not use surface normals */
			/* read the first line of the multi-line patch description */
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			sscanf( SingleLineBuffer, "%s", Tokens[0]);
			/* should be start of loop, discard if true */
			if ((strcmp( Tokens[0], LOOPSTART) != 0) &&
				(strcmp( Tokens[0], LOOPSTART_U) != 0) )
				FormatError( LineCounter );
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			sscanf( SingleLineBuffer, "%s %s %s %s",
					 Tokens[0], Tokens[1], Tokens[2], Tokens[3]);
			if ((strcmp( Tokens[0], POINT3D) != 0) &&
				(strcmp( Tokens[0], POINT3D_U) != 0) )
				FormatError( LineCounter );
			/* we have the first point/corner of polygon */
			sprintf( GeneralBuffer, "3 %s %s %s \\\n",
					 Tokens[1], Tokens[2], Tokens[3]);
			WriteOutput( GeneralBuffer );
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			sscanf( SingleLineBuffer, "%s %s %s %s",
					 Tokens[0], Tokens[1], Tokens[2], Tokens[3]);
			if (strcmp( Tokens[0], POINT3D) != 0 &&
				strcmp( Tokens[0], POINT3D_U) != 0 )
				FormatError( LineCounter );
			/* we have the second point/corner of polygon */
			sprintf( GeneralBuffer, "%s %s %s \\\n",
					 Tokens[1], Tokens[2], Tokens[3]);
			WriteOutput( GeneralBuffer );
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			sscanf( SingleLineBuffer, "%s %s %s %s",
					 Tokens[0], Tokens[1], Tokens[2], Tokens[3]);
			if (strcmp( Tokens[0], POINT3D) != 0 &&
				strcmp( Tokens[0], POINT3D_U) != 0 )
				FormatError( LineCounter );
			/* we have the third (and final) point/corner of polygon */
			sprintf( GeneralBuffer, "%s %s %s \n",
					 Tokens[1], Tokens[2], Tokens[3]);
			WriteOutput( GeneralBuffer );
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			sscanf( SingleLineBuffer, "%s", Tokens[0]);
			/* should be end of loop, discard if true */
			if (strcmp( Tokens[0], LOOPEND) != 0 &&
				strcmp( Tokens[0], LOOPEND_U) != 0 )
				FormatError( LineCounter );
			LineCounter++;
			if (fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) == NULL )
				FormatError( LineCounter );
			sscanf( SingleLineBuffer, "%s", Tokens[0]);
			/* should be end of loop, discard if true */
			if (strcmp( Tokens[0], ENDPATCHNAME) != 0 &&
				strcmp( Tokens[0], ENDPATCHNAME_U) != 0 )
				FormatError( LineCounter );
			/* we are done our loop */
			}
		else
			/* must be an error in format of input file */
			FormatError( LineCounter );

		} /* end of outer while loop */

	/* close the output file, close input, exit */
        WriteOutput("@\n");
	close(InputFile);
	close(OutputFile);
	fprintf(stderr,"Conversion complete, %d lines in input file\n", LineCounter);
	return 0;
	}
/* end of main */

int OpenInputAndOutput( argc, argv )
int argc;
char **argv;
	{
	char GeneralBuffer[MAX_NAME_LEN];
	char Tokens[MAX_NUMB_TOKEN][MAX_TOKEN_LEN];
	char *PositionOfExtension;

	/* check for number of command line arguments, also check for
	 *  default extensions on the files
	 */
	switch( argc )
		{
	default:
                fprintf(stderr,"Usage: %s infile[%s] [outfile[%s]]\n ", argv[0],
			DEF_INPUT_EXTENSION, DEF_OUTPUT_EXTENSION);
                return(0);
		break;
	case 2:
		/* only the input file was specified, check for extension */
		strcpy( GeneralBuffer, argv[1]);
		PositionOfExtension =  strchr( GeneralBuffer, EXTENSIONCHAR);
		if ( PositionOfExtension == NULL )
			/* the input file name has no extension, use default */
			strcat( GeneralBuffer, DEF_INPUT_EXTENSION );
		/* try to open the input file, quit if cannot */
		if ((InputFile=fopen(GeneralBuffer,"r"))==NULL)
			{
			fprintf(stderr,"File %s cannot be opened for input\n", GeneralBuffer);
			return(0);
			break;
			}
		/* since no output file was supplied, use same name, new extension if necessary */
		strcpy( GeneralBuffer, argv[1]); /* restore origional supplied filename  */
		/* if the input file had an extension, replace it with default output extension */
		if ( PositionOfExtension == NULL )
			strcat( GeneralBuffer, DEF_OUTPUT_EXTENSION );
		else
			strcpy( PositionOfExtension, DEF_OUTPUT_EXTENSION );
		/* now try to open the filename we just created for output */
		if ((OutputFile = fopen(GeneralBuffer,"w")) == NULL)
			{
			fprintf(stderr,"File %s cannot be opened for output\n", GeneralBuffer);
			exit(-1);
			break;
			}
		break;

	case 3:
		/* both an input filename and an output filename were supplied */
		/* check for extension on input name */
		strcpy( GeneralBuffer, argv[1]);
		PositionOfExtension =  strchr( GeneralBuffer, EXTENSIONCHAR);
		if ( PositionOfExtension == NULL )
			/* the input file name has no extension, use default */
			strcat( GeneralBuffer, DEF_INPUT_EXTENSION );
		if ((InputFile=fopen(GeneralBuffer,"r"))==NULL)
			{
			fprintf(stderr,"File %s cannot be opened for input\n", GeneralBuffer);
			exit(-1);
			break;
			}
		/* now use output name, check for extension */
		strcpy( GeneralBuffer, argv[2]);
		PositionOfExtension =  strchr( GeneralBuffer, EXTENSIONCHAR);
		if ( PositionOfExtension == NULL )
			/* the output file name has no extension, use default */
			strcat( GeneralBuffer, DEF_OUTPUT_EXTENSION );
		if ((OutputFile=fopen(GeneralBuffer,"w"))==NULL)
			{
			fprintf(stderr,"File %s cannot be opened for output\n", GeneralBuffer);
			exit(-1);
			break;
			}
		break;

		} /* end switch on argc */
	return(1);
	}

void FormatError(LineNumber)
int LineNumber;
	{
	fprintf(stderr,"Format error encountered on input file, line %d\n", LineNumber);
	close(InputFile);
	close(OutputFile);
	exit(-1);
	}

void WriteOutput(newstring)
char *newstring;
	{
	if( fprintf(OutputFile, "%s", newstring) == (int)EOF )
		{
		fprintf(stderr,"End-Of-File encountered on input file\n");
		close(InputFile);
		close(OutputFile);
		exit(-1);
		}
	}
