
#include <stdio.h>
#include <string.h>

#include "filter.h"

extern FILE *InputFile;
extern FILE *OutputFile;

/* CheckAndOpenFiles - use the command line arguments to open the
 *     files as supplied or the default files if not supplied (ie
 *     default extensions are provided).  If the program has no 
 *     problem then we teturn TRUE, else FALSE.
 */
bool CheckAndOpenFiles(argc, argv)
int argc; char **argv;
	{
	char GeneralBuffer[MAX_NAME_LEN];
	char *PositionOfExtension;

	/* check command line arguments, supply extensions and/or
	output file name if required */
	switch( argc )
		{
	default:
                fprintf(stderr,USAGE_STRING);
                return( FALSE );
		break;
	case 2:
		/* only the input file was specified, check for extension */
		strcpy( GeneralBuffer, argv[1]);
		PositionOfExtension =  strchr( GeneralBuffer, EXTENSIONCHAR);
		if ( PositionOfExtension == NULL )
			/* the input file name has no extension, use default */
			strcat( GeneralBuffer, DEF_INPUT_EXTENSION );
		if ((InputFile=fopen(GeneralBuffer,"r"))==NULL)
			{
			fprintf(stderr,"File %s cannot be opened for input\n", GeneralBuffer);
			return( FALSE );
			break;
			}
		/* since no output file was supplied, use same name, new extension */
		if( PositionOfExtension == NULL )
			strcpy( GeneralBuffer, argv[1]);
		else
			*PositionOfExtension = '\0';  /* remove the existing extension */
		strcat( GeneralBuffer, DEF_OUTPUT_EXTENSION );
		if ((OutputFile = fopen(GeneralBuffer,"w")) == NULL)
			{
			fprintf(stderr,"File %s cannot be opened for output\n", GeneralBuffer);
			return( FALSE );
			break;
			}
		break;

	case 3:
		/* both an input filename and an output filename were supplied */
		/* check for extension on input name */
		strcpy( GeneralBuffer, argv[1]);
		PositionOfExtension =  strchr( GeneralBuffer, EXTENSIONCHAR);
		if ( PositionOfExtension == NULL )
			/* the input file name has no extension, use default */
			strcat( GeneralBuffer, DEF_INPUT_EXTENSION );
		if ((InputFile=fopen(GeneralBuffer,"r"))==NULL)
			{
			fprintf(stderr,"File %s cannot be opened for input\n", GeneralBuffer);
			return( FALSE );
			break;
			}
		/* now use output name, check for extension */
		strcpy( GeneralBuffer, argv[2]);
		PositionOfExtension =  strchr( GeneralBuffer, EXTENSIONCHAR);
		if ( PositionOfExtension == NULL )
			/* the output file name has no extension, use default */
			strcat( GeneralBuffer, DEF_OUTPUT_EXTENSION );
		if ((OutputFile=fopen(GeneralBuffer,"w"))==NULL)
			{
			fprintf(stderr,"File %s cannot be opened for output\n", GeneralBuffer);
			return( FALSE );
			break;
			}
		break;

		} /* end switch on argc */

       return( TRUE );
       } /* end of CheckAnd.. routine  */

void FormatError(LineNumber)
int LineNumber;
	{
	fprintf(stderr,"Format error encountered on input file, line %d\n", LineNumber);
	close(InputFile);
	close(OutputFile);
	exit(-1);
	}

void WriteOutput(newstring)
char *newstring;
	{
	if( fprintf(OutputFile, "%s", newstring) == (int)EOF )
		{
		fprintf(stderr,"End-Of-File encountered on output file\n");
		close(InputFile);
		close(OutputFile);
		exit(-1);
		}
	}
