#include "public.h"
#include "WidgetObj.h"
#include "InterfaceObj.h"
#include "Resource.h"

#define String XString
#include "Xm/Xm.h"
#include "Xm/MessageB.h"
#undef String

Widget error_window;
Widget warning_window;

bool operator!= (const WidgetObj & item1,const WidgetObj &item2)
{
  if(item1.index == item2.index)
    return false;
  else
    return true;
}
bool operator== (const WidgetObj & item1,const WidgetObj &item2)
{
  if(item1.index == item2.index)
    return true;
  else
    return false;
}

bool operator!= (const InterfaceObj & item1,const InterfaceObj &item2)
{
  if(item1.index == item2.index)
    return false;
  else
    return true;
}
bool operator== (const InterfaceObj & item1,const InterfaceObj &item2)
{
  if(item1.index == item2.index)
    return true;
  else
    return false;
}

bool operator!= (const Resource & item1,const Resource &item2)
{
  if(strcmp(item1.get_name(),item2.get_name())==0)
    return false;
  else
    return true;
}

bool operator== (const Resource & item1,const Resource &item2)
{
  if(strcmp(item1.get_name(),item2.get_name())==0)
    return true;
  else
    return false;
}

int x_error_handler(Display * display, XErrorEvent *err)
{
  Arg arg[5]; 
  register int n = 0;
  char  msg[256];
  XmString str;
  
  XGetErrorText(display,err->error_code, msg, 256);
  str = XmStringCreate(msg,XmFONTLIST_DEFAULT_TAG);
  XtSetArg(arg[n], XmNmessageString, str); n++;
  XtSetValues(error_window,arg,n); 
  XtManageChild(error_window);
  XmStringFree(str); 
}

void xt_warning_handler(XString msg)
{
  XmString str;
  Arg arg[5]; 
  register int n = 0;
 
  if(msg && *msg)
  {
    str = XmStringCreateLtoR(msg,XmFONTLIST_DEFAULT_TAG);
    XtSetArg(arg[n], XmNmessageString, str); n++;
    XtSetValues(error_window,arg,n); 
    XtManageChild(error_window);
    XmStringFree(str); 
  }
}
void display_warning(char * msg)
{
  XmString str;
  Arg arg[5]; 
  register int n = 0;
 
  if(msg && *msg)
  {
    str = XmStringCreateLtoR(msg,XmFONTLIST_DEFAULT_TAG);
    XtSetArg(arg[n], XmNmessageString, str); n++;
    XtSetValues(warning_window,arg,n); 
    XtManageChild(warning_window);
    XmStringFree(str); 
  }
}

Widget create_error_message_box()
{
  Arg arg[5]; 
  register int n = 0;
  Widget box = NULL;
  Widget message_box = NULL;
  
  XtSetArg(arg[n], XmNdeleteResponse, XmUNMAP); n++;
  XtSetArg(arg[n], XmNallowShellResize, TRUE); n++;
  box = XmCreateDialogShell ( guide->get_top_widget(), "ERROR MESSAGE", arg, n );
  n = 0;
  XtSetArg(arg[n], XmNdialogType, XmDIALOG_ERROR); n++;
  message_box = XmCreateMessageBox ( box, "ERROR MESSAGE", arg, n );
  n = 0;

  return(message_box);
}

Widget create_warning_message_box()
{
  Arg arg[5]; 
  register int n = 0;
  Widget box = NULL;
  Widget message_box = NULL;
  
  XtSetArg(arg[n], XmNdeleteResponse, XmUNMAP); n++;
  XtSetArg(arg[n], XmNallowShellResize, TRUE); n++;
  box = XmCreateDialogShell ( guide->get_top_widget(), 
			      "WARNING MESSAGE", arg, n );
  n = 0;
  XtSetArg(arg[n], XmNdialogType, XmDIALOG_WARNING); n++;
  message_box = XmCreateMessageBox ( box, "WARNING MESSAGE", arg, n );
  n = 0;

  return(message_box);
}

void set_handlers()
{
  error_window = create_error_message_box();
  warning_window = create_warning_message_box();

  XSetErrorHandler(x_error_handler);
  XtAppSetWarningHandler(app_context,xt_warning_handler);
}
