/* WidgetResourceEditor.h */

#ifndef _WIDGETRESOURCEEDITOR_H
#define _WIDGETRESOURCEEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:WidgetResourceEditor********** Documentation **************/
// Creation Data : Thu Nov 21 09:53:46 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class WidgetResourceEditor :
 
*/
/*oodE************************************************************/
/*oodB#WidgetResourceEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Guide.h"
#include "Factory.h"
#include "DesignEditor.h"
#include "WidgetObj.h"
  enum widget_menu_enum {
       // File
       // Windows
       // Help
       // BUttons
       widget_apply_v,
       widget_close_v,
       widget_help_v
  };
  typedef enum widget_core_menu widget_core_menu;
  enum window_type_enum {
    display_v,
    setting_v,
    callback_v,
    drag_drop_v,
    color_pixmap_v,
    last_window_type_v
  };
  typedef enum window_type_enum window_type_enum;
/*oodE************************************************************/

class WidgetResourceEditor {
private:
  Widget _WidgetCoreResource;
  Widget _form;
  Widget _display_widget;
  Widget _setting_widget;
  Widget _callback_widget;
  Widget _drag_drop_widget;
  Widget _color_pixmap_widget;
  bool _is_popped;
  window_type_enum _window_type;
  window_type_enum _old_window_type;
  widget_type_enum _old_type;
protected : // member functions
	void init(void);
	void create_window(void);
        void show_display_window(void);
        void show_setting_window(void);
        void show_callback_window(void);
        void show_drag_drop_window(void);
        void show_color_pixmap_window(void);
        void remove_display_window(void);
        void remove_setting_window(void);
        void remove_callback_window(void);
        void remove_drag_drop_window(void);
        void remove_color_pixmap_window(void);
        void update_display_window(void);
        void update_setting_window(void);
        void update_callback_window(void);
        void update_drag_drop_window(void);
        void update_color_pixmap_window(void);
        void apply_display_window(void);
        void apply_setting_window(void);
        void apply_callback_window(void);
        void apply_drag_drop_window(void);
        void apply_color_pixmap_window(void);
        void create_form(Widget *prev, resource_rec &res_rec);
        void manage(Widget child);
        void unmanage(Widget child);
        int * get_resource_index();
        int get_number_of_resources();
        char * get_token(char * search_str);
        char * get_dynamic_value(resource_rec & res);
public : // member functions
	WidgetResourceEditor();
	~WidgetResourceEditor();
        void apply(void);
	void popup(void);
	void popdown(void);
        void update(void);
        void unmanage_all(void);
        void set_mode(window_type_enum mode);
        void text_changed(resource_rec * res_rec);
        void option_changed(resource_rec * res_rec);
        static void button_CB(Widget w, XtPointer clientdata, XtPointer calldata);
        static void set_mode_CB(Widget w, XtPointer clientdata, XtPointer calldata);
        static void text_changed_CB(Widget w, XtPointer clientdata, XtPointer calldata);
        static void option_changed_CB(Widget w, XtPointer clientdata, XtPointer calldata);
};

#endif
