/* Factory.C */

#include "Factory.h"
// Super Class : None

/*oodB%Factory*** Global Declarations and Stuffs ****/
/*oodE***********************************************/

Factory::Factory()
{
	// Empty
}

Factory::~Factory()
{
	// Empty
}

void Factory::create_widget(widget_type_enum type)
{
	cout << widget_name[type] << " created \n";
}

Widget Factory::create_widget(Widget parent,char* name,widget_type_enum wtype,void CALLBACK_FUNCTION,XtPointer callbackdata,callback_type_enum cbtype,int use_pixmap,Arg al[],int& ac)
{
   Widget w;
   PixmapServer * p = guide->get_PixmapServer();
   Pixmap pmap = 0;

   if(use_pixmap)
   {
     XtSetArg(al[ac],XmNlabelType,XmPIXMAP);ac++;
   }

   // check what kind of widget is requested and create the necessary widget(s)
   switch(wtype)
   {
      case applicationshell_v:
      case toplevelshell_v:
        XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
        XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
        w = XtCreatePopupShell(name,
			       topLevelShellWidgetClass,
			       parent,
			       al,ac);
        ac = 0;
	break;
      case errordialog_v:
        w = XmCreateErrorDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case formdialog_v:
        w = XmCreateFormDialog(parent,name,al,ac);
        XtManageChild(w);
        break;
      case informationdialog_v:
        w = XmCreateInformationDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case questiondialog_v:
        w = XmCreateQuestionDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case promptdialog_v:
        w = XmCreatePromptDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case selectiondialog_v:
        w = XmCreateSelectionDialog(parent,name,al,ac);
        XtManageChild(w);
        break;
      case templatedialog_v:
        w = XmCreateTemplateDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case warningdialog_v:
        w = XmCreateWarningDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case workingdialog_v:
        w = XmCreateWorkingDialog(parent,name,al,ac);
        XtManageChild(w);
	break;
      case menubar_v:
	w = XmCreateMenuBar(parent,name,al,ac);
        XtManageChild(w);
	break;
      case optionmenu_v:
	w = XmCreateOptionMenu(parent,name,al,ac);
        XtManageChild(w);
        break;
      case popupmenu_v:
	w = XmCreatePopupMenu(parent,name,al,ac);
	break;
      case pulldownmenu_v:
        w = XmCreatePulldownMenu(parent,name,al,ac);
	break;
      case radiobox_v:
         w =  XmCreateRadioBox(parent,name,al,ac);
        XtManageChild(w);
	break;
      case scrolledlist_v:
        w =  XmCreateScrolledList(parent,name,al,ac);
        XtManageChild(w);
	break;
      case scrolledtext_v:
        w =  XmCreateScrolledText(parent,name,al,ac);
        XtManageChild(w);
	break;
      case arrowbutton_v:
      case arrowbuttongadget_v:
      case bulletinboard_v:
      case cascadebutton_v:
      case cascadebuttongadget_v:
      case command_v:
      case dialogshell_v:
      case drawingarea_v:
      case drawnbutton_v:
      case fileselectionbox_v:
      case form_v:
      case frame_v:
      case label_v:
      case labelgadget_v:
      case list_v:
      case mainwindow_v:
      case messagebox_v:
      case panedwindow_v:
      case pushbutton_v:
      case pushbuttongadget_v:
      case rowcolumn_v:
      case scale_v:
      case scrollbar_v:
      case scrolledwindow_v:
      case selectionbox_v:
      case separator_v:
      case separatorgadget_v:
      case text_v:
      case textfield_v:
      case togglebutton_v:
      case togglebuttongadget_v:
        w = XtCreateManagedWidget(name,*widget_class_name[wtype],parent,al,ac);
        ac = 0;
	break;
   }

   if(use_pixmap)
   {
     pmap = p->get_pixmap((widget_type_enum)use_pixmap);
     XtSetArg(al[ac],XmNlabelPixmap,pmap);ac++;
   }

   if(ac != 0)
   {
     XtSetValues(w,al,ac);
   }
 
   if(f != NULL)
   {
     XtAddCallback(w,&callback_name[cbtype][3],f,callbackdata);
   }

   return(w);
}
