/* DesignEditor.h */

#ifndef _DESIGNEDITOR_H
#define _DESIGNEDITOR_H

#include "Classes.h"

#ifndef DEFAULT_TYPE
#define DEFAULT_TYPE
typedef int DefaultType;
#endif

/*oodB:DesignEditor********** Documentation **************/
// Creation Data : Sat Oct 26 18:54:36 1996
// Programmer : Automatic
// Revised Date :
/* Purpose of Class DesignEditor :
 
*/
/*oodE****************************************************/
/*oodB#DesignEditor*** Some Definitions and Stuffs *******/
#include "public.h"
#include "Factory.h"
#include "Guide.h"
#include "WidgetObj.h"
#include "InterfaceObj.h"
#include "ConstraintEditor.h"
#include "LiteClue.h"
/*oodE****************************************************/

class DesignEditor {
private : // data members
	Factory* _factory;
	Widget _Shells;
	Widget _Managers;
	Widget _Primitives;
	Widget _Dialogs;
	Widget _Gadgets;
	Widget _WidgetArea;
	Widget _InterfaceArea;
	Widget _warea;
	Widget _iarea;
        Widget _liteClue;
protected : // member functions
	void init();
        void resize_drawing(void);
        void draw_tree(Widget w);
        void draw_selection_box(Widget w,int x,int y,int width,int height);
        void clear_widget_area();
        void clear_interface_area();
        void create_interface_popup(Widget parent);
        void create_widget_popup(Widget parent);
        void create_children(Widget w, WidgetObj * parent,widget_type_enum type);
        void create_form_attachments(WidgetObj * wc, WidgetObj *wn, Arg al[],int &ac);
        void create_frame_args(WidgetObj *wc, Arg al[],int &ac);
public : // member functions
	DesignEditor();
	~DesignEditor();
	void popup();
	void popdown();
	void create_widget(widget_type_enum type);
	void update_widget_area(void);
	void update_interface_area(void);
        void set_sensitive_pixmaps(void);
        void sensitise_all(bool sensitive);
        void sensitise_buttons(widget_type_enum type);
	static void create_widget_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void widget_area_input_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void widget_area_refresh_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void interface_area_input_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void interface_area_refresh_CB(Widget w,XtPointer clientdata,XtPointer calldata);
	static void default_pushbutton_CB(Widget w,XtPointer clientdata,XtPointer calldata);
        void update_displays(void);
        void select_interface(int x,int y);
        void select_widget(int x,int y);
        void save_layout(void);
        unsigned long get_color(char * color);
};

#endif
