#define VERSION                "1.0"

#define ERR_SYNTAX             -1
#define ERR_BAD_LIST           -2
#define ERR_MEMORY             -3

#define NONE                   -1
#define MAX_PROGS              64

typedef struct _resources_rec
  {
    Boolean   notify;
    Boolean   motd;
    Boolean   remote;
    Boolean   keep_tmp_file;
    int       wm_count;
    String    wm_names;
    String    default_wm;
    Boolean   allow_bell;
    Boolean   ring_bell;
    Boolean   startup;
    int       app_count;
    String    app_names;
    String    lock_command;
    int       num_defines;
    String   *defines_sym;
    String   *defines_val;
    Boolean   sounds;
#ifdef SOUNDS
    String    sound_start;
    String    sound_end;
    String    sound_start_wm;
    String    sound_end_wm;
    String    sound_start_app;
    String    sound_end_app;
    String    sound_lock;
    String    sound_notify;
#endif /* SOUNDS */
  }
  resources_rec;

typedef struct _wm_info_rec
  {
    char  *short_name;
    char  *full_name;
    char  *command;
    char  *config_file;
    char  *cmdline_opt;
    char  *env_opt;
    char  *tmp_config_file;
  }
  wm_info_rec;

typedef struct _app_info_rec
  {
    char  *short_name;
    char  *full_name;
    char  *command;
  }
  app_info_rec;
