/* 
 * Copyright (C) 1993 Alain Nissen & Raphael Quinet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Authors :
 *    Raphael Quinet <quinet@montefiore.ulg.ac.be>
 *                   <quinet@server.montefiore.ulg.ac.be>
 *    Alain Nissen   <nissen@montefiore.ulg.ac.be>
 *                   <nissen@server.montefiore.ulg.ac.be>
 */

#include <sys/wait.h>
#include <sys/utsname.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include "xsession.h"
#include "resources.h"
#ifdef SOUNDS
#include <rplay.h>
#endif /* SOUNDS */

#ifdef __STDC__
extern void input_ready_callback(Widget w, int *input, XtInputId *input_id);
extern void clear_proc(Widget w, XEvent *event, String params[],
                       Cardinal *num_params);
extern void iconify_proc(Widget w, XEvent *event, String params[],
                         Cardinal *num_params);
extern void deiconify_proc(Widget w, XEvent *event, String params[],
                           Cardinal *num_params);
extern void start_choosing_proc(Widget w, XEvent *event, String params[],
                                Cardinal *num_params);
extern void end_choosing_proc(Widget w, XEvent *event, String params[],
                              Cardinal *num_params);
void wm_protocols_proc(Widget w, XEvent *event, String params[],
		       Cardinal *num_params);
#else
extern void input_ready_callback();
extern void clear_proc();
extern void iconify_proc();
extern void deiconify_proc();
extern void start_choosing_proc();
extern void end_choosing_proc();
void wm_protocols_proc();
#endif

extern int           errno;
extern Widget        top_shell;

char                *program_name;
int                  pipe_fd[2];
XtAppContext         app_context;
resources_rec        resources;
Boolean              widget_ok;

static Atom          XA_WM_DELETE_WINDOW;
static XtInputId     input_id;
static int           return_code;
static Boolean       closing_top_shell;
static XtActionsRec  actions[] =
  {
    {
      "WMProtocols",   wm_protocols_proc
    },
    {
      "Clear",         clear_proc
    },
    {
      "Iconify",       iconify_proc
    },
    {
      "Deiconify",     deiconify_proc
    },
    {
      "StartChoosing", start_choosing_proc
    },
    {
      "EndChoosing",   end_choosing_proc
    }
  };


#ifdef SOUNDS
/*****************************************************************************
 *                                 play_sound                                *
 *---------------------------------------------------------------------------*
 * Plays a sound on the current display, using the rplay library.            *
 *****************************************************************************/

#ifdef __STDC__
void play_sound(char *sound_name)
#else
void play_sound(sound_name)
     char *sound_name;
#endif
{
  if (resources.sounds && (sound_name != NULL) && strcmp(sound_name, "none"))
    {
      if (rplay_display(sound_name) < 0)
	console_log("Error: can't play a sound\n");
    }
}
#endif /* SOUNDS */


/*****************************************************************************
 *                               quit_callback                               *
 *---------------------------------------------------------------------------*
 * Terminates the program.                                                   *
 *****************************************************************************/

#ifdef __STDC__
void quit_callback(Widget w, XtPointer client_data, XtPointer call_data)
#else
void quit_callback(w, client_data, call_data)
     Widget    w;
     XtPointer client_data, call_data;
#endif
{
  end_current_wm();
  widget_ok = False;
  if (input_id)
    XtRemoveInput(input_id);
  if (top_shell)
    XtDestroyWidget(top_shell);
  /*
   * The following hack shuts down the socket used by "rsh".  If xsession is
   * launched with a remote shell (e.g. "xon numbercruncher xsession -remote"),
   * this is the only way to be sure that the "rsh" ends as soon as you quit
   * xsession.  If you don't use the "-remote" option, the socket will remain
   * open as long as there is a child of xsession alive (e.g. xterm, emacs,...)
   * and the "rsh" won't end.
   */
  if (resources.remote)
    shutdown(fileno(stdout), 2);
#ifdef SOUNDS
  play_sound(resources.sound_end);
#endif /* SOUNDS */
  exit(return_code);
}


/*****************************************************************************
 *                                fatal_error                                *
 *---------------------------------------------------------------------------*
 * Prints an error message and terminates the program.                       *
 *****************************************************************************/

#ifdef __STDC__
void fatal_error(int error_code, char *message)
#else
void fatal_error(error_code, message)
     int   error_code;
     char *message;
#endif
{
  return_code = error_code;
  fprintf(stderr, "%s: ", program_name);
  switch (error_code)
    {
      case ERR_SYNTAX :
        fprintf(stderr, "Syntax error.  Parameter \"%s\" not recognized.\n",
		message);
        break;
      case ERR_BAD_LIST :
        fprintf(stderr, "Invalid list.\n");
        break;
      case ERR_MEMORY :
        fprintf(stderr, "Out of memory!  Cannot allocate %u bytes\n",
		*((unsigned *) message));
        break;
      default :
        fprintf(stderr, "Error code #%d.\n", error_code);
    }
  quit_callback(top_shell, (XtPointer) NULL, (XtPointer) NULL);
}


/*****************************************************************************
 *                                  zmalloc                                  *
 *---------------------------------------------------------------------------*
 * Just a wrapper around malloc().                                           *
 *****************************************************************************/

#ifdef __STDC__
char *zmalloc(unsigned size)
#else
char *zmalloc(size)
     unsigned size;
#endif
{
  char *p;

  p = (char *)malloc(size);
  if (p == NULL)
    fatal_error(ERR_MEMORY, (char *)&size);
  return p;
}


/*****************************************************************************
 *                                  zrealloc                                 *
 *---------------------------------------------------------------------------*
 * Just a wrapper around realloc().                                          *
 *****************************************************************************/

#ifdef __STDC__
char *zrealloc(char *ptr, unsigned size)
#else
char *zrealloc(ptr, size)
     char *ptr;
     unsigned size;
#endif
{
  char *p;

  p = (char *)realloc(ptr, size);
  if (p == NULL)
    fatal_error(ERR_MEMORY, (char *)&size);
  return p;
}


/*****************************************************************************
 *                               wm_protocols_proc                           *
 *---------------------------------------------------------------------------*
 * Handles WM_PROTOCOL client messages.  If a WM_DELETE_WINDOW is sent, then *
 * the program must exit.                                                    *
 *****************************************************************************/

#ifdef __STDC__
void wm_protocols_proc(Widget w, XEvent *event, String params[], Cardinal *num_params)
#else
void wm_protocols_proc(w, event, params, num_params)
     Widget    w;
     XEvent   *event;
     String    params[];
     Cardinal *num_params;
#endif
{
  if (event -> xclient.data.l[0] == XA_WM_DELETE_WINDOW)
    if (! closing_top_shell)
      {
        closing_top_shell = True;
        quit_callback(top_shell, (XtPointer) NULL, (XtPointer) NULL);
        closing_top_shell = False;
      }
}


/*****************************************************************************
 *                                    main                                   *
 *---------------------------------------------------------------------------*
 * Believe me : the program won't run without this function...               *
 *****************************************************************************/

#ifdef __STDC__
#ifdef SGI
void main(int argc, char *argv[])
#else
void main(unsigned argc, char *argv[])
#endif
#else
void main(argc, argv)
#ifdef SGI
     unsigned argc;
#else
     int   argc;
#endif
     char *argv[];
#endif
{
  char *p;

  if ((program_name = strrchr(argv[0], (int) '/')) == NULL)
    program_name = argv[0];
  else
    program_name ++;
  return_code = 0;
  widget_ok = False;
  top_shell = XtAppInitialize(&app_context, "XSession",
                              options, XtNumber(options),
			      &argc, argv,
                              fallback_resources, NULL, ZERO);
  XA_WM_DELETE_WINDOW = XInternAtom(XtDisplay(top_shell),
				    "WM_DELETE_WINDOW", False);
  XtGetApplicationResources(top_shell, (XtPointer) &resources,
                            resources_desc, XtNumber(resources_desc),
			    NULL, ZERO);
  XtAppAddActions(app_context, actions, XtNumber(actions));

  resources.num_defines = 0;
  for (argv++, argc--; argc; argv++, argc--)
    if (!strcmp(*argv, "-help") || !strcmp(*argv, "--help")
	|| !strcmp(*argv, "-usage") || !strcmp(*argv, "--usage"))
      {
	printf("Usage: %s [-toolkitoption ...] [-defaultWM <name>] [-D<symbol>[=<value>]]\n",
	       program_name);
#ifdef SOUNDS
	printf("                [-notify] [-remote] [-sounds] [-startup] [-version] [-help]\n");
#else
	printf("                [-notify] [-remote] [-startup] [-version] [-help]\n");
#endif /* SOUNDS */
        quit_callback(top_shell, (XtPointer) NULL, (XtPointer) NULL);
      }
    else
      if (!strcmp(*argv, "-version") || !strcmp(*argv, "--version"))
	{
	  printf("XSession %s\n", VERSION);
	  quit_callback(top_shell, (XtPointer) NULL, (XtPointer) NULL);
	}
      else
	if ((argv[0][0] == '-') && (argv[0][1] == 'D'))   /* defines */
	  {
	    p = *argv + 2;
	    while (*p && (*p != '='))
	      p++;
	    if (*p == '=')
	      {
		*p = '\0';
		p++;
	      }
	    if (resources.num_defines++ == 0)
	      {
		resources.defines_sym = (String *)zmalloc(sizeof(String));
		resources.defines_val = (String *)zmalloc(sizeof(String));
		resources.defines_sym[0] = *argv + 2;
		resources.defines_val[0] = p;
	      }
	    else
	      {
		resources.defines_sym =
		  (String *)zrealloc((char *) resources.defines_sym,
				     resources.num_defines * sizeof(String));
		resources.defines_val =
		  (String *)zrealloc((char *) resources.defines_val,
				     resources.num_defines * sizeof(String));
		resources.defines_sym[resources.num_defines - 1] = *argv + 2;
		resources.defines_val[resources.num_defines - 1] = p;
	      }
	  }
	else
	  fatal_error(ERR_SYNTAX, *argv);

  get_wm_resources();
  get_app_resources();
  p = getenv("HOME");
  if (p != NULL)
    chdir(p);
  if (getenv("DISPLAY") == NULL)
    {
      p = (char *)zmalloc((10 + strlen(DisplayString(XtDisplay(top_shell))))
			  * sizeof(char));
      sprintf(p, "DISPLAY=%s", DisplayString(XtDisplay(top_shell)));
      putenv(p);
    }
  create_widgets();
  XtRealizeWidget(top_shell);
  widget_ok = True;
  XSetWMProtocols(XtDisplay(top_shell), XtWindow(top_shell),
		  &XA_WM_DELETE_WINDOW, 1);
  pipe(pipe_fd);
  input_id = XtAppAddInput(app_context, pipe_fd[0],
			   (XtPointer) XtInputReadMask,
                           (XtInputCallbackProc) input_ready_callback, NULL);
  activate_timeout();

  if (resources.motd)
    print_motd();

#ifdef SOUNDS
  play_sound(resources.sound_start);
#endif /* SOUNDS */

  startup();
  XtAppMainLoop(app_context);
}
