/*

Copyright 1992 by the University of Edinburgh, Department of Computer Science

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation, and that the name of the University of Edinburgh not be used
in advertising or publicity pertaining to distribution of the software
without specific, written prior permission.  The University of Edinburgh
makes no representations about the suitability of this software for any
purpose.  It is provided "as is" without express or implied warranty.

*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xmu/Converters.h>

#include <stdio.h>
#include <signal.h>

typedef struct _Resources {
	Pixmap	bitmap;
	Pixmap	iconBitmap;
	int	killPid;
	int	killSleep;
	Boolean	debug;
	Boolean bottom;
} Resources;

static Resources theResources;

static XtResource resourceSpec[] = {
	{ "bitmap", "Bitmap", XtRBitmap, sizeof(Pixmap),
	  XtOffsetOf(Resources, bitmap), XtRString, "hand.xbm" },
	{ "iconBitmap", "IconBitmap", XtRBitmap, sizeof(Pixmap),
	  XtOffsetOf(Resources, iconBitmap), XtRString, "stop.xbm" },
	{ "killPid", "KillPid", XtRInt, sizeof(int),
	  XtOffsetOf(Resources, killPid), XtRImmediate, (XtPointer) 0 },
	{ "killSleep", "KillSleep", XtRInt, sizeof(int),
	  XtOffsetOf(Resources, killSleep), XtRImmediate, (XtPointer) 4 },
	{ "debug", "Debug", XtRBoolean, sizeof(Boolean),
	  XtOffsetOf(Resources, debug), XtRImmediate, (XtPointer) False },
	{ "bottom", "Bottom", XtRBoolean, sizeof(Boolean),
	  XtOffsetOf(Resources, bottom), XtRImmediate, (XtPointer) False },
};

static XrmOptionDescRec options[] = {
	{ "-kill", ".killPid", XrmoptionSepArg, NULL },
	{ "-sleep", ".killSleep", XrmoptionSepArg, NULL },
	{ "-bitmap", ".bitmap", XrmoptionSepArg, NULL },
	{ "-iconbitmap", ".iconBitmap", XrmoptionSepArg, NULL },
	{ "-iconBitmap", ".iconBitmap", XrmoptionSepArg, NULL },
	{ "-text", "*dialog.label", XrmoptionSepArg, NULL },
	{ "-font", "*font", XrmoptionSepArg, NULL },
	{ "-buttonfont", "*Command*font", XrmoptionSepArg, NULL },
	{ "-debug", ".debug", XrmoptionNoArg, "True" },
};

static XtConvertArgRec screenConvertArg[] = {
    { XtBaseOffset, (XtPointer) XtOffset(Widget, core.screen), sizeof(Screen *)}
};

static XtAppContext appContext;
static Widget shell;
static Widget stop;
static Widget popup;
static Widget dialog;
static Widget yes;
static Widget no;

void stopCallback();
void yesCallback();
void noCallback();
void popupCallback();
void killTimeout();

main(argc, argv)
int argc;
char **argv;
{	Arg args[10];
	int n;
	Position iconX, iconY;

	shell = XtAppInitialize(&appContext, "XQuitButton", 
			options, XtNumber(options),
			&argc, argv, NULL, NULL, 0);

	XtAddConverter(XtRString, XtRBitmap, XmuCvtStringToBitmap,
		screenConvertArg, XtNumber(screenConvertArg));

	XtGetApplicationResources(shell, &theResources,
			resourceSpec, XtNumber(resourceSpec), NULL, 0);

	n = 0;
	XtSetArg(args[n], XtNiconPixmap, theResources.iconBitmap);	n++;
	XtSetValues(shell, args, n);

	n = 0;
	XtSetArg(args[n], XtNbitmap, theResources.iconBitmap);	n++;
	stop = XtCreateManagedWidget("stop", commandWidgetClass,
			shell, args, n);
	XtAddCallback(stop, XtNcallback, stopCallback, NULL);

	popup = XtCreatePopupShell("popup", transientShellWidgetClass,
			shell, NULL, 0);
	XtAddCallback(popup, XtNpopupCallback, popupCallback, NULL);

	n = 0;
	XtSetArg(args[n], XtNicon, theResources.bitmap);	n++;
	dialog = XtCreateManagedWidget("dialog", dialogWidgetClass,
			popup, args, n);

	yes = XtCreateManagedWidget("yes", commandWidgetClass,
			dialog, NULL, 0);
	XtAddCallback(yes, XtNcallback, yesCallback, NULL);

	no = XtCreateManagedWidget("no", commandWidgetClass,
			dialog, NULL, 0);
	XtAddCallback(no, XtNcallback, noCallback, NULL);

	XtRealizeWidget(popup);
	XtRealizeWidget(shell);
	if (theResources.bottom)
		XLowerWindow(XtDisplay(shell), XtWindow(shell));
	XtAppMainLoop(appContext);
}

static void stopCallback(w, client, call)
Widget w;
XtPointer client, call;
{	XtPopup(popup, XtGrabNone);
}

static void yesCallback(w, client, call)
Widget w;
XtPointer client, call;
{	if (theResources.killPid) {
		kill(theResources.killPid, SIGHUP);
		(void) XtAppAddTimeOut(appContext, theResources.killSleep,
				killTimeout, NULL);
		XtPopdown(popup);
	}
	else exit(0);
}

static void noCallback(w, client, call)
Widget w;
XtPointer client, call;
{	XtPopdown(popup);
}

static void popupCallback(w, client, call)
Widget w;
XtPointer client, call;
{	Dimension width;
	Dimension height;
	Arg args[10];
	int n;

	XBell(XtDisplay(w), 0);

	n = 0;
	XtSetArg(args[n], XtNwidth, &width);	n++;
	XtSetArg(args[n], XtNheight, &height);	n++;
	XtGetValues(w, args, n);

	n = 0;
	XtSetArg(args[n], XtNx, (WidthOfScreen(XtScreen(w)) - width) / 2);
	n++;
	XtSetArg(args[n], XtNy, (HeightOfScreen(XtScreen(w)) - height) / 2);
	n++;
	XtSetValues(w, args, n);
}

static void killTimeout(client, timer)
XtPointer client;
XtIntervalId *timer;
{	if (theResources.killPid) kill(theResources.killPid, SIGKILL);
	exit(0);
}
