/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
File:    xmib.c
System:  xmib ver. 1.00
Author:  Ranen Goren
Date:    20/07/92

File remarks: contains the xmib main(), and highest-level snmp routines
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/


#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include <dnpap.h>
#include <snmp.h>
#include <mib.h>
#include <stdarg.h>
#include <err.h>
#include "parse.h"
#include "mibinc.h"
#include "xmib.h"


char *SNMP_Errors[]=
{
    "No Error",					/* PKT_NOERROR */
    "To many SNMP varaibles in one request",	/* PKT_TOOBIG */
    "No such MIB variable",			/* PKT_NOSUCHNAME */
    "Illegal value",				/* PKT_BADVALUE */
    "Attempt to write READONLY MIB variable",	/* PKT_READONLY */
    "Unknown SNMP error"			/* PKT_GENERR */
};
/**
* execute an snmp command
*	type = PKT_GETRQS --> snmp-get
*	type = PKT_SETRQS --> snp-set
*	type = PKT_NXTRQS --> snmp-getnext
*	type = PKT_TBLRQS --> snmp-table
**/


extern SNMP_PARAMS snmpParams;
static mgt_sck	*handle;



/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
void main(int argc, char **argv)
{
    MIBNODE *mibRoot;
    
    
    initWidgets(&argc, argv);
    mibRoot = snmpOpen();
    MibShowXTree(mibRoot);
    startMainLoop();
}







/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
MIBNODE *snmpOpen()
{
    MIBNODE *mibRoot;
    
    if((handle=MgtOpn(htons(snmpParams.port), MgtAdr(snmpParams.host))) == NULL)
    {
	ERR_ERR(2, ERR_CRITICAL, "Opening SNMP port to %s failed\n", snmpParams.host);
    }	
    if (MibInit()!=0)
    {
	ERR_ERR(3, ERR_CRITICAL, "Mib initialization failed\n");
    }
       /* read the MIB files */
    MibFullMib();
    if ((mibRoot = MibFindNode(snmpParams.root)) == NULL)
	ERR_ERR(4, ERR_CRITICAL, "Invalid root given as a resource\n");
    return mibRoot;
}    







/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
void snmpClose()
{
    MgtCls(handle);
}    







/*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*/
int snmpCall(type, line)
  int type;
  char *line;
{  
    pkt_msg message;
    int table[256];
    int tableLength;
    int r;

    if(GetList(line,message.MsgPdu.PduRor.RorLst,PKT_SZERORLST,
	       (int *) &message.MsgPdu.PduRor.RorLstLen)<0)
    {
	strcpy(line, "Couldn't parse request");
	return 1;
    }
    tableLength=message.MsgPdu.PduRor.RorLst[0].ObjOjiLen;
    memcpy(table,message.MsgPdu.PduRor.RorLst[0].ObjOji,tableLength*sizeof(int));
    while(1)
    {
	strcpy(message.MsgCom, snmpParams.community);
	message.MsgComLen=strlen(snmpParams.community);
	if (type == PKT_TBLRQS)
	    message.MsgPdu.PduRor.RorTyp=PKT_NXTRQS;
	else
	    message.MsgPdu.PduRor.RorTyp=type;
	message.MsgPdu.PduRor.RorRid=0;
	message.MsgPdu.PduRor.RorErrSts=PKT_NOERROR;
	message.MsgPdu.PduRor.RorErrInd=0;
	if ( MgtRqs(handle, &message, snmpParams.timeout*1000000,
		  snmpParams.retries) < 0 )
	{
	    strcpy(line, "SNMP request failed, too many retries");
	    return 1;
	}
	if(type == PKT_TBLRQS)
	    if (memcmp(table, message.MsgPdu.PduRor.RorLst[0].ObjOji,
		       tableLength*sizeof(int))!=0 ||
		message.MsgPdu.PduRor.RorErrSts == PKT_NOSUCHNAME)
		break;
	
	if (message.MsgPdu.PduRor.RorErrSts!=PKT_NOERROR)
	{
	    if ( (r=PutIdentifier(
		  message.MsgPdu.PduRor.RorLst+message.MsgPdu.PduRor.RorErrInd-1,
		  line,sizeof(line))) < 0 )
		line[0]='\0';
	    else
		line[r]='\0';
#ifdef DEBUG
	    fprintf(stderr, "DEBUG error: ");
	    ERR_DEB(6, ERR_CRITICAL, "SNMP error: <%s>, variable %d, %s\n",
		    SNMP_Errors[message.MsgPdu.PduRor.RorErrSts],
		    message.MsgPdu.PduRor.RorErrInd, line);
#endif
	}
	if(PutList(message.MsgPdu.PduRor.RorLst,message.MsgPdu.PduRor.RorLstLen,
		   line,sizeof(line))<0)
	{
	    strcpy(line, "Couldn't handle result list");
	    return 1;
	}
#ifdef DEBUG
	fprintf(stderr, "Return channel: %s\n", line);
#endif	  
	if(type != PKT_TBLRQS)
	    break;
    }
    return 0;
}
