#include <stdio.h>
#include <assert.h>

int main(argc,argv)
int argc;
char **argv;
{
	int Lum;
	int i;
	int cols=64;
	int r,g,b;
	int ColourMapType;
	int Err;
	
	if (argc<2) {Err = fprintf(stderr,"Usage: ColourMap [map_id] number_of_colours[64]\
	  \n   0=grey 1=Red 2=Green 3=Blue 4=Cyan 5=Yellow 6=Magenta\n");
	assert(Err);
        exit(0);}

	if (argc>1) ColourMapType = atoi(argv[1]);
	else ColourMapType = 0;

	if (argc<3) cols=64;
	else cols = atoi(argv[2]);

	Err = fprintf(stdout,"%d\n",cols);
        assert(Err);
        for (i=0; i< cols; i++) {
        Lum = 256*(i*(256/cols));
        switch(ColourMapType){
        case 0:   r=Lum;g=Lum;b=Lum;break;
        case 1:    r=Lum;g=0;  b=0;  break;
        case 2:  r=0;  g=Lum;b=0;break;
        case 3:   r=0;  g=0;  b=Lum;break;
        case 4: r=Lum;  g=Lum;b=0;break;
        case 5:   r=0;g=Lum;b=Lum;break;
        case 6:r=Lum;g=0;  b=Lum;break;
	default:r=Lum;g=Lum;b=Lum;break;
        }
	Err = fprintf(stdout,"%d %d %d %d\n",i,r,g,b);
        assert(Err);
	}
	return 0;
}
