/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "InitX.h"
#include "GUI.h"
#include "Mouse.h"
#include "callbacks.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void 
XmgfEvent(w, closure, Xmgfevent, done)
Widget  w;
XtPointer closure;
XEvent *Xmgfevent;
int    *done;
{
  static int CurrentButton = 0;


  switch (Xmgfevent->type) {
   case Expose:{
      UpDateVisibleCB(w, (caddr_t)NULL, (caddr_t)NULL);
    }
    break;
   case ButtonPress:{
      XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;
      int     x, y;
      Window  win;

      win = but_event->window;
      x = but_event->x;
      y = but_event->y;

      switch (but_event->button) {
       case Button1:
	PointerSelectSetCB(w, (caddr_t)NULL, (caddr_t)NULL);
	CurrentButton = 1;
	break;
       case Button2:
	CurrentButton = 2;
	break;
       case Button3:
	CurrentButton = 3;
	break;
       default:
	CurrentButton = 0;
	break;
      }
    }
    break;
   case ButtonRelease:{
      XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;
      int     x, y;
      Window  win;

      win = but_event->window;
      x = but_event->x;
      y = but_event->y;
      switch (but_event->button) {
       case Button1:
	CurrentButton = 0;
	break;
       case Button2:
	CurrentButton = 0;
	break;
       case Button3:
	CurrentButton = 0;
	UpDateVisibleCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
       default:
	CurrentButton = 0;
	break;
      }
    }
    break;
   case MotionNotify:{
      switch (CurrentButton) {
       case 1:
	CurrentButton = 1;
	break;
       case 2:
	CurrentButton = 2;
	UpdatePositionCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
       case 3:
	CurrentButton = 3;
	UpdateScaleCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
       default:
	CurrentButton = 0;
	UpdateXYCB(w, (caddr_t)NULL, (caddr_t)NULL);
	break;
      }
    }
    break;
   default:
    break;			/* ignore unexpected events */
  }
}

void
XmgfEventList(w, closure, Xmgfevent, done)
Widget  w;
XtPointer closure;
XEvent *Xmgfevent;
int    *done;
{
  	switch (Xmgfevent->type) {
 	case ButtonPress:{
         XButtonEvent *but_event = (XButtonEvent *) Xmgfevent;

         switch (but_event->button) {
          case Button1:
	   SetCB(w,(caddr_t)SELECTSET,(caddr_t)NULL);
           break;
          case Button2:
	   SetCB(w,(caddr_t)SELECTSET,(caddr_t)NULL);
	   SetCB(w,(caddr_t)ARDEL,(caddr_t)NULL);
           break;
          case Button3:
	   SetCB(w,(caddr_t)SELECTSET,(caddr_t)NULL);
	   SetCB(w,(caddr_t)ARDRAW,(caddr_t)NULL);
           break;
          default:
           break;
         }
	   break;
	}
	case EnterNotify:{
        XmgfMessage("1st Button Select, 2nd Button Delete, 3rd Button Draw");
	break;
	}
	default: break;
	}
}
