/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <assert.h>

#include <Xm/SelectioB.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <XmgfDefines.h>
#include <XmError.h>
#include <stdio.h>
#include <malloc.h>
#include "Disp3DGF.h"
#include "GUI.h"
#include "MotifUtils.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
XmErr(ErrorCode)
int ErrorCode;
{
	Widget w_NotImplemented;
	char *MainMessage;

	MainMessage = (char *) malloc(100 * sizeof(char));
	assert(MainMessage);

	sprintf(MainMessage, "Xmgf SYSTEM Error :-%d", ErrorCode);

	switch (ErrorCode) {
	    case NOT_IMPLEMENTED:
		strcat(MainMessage, " Not Implemented Yet ");
		break;
	    case FILE_NOT_FOUND:
		strcat(MainMessage, " File Not Found ");
		break;
	    case EMPTY_STRING:
		strcat(MainMessage, " Empty String ");
		break;
	    case NO_IMAGE_PRESENT:
		strcat(MainMessage, " No Image Present ");
		break;
	    case MONO_SCREEN:
		strcat(MainMessage, " No Image on MONO Screen ");
		break;
	    case NUMBER_TO_BIG:
		strcat(MainMessage, " Number too Big ");
		break;
	    case MONO_NOSAVE:
		strcat(MainMessage, " Mono Screen Can't Save in this format ");
		break;
	    case IMAGE_FORMAT:
		strcat(MainMessage, " Unrecognised image format. Not P5 pgm ");
		break;
	    case NO_SET:
		strcat(MainMessage, " No Set Selected ");
		break;
	    case NOT_IN_THIS_MODE:
		strcat(MainMessage, " No Images in Orth or Stereo Modes ");
		break;
	    case IMPORT_ERROR:
		strcat(MainMessage, " Import Error  ");
		break;
	    case NO_COMPRESSIONCMD:
		strcat(MainMessage, " Compression Command Not found (see XMgf.ad) ");
		break;
	    default:
		strcat(MainMessage, " An Error Has Occured ");
		break;
	}
#ifdef DEBUG
	fprintf(stderr, "%s\n", MainMessage);
#endif
	w_NotImplemented = CreateSpecialWarningDialog(main_window,
		MainMessage, "Warning_image", "             See README for info ", NULL, 0);
	XtAddCallback(w_NotImplemented, XmNokCallback, (XtCallbackProc) NICB, 0);
	XtManageChild(w_NotImplemented);
	return 0;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
NICB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{

	XtDestroyWidget(w);
	return 0;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
Widget
CreateSpecialWarningDialog(parent, name, image_string, message, arglist, argcount)
Widget parent;
String name;
String image_string;
String message;
ArgList arglist;
int argcount;
{
	Widget warning_dialog;
	Widget work_area2, work_area;
	Widget pixmap_label;
	Widget text_label, text_label1;
	Widget apply_button;
	Widget ok_button;
	Widget kid[5];
	Pixel foreground;
	Pixel background;
	Pixmap pixmap;
	unsigned int i;
	Arg args[10];
	unsigned int n;

	n = (unsigned int) argcount;
	warning_dialog = XmCreatePromptDialog(parent, "Warning", arglist, n);

	XtSetArg(args[0], XmNorientation, XmVERTICAL);
	work_area2 = XmCreateRowColumn(warning_dialog, "workarea2", args, 1);
	XtManageChild(work_area2);

	XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
	work_area = XmCreateRowColumn(work_area2, "workarea", args, 1);
	XtManageChild(work_area);

	XtSetArg(args[0], XmNforeground, &foreground);
	XtSetArg(args[1], XmNbackground, &background);
	XtGetValues(warning_dialog, args, 2);

	foreground = appres.WarningBitmapfg;
	background = appres.WarningBitmapbg;

	n = 0;
	XtSetArg(args[n], XmNlabelType, XmPIXMAP);
	n++;
	pixmap = XmGetPixmap(XtScreen(warning_dialog), image_string, foreground, background);
	XtSetArg(args[n], XmNlabelPixmap, pixmap);
	n++;
	pixmap_label = XmCreateLabel(work_area, "pixmap_label", args, n);
	XtManageChild(pixmap_label);

	XtSetArg(args[0], XmNlabelString, Str2MotStr(name));
	text_label = XmCreateLabel(work_area, "text_label", args, 1);
	XtManageChild(text_label);

	XtSetArg(args[0], XmNlabelString, Str2MotStr(message));
	text_label1 = XmCreateLabel(work_area2, "text_label1", args, 1);
	XtManageChild(text_label1);

	apply_button = XmSelectionBoxGetChild(warning_dialog, XmDIALOG_APPLY_BUTTON);
	ok_button = XmSelectionBoxGetChild(warning_dialog, XmDIALOG_OK_BUTTON);
	XtSetArg(args[0], XmNlabelString, Str2MotStr("          OK          "));
	XtSetValues(ok_button, args, 1);

	i = 0;
	kid[i++] = XmSelectionBoxGetChild(warning_dialog, XmDIALOG_TEXT);
	kid[i++] = XmSelectionBoxGetChild(warning_dialog, XmDIALOG_HELP_BUTTON);
	kid[i++] = XmSelectionBoxGetChild(warning_dialog, XmDIALOG_CANCEL_BUTTON);
	kid[i++] = XmSelectionBoxGetChild(warning_dialog, XmDIALOG_SELECTION_LABEL);
	XtUnmanageChildren(kid, i);
	return (warning_dialog);
}
