/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include <X11/StringDefs.h>
#include <Xm/Scale.h>
#include "XFig.h"
#include "Pixmaps.h"
#include "3Droutines.h"
#include "Parse.h"

int             OutFig;
int             OutFigCol;
FILE           *FigFilePtr;

#ifndef _NO_PROTO 
void MakeOutLineFIG(XPoint *Pts,int num,int LineWidth,int LineStyle);
int SetFigColour(int Color);
#else 
void MakeOutLineFIG();
int SetFigColour();
#endif 



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveFIGCB(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	int ColourRequest = (int) client_data;
	int FileType;

	switch (ColourRequest) {
	    case SAVE_COLOUR:
		FileType = SAVE_FIGCOL_FILE;
		break;
	    case SAVE_GREY:
		FileType = SAVE_FIG_FILE;
		break;
	    default:
		FileType = SAVE_FIG_FILE;
		break;
	}
	XmFileSelect("Saving FIG  File", FileType, FIGFIL, "Out.fig", FIGDIR);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputFIG(fname, Col)
char *fname;
int Col;
{
	switch (Col) {
	    case SAVE_COLOUR:
		OutFigCol = 1;
		break;
	    case SAVE_GREY:
		OutFig = 1;
		break;
	    default:
		OutFig = 1;
		break;
	}
	if ((FigFilePtr = fopen(fname, "w")) == NULL)
		return ;
	else if (OutFig == 1 || OutFigCol == 1)
		InitFig();
	REDRAW_SCREEN;
	if (OutFig == 1 || OutFigCol == 1)
		EndFig();
	fclose(FigFilePtr);
	OutFig = 0;
	OutFigCol = 0;
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PolygonFIG(Pts, num, fill, TmpWind, Color, PtType, BaseType, LineStyle, LineWidth, FillStyle,ShadedVal)
XPoint *Pts;
int num;
int fill;
Window TmpWind;
int Color;
int PtType;
int BaseType;
int LineStyle;
int LineWidth;
int FillStyle;
int ShadedVal;
{
	int i;
	int FigColour = -1;
	int P = DefaultPointSize;
	int FigFill = 0;

	FigColour = SetFigColour(Color);
	fill =  DetermineFillType(fill,num,PtType,FillStyle,BaseType);

	if (Color >= 64) {
		FigFill = 21;
	} else {
		FigColour = -1;
		FigFill = 21 - (int) (((double) Color / 64.0) * 21.0);
	}

	switch (fill) {
	    case DOT:{
			fprintf(FigFilePtr, "6 %d %d %d %d\n", (int) Pts[0].x - P, (int) Pts[0].y - P,
				(int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 %d 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour, 21);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - 1, (int) Pts[0].y - 1);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x - 1, (int) Pts[0].y + 1);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + 1, (int) Pts[0].y + 1);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + 1, (int) Pts[0].y - 1);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x - 1, (int) Pts[0].y - 1);
			fprintf(FigFilePtr, "-6\n");
			break;
		}
	    case PLUS:{
			fprintf(FigFilePtr, "6 %d %d %d %d\n", (int) Pts[0].x - P, (int) Pts[0].y - P,
				(int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x + P, (int) Pts[0].y);
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "-6\n");
			break;
		}
	    case CROSS:{
			fprintf(FigFilePtr, "6 %d %d %d %d\n", (int) Pts[0].x - P, (int) Pts[0].y - P,
				(int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x + P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "-6\n");
			break;
		}
	    case BOX:{
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d \n", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x - P, (int) Pts[0].y - P);

			break;
		}
	    case TRI:{
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x - P, (int) Pts[0].y + P);
			break;
		}
	    case FILLEDTRI:{
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 21 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x - P, (int) Pts[0].y + P);
			break;
		}
	    case FILLEDBOX:{
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 21 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x - P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y - P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x + P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d \n", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d ", (int) Pts[0].x - P, (int) Pts[0].y + P);
			fprintf(FigFilePtr, "%d %d 9999 9999\n", (int) Pts[0].x - P, (int) Pts[0].y - P);
			break;
		}
	    case PTCIRCLE:{
			fprintf(FigFilePtr, "1 3 %d %d %d 0 0 0 0.000 1 0.000 %d %d %d %d %d %d %d %d\n", LineStyle,LineWidth, FigColour, (int) Pts[0].x, (int) Pts[0].y, P, P, (int) Pts[0].x, (int) Pts[0].y, (int) Pts[0].x + P, (int) Pts[0].y + P);
			break;
		}
	    case FILLEDCIRCLE:{
			fprintf(FigFilePtr, "1 3 %d %d %d 0 0 21 0.000 1 0.000 %d %d %d %d %d %d %d %d\n", LineStyle,LineWidth, FigColour, (int) Pts[0].x, (int) Pts[0].y, P, P, (int) Pts[0].x, (int) Pts[0].y, (int) Pts[0].x + P, (int) Pts[0].y + P);
			break;
		}
	    case FILLEDOPAQUE:{/* Polygon and PolyLine */
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 %d 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour, 1);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			for (i = 1; i < num; i++) {
				fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
			}
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			fprintf(FigFilePtr, "9999 9999\n");
			break;
		}
	    case COLOUREDOPAQUE:{
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 %d 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour, 1);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			for (i = 1; i < num; i++) {
				fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
			}
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			fprintf(FigFilePtr, "9999 9999\n");
			break;
		}
	    case FILLEDHIDDENLINE:{
			/* Polygon and PolyLine */
			if (DitherFill) {
			FigFill = 21 - (int) (((double) ShadedVal / 64.0) * 21.0);
			}
			fprintf(FigFilePtr, "2 1 %d %d %d 0 0 %d 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour, 5);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			for (i = 1; i < num; i++) {
				fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
			}
			fprintf(FigFilePtr, "9999 9999\n");
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 %d 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour, 21);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			for (i = 1; i < num; i++) {
				fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
			}
			fprintf(FigFilePtr, "9999 9999\n");
			MakeOutLineFIG(Pts,num,LineWidth,LineStyle);
			break;
		}
	    case COLOUREDLINES:
	    case FILLEDCOLOR:{	/* Polygon */
			if (DitherFill) {
			FigFill = 21 - (int) (((double) ShadedVal / 64.0) * 21.0);
			}
			fprintf(FigFilePtr, "2 3 %d %d %d 0 0 %d 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour, FigFill);
			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			for (i = 1; i < num; i++) {
				fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
			}
			fprintf(FigFilePtr, "9999 9999\n");
			MakeOutLineFIG(Pts,num,LineWidth,LineStyle);
			break;
		}
	    case TEXTLABEL: {
		fprintf(FigFilePtr, "4 0 0 12 0 %d 0 0.000 4 9 27 %d %d %s\001\n",
                        FigColour, Pts[0].x, Pts[0].y, CurrentString);
		break;
        }

	    default:{		/* PolyLine */
			/* If is needed to allow for Lines not being Polygons */
			if (num > 2) {
				fprintf(FigFilePtr, "2 1 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			} else {
				fprintf(FigFilePtr, "2 1 %d %d %d 0 0 0 0.000 -1 0 0\n",LineStyle, LineWidth, FigColour);
			}

			fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
			for (i = 1; i < num; i++) {
				fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
			}
			fprintf(FigFilePtr, "9999 9999\n");
			break;
		}
	}
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitFig()
{
	fprintf(FigFilePtr, "#FIG 2.1\n80 2\n");
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
EndFig()
{
	fprintf(FigFilePtr, "\n");
	return ;
}

void
MakeOutLineFIG(Pts,num,LineWidth,LineStyle)
XPoint *Pts;
int num;
int LineWidth;
int LineStyle;
{
    int FigColour = -1;
    int FigFill;
    int i;

    if(OutLine){
    FigColour = SetFigColour(OutLineColour);
    FigFill = 0;
    fprintf(FigFilePtr, "2 3 %d %d %d 0 0 %d 0.000 -1 0 0\n", 
    LineStyle,LineWidth, FigColour, FigFill);
    fprintf(FigFilePtr, "\t%d %d ", (int) Pts[0].x, (int) Pts[0].y);
    for (i = 1; i < num; i++) {
    fprintf(FigFilePtr, "%d %d ", (int) Pts[i].x, (int) Pts[i].y);
    }
    fprintf(FigFilePtr, "9999 9999\n");
    }
}

int SetFigColour(Color)
int Color;
{
	int FigColour = -1;
	switch (Color) {
            case 64:
                FigColour = 0;
                break;
            case 66:
                FigColour = 1;
                break;
            case 69:
                FigColour = 2;
                break;
            case 72:
                FigColour = 3;
                break;
            case 65:
                FigColour = 4;
                break;
            case 92:
                FigColour = 5;
                break;
            case 67:
                FigColour = 6;
                break;
            case 70:
                FigColour = 7;
                break;
            case -1:
                FigColour = -1;
                break;
            default:
                FigColour = -1;
                break;
	}
	return FigColour;
}

