/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "callbacks.h"
#include "Pixmaps.h"
#include "Parse.h"
#include "3Droutines.h"
#include "VersionInfo.h"
#include "ReadWriteParm.h"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load A Parameter file (call the file selector )            */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadParm(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Loading Parm File", LOAD_PARM_FILE, PARMFIL, "Out.Parm", PARMDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load in those Paramters                                     */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InputPARM(fname)
char *fname;
{
	FILE *FilePtr;

	if ((FilePtr = fopen(fname, "r")) == NULL)
		return ;
	else
	fscanf(FilePtr,
	"%*[^\n]%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n",
#ifndef NEWPARAMETER
	&defTheta, &defPhi, &defGamma, &defOX, &defOY, &defOZ,
	&defScale_factor, &defscal, &viewtype, &FillPolys, &PointType,
	&DefaultLineWidth, &Sorting, &SelectColours, &SelectLabels);
#else 
	&defTheta, &defPhi, &defGamma, &defOX, &defOY, &defOZ,
	&defScale_factor, &defscal, &viewtype, &FillPolys, &PointType,
	&DefaultLineWidth, &Sorting, &SelectColours, &SelectLabels,
	&SelectPoints,&Centroid,&DoubleBuff,&BackFace,&Axis,&AxisLabel,
	&Axis_Size,&DefaultAxisSize,&DefaultAnimSpeed,&DefaultResolution,
	&BackDropImage,&ExpandImage,&Origin,&DefaultLineStyle,
	&DefaultFillStyle,&DefaultTessLevel,&DefaultPointSize,
	&PSOrientation,&PSColour,&polydiv,&FillPolys,&DepthCueing,
	&RotateGuide,&BackGroundColour,&AutoRotateFlag,&AutoCommand,
	&GFColours,&AxisType,&AxisColour,&OrthoGraphicProj,&TwoDimSettings,
	&DefaultPointType,&OutLineColour,&OutLine,&DitherFill,&FixateType
	&FixateType,&ScaleObectType,&DefaultARThetaStep,
	&DefaultARPhiStep,&DefaultARGammaStep,&ARThetaStep,
	&ARPhiStep,&ARGammaStep,&ARScale,&UserScaleFactor,&DefaultMaxDisp);
#endif 


	ScaleNumber = defScale_factor;
	Scale_factor = LogScale(ScaleNumber);
	fclose(FilePtr);
	SetLine(DefaultLineWidth, DefaultLineStyle);
	ResetScale();
	return ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Save out the Parameters (use file selector )                */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SaveParm(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XmFileSelect("Saving Parm File", SAVE_PARM_FILE, PARMFIL, "Out.Parm", PARMDIR);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Save Paramters */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OutputPARM(fname)
char *fname;
{
	FILE *FilePtr;

	if ((FilePtr = fopen(fname, "w")) == NULL)
		return ;
	else
	fprintf(FilePtr,
	"%s\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n",
	FILEFORMAT, Theta, Phi, Gamma, Ox, Oy, Oz, ScaleNumber, DistSC,
	viewtype, FillPolys, PointType, DefaultLineWidth, Sorting,
	SelectColours, SelectLabels);
	fclose(FilePtr);
	return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Load a Parameter and specify a file name ?? why not defunct */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
LoadParmSpecify(filename)
char *filename;
{
	FILE *FilePtr;

	if ((FilePtr = fopen(filename, "r")) == NULL)
		return ;
	else
	fscanf(FilePtr,
	"%*[^\n]%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n%d\n",
	&defTheta, &defPhi, &defGamma, &defOX, &defOY, &defOZ, &ScaleNumber,
	&defscal, &viewtype, &FillPolys, &PointType, &DefaultLineWidth,
	&Sorting, &SelectColours, &SelectLabels);
	Scale_factor = LogScale(ScaleNumber);
	defScale_factor = Scale_factor;
	fclose(FilePtr);
	return ;
}
