/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */
#include <stdio.h>
#include <string.h>
#include <assert.h>

#include <X11/StringDefs.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>
#include <Xm/PushB.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/BulletinB.h>
#include <Xm/List.h>
#include <Xm/Command.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <Xm/Form.h>

#include "XmgfStruct.h"
#include "XmgfGlobal.h"
#include "XmgfDefines.h"
#include "XmgfEvent.h"
#include "3Droutines.h"
#include "GetColNum.h"
#include "XmError.h"
#include "Icons.h"
#include "Disp3DGF.h"
#include "Bitmaps.h"
#include "Rheostat.h"
#include "Stereo.h"
#include "callbacks.h"
#include "Parse.h"
#include "InitX.h"
#include "GUI.h"
#include "Menus.h"
#include "Orth.h"
#include "Perspec.h"
#include "VersionInfo.h"
#include "MotifUtils.h"
#include "Read3DSet.h"
#include "Init.h"
#include "Mouse.h"
#include "BackDrop.h"

#define XSIZE 530
#define YSIZE 530

Widget  AutoScale, AutoScaleVisible, ConButt, SetCButt, w_QuickQuit;
Widget  ReDrawButt, BackCull, DrawAxis, SelColor, SortPolyButt;
Widget  CntrlSetButt, Set2DButt, Del3DButt, QuitButt, Tool_Bar;
Widget  Reset_Button, Rotate_Button, BURChetaLAB, PhiLAB, GammaLAB;
Widget  TransformButtRC, TransformPre, Button_RCTop, submainpane;
Widget  View_Pers, View_Orth, View_Ster, View_Radio, Button_RCBot;
Widget  Distfr, DistRC, DistScal, ImgScale, CommandShell, ThRCfr;
Widget  PhRCfr, GaRCfr, ThRC, PhRC, GaRC, TransformRC, TransformRes;
Widget  ThetaValLAB, PhiValLAB, GammaValLAB, Transformfr, ItemButt;
Widget  OriginButt, OriginColButt, HighLighButt, CommandShellDia;
Widget  CommandShellDia, SetControlShellDia, ControlShellDia;
Widget  ControlShell, SetControlShell, ARSizeShellDia, graphicspane;
Widget  ThetaTog, PhiTog, GammaTog, AllScale, Orthdr, pieces;
Widget  versionRC, versionFile, versionName, w_version, main_window;
Widget  fr2, ScRC, w_Theta, w_Phi, w_Gamma, fr1, fr0, ViewManager;
Widget  frameRC, fr2a, fr2b, ScRC1, OX, OY, OZ, toplevel, mainpane;
Widget  ThetaLAB, ZoomButt, MessageBox, MessageFrame,MessageForm;
Widget  IconShellDia, IconShell, IconCButt, SubLeftRC;
Widget  RightRC, versionFileFr;
Widget  ArrIconPanel[ICONNUMBER];
Widget  ArrIconCanvas[ICONNUMBER];
int     TmpTheta, TmpPhi, TmpGamma;

char   *XMGFVERSION;
char   *XMGFRELEASE;
char   *RELEASEDATE;
char   *FILEFORMAT;



#define ITEM_OK 0
#define ITEM_CAN 1
#define THETA_ANG 2
#define PHI_ANG 3
#define GAMMA_ANG 4

#define ITEM_PANEL 0
#define THETA_PANEL 1
#define PHI_PANEL 2
#define GAMMA_PANEL 3

Widget  SetCoordLab, SetNumLab, SetArName;
Widget  ColorPal, ShellDia;
Widget  ColShellDia, ColShell;
Widget  PtShellDia, PtShell;
Widget  AxisShellDia, AxisPtShell;
Widget  LnShellDia, LnShell;
Widget  AnimShellDia, AnimShell;
Widget  AnimSpeedShellDia,AnimSpeedScal;
Widget  SetList;
Widget  ColourList;
int     GlobalSetNum, GlobalLineNum;
t_LL    HighLightedPoly;
t_LL    HighLightItem;
t_LL    HighIDObjects;
t_LL    IDListTmp;
int     ControlOpen = 0;
int     HighLightColor = 0;
int     OriginColour = 0;

static int SetNum, LineNum;

Widget  SetArPtT, SetArLin;


#define XPushFnt(w) { \
if(w)\
{XRaiseWindow(theDisplay,XtWindow((w))); \
return ; }}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
create_master_widgets()
{
 /* set up windows */
  Arg     args[10];
  char   *TitleBannerName;

  Widget  LeftRC;
  Widget  TopRC;

#ifdef MAIN_PANEL
  Widget  RightRC;

#endif

 /* Version Stuff */
  XMGFVERSION = (char *) malloc(10 * sizeof(char));
  assert(XMGFVERSION);
  XMGFRELEASE = (char *) malloc(10 * sizeof(char));
  assert(XMGFRELEASE);
  RELEASEDATE = (char *) malloc(10 * sizeof(char));
  assert(RELEASEDATE);
  FILEFORMAT = (char *) malloc(100 * sizeof(char));
  assert(FILEFORMAT);
  TitleBannerName = (char *) malloc(100 * sizeof(char));
  assert(TitleBannerName);

  sprintf(XMGFVERSION, "%s", appres.XMgfVersion);
  sprintf(XMGFRELEASE, "%s", appres.XMgfRelease);
  sprintf(RELEASEDATE, "%s", appres.XMgfRelDate);
  sprintf(FILEFORMAT, "#Xmgfv %s.%s :Paul Hoad UoS %s",
    XMGFVERSION, XMGFRELEASE, RELEASEDATE);

 /* Main window */
 /* Frame */
  fr0 = XtCreateManagedWidget("Frame0", xmFrameWidgetClass, main_window, args, 0);
 /* Vertical Row-Col Holding Version/MenuBar/MainFrameRC */
  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 4);
  XtSetArg(args[2], XmNorientation, XmVERTICAL);
  mainpane = XtCreateManagedWidget("mainpane", xmRowColumnWidgetClass, fr0, args, 3);

 /* Version */
  sprintf(TitleBannerName, "3D Xmgf- %s.%s  Author:Paul Hoad,  UoS %s ",
    XMGFVERSION, XMGFRELEASE, RELEASEDATE);

  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNorientation, XmVERTICAL);
  TopRC = XtCreateManagedWidget("TopRC",
    xmRowColumnWidgetClass, mainpane, args, 3);
  XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
#ifdef MAIN_PANEL
  versionRC = XtCreateManagedWidget("versionRC",
    xmRowColumnWidgetClass, TopRC, args, 3);
  w_version = XtCreateManagedWidget(TitleBannerName,
    xmLabelWidgetClass, versionRC, args, 0);
#else
  w_version = XtCreateManagedWidget(TitleBannerName,
    xmLabelWidgetClass, TopRC, args, 0);
  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
  versionRC = XtCreateManagedWidget("versionRC",
    xmRowColumnWidgetClass, TopRC, args, 3);
#endif
  versionFile = XtCreateManagedWidget("CurrentFile:",
    xmLabelWidgetClass, versionRC, args, 0);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("None"));
  versionName = XtCreateManagedWidget("versionName",
    xmLabelWidgetClass, versionRC, args, 1);

 /* Tool Bar */

  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 1);
  XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
  Tool_Bar = XtCreateManagedWidget("Tool_Bar", xmRowColumnWidgetClass, TopRC, args, 3);

 /* Tool Bar Buttons */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
 /* Auto Scale Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  AutoScale = XtCreateManagedWidget("AutoScale",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(AutoScale, XmNactivateCallback,
    (XtCallbackProc) AutoScaleCB, (caddr_t) NULL);
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
 /* Auto Scale Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  AutoScaleVisible = XtCreateManagedWidget("Centre",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(AutoScaleVisible, XmNactivateCallback,
    (XtCallbackProc) AutoScaleVisibleCB, (caddr_t) NULL);
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
 /* Re Draw Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  ReDrawButt = XtCreateManagedWidget("Draw", xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(ReDrawButt, XmNactivateCallback,
    (XtCallbackProc) ReDrawCB, (caddr_t) NULL);

#ifndef MAIN_PANEL
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
 /* Control Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  ConButt = XtCreateManagedWidget("3D Panel",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(ConButt, XmNactivateCallback,
    (XtCallbackProc) ConButtCB, (caddr_t) 0);
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
 /* Quit Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  SetCButt = XtCreateManagedWidget("Control Panel",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(SetCButt, XmNactivateCallback,
    (XtCallbackProc) SetCButtCB, (caddr_t) 0);

  IconCButt = XtCreateManagedWidget("Icon Panel",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(IconCButt, XmNactivateCallback,
    (XtCallbackProc) IconCButtCB, (caddr_t) 0);
#endif
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
 /* Delete Sets Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  Del3DButt = XtCreateManagedWidget("Clear All",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(Del3DButt, XmNactivateCallback,
    (XtCallbackProc) Empty3DSets, (caddr_t) 0);

 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
 /* Quit Button */
 /* |///////////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ \| */
  ZoomButt = XtCreateManagedWidget("Zoom",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(ZoomButt, XmNactivateCallback,
    (XtCallbackProc) ZoomCB, (caddr_t) 0);

  QuitButt = XtCreateManagedWidget("Quit",
    xmPushButtonWidgetClass, Tool_Bar, args, 0);
  XtAddCallback(QuitButt, XmNactivateCallback,
    (XtCallbackProc) QuitCB, (caddr_t) 0);


 /* Menus Bar */
  Create_Menus();

 /* Main Pane for Drawing and Controls */
  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 2);
  XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[3], XmNheight, 700);
  XtSetArg(args[4], XmNwidth, 700);
  submainpane = XtCreateManagedWidget("submainpane", xmRowColumnWidgetClass, mainpane, args, 5);

  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNorientation, XmVERTICAL);
  XtSetArg(args[2], XmNnumColumns, 2);
  LeftRC = XtCreateManagedWidget("LeftRC", xmRowColumnWidgetClass, submainpane, args, 3);

 /* Drawing Window Frame */
  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[2], XmNnumColumns, 2);
  XtSetArg(args[3], XmNadjustLast, FALSE);
  SubLeftRC = XtCreateManagedWidget("SubLeftRC", xmRowColumnWidgetClass, LeftRC, args, 4);

  XtSetArg(args[0], XmNheight, 530);
  XtSetArg(args[1], XmNwidth, 530);
  XtSetArg(args[2], XmNleftAttachment, XmATTACH_FORM);
  XtSetArg(args[3], XmNrightAttachment, XmATTACH_FORM);
  XtSetArg(args[4], XmNtopAttachment, XmATTACH_WIDGET);
  fr1 = XtCreateManagedWidget("fr1", xmFrameWidgetClass, SubLeftRC, args, 5);

  if (ICONPANEL)
    MakeIconPanel(SubLeftRC, 3,ArrIconCanvas);

  if (MAINPANEL) {
    XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
    XtSetArg(args[1], XmNorientation, XmVERTICAL);
    XtSetArg(args[2], XmNnumColumns, 3);
    RightRC = XtCreateManagedWidget("RightRC", xmRowColumnWidgetClass, submainpane, args, 3);
    GFScale_Widgets(RightRC);
    GFTrans_Widgets(RightRC);
    GFDist_Widgets(LeftRC);
    GFControl(RightRC);
  } else {
    CreateSetControlPopup(toplevel);
    CreateControlPopup(toplevel);
    CreateIconPopup(toplevel);
  }


  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 1);
  XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[3], XmNheight, 530);
  XtSetArg(args[4], XmNwidth, 530);
  graphicspane = XtCreateManagedWidget("graphicspane", xmRowColumnWidgetClass, fr1, args, 5);

 /* Xmgf Message Panel to give any useful messages on how to use Xmgf */
 MessageForm = XtCreateManagedWidget("MessForm",xmFormWidgetClass,LeftRC,args,1); 

 XtSetArg(args[0], XmNshadowThickness, 1); 
 XtSetArg(args[1], XmNshadowType, XmSHADOW_ETCHED_IN); 
 XtSetArg(args[2], XmNrightAttachment, XmATTACH_WIDGET);  
 XtSetArg(args[3], XmNbottomAttachment, XmATTACH_WIDGET);
 XtSetArg(args[4], XmNleftAttachment, XmATTACH_WIDGET);  
 XtSetArg(args[5], XmNrightAttachment, XmATTACH_WIDGET);
 XtSetArg(args[6], XmNmarginWidth, 2);
 XtSetArg(args[7], XmNmarginHeight, 2);
 MessageFrame = XtCreateManagedWidget("MessFr",xmFrameWidgetClass,MessageForm,args,8); 

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Message:"));
  XtSetArg(args[1], XmNshadowThickness, 0);
  XtSetArg(args[2], XmNalignment, XmALIGNMENT_BEGINNING);
  MessageBox = XtCreateManagedWidget("Message:", xmLabelWidgetClass, MessageFrame, args, 3);

 /* Drawing Region */
  switch (viewtype) {
   case VIEW_ORTH:{
      create_Ortho_widgets(graphicspane, 256);
      CreateBuff(w_Orth, XSIZE, XSIZE);
      break;
    }
   case VIEW_STEREO:{
      create_Stereo_widgets(graphicspane, 256);
      CreateBuff(w_Orth, XSIZE, XSIZE);
      break;
    }
   default:{
      create_Perspective_widget(graphicspane, 512);
      CreateBuff(w_Orth, XSIZE, XSIZE);
      break;
    }

  }
  Oldviewtype = viewtype;
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeView(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  viewtype = (int) (caddr_t) client_data;
  XtDestroyWidget(ViewManager);
  switch (viewtype) {
   case VIEW_PERS:{
      create_Perspective_widget(graphicspane, XSIZE);
      break;
    }
   case VIEW_ORTH:{
      create_Ortho_widgets(graphicspane, 256);
      break;
    }
   case VIEW_STEREO:{
      create_Stereo_widgets(graphicspane, 256);
      break;
    }
  }
  switch (viewtype) {
   case VIEW_ORTH:
    Midx = 128;
    Midy = 128;
    break;
   case VIEW_STEREO:
    Midx = 128;
    Midy = 128;
    break;
   default:
    Midx = 256;
    Midy = 256;
    break;
  }
  InitViewScale();
  Oldviewtype = viewtype;
  SetScale();
  Redraw();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeAngleLab()
{
  Arg     args[2];
  char    Buff[10];

  XtVaGetValues(w_Theta, XtNvalue, &Theta, NULL);
  sprintf(Buff, "%d", Theta);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(Buff));
  XtSetValues(ThetaValLAB, args, 1);
  XtVaGetValues(w_Phi, XtNvalue, &Phi, NULL);
  sprintf(Buff, "%d", Phi);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(Buff));
  XtSetValues(PhiValLAB, args, 1);
  XtVaGetValues(w_Gamma, XtNvalue, &Gamma, NULL);
  sprintf(Buff, "%d", Gamma);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(Buff));
  XtSetValues(GammaValLAB, args, 1);
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeThetaLab(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg     args[2];
  char    Buff[10];

  XtVaGetValues(w_Theta, XtNvalue, &Theta, NULL);
  sprintf(Buff, "%d", Theta);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(Buff));
  XtSetValues(ThetaValLAB, args, 1);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangePhiLab(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg     args[2];
  char    Buff[10];

  XtVaGetValues(w_Phi, XtNvalue, &Phi, NULL);
  sprintf(Buff, "%d", Phi);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(Buff));
  XtSetValues(PhiValLAB, args, 1);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeGammaLab(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  Arg     args[2];
  char    Buff[10];

  XtVaGetValues(w_Gamma, XtNvalue, &Gamma, NULL);
  sprintf(Buff, "%d", Gamma);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(Buff));
  XtSetValues(GammaValLAB, args, 1);
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ChangeCurrentFile(currentFile)
char   *currentFile;
{
  Arg     args[1];

  XtUnmanageChild(versionName);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(currentFile));
  XtSetValues(versionName, args, 1);
  XtManageChild(versionName);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GFControl(Parent)
Widget  Parent;
{


  Widget  SetArDel, SetArFill, SetArCol, SetArDraw;
  Widget  SetArRCB, SetArRCBA, SetArRCBB;
  Widget  SetGenNext, SetGenPrev, SetCoordTiLab, SetNumTiLab;
  Widget  SetArNmLab, SetArRCA, SetArRC;
  Widget  SetCoordRC, SetNumRC, SetGenDel, SetGenDraw, SetGenRCB, SetGenRCA, SetGenRC;
  Widget  SetAttrFrame, SetGenFrame, V_RowCol_1, H_RowCol, Frame, ListFrame;
  Widget  Main_RowCol;
  Arg     args[10];

  HighLightedPoly =ConsLL();
  HighIDObjects = ConsLL();
  IDListTmp = ConsLL();
  ControlOpen = 1;

  HighLightColor = GetColourNumber("Yellow");
  OriginColour = GetColourNumber("Orange");
  SetNum = 1;
  LineNum = 1;

  Frame = XtCreateManagedWidget("GfFrame", xmFrameWidgetClass, Parent, args, 0);


  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  Main_RowCol = XtCreateManagedWidget("Main_RowCol", xmRowColumnWidgetClass, Frame, args, 3);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  H_RowCol = XtCreateManagedWidget("H_RowCol", xmRowColumnWidgetClass, Main_RowCol, args, 3);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  V_RowCol_1 = XtCreateManagedWidget("V_RowCol_1", xmRowColumnWidgetClass, H_RowCol, args, 3);

  ListFrame = XtCreateManagedWidget("ListFrame", xmFrameWidgetClass, H_RowCol, args, 0);


  SetGenFrame = XtCreateManagedWidget("SetGenFrame", xmFrameWidgetClass, V_RowCol_1, args, 0);
  SetAttrFrame = XtCreateManagedWidget("SetAttrFrame", xmFrameWidgetClass, V_RowCol_1, args, 0);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  SetGenRC = XtCreateManagedWidget("SetGenRC", xmRowColumnWidgetClass, SetGenFrame, args, 3);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 1);
  SetGenRCA = XtCreateManagedWidget("SetGenRCA", xmRowColumnWidgetClass, SetGenRC, args, 3);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 1);
  SetGenRCB = XtCreateManagedWidget("SetGenRCB", xmRowColumnWidgetClass, SetGenRC, args, 3);

  SetGenDraw = XtCreateManagedWidget("Draw All Sets", xmPushButtonWidgetClass, SetGenRCA, args, 0);
  SetGenDel = XtCreateManagedWidget("RemoveSets", xmPushButtonWidgetClass, SetGenRCB, args, 0);


  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  SetArRC = XtCreateManagedWidget("SetArGenRC", xmRowColumnWidgetClass, SetAttrFrame, args, 3);


  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  SetArRCA = XtCreateManagedWidget("SetArGenRCA", xmRowColumnWidgetClass, SetArRC, args, 3);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Name:"));
  SetArNmLab = XtCreateManagedWidget("SetArNmLab", xmLabelWidgetClass, SetArRCA, args, 1);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("None"));
  SetArName = XtCreateManagedWidget("SetArName", xmLabelWidgetClass, SetArRCA, args, 1);


  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  SetArRCB = XtCreateManagedWidget("SetArGenRCB", xmRowColumnWidgetClass, SetArRC, args, 3);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 5);
  SetArRCBA = XtCreateManagedWidget("SetArGenRCBA", xmRowColumnWidgetClass, SetArRCB, args, 3);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 5);
  SetArRCBB = XtCreateManagedWidget("SetArGenRCBB", xmRowColumnWidgetClass, SetArRCB, args, 3);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  SetNumRC = XtCreateManagedWidget("SetNumRC", xmRowColumnWidgetClass, SetArRCBA, args, 3);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[2], XmNnumColumns, 2);
  SetCoordRC = XtCreateManagedWidget("SetCoordRC", xmRowColumnWidgetClass, SetArRCBB, args, 3);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Set #: "));
  SetNumTiLab = XtCreateManagedWidget("SetNumTiLab", xmLabelWidgetClass, SetNumRC, args, 1);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("0000"));
  SetNumLab = XtCreateManagedWidget("SetNumLab", xmLabelWidgetClass, SetNumRC, args, 1);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("X:Y: "));
  SetCoordTiLab = XtCreateManagedWidget("StCoordTiLab", xmLabelWidgetClass, SetCoordRC, args, 1);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("000:000"));
  SetCoordLab = XtCreateManagedWidget("SetCoordLab", xmLabelWidgetClass, SetCoordRC, args, 1);

  SetGenNext = XtCreateManagedWidget("Next", xmPushButtonWidgetClass, SetArRCBA, args, 0);
  SetGenPrev = XtCreateManagedWidget("Previous", xmPushButtonWidgetClass, SetArRCBB, args, 0);
  ItemButt = XtCreateManagedWidget("Item #", xmPushButtonWidgetClass, SetArRCBA, args, 0);
  HighLighButt = XtCreateManagedWidget("HighLight Colour", xmPushButtonWidgetClass, SetArRCBB, args, 0);
  OriginButt = XtCreateManagedWidget("Origin", xmToggleButtonWidgetClass, SetArRCBA, args, 0);
  OriginColButt = XtCreateManagedWidget("Origin Colour", xmPushButtonWidgetClass, SetArRCBB, args, 0);


  SetArDraw = XtCreateManagedWidget("Draw Selected Set", xmPushButtonWidgetClass, SetArRCBA, args, 0);
  SetArCol = XtCreateManagedWidget("Set Colour", xmPushButtonWidgetClass, SetArRCBA, args, 0);
  SetArPtT = XtCreateManagedWidget("Set Point Type", xmPushButtonWidgetClass, SetArRCBA, args, 0);

  SetArDel = XtCreateManagedWidget("Remove Set", xmPushButtonWidgetClass, SetArRCBB, args, 0);
  SetArLin = XtCreateManagedWidget("Set Line Type", xmPushButtonWidgetClass, SetArRCBB, args, 0);
  SetArFill = XtCreateManagedWidget("Set Fill Style", xmPushButtonWidgetClass, SetArRCBB, args, 0);


  XtAddCallback(SetArDel, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ARDEL);
  XtAddCallback(SetArLin, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ARLIN);
  XtAddCallback(SetArFill, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ARFILL);
  XtAddCallback(SetArPtT, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ARPTT);
  XtAddCallback(SetArCol, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ARCOL);
  XtAddCallback(SetArDraw, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ARDRAW);
  XtAddCallback(SetGenNext, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) GENNXT);
  XtAddCallback(SetGenPrev, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) GENPRV);
  XtAddCallback(SetGenDel, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) GENDEL);
  XtAddCallback(SetGenDraw, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) GENDRW);
  XtAddCallback(ItemButt, XmNactivateCallback,
    (XtCallbackProc) ItemNumberCB, (caddr_t) ITEMBUTT);
  XtAddCallback(HighLighButt, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) HIGHLIGHTBUTT);
  XtAddCallback(OriginColButt, XmNactivateCallback,
    (XtCallbackProc) SetCB, (caddr_t) ORIGINCOLBUTT);
  XtAddCallback(OriginButt, XmNvalueChangedCallback,
    (XtCallbackProc) SetOriginCB, (caddr_t) ORIGINBUTT);

  InitColorList();

  XtSetArg(args[0], XmNvisibleItemCount, 15);
  XtSetArg(args[1], XmNautomaticSelection, TRUE);
  XtSetArg(args[2], XmNscrollBarDisplayPolicy, XmSTATIC);
  XtSetArg(args[3], XmNwidth, 100);
  XtSetArg(args[4], XmNlistSizePolicy, XmCONSTANT);
  SetList = XmCreateScrolledList(ListFrame, "ListWidget", args, 5);
  XtManageChild(SetList);
  /*XtAddCallback(SetList, XmNbrowseSelectionCallback,
		 (XtCallbackProc) SetCB, (caddr_t) SELECTSET); */
  XtAddEventHandler(SetList,ButtonPressMask | EnterWindowMask,False,
			(XtEventHandler) XmgfEventList, (caddr_t) NULL);

  UpdateList();
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
ItemNumberCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreateCommandPanel(toplevel, ITEM_PANEL, "Choose and Item Number");
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CmdThetaCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreateCommandPanel(toplevel, THETA_PANEL, "Select Theta Angle");
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CmdPhiCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreateCommandPanel(toplevel, PHI_PANEL, "Select Phi Angle");
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CmdGammaCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreateCommandPanel(toplevel, GAMMA_PANEL, "Select Gamma Angle");
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int     Typ;
  t_XmgfPoly *Poly;

  Typ = (int) client_data;
  switch (Typ) {
   case ARDEL:
    GetSetNum(&SetNum, &LineNum);	/* Remove Set */
    if (SetNum == -1) { break;}
    UnDrawSingleSet(SetNum);
    UpDateVisible();
    break;
   case ARLIN:
    CreateLnPal(toplevel);	/* Set Line Style */
    break;
   case ARFILL:
    CreateFillPal(toplevel);	/* Set Fill Style */
    break;
   case ARPTT:
    CreatePtPal(toplevel);	/* Set Point Type */
    break;
   case ARCOL:
    CreateColorPall(toplevel, SET_COLOUR);	/* Set SET Color */
    break;
   case ARDRAW:
    GetSetNum(&SetNum, &LineNum);	/* Darw Selected Set */
    if (SetNum == -1) { break; }
    GlobalSetNum = SetNum;
    GlobalLineNum = LineNum;
    DrawSingleSet(SetNum);
    if (DoubleBuff) Redraw();
    Redraw();
    break;
   case GENNXT:
    if (SizeLL(HighLightedPoly) > 0) {	/* Next */
      ForeachLL_M(HighLightedPoly, Poly) {
	Poly->ColNum = Poly->OldColNum;
      }
      DrawSingleItem(HighLightedPoly);
    }
    NextLine(&SetNum, &LineNum);
    SetVisible(&SetNum, &LineNum);
    UpDateVisible();
    HighLightedPoly = NewDrawSingleLineofSet(SetNum, LineNum);
    ForeachLL_M(HighLightedPoly, Poly) {
      Poly->OldColNum = Poly->ColNum;
      Poly->ColNum = HighLightColor;
    }
    DrawSingleItem(HighLightedPoly);
    if (DoubleBuff)
      Redraw();
    GlobalSetNum = SetNum;
    GlobalLineNum = LineNum;
    SetNumberLabel(GlobalLineNum);
    if (Origin)
      OriginSub();
    break;
   case GENPRV:
    if (SizeLL(HighLightedPoly) > 0) {
      ForeachLL_M(HighLightedPoly, Poly) {
	Poly->ColNum = Poly->OldColNum;
      }
      DrawSingleItem(HighLightedPoly);
    }
    PrevLine(&SetNum, &LineNum);
    SetVisible(&SetNum, &LineNum);
    UpDateVisible();
    HighLightedPoly = NewDrawSingleLineofSet(SetNum, LineNum);
    ForeachLL_M(HighLightedPoly, Poly) {
      Poly->ColNum = HighLightColor;
    }
    DrawSingleItem(HighLightedPoly);
    if (DoubleBuff == 1)
      Redraw();
    GlobalSetNum = SetNum;
    GlobalLineNum = LineNum;
    SetNumberLabel(GlobalLineNum);
    if (Origin == 1) {
      OriginSub();
    }
    break;
   case GENDEL:
    DrawClear();
    if (DoubleBuff == 1)
      Redraw();
    EmptyLL(HighLightedPoly);
    break;
   case GENDRW:
    DrawClear();
    DrawAllSets();
    Redraw();
    EmptyLL(HighLightedPoly);
    if (DoubleBuff == 1)
      Redraw();
    break;

   case SELECTSET:
    GetSetNum(&SetNum, &LineNum);
    if (SetNum == -1) { break; }
    UpdateSetName(SetNum);
    SetNumberLabel(LineNum);
    if (SizeLL(HighLightedPoly) > 0) {
      ForeachLL_M(HighLightedPoly, Poly) {
	Poly->ColNum = Poly->OldColNum;
      }
      DrawSingleItem(HighLightedPoly);
    }
    EmptyLL(HighLightedPoly);
    break;
   case ITEMBUTT:
    GetSetNum(&SetNum, &LineNum);
    if (SetNum == -1) {
      break;
    }
    LineNum = 4;
    SetNumberLabel(LineNum);
    HighLightedPoly = NewDrawSingleLineofSet(SetNum, LineNum);
    ForeachLL_M(HighLightedPoly, Poly) {
      Poly->ColNum = HighLightColor;
    }
    DrawSingleItem(HighLightedPoly);
    if (Origin == 1) {
      OriginSub();
    }
    break;
   case HIGHLIGHTBUTT:
    CreateColorPall(toplevel, HIGH_COLOUR);
    break;
   case ORIGINBUTT:
    break;
   case ORIGINCOLBUTT:
    CreateColorPall(toplevel, ORIG_COLOUR);
    break;




  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OriginClean()
{
  t_XmgfPoly *Poly;

  if (SizeLL(IDListTmp) > 0) {
    ForeachLL_M(IDListTmp, Poly) {
      Poly->ColNum = Poly->OldColNum;
    }
    DrawSingleItem(IDListTmp);
    DestLL(IDListTmp);
    IDListTmp = ConsLL();
  } else {
    IDListTmp = ConsLL();
  }
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
OriginSub()
{
  t_XmgfObject *NowObject;
  int     NowSetNum, NowLineNum;
  t_XmgfPoly *Poly;
  t_LL    IDedTmp;

  OriginClean();

  HighLightItem = NewSingleLine(SetNum, LineNum);
  ForeachLL_M(HighLightItem, NowObject) {
    if (NowObject->gfID.IDidentifier == IDIDENTIFIER) {
      NowSetNum = SearchNameList(NowObject->gfID.XmgfSetName);
      NowLineNum = NowObject->gfID.XmgfLineNum;
      HighIDObjects = NewDrawSingleLineofSet(NowSetNum, NowLineNum);
      ForeachLL_M(HighIDObjects, Poly) {
	Poly->OldColNum = Poly->ColNum;
	Poly->ColNum = OriginColour;
      }
    }
    IDedTmp = ConsCopyLL(HighIDObjects);
    MoveListLastLL(IDListTmp, IDedTmp);
  }
  DrawSingleItem(IDListTmp);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetNumberLabel(LocalLineNum)
int     LocalLineNum;
{
  Arg     args[1];
  char   *buffer;

  buffer = (char *) calloc(10, sizeof(char));
  sprintf(buffer, " %d ", LocalLineNum);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(buffer));
  XtSetValues(SetNumLab, args, 1);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SetNameLabel(buffer)
char   *buffer;
{
  Arg     args[1];

  XtSetArg(args[0], XmNlabelString, Str2MotStr(buffer));
  XtSetValues(SetArName, args, 1);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Clear Message */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
ClearXmgfMessage()
{
  Arg     args[1];
  char   *MessageBuffer;

  MessageBuffer = (char *) malloc(100 * sizeof(char));
  assert(MessageBuffer);

  sprintf(MessageBuffer, "Message:");
  XtSetArg(args[0], XmNlabelString, Str2MotStr(MessageBuffer));
  XtSetValues(MessageBox, args, 1);
  free(MessageBuffer);
  return 0;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Set Message */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
SetXmgfMessage(buffer)
char   *buffer;
{
  Arg     args[1];
  char   *MessageBuffer;

  MessageBuffer = (char *) malloc(100 * sizeof(char));
  assert(MessageBuffer);

  sprintf(MessageBuffer, "Message: %s", buffer);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(MessageBuffer));
  XtSetValues(MessageBox, args, 1);
  free(MessageBuffer);
  return 0;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdateSetName(LocalSetNum)
int     LocalSetNum;
{
  t_XmgfSet *SelectedSet;

  SelectedSet = SelectSet(&LocalSetNum);
  SetNum = LocalSetNum;
  SetNameLabel(SelectedSet->Name);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GetSetNum(LocalSetNum, LocalLineNum)
int    *LocalSetNum;
int    *LocalLineNum;
{
  int    *Pos;
  int     PosCount;

  Pos = (int *) malloc(10 * sizeof(int));
  assert(Pos);
  if (!XmListGetSelectedPos(SetList, &Pos, &PosCount)) {
    *LocalSetNum = -1;
    *LocalLineNum = 0;
    return ;
  }
  GlobalSetNum = *Pos;
  GlobalLineNum = 1;
  *LocalSetNum = *Pos;
  *LocalLineNum = 1;
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Item Select Motif Function */
void
CreateCommandPanel(Parent, PanelType, Message)
Widget  Parent;
int     PanelType;
char   *Message;
{
  Arg     args[10];
  Widget  ok_button;

  XtSetArg(args[0],
    XmNselectionLabelString, Str2MotStr(Message));
  CommandShellDia = XmCreatePromptDialog(Parent, "Panel", args, 1);
  switch (PanelType) {
   case ITEM_PANEL:{
      XtAddCallback(CommandShellDia, XmNokCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) ITEM_OK);
      XtAddCallback(CommandShellDia, XmNcancelCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) ITEM_CAN);
      break;
    }
   case THETA_PANEL:{
      XtAddCallback(CommandShellDia, XmNokCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) THETA_ANG);
      XtAddCallback(CommandShellDia, XmNcancelCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) ITEM_CAN);
      break;
    }
   case PHI_PANEL:{
      XtAddCallback(CommandShellDia, XmNokCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) PHI_ANG);
      XtAddCallback(CommandShellDia, XmNcancelCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) ITEM_CAN);
      break;
    }
   case GAMMA_PANEL:{
      XtAddCallback(CommandShellDia, XmNokCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) GAMMA_ANG);
      XtAddCallback(CommandShellDia, XmNcancelCallback,
	(XtCallbackProc) KillCommandCB, (caddr_t) ITEM_CAN);
      break;
    }
  }

  XtManageChild(CommandShellDia);
  ok_button = XmSelectionBoxGetChild(CommandShellDia, XmDIALOG_OK_BUTTON);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreatePtPal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, CPRCradio, SelButton;

  XPushFnt(PtShellDia);
  PtShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  PtShell = XmCreateBulletinBoard(PtShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(PtShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Point"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[3], XmNradioBehavior, TRUE);
  CPRCradio = XmCreateRowColumn(CPRC, "workarea", args, 3);
  XtManageChild(CPRCradio);
  w_PTPoint = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_POINT,
    toplevel, CPRCradio, Point_bits, Point_width, Point_width);
  w_PTBox = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_BOX,
    toplevel, CPRCradio, Box_bits, Box_width, Box_width);
  w_PTTri = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_TRI,
    toplevel, CPRCradio, Tri_bits, Tri_width, Tri_width);
  w_PTPlus = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_PLUS,
    toplevel, CPRCradio, Plus_bits, Plus_width, Plus_width);
  w_PTCross = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_CROSS,
    toplevel, CPRCradio, Cross_bits, Cross_width, Cross_width);
  w_PTCircle = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_CIRCLE,
    toplevel, CPRCradio, Circle_bits, Circle_width, Circle_width);
  w_PTFillBox = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_FILLEDBOX,
    toplevel, CPRCradio, FillBox_bits, FillBox_width, FillBox_width);
  w_PTFillTri = CreateBitmapToggButt((void *) XPointAttrCB, (caddr_t) MENU_FILLEDTRI,
    toplevel, CPRCradio, FillTri_bits, FillTri_width, FillTri_width);
  w_PTFillCircle = CreateBitmapToggButt((void *) XPointAttrCB,
    (caddr_t) MENU_FILLEDCIRCLE, toplevel, CPRCradio, FillCircle_bits,
    FillCircle_width, FillCircle_width);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillPtPalCB, (caddr_t) 0);


  XtManageChild(PtShell);
  XtManageChild(PtShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillPtPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  KillPtPal();
}

void
KillPtPal()
{
  XtUnmanageChild(PtShellDia);
  XtDestroyWidget(PtShellDia);
  PtShellDia=NULL;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillLnPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  KillLnPal();
}
void
KillLnPal()
{
  XtUnmanageChild(LnShellDia);
  XtDestroyWidget(LnShellDia);
  LnShellDia=NULL;
}
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillAnimPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  KillAnimPal();
}
void
KillAnimPal()
{
  XtUnmanageChild(AnimShellDia);
  XtDestroyWidget(AnimShellDia);
  AnimShellDia=NULL;
}




/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateLnPal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, CPRCradio, SelButton;

  XPushFnt(LnShellDia)
  LnShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  LnShell = XmCreateBulletinBoard(LnShellDia, "Shell", args, 0);
  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(LnShell, "workarea", args, 3);
  XtManageChild(CPRC);
  XtSetArg(args[0], XmNlabelString, Str2MotStr("Single Line"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[3], XmNradioBehavior, TRUE);
  CPRCradio = XmCreateRowColumn(CPRC, "workarea", args, 3);
  XtManageChild(CPRCradio);
  Line0pt = (Widget) CreateBitmapToggButt((void*)XLineAttrCB, (caddr_t) 0, toplevel,
    CPRCradio, Line0pt_bits, Line0pt_width, Line0pt_height);
  Line1pt = (Widget) CreateBitmapToggButt((void*)XLineAttrCB, (caddr_t) 1, toplevel,
    CPRCradio, Line1pt_bits, Line1pt_width, Line1pt_height);
  Line2pt = (Widget) CreateBitmapToggButt((void*)XLineAttrCB, (caddr_t) 2, toplevel,
    CPRCradio, Line2pt_bits, Line2pt_width, Line2pt_height);
  Line3pt = (Widget) CreateBitmapToggButt((void*)XLineAttrCB, (caddr_t) 3, toplevel,
    CPRCradio, Line3pt_bits, Line3pt_width, Line3pt_height);
  Line4pt = (Widget) CreateBitmapToggButt((void*)XLineAttrCB, (caddr_t) 4, toplevel,
    CPRCradio, Line4pt_bits, Line4pt_width, Line4pt_height);
  Line5pt = (Widget) CreateBitmapToggButt((void*)XLineAttrCB, (caddr_t) 5, toplevel,
    CPRCradio, Line5pt_bits, Line5pt_width, Line5pt_height);
  LineSol = (Widget) CreateBitmapToggButt((void*)XLineSAttrCB, (caddr_t) 0, toplevel,
    CPRCradio, LineSol_bits, LineSol_width, LineSol_height);
  LineDot = (Widget) CreateBitmapToggButt((void*)XLineSAttrCB, (caddr_t) 1, toplevel,
    CPRCradio, LineDot_bits, LineDot_width, LineDot_height);
  LineDas = (Widget) CreateBitmapToggButt((void*)XLineSAttrCB, (caddr_t) 2, toplevel,
    CPRCradio, LineDas_bits, LineDas_width, LineDas_height);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillLnPalCB, (caddr_t) 0);


  XtManageChild(LnShell);
  XtManageChild(LnShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateColorPall(Parent, PopupType)
Widget  Parent;
int     PopupType;
{
  Arg     args[10];
  Widget  Text_Label, CPRC;
  Widget  SelButton;
  XmString *Name;

  XPushFnt(ColShellDia)
  ColShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  ColShell = XmCreateBulletinBoard(ColShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(ColShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Colour Palette"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);


  XtSetArg(args[0], XmNvisibleItemCount, 12);
  XtSetArg(args[1], XmNautomaticSelection, TRUE);
  ColourList = XmCreateScrolledList(CPRC, "ColorList", args, 2);
  XtManageChild(ColourList);

  switch (PopupType) {
   case SET_COLOUR:
    XtAddCallback(ColourList, XmNbrowseSelectionCallback,
      (XtCallbackProc) SelectColorCB, (caddr_t) SELECTCOL);
    break;
   case BACK_COLOUR:
    XtAddCallback(ColourList, XmNbrowseSelectionCallback,
      (XtCallbackProc) SelectBGRDColorCB, (caddr_t) SELECTCOL);
    break;
   case HIGH_COLOUR:
    XtAddCallback(ColourList, XmNbrowseSelectionCallback,
      (XtCallbackProc) SelectHIGHColorCB, (caddr_t) SELECTCOL);
    break;
   case ORIG_COLOUR:
    XtAddCallback(ColourList, XmNbrowseSelectionCallback,
      (XtCallbackProc) SelectORIGColorCB, (caddr_t) SELECTCOL);
    break;
   case OUTL_COLOUR:
    XtAddCallback(ColourList, XmNbrowseSelectionCallback,
      (XtCallbackProc) SelectOUTColorCB, (caddr_t) SELECTCOL);
    break;

  }


  ForeachLL_M(ColorNameList, Name) {
    XmListAddItem(ColourList, *Name, 0);
  }

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss", xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillColorCB, (caddr_t) 0);

  XtManageChild(ColShell);
  XtManageChild(ColShellDia);

  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
InitColorList()
{
  int     i;
  XmString Name;
  int     maxColors = maxPixels;

  for (i = 0; i < maxColors + 1; i++) {
    Name = Str2MotStr(theColorNames[i]);
    InsLastLL(ColorNameList, Name);
  }
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelectColorCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int    *Pos;
  int     PosCount;
  int     Color;
  char   *Col;

  Pos = (int *) malloc(10 * sizeof(int));
  assert(Pos);
  Col = (char *) malloc(20 * sizeof(char));
  assert(Col);
  XmListGetSelectedPos(ColourList, &Pos, &PosCount);
  Color = *Pos - 1;
#ifdef DEBUG
  fprintf(stderr, "%d\n", *Pos);
#endif
  Col = (theColorNames[Color]);
  Color = GetColourNumber(Col);
  KillColorCB(ColShellDia, (caddr_t) 0, (caddr_t) 0);
#ifdef DEBUG
  fprintf(stderr, "NewColour of Set %d Line %d = %d %s\n",
    GlobalSetNum, GlobalLineNum, Color, Col);
#endif
  SetSingleSetCol(GlobalSetNum, Color);
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelectBGRDColorCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int    *Pos;
  int     PosCount;
  int     Color;
  char   *Col;
  Pixel   fg, bg;

  Pos = (int *) malloc(10 * sizeof(int));
  assert(Pos);
  Col = (char *) malloc(20 * sizeof(char));
  assert(Col);
  XmListGetSelectedPos(ColourList, &Pos, &PosCount);
  Color = *Pos - 1;
  Col = (theColorNames[Color]);
  Color = GetColourNumber(Col);
  KillColorCB(ColShellDia, (caddr_t) 0, (caddr_t) 0);

  fg = colorpixels[Color];
  bg = colorpixels[Color];
  BackGroundColour = Color;
  XtVaSetValues(Orthdr, XmNbackground, bg, NULL);
  XtVaSetValues(Orthdr, XmNforeground, fg, NULL);
  if (ImagePix != NULL) XFreePixmap(theDisplay, ImagePix);
  if (ImageDraw != NULL) XFreePixmap(theDisplay, ImageDraw);

}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelectHIGHColorCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int    *Pos;
  int     PosCount;
  int     Color;
  char   *Col;

  Pos = (int *) malloc(10 * sizeof(int));
  assert(Pos);
  Col = (char *) malloc(20 * sizeof(char));
  assert(Col);
  XmListGetSelectedPos(ColourList, &Pos, &PosCount);
  Color = *Pos - 1;
  Col = (theColorNames[Color]);
  Color = GetColourNumber(Col);
  KillColorCB(ColShellDia, (caddr_t) 0, (caddr_t) 0);
  HighLightColor = Color;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelectORIGColorCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int    *Pos;
  int     PosCount;
  int     Color;
  char   *Col;

  Pos = (int *) calloc(10, sizeof(int));
  Col = (char *) calloc(20, sizeof(char));
  XmListGetSelectedPos(ColourList, &Pos, &PosCount);
  Color = *Pos - 1;

  Col = (theColorNames[Color]);
  Color = GetColourNumber(Col);
  KillColorCB(ColShellDia, (caddr_t) 0, (caddr_t) 0);
  OriginColour = Color;

  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
SelectOUTColorCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int    *Pos;
  int     PosCount;
  int     Color;
  char   *Col;

  Pos = (int *) calloc(10, sizeof(int));
  Col = (char *) calloc(20, sizeof(char));
  XmListGetSelectedPos(ColourList, &Pos, &PosCount);
  Color = *Pos - 1;

  Col = (theColorNames[Color]);
  Color = GetColourNumber(Col);
  KillColorCB(ColShellDia, (caddr_t) 0, (caddr_t) 0);
  OutLineColour = Color;

  return;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillColorCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(ColShellDia);
  XtDestroyWidget(ColShellDia);
  ColShellDia = NULL;
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillCommandCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  char   *Number;
  t_XmgfPoly *Poly;
  int     CBtype;
  int     IntNumber;

  CBtype = (int) client_data;

  switch (CBtype) {
   case ITEM_OK:
    {
      XmSelectionBoxCallbackStruct *scb =
      (XmSelectionBoxCallbackStruct *) call_data;

      Number = (char *) malloc(80 * sizeof(char));
      assert(Number);

      XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &Number);
      if (!strcasecmp(Number, "")) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (strlen(Number) <= 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (sscanf(Number, "%d", &IntNumber) == 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      GetSetNum(&SetNum, &LineNum);
      if (SetNum == -1) {
	return;
      }
      LineNum = IntNumber;
      SetVisible(&SetNum, &LineNum);
      UpDateVisible();
      SetNumberLabel(LineNum);

  /* Reset OldPolygons */
      if (SizeLL(HighLightedPoly) > 0) {
	ForeachLL_M(HighLightedPoly, Poly) {
	  Poly->ColNum = Poly->OldColNum;
	}
	DrawSingleItem(HighLightedPoly);
      }
  /* HighLightNewOnes */
      HighLightedPoly = NewDrawSingleLineofSet(SetNum, LineNum);
      ForeachLL_M(HighLightedPoly, Poly) {
	Poly->OldColNum = Poly->ColNum;
	Poly->ColNum = HighLightColor;
      }
      DrawSingleItem(HighLightedPoly);
      break;
    }
   case ITEM_CAN:{
      return;
      break;
    }
   case THETA_ANG:{
      XmSelectionBoxCallbackStruct *scb =
      (XmSelectionBoxCallbackStruct *) call_data;

      Number = (char *) malloc(80 * sizeof(char));
      assert(Number);
      XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &Number);
      if (!strcasecmp(Number, "")) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (strlen(Number) <= 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (sscanf(Number, "%d", &IntNumber) == 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      Theta = IntNumber;
      UpdateRotationParms();
      SetScale();
      Redraw();
      break;
    }
   case PHI_ANG:{
      XmSelectionBoxCallbackStruct *scb =
      (XmSelectionBoxCallbackStruct *) call_data;

      Number = (char *) malloc(80 * sizeof(char));
      assert(Number);
      XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &Number);
      if (!strcasecmp(Number, "")) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (strlen(Number) <= 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (sscanf(Number, "%d", &IntNumber) == 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      Phi = IntNumber;
      UpdateRotationParms();
      SetScale();
      Redraw();
      break;
    }
   case GAMMA_ANG:{
      XmSelectionBoxCallbackStruct *scb =
      (XmSelectionBoxCallbackStruct *) call_data;

      Number = (char *) malloc(80 * sizeof(char));
      assert(Number);
      XmStringGetLtoR(scb->value, XmSTRING_DEFAULT_CHARSET, &Number);
      if (!strcasecmp(Number, "")) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (strlen(Number) <= 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      if (sscanf(Number, "%d", &IntNumber) == 0) {
	XmErr(EMPTY_STRING);
	return;
      }
      Gamma = IntNumber;
      UpdateRotationParms();
      SetScale();
      Redraw();
      break;
    }



  }

  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
PointerSelectSetCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  int     x, y;
  unsigned int mask;
  Window  du, du1;
  int     wx, wy;
  t_XmgfSet *SelectedSet;
  t_XmgfLine *SelectedLine;
  t_XmgfObject *SelectedObject;
  t_XmgfPoly *Poly;
  t_XmgfPt *Pts;
  int     avx, avy, CloseLineNum, count, dmax, dmay, mindist, IntNumber;
  double  dist, Numsqr;
  int     xPt, yPt;
  char   *MessageString;

  avx = 0;
  avy = 0;
  CloseLineNum = 0;
  XQueryPointer(theDisplay, w_Orth, &du, &du1, &x, &y, &wx, &wy, &mask);
  GetSetNum(&SetNum, &LineNum);
  if (SetNum == -1) {
    return;
  }
  SelectedSet = SelectSet(&SetNum);
  LineNum = 0;
  mindist = 10E+7;
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    LineNum++;
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	count = 0;

	ForeachLL_M(Poly->ListXmgfPts, Pts) {
	  NEWTHREEDTWOD(Pts->x, Pts->y, Pts->z);
	  xPt = (int) ((Scale_factor * ax) + Midx);
	  yPt = (int) ((Scale_factor * ay) + Midy);
	  dmax = xPt - wx;
	  dmay = yPt - wy;
	  Numsqr = dmax * dmax + dmay * dmay;
	  if (Numsqr > 0) {
	    dist = sqrt(Numsqr);
	  } else
	    dist = 0;
	  if (dist < mindist) {
	    mindist = dist;
	    CloseLineNum = LineNum;
	  }
	}			
      }
    }
  }

  IntNumber = CloseLineNum;
#ifdef DEBUG
  fprintf(stderr, "Current LineNum Now %d\n", IntNumber);
#endif
  MessageString = malloc(100 * sizeof(char));
  assert(MessageString);
  sprintf(MessageString, "Item Chosen = %d ", IntNumber);
  SetXmgfMessage(MessageString);
  free(MessageString);
  GetSetNum(&SetNum, &LineNum);
  if (SetNum == -1) {
    return;
  }
  LineNum = IntNumber;
  SetNumberLabel(LineNum);

 /* Reset OldPolygons */
  if (SizeLL(HighLightedPoly) > 0) {
    ForeachLL_M(HighLightedPoly, Poly) {
      Poly->ColNum = Poly->OldColNum;
    }
    DrawSingleItem(HighLightedPoly);
  }
 /* HighLightNewOnes */
  HighLightedPoly = NewDrawSingleLineofSet(SetNum, LineNum);
  ForeachLL_M(HighLightedPoly, Poly) {
    Poly->OldColNum = Poly->ColNum;
    Poly->ColNum = HighLightColor;
  }
DrawSingleItem(HighLightedPoly);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdateXY()
{
  char    Lab[10];
  Arg     args[1];
  int     x, y;
  unsigned int mask;
  Window  du, du1;
  int     wx, wy;

  XQueryPointer(theDisplay, w_Orth, &du, &du1, &x, &y, &wx, &wy, &mask);
  if (ControlOpen == 1) {
    sprintf(Lab, "%d:%d", wx, wy);
    XtSetArg(args[0], XmNlabelString, Str2MotStr(Lab));
    XtSetValues(SetCoordLab, args, 1);
  }
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
UpdateList()
{
  XmString *Name;

  XmListDeleteAllItems(SetList);
  ForeachLL_M(NameList, Name) {
    XmListAddItem(SetList, *Name, 0);
  }
  XmListSelectPos(SetList, 1, True);

  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
int
SearchNameList(SetName)
char   *SetName;
{
  int     count = 0;
  XmString *Name;
  char   *NewName;

  ForeachLL_M(NameList, Name) {
    count++;
    NewName = MotStr2Str(Name);
#ifdef DEBUG
    fprintf(stderr, "NewName=%s %s\n", NewName, SetName);
#endif
    if (!strcasecmp(SetName, NewName))
      return count;
  }
  return -1;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GFDist_Widgets(Parent)
Widget  Parent;
{
  Arg     args[10];

  Distfr = XtCreateManagedWidget("DistFrame",
    xmFrameWidgetClass, Parent, args, 0);
  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 2);
  XtSetArg(args[2], XmNorientation, XmVERTICAL);
  DistRC = XtCreateManagedWidget("DistRC",
    xmRowColumnWidgetClass, Distfr, args, 3);

 /* Scale of Scale of Object */
  XtSetArg(args[0], XmNtitleString, Str2MotStr("Dist"));
  XtSetArg(args[1], XmNmaximum, 800);
  XtSetArg(args[2], XmNminimum, 1);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 100);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  DistScal = XtCreateManagedWidget("DistScal",
    xmScaleWidgetClass, DistRC, args, 9);
  XtAddCallback(DistScal, XmNdragCallback, (XtCallbackProc) TouchScaleCB, 0);
  XtAddCallback(DistScal, XmNvalueChangedCallback, (XtCallbackProc) ReleaseRheoCB, 0);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Scale"));
  XtSetArg(args[1], XmNmaximum, 80);
  XtSetArg(args[2], XmNminimum, -20);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 100);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  ImgScale = XtCreateManagedWidget("ImgScale",
    xmScaleWidgetClass, DistRC, args, 9);
  XtAddCallback(ImgScale, XmNdragCallback, (XtCallbackProc) TouchScaleCB, 0);
  XtAddCallback(ImgScale, XmNvalueChangedCallback, (XtCallbackProc) ReleaseRheoCB, 0);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GFScale_Widgets(Parent)
Widget  Parent;
{
  Arg     args[10];

 /* w_Theta w_Phi w_Gamma */

  XtSetArg(args[0], XmNleftAttachment, XmATTACH_WIDGET);
  XtSetArg(args[1], XmNrightAttachment, XmATTACH_WIDGET);
  XtSetArg(args[2], XmNtopAttachment, XmATTACH_WIDGET);
  XtSetArg(args[3], XmNbottomAttachment, XmATTACH_WIDGET);
  fr2a = XtCreateManagedWidget("fr2a", xmFrameWidgetClass, Parent, args, 4);

  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[3], XmNleftAttachment, XmATTACH_WIDGET);
  XtSetArg(args[4], XmNrightAttachment, XmATTACH_WIDGET);
  XtSetArg(args[5], XmNtopAttachment, XmATTACH_WIDGET);
  XtSetArg(args[6], XmNbottomAttachment, XmATTACH_WIDGET);
  ScRC = XtCreateManagedWidget("gr1", xmRowColumnWidgetClass, fr2a, args, 7);

  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNorientation, XmVERTICAL);
  ThRCfr = XtCreateManagedWidget("RHSc", xmFrameWidgetClass, ScRC, args, 5);
  PhRCfr = XtCreateManagedWidget("RHSc", xmFrameWidgetClass, ScRC, args, 5);
  GaRCfr = XtCreateManagedWidget("RHSc", xmFrameWidgetClass, ScRC, args, 5);
  ThRC = XtCreateManagedWidget("RHScRC", xmRowColumnWidgetClass, ThRCfr, args, 5);
  PhRC = XtCreateManagedWidget("RHScRC", xmRowColumnWidgetClass, PhRCfr, args, 5);
  GaRC = XtCreateManagedWidget("RHScRC", xmRowColumnWidgetClass, GaRCfr, args, 5);
  XtSetArg(args[0], XmNlabelString, Str2MotStr("Theta"));
  ThetaLAB = XtCreateManagedWidget("Theta", xmLabelWidgetClass, ThRC, args, 1);
  XtSetArg(args[0], XmNlabelString, Str2MotStr(" Phi "));
  PhiLAB = XtCreateManagedWidget("Phi", xmLabelWidgetClass, PhRC, args, 1);
  XtSetArg(args[0], XmNlabelString, Str2MotStr("Gamma"));
  GammaLAB = XtCreateManagedWidget("Gamma", xmLabelWidgetClass, GaRC, args, 1);

 /* Value of Rheostat Widgets */
  XtSetArg(args[0], XmNlabelString, Str2MotStr("0"));
  ThetaValLAB = XtCreateManagedWidget("Theta", xmPushButtonWidgetClass, ThRC, args, 1);
  XtAddCallback(ThetaValLAB, XmNactivateCallback, (XtCallbackProc) CmdThetaCB, NULL);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("0"));
  PhiValLAB = XtCreateManagedWidget("Phi", xmPushButtonWidgetClass, PhRC, args, 1);
  XtAddCallback(PhiValLAB, XmNactivateCallback, (XtCallbackProc) CmdPhiCB, NULL);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("0"));
  GammaValLAB = XtCreateManagedWidget("Gamma", xmPushButtonWidgetClass, GaRC, args, 1);
  XtAddCallback(GammaValLAB, XmNactivateCallback, (XtCallbackProc) CmdGammaCB, NULL);

  XtSetArg(args[0], XtNmaximumAngle, 359);
  XtSetArg(args[1], XtNminimumAngle, 0);
  XtSetArg(args[2], XtNmaximumValue, 359);
  XtSetArg(args[3], XtNminimumValue, 0);
  XtSetArg(args[4], XtNinnerArrowLength, 30);
  XtSetArg(args[5], XtNouterArrowLength, 30);


  XtSetArg(args[6], XmNtitleString, Str2MotStr("Gamma"));
  w_Theta = XtCreateManagedWidget("w_Theta", rheostatWidgetClass, ThRC, args, 7);
  XtAddCallback(w_Theta, XtNnotifyCallback, (XtCallbackProc) TouchScaleCB, NULL);
  XtAddCallback(w_Theta, XtNreleaseCallback, (XtCallbackProc) ReleaseRheoCB, NULL);
  w_Phi = XtCreateManagedWidget("w_Phi", rheostatWidgetClass, PhRC, args, 6);
  XtAddCallback(w_Phi, XtNnotifyCallback, (XtCallbackProc) TouchScaleCB, NULL);
  XtAddCallback(w_Phi, XtNreleaseCallback, (XtCallbackProc) ReleaseRheoCB, NULL);
  w_Gamma = XtCreateManagedWidget("w_Gamma", rheostatWidgetClass, GaRC, args, 6);
  XtAddCallback(w_Gamma, XtNnotifyCallback, (XtCallbackProc) TouchScaleCB, NULL);
  XtAddCallback(w_Gamma, XtNreleaseCallback, (XtCallbackProc) ReleaseRheoCB, NULL);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
GFTrans_Widgets(Parent)
Widget  Parent;
{
  Arg     args[10];

  Transformfr = XtCreateManagedWidget("ScRC1", xmFrameWidgetClass, Parent, args, 0);
 /* Dist Scale Frame */


  XtSetArg(args[0], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNorientation, XmVERTICAL);
  TransformRC = XtCreateManagedWidget("TRC",
    xmRowColumnWidgetClass, Transformfr, args, 3);

  XtSetArg(args[1], XmNmaximum, DefaultMaxDisp);
  XtSetArg(args[2], XmNminimum, -DefaultMaxDisp);
  XtSetArg(args[3], XmNscaleMultiple, 10);
  XtSetArg(args[4], XmNvalue, 100);
  XtSetArg(args[5], XmNshowValue, True);
  XtSetArg(args[6], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[7], XmNheight, 80);
  XtSetArg(args[8], XmNwidth, 100);
  XtSetArg(args[9], XmNorientation, XmHORIZONTAL);

 /* OX OY OZ Scale */

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Ox"));
  OX = XtCreateManagedWidget("OX", xmScaleWidgetClass, TransformRC, args, 10);
  XtAddCallback(OX, XmNdragCallback, (XtCallbackProc) TouchScaleCB, NULL);
  XtAddCallback(OX, XmNvalueChangedCallback, (XtCallbackProc) ReleaseRheoCB, 0);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Oy"));
  OY = XtCreateManagedWidget("OY", xmScaleWidgetClass, TransformRC, args, 10);
  XtAddCallback(OY, XmNdragCallback, (XtCallbackProc) TouchScaleCB, NULL);
  XtAddCallback(OY, XmNvalueChangedCallback, (XtCallbackProc) ReleaseRheoCB, 0);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Oz"));
  OZ = XtCreateManagedWidget("OZ", xmScaleWidgetClass, TransformRC, args, 10);
  XtAddCallback(OZ, XmNdragCallback, (XtCallbackProc) TouchScaleCB, NULL);
  XtAddCallback(OZ, XmNvalueChangedCallback, (XtCallbackProc) ReleaseRheoCB, 0);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Operation on Single Set */
void
XLineAttrCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  t_XmgfSet *SelectedSet;
  t_XmgfLine *SelectedLine;
  t_XmgfObject *SelectedObject;
  t_XmgfPoly *Poly;

  int     width = (int) client_data;

  GetSetNum(&SetNum, &LineNum);
  if (SetNum == -1) {
    return;
  }
  SelectedSet = SelectSet(&SetNum);
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	Poly->LineWidth = width;
      }
    }
  }
  KillLnPal();
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
XLineSAttrCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  t_XmgfSet *SelectedSet;
  t_XmgfLine *SelectedLine;
  t_XmgfObject *SelectedObject;
  t_XmgfPoly *Poly;

  int     style = (int) client_data;

  GetSetNum(&SetNum, &LineNum);
  if (SetNum == -1) {
    return;
  }
  SelectedSet = SelectSet(&SetNum);
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	Poly->LineStyle = style;
      }
    }
  }
  KillLnPal();
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
XPointAttrCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  t_XmgfSet *SelectedSet;
  t_XmgfLine *SelectedLine;
  t_XmgfObject *SelectedObject;
  t_XmgfPoly *Poly;

  int     Pttype = (int) client_data;

  GetSetNum(&SetNum, &LineNum);
  if (SetNum == -1) {
    return;
  }
  SelectedSet = SelectSet(&SetNum);
  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	Poly->PtType = Pttype;
      }
    }
  }
  KillPtPal();
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateFillPal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, CPRCradio;
  Widget  FillShell, SelButton;
  Widget  XBlackFill, XWhiteFill, XNoFill, XOpaqueFill, XDoFill, XHide_Line;
  Widget  XShadeLine, XShadeFill, XCOpaqueFill,XPointsOnly;

  XPushFnt(FillShellDia)
  FillShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  FillShell = XmCreateBulletinBoard(FillShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(FillShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Fill Style"));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[3], XmNradioBehavior, TRUE);
  CPRCradio = XmCreateRowColumn(CPRC, "workarea", args, 3);

  XBlackFill = XtCreateWidget(" Black Lines",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XBlackFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) BLACKLINES);
  XtManageChild(XBlackFill);
  XWhiteFill = XtCreateWidget(" White Lines",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XWhiteFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) WHITELINES);
  XtManageChild(XWhiteFill);
  XNoFill = XtCreateWidget(" Coloured Lines",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XNoFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) NOTFILLED);
  XtManageChild(XNoFill);
  XShadeLine = XtCreateWidget(" Shaded Lines",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XShadeLine, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) SHADED_LINES);
  XtManageChild(XShadeLine);
  XHide_Line = XtCreateWidget(" Hidden Line",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XHide_Line, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) FILLEDHIDDENLINE);
  XtManageChild(XHide_Line);
  XOpaqueFill = XtCreateWidget(" Opaque Fill",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XOpaqueFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) FILLEDOPAQUE);
  XtManageChild(XOpaqueFill);
  XCOpaqueFill = XtCreateWidget(" Coloured Opaque Fill",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XCOpaqueFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) COLOUREDOPAQUE);
  XtManageChild(XCOpaqueFill);
  XDoFill = XtCreateWidget(" Coloured Fill",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XDoFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) FILLEDCOLOR);
  XtManageChild(XDoFill);
  XShadeFill = XtCreateWidget(" Shaded Fill",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XShadeFill, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) SHADED_FILL);
  XtManageChild(XShadeFill);
  XPointsOnly = XtCreateWidget(" Points ",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(XPointsOnly, XmNactivateCallback,
    (XtCallbackProc) XPolyAttrCB, (caddr_t) POINTS_ONLY);
  XtManageChild(XPointsOnly);
 /* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

  SelButton = XtCreateManagedWidget("Cancel",
    xmPushButtonWidgetClass, CPRC, args, 0);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillFillPalCB, (caddr_t) 0);

  XtManageChild(FillShell);
  XtManageChild(FillShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillFillPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(FillShellDia);
  XtDestroyWidget(FillShellDia);
  FillShellDia = NULL;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* Operation on Single Set */
void
XPolyAttrCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  t_XmgfSet *SelectedSet;
  t_XmgfLine *SelectedLine;
  t_XmgfObject *SelectedObject;
  t_XmgfPoly *Poly;
  int     NewFillStyle;

  int     FillStyle = (int) client_data;

  GetSetNum(&SetNum, &LineNum);
  if (SetNum == -1) {
    return;
  }
  SelectedSet = SelectSet(&SetNum);
  NewFillStyle = FillStyle;
  switch (FillStyle) {
   case SHADED_FILL:
    SelectColours = 0;
    NewFillStyle = FILLEDCOLOR;
    break;
   case SHADED_LINES:
    SelectColours = 0;
    NewFillStyle = NOTFILLED;
    break;
   case FILLEDCOLOR:
    SelectColours = 1;
    NewFillStyle = FILLEDCOLOR;
    break;
   case NOTFILLED:
    SelectColours = 1;
    NewFillStyle = NOTFILLED;
    break;
  }

  ForeachLL_M(SelectedSet->ListXmgfLines, SelectedLine) {
    ForeachLL_M(SelectedLine->ListXmgfObjects, SelectedObject) {
      ForeachLL_M(SelectedObject->ListXmgfPolys, Poly) {
	Poly->FillStyle = NewFillStyle;
      }
    }
  }
  XtUnmanageChild(FillShellDia);
  XtDestroyWidget(FillShellDia);
  FillShellDia = NULL;
  UpDateVisible();
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreatePtSizePalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreatePtSizePal(toplevel);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreatePtSizePal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton, PtSizeShell;

  XPushFnt(PtSizeShellDia)
  PtSizeShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  PtSizeShell = XmCreateBulletinBoard(PtSizeShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(PtSizeShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("   PointSize Panel   "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("PointSize"));
  XtSetArg(args[1], XmNmaximum, 50);
  XtSetArg(args[2], XmNminimum, 0);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 100);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  PtSizeScal = XtCreateManagedWidget("PtSizeScal",
    xmScaleWidgetClass, CPRC, args, 9);
  XtAddCallback(PtSizeScal, XmNdragCallback, (XtCallbackProc) PointSizeCB, 0);
  XtAddCallback(PtSizeScal, XmNvalueChangedCallback, (XtCallbackProc) PointSizeCB, 0);
  XmScaleSetValue(PtSizeScal, DefaultPointSize);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillPtSizePalCB, (caddr_t) 0);


  XtManageChild(PtSizeShell);
  XtManageChild(PtSizeShellDia);
/*  return PtSizeShellDia;*/
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillPtSizePalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(PtSizeShellDia);
  XtDestroyWidget(PtSizeShellDia);
  PtSizeShellDia = NULL;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateControlPopup(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton;

/*	XtSetArg(args[0], XmNallowShellResize, False);*/
  XPushFnt(ControlShellDia)
	XtSetArg(args[0], XtNwidth, 345);
	XtSetArg(args[1], XtNheight, 650);
  ControlShellDia = XtCreatePopupShell("3D Control Panel", topLevelShellWidgetClass, Parent, args, 2);
/*	XtSetArg(args[0], XtNwidth, 421);*/
/*	XtSetArg(args[1], XtNheight, 562);*/
/*  XtSetArg(args[0], XmNresizePolicy, XmRESIZE_NONE);*/
  ControlShell = XmCreateBulletinBoard(ControlShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(ControlShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("   3D Control Panel   "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  GFScale_Widgets(CPRC);
  GFTrans_Widgets(CPRC);
  GFDist_Widgets(CPRC);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillControlCB, (caddr_t) 0);

  XtManageChild(ControlShell);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillControlCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(ControlShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateSetControlPopup(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton;
  XPushFnt(SetControlShellDia)
/*	XtSetArg(args[0], XmNallowShellResize, False);*/
/*	XtSetArg(args[1], XtNwidth, 493);*/
/*	XtSetArg(args[2], XtNheight, 391);*/
  SetControlShellDia = XtCreatePopupShell("Set Control Panel", topLevelShellWidgetClass, Parent, args, 0);
/*  XtSetArg(args[0], XmNresizePolicy, XmRESIZE_NONE);*/
  SetControlShell = XmCreateBulletinBoard(SetControlShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(SetControlShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("  Set Control Panel   "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  GFControl(CPRC);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillSetControlCB, (caddr_t) 0);

  XtManageChild(SetControlShell);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillSetControlCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(SetControlShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateARSizePalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;

caddr_t
call_data;
{
  XtManageChild(ARSizeShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateARSizePal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton, ARSizeShell;
  Widget  ScaleCPRC, ThetaCPRC, PhiCPRC, GammaCPRC;

  XPushFnt(ARSizeShellDia)
  XtSetArg(args[0], XmNallowShellResize, False);
  ARSizeShellDia = XtCreatePopupShell("AutoRotate Panel", topLevelShellWidgetClass, Parent, args, 1);

  ARSizeShell = XmCreateBulletinBoard(ARSizeShellDia, "Shell", args, 0);


  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 5);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XtCreateManagedWidget("CPRC", xmRowColumnWidgetClass, ARSizeShell, args, 3);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("   AutoRotate Guide "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 2);
  ScaleCPRC = XtCreateManagedWidget("CPRC", xmRowColumnWidgetClass, CPRC, args, 3);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  ThetaCPRC = XtCreateManagedWidget("CPRC",
    xmRowColumnWidgetClass, ScaleCPRC, args, 3);
  PhiCPRC = XtCreateManagedWidget("CPRC",
    xmRowColumnWidgetClass, ScaleCPRC, args, 3);
  GammaCPRC = XtCreateManagedWidget("CPRC",
    xmRowColumnWidgetClass, ScaleCPRC, args, 3);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Theta Step"));
  XtSetArg(args[1], XmNmaximum, 30);
  XtSetArg(args[2], XmNminimum, -30);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 40);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[9], XmNwidth, 100);
  ARThetaScal = XtCreateManagedWidget("ARSizeScal", xmScaleWidgetClass, ThetaCPRC, args, 9);
  XtSetArg(args[0], XmNtitleString, Str2MotStr("Phi Step"));
  ARPhiScal = XtCreateManagedWidget("ARSizeScal", xmScaleWidgetClass, PhiCPRC, args, 9);
  XtSetArg(args[0], XmNtitleString, Str2MotStr("Gamma Step"));
  ARGammaScal = XtCreateManagedWidget("ARSizeScal", xmScaleWidgetClass, GammaCPRC, args, 9);
  XtAddCallback(ARThetaScal, XmNdragCallback, (XtCallbackProc) ARSizeCB, 0);
  XtAddCallback(ARThetaScal, XmNvalueChangedCallback, (XtCallbackProc) ARSizeCB, 0);
  XtAddCallback(ARPhiScal, XmNdragCallback, (XtCallbackProc) ARSizeCB, 0);
  XtAddCallback(ARPhiScal, XmNvalueChangedCallback, (XtCallbackProc) ARSizeCB, 0);
  XtAddCallback(ARGammaScal, XmNdragCallback, (XtCallbackProc) ARSizeCB, 0);
  XtAddCallback(ARGammaScal, XmNvalueChangedCallback, (XtCallbackProc) ARSizeCB, 0);

  XtSetArg(args[0], XmNheight, 50);
  XtSetArg(args[1], XmNwidth, 50);
  ThetaTog = XtCreateManagedWidget("",
    xmToggleButtonWidgetClass, ThetaCPRC, args, 2);
  XtAddCallback(ThetaTog, XmNvalueChangedCallback,
    (XtCallbackProc) ThetaTogCB, (caddr_t) 0);

  PhiTog = XtCreateManagedWidget("",
    xmToggleButtonWidgetClass, PhiCPRC, args, 2);
  XtAddCallback(PhiTog, XmNvalueChangedCallback,
    (XtCallbackProc) PhiTogCB, (caddr_t) 0);

  GammaTog = XtCreateManagedWidget("",
    xmToggleButtonWidgetClass, GammaCPRC, args, 2);
  XtAddCallback(GammaTog, XmNvalueChangedCallback,
    (XtCallbackProc) GammaTogCB, (caddr_t) 0);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Step Scale"));
  XtSetArg(args[1], XmNmaximum, 30);
  XtSetArg(args[2], XmNminimum, 0);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 100);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[9], XmNwidth, 100);
  AllScale = XtCreateManagedWidget("AllScale", xmScaleWidgetClass, CPRC, args, 9);
  XtAddCallback(AllScale, XmNdragCallback, (XtCallbackProc) ARScaleCB, 0);
  XtAddCallback(AllScale, XmNvalueChangedCallback, (XtCallbackProc) ARScaleCB, 0);

  XmScaleSetValue(ARThetaScal, ARScale);
  DefaultARThetaStep = ARThetaStep * ARScale;
  DefaultARPhiStep = ARPhiStep * ARScale;
  DefaultARGammaStep = ARGammaStep * ARScale;

  XmScaleSetValue(ARThetaScal, DefaultARThetaStep);
  XmScaleSetValue(ARPhiScal, DefaultARPhiStep);
  XmScaleSetValue(ARGammaScal, DefaultARGammaStep);
  XmToggleButtonSetState(ThetaTog, 0, TRUE);
  XmToggleButtonSetState(PhiTog, 0, TRUE);
  XmToggleButtonSetState(GammaTog, 0, TRUE);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillARSizePalCB, (caddr_t) 0);


  XtManageChild(ARSizeShell);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillARSizePalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(ARSizeShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateAxisSizePalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreateAxisSizePal(toplevel);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateAxisSizePal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton, AxisSizeShell;

  XPushFnt(AxisSizeShellDia)
  AxisSizeShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  AxisSizeShell = XmCreateBulletinBoard(AxisSizeShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(AxisSizeShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("   AxisSize Panel   "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("AxisSize"));
  XtSetArg(args[1], XmNmaximum, 500);
  XtSetArg(args[2], XmNminimum, 0);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 200);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  AxisSizeScal = XtCreateManagedWidget("AxisSizeScal",
    xmScaleWidgetClass, CPRC, args, 9);
  XtAddCallback(AxisSizeScal, XmNdragCallback, (XtCallbackProc) AxisSizeCB, 0);
  XtAddCallback(AxisSizeScal, XmNvalueChangedCallback, (XtCallbackProc) AxisSizeCB, 0);
  XmScaleSetValue(AxisSizeScal, DefaultAxisSize);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillAxisSizePalCB, (caddr_t) 0);


  XtManageChild(AxisSizeShell);
  XtManageChild(AxisSizeShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillAxisPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  KillAxisPal();
}

void
KillAxisPal()
{
  XtUnmanageChild(AxisShellDia);
  XtDestroyWidget(AxisShellDia);
  AxisShellDia = NULL;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillAxisSizePalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(AxisSizeShellDia);
  XtDestroyWidget(AxisSizeShellDia);
  AxisSizeShellDia = NULL ;
}


/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateIconPopup(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton;

  XPushFnt(IconShellDia)
  IconShellDia = XtCreatePopupShell("Icon Work Panel", topLevelShellWidgetClass, Parent, args, 0);
  XtSetArg(args[1], XmNresizePolicy, XmRESIZE_NONE);
  IconShell = XmCreateBulletinBoard(IconShellDia, "Shell", args, 1);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(IconShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("   Icon Work Panel   "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  MakeIconPanel(CPRC, 4,ArrIconPanel);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillIconCB, (caddr_t) 0);

  XtManageChild(IconShell);
  return;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillIconCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(IconShellDia);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
#include "ICONS/NewAnim.xbm"
#include "ICONS/Play.xbm"
#include "ICONS/Record.xbm"
#include "ICONS/Pause.xbm"
#include "ICONS/Stop.xbm"
#include "ICONS/Reverse.xbm"
#include "ICONS/FForward.xbm"
#include "ICONS/FRewind.xbm"
#include "ICONS/Speed.xbm"
#include "ICONS/AniLoad.xbm"
#include "ICONS/AniSave.xbm"

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateAnimPal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, CPRCradio, CPRCButRad, SelButton;
  Widget  PlayButt,RecButt,NewAnimButt;
  Widget  FForwardButt,FRewindButt,ReverseButt,StopButt,PauseButt;
  Widget  SpeedButt,LoadAniButt,SaveAniButt;
  Widget  ButtonRC;

  XPushFnt(AnimShellDia)
  AnimShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  AnimShell = XmCreateBulletinBoard(AnimShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRCradio = XmCreateRowColumn(AnimShell, "workarea", args, 3);
  XtManageChild(CPRCradio);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("Animation"));
  Text_Label = XmCreateLabel(CPRCradio, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(CPRCradio, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  ButtonRC = XmCreateRowColumn(CPRCradio, "workarea", args, 3);
  XtManageChild(ButtonRC);

   NewAnimButt = CreateIconButt
    ((void *) NewAnimCB, (caddr_t) 0, toplevel, CPRC,
    NewAnim_bits, NewAnim_width, NewAnim_height,0);
   LoadAniButt = CreateIconButt
    ((void *) LoadAniCB, (caddr_t) 0, toplevel, CPRC,
    AniLoad_bits, AniLoad_width, AniLoad_height,0);
   SaveAniButt = CreateIconButt
    ((void *) SaveAniCB, (caddr_t) 0, toplevel, CPRC,
    AniSave_bits, AniSave_width, AniSave_height,0);
   SpeedButt = CreateIconButt
    ((void *) CreateAnimSpeedPalCB, (caddr_t) 0, toplevel, CPRC,
    Speed_bits, Speed_width, Speed_height,0);
   RecButt = CreateIconButt
    ((void *) RecordCB, (caddr_t) 0, toplevel, CPRC,
    Record_bits, Record_width, Record_height,0);

  XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  XtSetArg(args[3], XmNradioAlwaysOne, True );
  XtSetArg(args[4], XmNradioBehavior, True );
  CPRCButRad = XmCreateRowColumn(ButtonRC, "workarea", args, 5);
  XtManageChild(CPRCButRad);

   FRewindButt = CreateIconButt
    ((void *) FRewindCB, (caddr_t) 0, toplevel, CPRCButRad,
    FRewind_bits, FRewind_width, FRewind_height,1);
   ReverseButt = CreateIconButt
    ((void *) ReverseCB, (caddr_t) 0, toplevel, CPRCButRad,
    Reverse_bits, Reverse_width, Reverse_height,1);
   StopButt = CreateIconButt
    ((void *) StopCB, (caddr_t) 0, toplevel, CPRCButRad,
    Stop_bits, Stop_width, Stop_height,1);
   PlayButt = CreateIconButt
    ((void *) PlayCB, (caddr_t) 0, toplevel, CPRCButRad,
    Play_bits, Play_width, Play_height,1);
   FForwardButt = CreateIconButt
    ((void *) FForwardCB, (caddr_t) 0, toplevel, CPRCButRad,
    FForward_bits, FForward_width, FForward_height,1);

   PauseButt = CreateIconButt
    ((void *) PauseCB, (caddr_t) 0, toplevel, ButtonRC,
    Pause_bits, Pause_width, Pause_height,1);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRCradio, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillAnimPalCB, (caddr_t) 0);


  XtManageChild(AnimShell);
  XtManageChild(AnimShellDia);
  return ;
}



/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* AnimationSpeed */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateAnimSpeedPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  CreateAnimSpeedPal(toplevel);
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
CreateAnimSpeedPal(Parent)
Widget  Parent;
{
  Arg     args[10];
  Widget  Text_Label, CPRC, SelButton, AnimSpeedShell;

  XPushFnt(AnimSpeedShellDia)
  AnimSpeedShellDia = XmCreateDialogShell(Parent, "Shell", args, 0);
  AnimSpeedShell = XmCreateBulletinBoard(AnimSpeedShellDia, "Shell", args, 0);

  XtSetArg(args[0], XmNorientation, XmVERTICAL);
  XtSetArg(args[1], XmNnumColumns, 3);
  XtSetArg(args[2], XmNpacking, XmPACK_TIGHT);
  CPRC = XmCreateRowColumn(AnimSpeedShell, "workarea", args, 3);
  XtManageChild(CPRC);

  XtSetArg(args[0], XmNlabelString, Str2MotStr("   Animation Speed Panel   "));
  Text_Label = XmCreateLabel(CPRC, "Text_Label", args, 1);
  XtManageChild(Text_Label);

  XtSetArg(args[0], XmNtitleString, Str2MotStr("Number of Frames Per Division"));
  XtSetArg(args[1], XmNmaximum, 100);
  XtSetArg(args[2], XmNminimum, 1);
  XtSetArg(args[3], XmNscaleMultiple, 1);
  XtSetArg(args[4], XmNvalue, 1);
  XtSetArg(args[5], XmNheight, 200);
  XtSetArg(args[6], XmNshowValue, True);
  XtSetArg(args[7], XmNprocessingDirection, XmMAX_ON_RIGHT);
  XtSetArg(args[8], XmNorientation, XmHORIZONTAL);
  AnimSpeedScal = XtCreateManagedWidget("AnimSpeedScal",
    xmScaleWidgetClass, CPRC, args, 9);
 XtAddCallback(AnimSpeedScal, XmNdragCallback, (XtCallbackProc) AnimSpeedCB, 0);
  XtAddCallback(AnimSpeedScal, XmNvalueChangedCallback, (XtCallbackProc) AnimSpeedCB,
0);
  XmScaleSetValue(AnimSpeedScal, DefaultAnimSpeed);

  XtSetArg(args[0], XmNalignment, XmALIGNMENT_CENTER);
  SelButton = XtCreateManagedWidget("Dismiss",
    xmPushButtonWidgetClass, CPRC, args, 1);
  XtAddCallback(SelButton, XmNactivateCallback,
    (XtCallbackProc) KillAnimSpeedPalCB, (caddr_t) 0);


  XtManageChild(AnimSpeedShell);
  XtManageChild(AnimSpeedShellDia);
  return ;
}

/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
void
KillAnimSpeedPalCB(w, client_data, call_data)
Widget  w;
caddr_t client_data;
caddr_t call_data;
{
  XtUnmanageChild(AnimSpeedShellDia);
  XtDestroyWidget(AnimSpeedShellDia);
  AnimSpeedShellDia = NULL; 
}

