#ifndef LL_h
#define LL_h
/*---------- Double linked list handler  ---------------------------------- */
/*  author: G. Matas   (g.matas@ee.surrey.ac.uk)                            */
/*
   8-May-93, George Matas  (vers. 4.1)
     'const' qualifiers added to SortLL prototype 

   26-Jan-93,  George Matas
    ConsLL prototype changed form ConsLL() into ConsLL(void)

 
   version: 4.0                             date: 16.6.92
*/

/*  based on a link library by Duane Morse (the circularity trick)          */
/*--------------------------------------------------------------------------*/

#include <stdio.h>             /* to get NULL */
#include <stddef.h>            /* to get size_t  */
#define t_LLsize unsigned int
typedef struct s_list { 	
  int b;
  struct s_list *forward;
  struct s_list *backward;
  t_LLsize size;         /* size of elmement stored; 0 for the list head */
} l_list;

typedef struct{ 
    l_list links;                                /* links to list elements */
    char  * id;                    /* nonessetial head identification*/
} *t_LL;
#endif

#ifndef _NO_PROTO
/*------------------- basic list functions ------------------------------- */
t_LL   ConsLL (void);              /*                   list constructor   */
void * DestLL ( t_LL list);         /*                   list destructor    */

t_LL ConsCopyLL(t_LL src);  /* construct a copy of src                    */
t_LL ConsPtrLL (t_LL src);   /* construct a list of pointers to data in src*/

t_LL   EmptyLL  (t_LL list);       /* delete all elmements from a list     */
int    IsEmptyLL(t_LL list);       /* test for an empty list               */
t_LL ReverseLL (t_LL list);  

void * ApplyLL (t_LL list, void * (*apply) (void *));
			           /* apply a function to every elmement   */

t_LL   SortLL (t_LL list,  int (*compar) (void *, void*)); 
                            /* sort the list according to compare function */
			    /* compare receives    p_element (same as qsort)*/

long   SizeLL (t_LL list);    /* return the number of  elmements in  a list */

void * LookInLL(t_LL list);
		       /* create a look-up table for random access into list */
		       /* to get n-th element, write Look[n] (after Look=..  */

char * FprintLL(t_LL list, FILE * file,char *bef,char *control, char *aft);
char * SprintLL(t_LL list, char * string, char *bef, char *control, char *aft);
		       /* print a list. */
char * SscanLL(t_LL list, char *string, char * control, int termination);

/*-------Insert/Delete     elmements ---------------------- */
/* INSERT a  new  elmement in the  list                                     */
/*    Bef/Aft    - before/after a given   p_element                         */
/*    first/Last - as a first or last elmement of the list                  */
/*         returns address of the new element                               */

#define InsBefLL(p_el,data)   InsBefLLf(p_el,   sizeof(data), &data)
#define InsAftLL(p_el,data)   InsAftLLf(p_el,   sizeof(data), &data)
#define InsFirstLL(list,data) InsFirstLLf(list,   sizeof(data), &data)
#define InsLastLL(list,data)  InsLastLLf(list,   sizeof(data), &data)

void * InsBefLLf (void * p_elm, size_t size, void * data);
void * InsAftLLf (void * p_elm, size_t size, void * data);
void * InsFirstLLf (t_LL list, size_t size, void * data);
void * InsLastLLf (t_LL list,  size_t size, void * data);

void  DelElmLL   (void * p_elm);        /* Delete   p_element from the list */
void * DelElmNeLL(void * p_elm);        /* Delete p_elem, return p to next */
void * DelElmPrLL(void * p_elm);        /* Delete p_elem, return p to prev */
/*--------------------------------------------------------------------------*/

/*-------- Moves (Cut & Paste) involving 2 lists ------------------------*/
/* NOTE: for all moves: pointers to moved elems are still valid          */

/* move the whole list  to dest, src becomes empty */
t_LL  MoveListFirstLL(t_LL  dest, t_LL src);
t_LL  MoveListLastLL(t_LL  dest, t_LL src);
void *  MoveListAftLL(void *el,  t_LL src);
void *  MoveListBefLL(void *el,  t_LL src);

/* move head (elements from start to head <excluding> to dest */
/* head must be an element of src ! */
t_LL  MoveHeadFirstLL(t_LL  dest, t_LL src, void *head);
t_LL  MoveHeadLastLL(t_LL  dest, t_LL src, void *head);
void *  MoveHeadAftLL(void *el,  t_LL src, void *head);
void *  MoveHeadBefLL(void *el,  t_LL src, void *head);

/* move tail (elements from tail (including) to end of list to dest */
/* tail must be an element fo src! */
t_LL  MoveTailFirstLL(t_LL  dest, t_LL src, void *tail);
t_LL  MoveTailLastLL(t_LL  dest, t_LL src, void *tail);
void *  MoveTailAftLL(void *el,  t_LL src, void *tail);
void *  MoveTailBefLL(void *el,  t_LL src, void *tail);


/*--------------    Moves of Element ptrs-----------------------------------*/
/*    get (move to) the First/Last/                                         */
/*                  Nth    - n-th   element in the list                     */ 
/*                  RelNth - n-th   p_element after the given one           */

void * FirstElmLL (t_LL list);
void *  LastElmLL (t_LL list);
void *   NthElmLL (t_LL list, long n);
void *  NextElmLL (void * p_elm);
void *  PrevElmLL (void * p_elm);
void *  RelNthElmLL (void * p_elm, long n);
long  IndexElmLL    (t_LL list, void *ind_el); /* element position */

                                    /* macros for scanning through the list */
#define ForeachLL_M(list,p_elm)\
     for(p_elm=FirstElmLL(list); IsElmLL(p_elm); p_elm=NextElmLL(p_elm))

#define ForeachDownLL_M(list,p_elm)\
     for(p_elm=LastElmLL(list); IsElmLL(p_elm); p_elm=PrevElmLL(p_elm))

#define SafeForeachLL_M(list,p_elm,next_p_elm)\
     for(p_elm=FirstElmLL(list); IsElmLL(p_elm); p_elm=next_p_elm)
/*-------------- Linking in/out from the list -------------------------------*/
void * LinkAftLL(void * curr,void * new);   /* link new after current */
void * LinkBefLL(void * curr,void * new);   /* link new before current */
void * UnlinkLL(void * el); 
void * UnlinkNeLL(void * el);
void * UnlinkPrLL(void * el);

/*---------------------- Misc. functions-------------------------------------*/

int   IsElmLL  (void * p_elm); /* Test for the end of the list    */
int   IsFirstElmLL  (void * p_elm); /* is p_elm the last elm in the list? */
int   IsLastElmLL   (void * p_elm); /* is p_elm the first elm in the list?*/


#endif

#ifdef _NO_PROTO
/*------------------- basic list functions ------------------------------- */
t_LL   ConsLL ();              /*                   list constructor   */
void * DestLL ();         /*                   list destructor    */

t_LL ConsCopyLL();  /* construct a copy of src                    */
t_LL ConsPtrLL ();   /* construct a list of pointers to data in src*/

t_LL   EmptyLL  ();       /* delete all elmements from a list     */
int    IsEmptyLL();       /* test for an empty list               */
t_LL ReverseLL ();

void * ApplyLL ();
                                   /* apply a function to every elmement   */

t_LL   SortLL ();
                            /* sort the list according to compare function */
                            /* compare receives    p_element (same as qsort)*/

long   SizeLL ();    /* return the number of  elmements in  a list */

void * LookInLL();
                       /* create a look-up table for random access into list */
                       /* to get n-th element, write Look[n] (after Look=..  */

char * FprintLL();
char * SprintLL();
                       /* print a list. */
char * SscanLL();

/*-------Insert/Delete     elmements ---------------------- */
/* INSERT a  new  elmement in the  list                                     */
/*    Bef/Aft    - before/after a given   p_element                         */
/*    first/Last - as a first or last elmement of the list                  */
/*         returns address of the new element                               */

#define InsBefLL(p_el,data)   InsBefLLf(p_el,   sizeof(data), &data)
#define InsAftLL(p_el,data)   InsAftLLf(p_el,   sizeof(data), &data)
#define InsFirstLL(list,data) InsFirstLLf(list,   sizeof(data), &data)
#define InsLastLL(list,data)  InsLastLLf(list,   sizeof(data), &data)

void * InsBefLLf ();
void * InsAftLLf ();
void * InsFirstLLf ();
void * InsLastLLf ();

void  DelElmLL   ();        /* Delete   p_element from the list */
void * DelElmNeLL();        /* Delete p_elem, return p to next */
void * DelElmPrLL();        /* Delete p_elem, return p to prev */
/*--------------------------------------------------------------------------*/

/*-------- Moves (Cut & Paste) involving 2 lists ------------------------*/
/* NOTE: for all moves: pointers to moved elems are still valid          */

/* move the whole list  to dest, src becomes empty */
t_LL  MoveListFirstLL();
t_LL  MoveListLastLL();
void *  MoveListAftLL();
void *  MoveListBefLL();

/* move head (elements from start to head <excluding> to dest */
/* head must be an element of src ! */
t_LL  MoveHeadFirstLL();
t_LL  MoveHeadLastLL();
void *  MoveHeadAftLL();
void *  MoveHeadBefLL();

/* move tail (elements from tail (including) to end of list to dest */
/* tail must be an element fo src! */
t_LL  MoveTailFirstLL();
t_LL  MoveTailLastLL();
void *  MoveTailAftLL();
void *  MoveTailBefLL();


/*--------------    Moves of Element ptrs-----------------------------------*/
/*    get (move to) the First/Last/                                         */
/*                  Nth    - n-th   element in the list                     */
/*                  RelNth - n-th   p_element after the given one           */

void * FirstElmLL ();
void *  LastElmLL ();
void *   NthElmLL ();
void *  NextElmLL ();
void *  PrevElmLL ();
void *  RelNthElmLL ();
long  IndexElmLL    ();

                                    /* macros for scanning through the list */
#define ForeachLL_M(list,p_elm)\
     for(p_elm=FirstElmLL(list); IsElmLL(p_elm); p_elm=NextElmLL(p_elm))

#define ForeachDownLL_M(list,p_elm)\
     for(p_elm=LastElmLL(list); IsElmLL(p_elm); p_elm=PrevElmLL(p_elm))

#define SafeForeachLL_M(list,p_elm,next_p_elm)\
     for(p_elm=FirstElmLL(list); IsElmLL(p_elm); p_elm=next_p_elm)
/*-------------- Linking in/out from the list -------------------------------*/
void * LinkAftLL();
void * LinkBefLL();
void * UnlinkLL();
void * UnlinkNeLL();
void * UnlinkPrLL();

/*---------------------- Misc. functions-------------------------------------*/

int   IsElmLL  ();
int   IsFirstElmLL  ();
int   IsLastElmLL   ();


#endif
