/*---------- Double linked list handler  ---------------------------------- */
/*  author: G. Matas                           (g.matas@ee.surrey.ac.uk)    */
/* +-------------------------------------------------------------------+ */
/* | Copyright 1992, George Matas.                                     | */
/* |   Permission to use, copy, modify, and distribute this software   | */
/* |   and its documentation for any purpose and without fee is hereby | */
/* |   granted, provided that the above copyright notice appear in all | */
/* |   copies and that both that copyright notice and this permission  | */
/* |   notice appear in supporting documentation.  This software is    | */
/* |   provided "as is" without express or implied warranty.           | */
/* +-------------------------------------------------------------------+
*/

/*
      G.Matas, 8-May-93   (version 4.1)
	- all problems around SortLL leading to warnings:
	   cast discards `const' from pointer target type
	   fixed

      G.Matas, 20-Jan-93
       - strdup function added 

      G.Matas, 8-Oct-92
       - fix minor non-ANSI-compatibilities
    
      version: 4.0                           date: 
       -  ConsCopyLL replaces CopyAftLL
       -  ConsPtrLL  added
       -  MoveXXXLL replaces MoveAftLL, TailAftLL 
       -  IndexElmLL added
       -  ReverseLL added
       -  IndexLL added

 
      version: 3.3                             date: 15.6.92
       -  function  PrintLL modified and renamed  to FprintLL
       -  functions SprintLL and SscanfLL added
       -  a large general purpose buffer BuffLL created

      -   functions 
      version: 3.2                             date: 25.5.92
       -  IsLastElmLL  added
       -  IsFirstElmLL added

      version: 3.1                             date: 14.4.92
       -  TailAftLL replaces  MoveTailAftLL 

      version: 3.0                             date: 13.4.92
       Substantial changes
       - t_LL type changed
       - IsElmLL   changed to take just one param
       - IsElm1LL  deleted

   version :2.2           date:  6.4. 92
      - function IsElm1LL added
   version :2.1           date:  13.2.92
      - Unlink returns void *
      - LookInLL changed (see the func. for desc.)
      - NthElmLL generalized
      - l_prevl, l_nextl : macro implementation added
      - SizeLL made more efficient
*/
/*                                                                          */
/*  based on a link library by Duane Morse                                  */
/*--------------------------------------------------------------------------*/

#include "LL.h"
#include "linkLL.h"
/* #include <stdio.h> */
#include <stdlib.h>
/* #include <stdarg.h> */
/* #include <string.h> */


/* common error messages */
static char * NullMall = "malloc returned NULL";


/*--------------- linking ------------------------------------------*/
void 
l_lafter(current, new)   l_list *current; l_list *new;
{
  new->forward = current->forward;
  new->backward = current;
  current->forward->backward = new;
  current->forward = new;
}

void 
l_lbefore(current, new)  l_list *current;l_list  *new;
{
  new->forward = current;
  new->backward = current->backward;
  current->backward->forward = new;
  current->backward = new;
}

void 
l_unlink(link)  l_list *link;
{
  link->forward->backward = link->backward;
  link->backward->forward = link->forward;
}

static void    
l_linit(link)  l_list *link; 
{ link->forward = link->backward = link; }

#ifndef L_BASIC_MACRO
l_list *l_nextl(l_list *link) { return link->forward;  }
l_list *l_prevl(l_list *link) { return link->backward; }
int    l_lempty(l_list *link) { return (link->forward == link); }
#endif

/*------------- LinkIn/Out an element ----------------------------*/
void * 
LinkAftLL(curr, new)  void * curr;void * new;
			{ l_lafter(elm2link(curr),elm2link(new)); return new; }
void * 
LinkBefLL(curr, new)  void * curr;void * new;
			{ l_lbefore(elm2link(curr),elm2link(new)); return new; }
void * 
UnlinkLL(el)  void * el;
                        {l_unlink(elm2link(el)); return el; }

void * 
UnlinkNeLL(el)  void * el;
{  
   void * next = NextElmLL(el);
   l_unlink(elm2link(el));
   return next;
}

void * 
UnlinkPrLL(el)  void * el;
{  
   void * prev = PrevElmLL(el);
   l_unlink(elm2link(el));
   return prev;
}

#define AbortLL_M(where,error)\
    {fprintf(stderr,"In %s: %s \n",where,error); exit (-1); }

/*---------------- Insert Element ----------------------------------------*/
static void *
InsLLf(li, size, data, linkin)  
l_list *li; size_t size; void *data; 
void (*linkin)();
{
  l_list * new;

  if (NULL==(new=(l_list*)malloc(size+sizeof(l_list))))
       AbortLL_M("InsBefLLf",NullMall);
  linkin(li,new);
  memcpy(link2elm(new),data,size);
  new->size=size;
  return (link2elm(new));
}
 

void * 
InsBefLLf (el, size, data)  void *el; size_t size; void *data;
                        { return InsLLf(elm2link(el),size,data,l_lbefore); }
void * 
InsAftLLf (el, size, data)  void * el; size_t size; void * data;
                        { return InsLLf(elm2link(el),size,data,l_lafter); }
void * 
InsLastLLf (list, size, data)  t_LL list; size_t size; void * data;
                        { return InsLLf(list2link(list),size,data,l_lbefore); }
void * 
InsFirstLLf (list, size, data)  t_LL  list; size_t size; void * data;
                        { return InsLLf(list2link(list),size,data,l_lafter); }

/*---------------- Delete Element ----------------------------------------*/
void  
DelElmLL  (el)  void * el;
{ 
  l_unlink( elm2link(el));
  free    ( elm2link(el));
}
void * 
DelElmNeLL (el)  void * el;
{ 
  void * next = NextElmLL(el);
  DelElmLL(el);
  return (next);
}

void * 
DelElmPrLL (el)  void * el;
{ 
  void * prev = PrevElmLL(el);
  DelElmLL(el);
  return (prev);
}

/*----------------- Get an element ---------------------------------------*/
void * 
FirstElmLL (list)  t_LL list;  
	{ return link2elm(l_nextl(list2link(list))); }
void *  
LastElmLL (list)  t_LL list;  
	{ return link2elm(l_prevl(list2link(list))); }
void *  
PrevElmLL (el)  
void *el;  
	{ return link2elm(l_prevl(elm2link(el))); }
void *  NextElmLL(el)  
void *el;
	{ return link2elm(l_nextl(elm2link(el))); }

/* 2.1 : NthElmLL can be called with a negative value */
void *  
NthElmLL (list, num)  t_LL list; long num;
{
  l_list * link = list2link(list);

  if (num >0) while (num--) link = l_nextl(link);
  else        while (num++) link = l_prevl(link); 

  return link2elm(link);
}
void *  
RelNthElmLL (el, num)  void * el; long num;
{
  l_list * link = elm2link(el);

  if (num >0) while (num--) link = l_nextl(link);
  else        while (num++) link = l_prevl(link); 

  return link2elm(link);
}

static char LL_id[] = "gm"; 

int 
IsElmLL     (el)  void * el; 
	{ return elm2link(el)->size ; }
int 
IsLastElmLL (el)  void *el;  
	{return IsElmLL(NextElmLL(el)); }
int 
IsFirstElmLL(el)  void *el;  
	{return IsElmLL(PrevElmLL(el)); }


t_LL 
ConsLL ()
{
  t_LL   head;

  if (NULL==(head=(t_LL) malloc(sizeof(*head))))
               AbortLL_M("CreatLL",NullMall);

  l_linit(list2link(head));
  head->id  = LL_id;
  head->links.size= 0;
  return (head);
}

int  
IsEmptyLL(list)  t_LL list; 
	{ return (l_lempty(list2link(list))); }
t_LL 
EmptyLL(list)  t_LL list;
{
  l_list  * head = list2link(list);
  l_list  * link = l_nextl(head);
  l_list  * old  =link;

  while(head != link){
    old = link;
    link = l_nextl(link);
    free(old);
  }

  l_linit(head);

  return list;
}

void  *
DestLL(list)  t_LL list;
{
  EmptyLL(list);
  free(list);
  return NULL;
}

void * 
ApplyLL (list, apply)  
t_LL list; 
void *(*apply)();
{
  void * el, * ret_el, *next;

  SafeForeachLL_M (list,el,next){
   next = NextElmLL(el);
   if ((ret_el=(*apply)(el)) != NULL ) return ret_el;
  }

  return NULL;
}

t_LL 
ReverseLL (list)  t_LL list;
{
  l_list * head = list2link(list);
  l_list * link = head; 
  l_list * temp;
 
  do{
    temp= link->forward;               /* swap */
    link->forward = link->backward;
    link->backward= temp;

    link=l_prevl(link);                /* move */
  }
  while (head != link) ;
  
  return list;
}
long 
SizeLL (list)  t_LL list;
{
  long i=0;
  l_list * head = list2link(list);
  l_list * link; 

  ForeachLink_M(head,link) i++;
  
  return i;
}

t_LL  
ConsPtrLL(src)  t_LL src;
{
  void * el ;
  t_LL dest= ConsLL();

  ForeachLL_M (src,el)
     InsLastLL(dest,el);

  return dest;
}
t_LL  
ConsCopyLL(src)  t_LL src;
{
  void * el ;
  t_LL dest= ConsLL();

  ForeachLL_M (src,el)
     InsLastLLf(dest,elm2link(el)->size, el);

  return dest;
}

 
/* cut what is required and paste it after dest */
static void 
CutPaste(first_out, first_not_out, dest)  l_list *first_out; l_list *first_not_out; l_list *dest;
{
  l_list *last_out = first_not_out->backward;
 
  if (first_out==first_not_out) return;

  first_out->backward->forward = first_not_out;      /* cut */
  first_not_out->backward      = first_out->backward;  
 
  last_out->forward   = dest->forward;
  first_out->backward = dest;

  dest->forward->backward = last_out;
  dest->forward           = first_out; 
  
}
/*-------------- Move List -----------------------------------------------*/
t_LL  
MoveListFirstLL(dest, src)  t_LL  dest; t_LL src;
{
  CutPaste(elm2link(FirstElmLL(src)),list2link(src),list2link(dest));
  return dest;
}
t_LL  
MoveListLastLL(dest, src)  t_LL  dest; t_LL src;
{
  CutPaste(elm2link(FirstElmLL(src)),list2link(src),elm2link(LastElmLL(dest)));
  return dest;
}
void *  
MoveListAftLL(el, src)  void *el;  t_LL src;
{
  CutPaste(elm2link(FirstElmLL(src)),list2link(src),elm2link(el));
  return el;
}
void *  
MoveListBefLL(el, src)  void *el;  t_LL src;
{
  CutPaste(elm2link(FirstElmLL(src)),list2link(src),elm2link(PrevElmLL(el)));
  return el;
}
/*-------------- Move Head -----------------------------------------------*/
t_LL  
MoveHeadFirstLL(dest, src, head)  t_LL  dest; t_LL src; void *head;
{
  CutPaste(elm2link(FirstElmLL(src)),elm2link(head),list2link(dest));
  return dest;
}
t_LL  
MoveHeadLastLL(dest, src, head)  t_LL  dest; t_LL src; void *head;
{
  CutPaste(elm2link(FirstElmLL(src)),elm2link(head),elm2link(LastElmLL(dest)));
  return dest;
}
void *  
MoveHeadAftLL(el, src, head)  void *el;  t_LL src; void *head;
{
  CutPaste(elm2link(FirstElmLL(src)),elm2link(head),elm2link(el));
  return el;
}
void *  
MoveHeadBefLL(el, src, head)  void *el;  t_LL src; void *head;
{
  CutPaste(elm2link(FirstElmLL(src)), elm2link(head),elm2link(PrevElmLL(el)));
  return el;
}
/*-------------- Move Tail -----------------------------------------------*/
t_LL  
MoveTailFirstLL(dest, src, tail)  t_LL  dest; t_LL src; void *tail;
{
  CutPaste(elm2link(tail),list2link(src),list2link(dest));
  return dest;
}

t_LL  
MoveTailLastLL(dest, src, tail)  t_LL  dest; t_LL src; void *tail;
{
  CutPaste(elm2link(tail),list2link(src),elm2link(LastElmLL(dest)));
  return dest;
}
void *  
MoveTailAftLL(el, src, tail)  void *el;  t_LL src; void *tail;
{
  CutPaste(elm2link(tail),list2link(src),elm2link(el));
  return el;
}

void *  
MoveTailBefLL(el, src, tail)  void *el;  t_LL src; void *tail;
{
  CutPaste(elm2link(tail),list2link(src),elm2link(PrevElmLL(el)));
  return el;
}

/* Create a look up table into a list for random access                    */
void * 
LookInLL(list)  t_LL list;
{

  void * * array = (void **) malloc ((SizeLL(list)+ 1) * sizeof(void *));
	/* array has one element more then the size of the list  */
	/* so that the first element is array[1]                 */
	/* array[0] is the head of the list*/

  void * el;
  int i = 1;

  array[0]= &(list->id);
  ForeachLL_M (list,el)
     array[i++] = el;


  return array;
}
long 
IndexElmLL(list, ind_el)  t_LL list; void *ind_el;
{
  void *el; 
  long i=1;

  ForeachLL_M (list,el)
   if (el==ind_el) return i;
   else i++;
  
 return -1;
}
  
static int (*UserCompare)();

static int 
IntCompare(el1, el2)
char *el1; 
char *el2;
    { return (*UserCompare) (*(char *)el1, *(char *)el2);}


t_LL 
SortLL (list, compar)  
t_LL list;  int (*compar) ();
{
  int ListSize = SizeLL(list);
  l_list *      head_link;

  void * el;
  void * * array = (void **) malloc (ListSize * sizeof(void *));
  int i = 0;
  
  ForeachLL_M (list,el)
    array[i++] = el;

  UserCompare=compar;
  qsort(array,ListSize,sizeof(void *),UserCompare);

  head_link = list2link(list);
  l_linit(head_link);

  for(i=0; i<ListSize; i++)
    l_lbefore(head_link,elm2link(array[i]));
  
  free(array);
  return list;
}


#if 0
/*----- io functions ---------------------------------------------------*/
static char * 
GenPrintLL(t_LL list,char *bef,char * control, char *aft,int out);

FILE * FiLL;
char * 
FprintLL(list, file, bef, control, aft)  t_LL list; FILE * file; char *bef; char * control; char *aft;
{
   FiLL = file;
   return GenPrintLL(list,bef,control,aft,1);
}
/* just for online debug  - private*/
char * DprintLL(t_LL list,  char * control);
char * 
DprintLL(list, control)  t_LL list;  char * control;
{
return FprintLL(list,stdout,"",control,"\n");
}


#define MAX_LINE_LENGHT 300000
char BuffLL[MAX_LINE_LENGHT]; 
char *stringLL, *stLL;

char * 
SprintLL(list, string, bef, control, aft)  t_LL list; char * string; char *bef;char *control; char* aft;
{
   if (NULL == string)  stLL=stringLL=BuffLL; 
   else                 stLL=stringLL=string;
   return GenPrintLL(list,bef,control,aft,0);
}
 
static char * 
GenPrintLL(list, bef, control, aft, out)  t_LL list; char *bef; char *control; char *aft;int out;
{
   char  conv = '%';
   char  *curr_cont_start  ,*curr_conv_start,* curr_conv_end;
   int curr_conv_length;

   char * conv_type = "diuoxXfegcsS%";
   char curr_control[200];
   void * elm, * curr_item;
   int n_char;

    if(out)       fprintf(FiLL,bef);
      else          {
	sprintf(stLL,bef);
	stLL+=strlen(bef);
    }
   ForeachLL_M(list,elm){
      curr_item = elm;
      curr_cont_start = control;

      while(1){
	if (NULL == (curr_conv_start = strchr(curr_cont_start,conv))){
          if(out)       fprintf(FiLL,curr_cont_start); 
          else          {
            sprintf(stLL,curr_cont_start);
            stLL+=strlen(curr_cont_start);
          }
                                               /*print chars after last cont.*/
	  break;                      /* find the start of conversion spec. */
	}
	
	if(NULL == (curr_conv_end = strpbrk(curr_conv_start+1,conv_type)))
	     break;    /*  find the converstion type */
	  
	curr_conv_length = curr_conv_end - curr_cont_start + 1;

	strncpy(curr_control,curr_cont_start,curr_conv_length);
		      /* copy the part of control string with % into current */
	curr_control[curr_conv_length] = '\0';
		      /* terminate the control string */

        if(!out) strcat(curr_control,"%n");

       switch (curr_control[curr_conv_length-1]){

	 case 'd': case 'i' :
          if (*(curr_conv_start+1) != '*'){
	    if(out)  fprintf(FiLL,curr_control,*(int *) curr_item);
            else  sprintf(stLL,curr_control,*(int *) curr_item,&n_char);
          }
	  curr_item = (int *) curr_item + 1;
	  break;

	 case 'u': case 'o':
          if (*(curr_conv_start+1) != '*'){
	    if(out)  fprintf(FiLL,curr_control,*(unsigned int *) curr_item);
            else sprintf(stLL,curr_control,*(unsigned int *) curr_item,&n_char);
          }
	  curr_item = (unsigned int *) curr_item + 1;
	  break;

	 case 'e':  case'f': case 'g': 
          if (*(curr_conv_start+1) != '*'){
	  if (curr_control[curr_conv_length-2]=='l')
	    if(out)  fprintf(FiLL,curr_control,*(double*) curr_item);
            else  sprintf(stLL,curr_control,*(double*) curr_item,&n_char);
	  else
	    if(out)  fprintf(FiLL,curr_control,*(float*) curr_item);
            else  sprintf(stLL,curr_control,*(float*) curr_item,&n_char);
          }
	  if (curr_control[curr_conv_length-2]=='l')
	    curr_item = (double *) curr_item + 1;
	  else
	    curr_item = (float *) curr_item + 1;
	  break;

	 case 'S':  /* an array of char */
          if (*(curr_conv_start+1) != '*'){
	    curr_control[curr_conv_length-1]='s';
	    if(out)  fprintf(FiLL,curr_control,(char *) curr_item);
            else  sprintf(stLL,curr_control,(char *) curr_item,&n_char);
          }
	  curr_item = (char *) curr_item + strlen(curr_item)+1;
			/* skip the string */
	  break;

	 case 's': 
           if (*(curr_conv_start+1) != '*'){
	    if(out)  fprintf(FiLL,curr_control,*(char **) curr_item);
            else  sprintf(stLL,curr_control,*(char **) curr_item,&n_char);
           }
	  curr_item = (char **) curr_item + 1;
	  break;

	 case 'c': 
          if (*(curr_conv_start+1) != '*'){
	    if(out)  fprintf(FiLL,curr_control,*(char *) curr_item);
            else  sprintf(stLL,curr_control,*(char *) curr_item,&n_char);
          }
	  curr_item = (char *) curr_item + 1;
	  break;

	 case '%': 
          if (*(curr_conv_start+1) != '*'){
	    if(out)  fprintf(FiLL,curr_control);
            else  sprintf(stLL,curr_control,&n_char);
          }
	  curr_item = (char *) curr_item + 1;
	  break;
         
	 default:
	   break;
	}
	curr_cont_start=curr_conv_end + 1;
	if (!out){
	  stLL += n_char;
	  if (stLL - stringLL > MAX_LINE_LENGHT){
	   fprintf(stderr,"string buffer overflow in SprintfLL\n");
	   exit(-1);
	  }
      }
      }
    }
    if(out)       fprintf(FiLL,aft);
      else          {
	sprintf(stLL,aft);
	stLL+=strlen(aft);
    }

    if (!out) return stLL;
    else      return NULL;
}
 
static char * 
GMstrdup (s)  char * s;
{
   char * copy;
   if (NULL == s) { fprintf(stderr,"NULL passed to strdup \n"); exit(-1);}
   if (NULL == (copy = malloc(strlen(s) + 1)))
   {
     fprintf(stderr,"malloc returned NULL in strdup\n");
     exit(-1);
   }
   strcpy(copy,s);
   return copy;
}

char * 
SscanLL(list, String, control, termination)  t_LL list; char *String; char * control; int termination;
{
   char  conv = '%';
   char  *curr_cont_start  ,*curr_conv_start,* curr_conv_end;
   int curr_conv_length;

   char * conv_type = "diuoxXfegsS%";
   char curr_control[200];
   int n_char;
   char * curr_item;
   long i;
   long size=0;
   char * s = String;

   if (termination == -1){
     sscanf(s,"%d%n",&termination,&n_char);
     s+=n_char;
   }

   for(i=1;i<=termination || (termination==0); i++) {
     curr_cont_start = control;
     curr_item= BuffLL;
     while(1){ 
        if (NULL == (curr_conv_start = strchr(curr_cont_start,conv)))
         break;

	if(NULL == (curr_conv_end = strpbrk(curr_conv_start+1,conv_type)))
	     break;    /*  find the converstion type */
	  
	curr_conv_length = curr_conv_end - curr_cont_start + 1;

	strncpy(curr_control,curr_cont_start,curr_conv_length);
		      /* copy the part of control string with % into current */
	curr_control[curr_conv_length] = '\0';
		      /* terminate the control string */

        strcat(curr_control,"%n");

       switch (curr_control[curr_conv_length-1]){

	 case 'd': case 'i' :
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control,curr_item,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
            size = sizeof(int);
	    break;

	 case 'u': case 'o':
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control, curr_item,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
	  size= sizeof(unsigned int *);
	  break;

	 case 'e':  case'f': case 'g': 
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control,curr_item,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
	  if (curr_control[curr_conv_length-2]=='l') size= sizeof(double *);
	  else                                       size= sizeof(float *);
	  break;

	 case 'S':  /* an array of char */
	    curr_control[curr_conv_length-1]='s';
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control, curr_item,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
	  size= strlen(curr_item)+1;
			  /* skip the string */
            
	    break;

	 case 's': 
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control, curr_item,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
            curr_item = GMstrdup(curr_item);
	  size= sizeof(char *);
	  break;

	 case 'c': 
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control, curr_item,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
	  size= sizeof(char *);
	  break;

	 case '%': 
          if (*(curr_conv_start+1) != '*')
            sscanf(s,curr_control,&n_char);
          else 
            sscanf(s,curr_control,&n_char);
	  size= sizeof(char *);
	  break;
         
	 default:
	     break;
	}
        if (*(curr_conv_start+1) != '*')
          curr_item += size;

        s += n_char;
	curr_cont_start=curr_conv_end + 1;
      }
      InsLastLLf(list,(char*)curr_item-BuffLL,BuffLL);
      if (*s == '\0') break;
    }
	
    if (termination!=0 && i!=termination) return NULL;
    return s;
}
#endif
