/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 *
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */

typedef struct {
  char    Name[200];
  char    Structure[200];
}       t_XmgfGeomStruct;

typedef struct {
  double  startx, starty, startz, endx, endy, endz;
  double  xcen, ycen, zcen, radius, Elmajor, Elminor, theta, botradius, topradius;
  double  x, y, z, width, height, vx, vy, vz, startangle, endangle;
  double  origx, origy, origz, length;
  char   *textseg, *num, *type;
  char   *color;
  int     position;
}       t_XmgfInfoStruct;

/* Attributes Currently being Added for Version 3.0 */
typedef struct {
  int     LineWidth;
  int     LineStyle;
  int     Color;
  int     FillStyle;
  int     PointType;
}       t_XmgfAttrib;


#ifndef _NO_PROTO
char   *GetFormat(t_LLSet InSet);
char   *GetName(t_LLSet InSet);
void     Append3DSets(char *filename);
void     ImportFile(char *filename, int CADtype);
void     Load3DSets(char *filename);
int     LoadNumItem(char *SingleLine, int *Pos);
void     LoadTextItem(char *SingleLine, int *Pos);
void     LoadgfSetNew(char *newfilename, int status);
int     PrimtoInt(char *Primitive);
int     Read3DSets(char *filename);
int     TestFormatGF(t_LLSet Set, char *format);
t_LL    GetData(t_LLSet InSet);
t_LL    Load3DItem(char *SingleLine, int *Pos, int Sides, int TrCo, int Prim);
t_LL    LoadOr3DItem(char *SingleLine, int *Pos, int Sides, int TrCo, int PrimitiveType);
t_LL    LoadRepItem(char *SingleLine, int NewItemNumber, int *Pos, int Rep);
t_LL    LoadSingleItem(char *SingleLine, int itemType, int *Pos);
t_LL    ReadGeneral(char *SingleLine, int *Pos, int PrimitiveType);
void     AngleCheck(double *StAn, double *EnAn);
double  VecLen(t_XmgfPt V_D);
t_XmgfPt VecCross(t_XmgfPt V_A, t_XmgfPt V_B);
t_XmgfPt VecNorm(t_XmgfPt V_D);
void     OrObject(t_XmgfPt V_D, double *Cirx, double *Ciry, double *Cirz, int count, double DisOX, double DisOY, double DisOZ);
t_XmgfPoly LoadOr3DDisc(char *SingleLine, int *Pos, int NumberofSides, int PrimitiveType);
t_LL    GetGeom(t_LLSet InSet);
void     RestoreDefaultStructures(void);
void     MakeDefaultStructures(void);
t_LL    MakeSphere(double Xcen, double Ycen, double Zcen, double Radius, int TessLevel);

t_XmgfPoly LoadPointItem(int PrimitiveType, char *SingleLine, int PtType, int ThreeD, int *NPos);
t_XmgfPoly LoadLineItem(int PrimitiveType, char *SingleLine, int LineType, int ThreeD, int *NPos);
t_XmgfInfoStruct SearchFormatLine(char *IndividualStructure, char *CurrentLine);
int     GeomStructToken(char *CurrentToken);
t_LL    GetAttrib(t_LLSet InSet);
void     Empty3DSets(void);
void    SpecialEmpty3DSets(void);
void     ResetDefaultAttribs(void);
void     SetDefaultAttribs(void);
int     AttribStructToken(char *CurrentToken);
void 	ParseAttribs(int AttribId,char *ATTokenVal);
void SetDefaultAttribs(void);
void 	ReLoad(void);
void    ReadInit(void);
void	DestroyAllgfSet(void);
void    DestroyAllPolygons(t_LL List);
int     FileExist(char *filename);
#else
char   *GetFormat();
char   *GetName();
void     Append3DSets();
void     ImportFile();
int     GetColourNumber();
int     GetPointNumber();
void     Load3DSets();
int     LoadNumItem();
void     LoadTextItem();
void     LoadgfSetNew();
int     PrimtoInt();
int     Read3DSets();
int     TestFormatGF();
t_LL    GetData();
t_LL    Load3DItem();
t_LL    LoadOr3DItem();
t_LL    LoadRepItem();
t_LL    LoadSingleItem();
t_LL    ReadGeneral();
void     AngleCheck();
double  VecLen();
t_XmgfPt VecCross();
t_XmgfPt VecNorm();
void     OrObject();
t_XmgfPoly LoadOr3DDisc();
t_LL    GetGeom();
void     RestoreDefaultStructures();
void     MakeDefaultStructures();
t_LL    MakeSphere();
t_XmgfPoly LoadPointItem();
t_XmgfPoly LoadLineItem();
t_XmgfInfoStruct SearchFormatLine();
int     GeomStructToken();
t_LL    GetAttrib();
void     Empty3DSets();
void    SpecialEmpty3DSets();
void     ResetDefaultAttribs();
void     SetDefaultAttribs();
int     AttribStructToken();
void 	ParseAttribs();
void 	ReLoad();
void    SetDefaultAttribs();
void    ReadInit();
void	DestroyAllgfSet();
void    DestroyAllPolygons();
int     FileExist();
#endif

extern char NewGlobalColor[50];


