/*
 * Copyright (C) 1992, 1993, Paul D. Hoad This file is part of the Xmgf
 * Software. For conditions of distribution and use, see the accompanying
 * README file.
 * 
 * Vision Speech and Signal Processing Group . Dept. of Electronic Engineering.
 * University of Surrey. Guildford, Surrey. England. Phone: +44 483 300800
 * Ext 2753 Email: P.Hoad@ee.surrey.ac.uk
 */

extern double           ax, ay, az,NewThreeDen;
extern int              DistSC;
extern double           R11,R12,R13,R21,R22,R23,R31,R32,R33;
extern double           FDistSC,FOX,FOY,FOZ;
extern double           costab[451];
extern double           sintab[451];

/* Defines */
#define REDRAW_SCREEN DrawSingleItem(All_Polys)
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */
/* |/////////////////////////////oOo\\\\\\\\\\\\\\\\\\\\\\\\\\\| */


#ifndef RIGHTHAND
#define NEWTHREEDTWOD(x,y,z)                                    \
    az = R31*((x)+FOX) + R32*((y)+FOY) + R33*((z)+FOZ);         \
    NewThreeDen = 1/(az + FDistSC);                             \
    ax = ((R11*((x)+FOX) + R12*((y)+FOY) + R13*((z)+FOZ)) * FDistSC) *NewThreeDen;\
    ay = ((R21*((x)+FOX) + R22*((y)+FOY) + R23*((z)+FOZ)) * FDistSC) *NewThreeDen
#else
#define NEWTHREEDTWOD(x,y,z)                                    \
    az =-1* ( R31*((x)+FOX) + R32*((y)+FOY) + R33*((z)+FOZ));   \
    NewThreeDen = 1/(az + FDistSC);                             \
    ax = ((R11*((x)+FOX) + R12*((y)+FOY) + R13*((z)+FOZ)) * FDistSC) *NewThreeDen;\
    ay = ((R21*((x)+FOX) + R22*((y)+FOY) + R23*((z)+FOZ)) * FDistSC) *NewThreeDen
#endif

	




#ifndef _NO_PROTO
double          Cos2 (double deg);
double          Sin2 (double deg);
double          dc2 (double w, double d);
double          ds2 (double w, double d);
void             Draw3DSet (t_XmgfSet *SelectedSet);
void             DrawAll3DSets (void);
void             DrawAllSets (void);
void             DrawAxisProc (double AcenX,double AcenY,double AcenZ);
void             DrawClear (void);
int             DrawItem (int SetNum, int LineNum);
void            DrawSelectedSet (t_XmgfSet *SelectedSet);
int             DrawSet (int SetNum);
int             DrawSets (void);
void             DrawSingleItem (t_LL ListPolys);
void             DrawSingleSet (int SetNum);
void             InitDraw (void);
void             InitSets (void);
int             NewThreeDTwoD (double Dx, double Dy, double Dz);
int             ReDraw (void);
void             QuickReDraw (void);
void             SetSingleSetCol (int SetNum, int ColNum);
int             SetSingleSetPt (int SetNum, int PtNum);
void             SetVisible (int *SetNum, int *LineNum);
int             ThreeDTwoD (double x, double y, double z);
void             ThreeDxyz (double x, double y, double z, int direction);
void             UnDrawSingleSet (int SetNum);
void             UpDateVisible (void);
void             makesintab (void);
t_LL            DrawSingleLineofSet (int SetNum, int LineNum);
t_LL            NewDrawSingleLineofSet (int SetNum, int LineNum);
t_LL            NewSingleLine (int SetNum, int LineNum);
void     	NextLine (int *SetNum, int *LineNum);
void     	PrevLine (int *SetNum, int *LineNum);
t_XmgfLine     *SelectLine (int *SetNum, int *LineNum);
t_XmgfPoly      PointVisible (t_XmgfPoly *Poly);
t_XmgfPoly      visible (t_XmgfPoly *Poly);
t_XmgfSet      *SelectSet (int *SetNum);
void		UpdateRotationParms(void);
void 		GetMaxDepth(t_LL PolyList,double *MaxDepth,double *MinDepth);
t_XmgfPt 	FindYInt(t_XmgfPt *Pt1,t_XmgfPt *Pt2,int k);
t_XmgfPt 	FindXInt(t_XmgfPt *Pt1,t_XmgfPt *Pt2,int k);
t_LL 		Clip2D(t_LL Points);
t_LL		FindBoundingBox(t_LL PolyList);
void 		FindVisibleInBox(double vbx1,double vby1,double vbx2,double vby2);
void            MakeLookPt(void);
#else
double           Sin2 ();
double           dc2 ();
double           ds2 ();
void             Draw3DSet ();
void             DrawAll3DSets ();
void             DrawAllSets ();
void             DrawAxisProc ();
void             DrawClear ();
int             DrawItem ();
void             DrawSelectedSet ();
int             DrawSet ();
int             DrawSets ();
void             DrawSingleItem ();
void             DrawSingleSet ();
void             InitDraw ();
void             InitSets ();
int             NewThreeDTwoD ();
int             ReDraw ();
void             QuickReDraw ();
void             SetSingleSetCol ();
int             SetSingleSetPt ();
void             SetVisible ();
int             ThreeDTwoD ();
void             ThreeDxyz ();
void             UnDrawSingleSet ();
void             UpDateVisible ();
void             makesintab ();
t_LL            DrawSingleLineofSet ();
t_LL            NewDrawSingleLineofSet ();
t_LL            NewSingleLine ();
void     	NextLine ();
void     	PrevLine ();
t_XmgfLine     *SelectLine ();
t_XmgfPoly      PointVisible ();
t_XmgfPoly      visible ();
t_XmgfSet      *SelectSet ();
void		UpdateRotationParms();
void 		GetMaxDepth();
t_XmgfPt 	FindYInt();
t_XmgfPt 	FindXInt();
void 		FindVisibleInBox();
t_LL 		Clip2D();
void            MakeLookPt();
#endif
