
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include "filter.h"

FILE *InputFile;
FILE *OutputFile;

int main(argc, argv)
int argc; char **argv;
	{
	char SingleLineBuffer[MAX_LINE_LEN];
	char Tokens[MAX_NUMB_TOKEN][MAX_TOKEN_LEN];
	int LineCounter, SideCount, PolyCount, VertixCount, i, j;
	int ShapeCount, VertixID, PositionInLine;
	char GeneralBuffer[MAX_NAME_LEN];
	char *VertixStrings;

	fprintf(stderr,"igrip2gf Filter :- D.Johnston 1993-Nov-04\n");

	/* check command line arguments, supply extensions and/or
	output file name if required */
	if( !CheckAndOpenFiles( argc, argv ))
	        exit(-1);

	WriteOutput( ";This file produced from igrip2gf filter\n");
	WriteOutput( ";It contains only Polygon3D objects\n");

	/* the Igrip output file does not label the polygons, and there
	 *  are no text labels for any internal parts.  We will just have
	 *  to read past the fixed header until we get to the number
	 *  of sets (shapes) defined in this file.
	 */
	fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
	fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
	fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
	fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
	LineCounter = 4;

	/* now read (and discard) the number of shapes/sets */
	fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
	LineCounter++;
	/* we will use a dummy name for the sets */
	ShapeCount = 1;
	/* Now... we can get to work */
	while( fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile) != NULL )
		{
		LineCounter++;
		sscanf( SingleLineBuffer, "%s", Tokens[0]);
		
		/* check for any tokens we recognize */
		/* first look for a new set name  */
		if( strncmp(Tokens[0], NAME, strlen(NAME)) == 0 )
		   {
                   /* use the dummy name as the new set name,  */
                   sprintf(GeneralBuffer, "@Set %s%d\nFormat Polygon3D\n",POLYNAME,ShapeCount++);
                   WriteOutput( GeneralBuffer );
        	   }

		/* now read the number of verticies into the array  */
		fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
		LineCounter++;
		sscanf( SingleLineBuffer, "%d", &VertixCount );
		/* allocate the space for the vertix array */
		VertixStrings = calloc( (size_t)VertixCount, (size_t)MAX_LENGTH_VERTIX );

		/* and read all the verticies (as strings) */
		for(j=0; j<VertixCount ; j++)
			{
			fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
			/* remove the trailing newline */
			SingleLineBuffer[ strlen(SingleLineBuffer)-1 ] = '\0';
			strcpy(&VertixStrings[MAX_LENGTH_VERTIX*j], SingleLineBuffer );
			LineCounter++;
			}
		/* now we can read past the trailing line */
		fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
		LineCounter++;
		if( strncmp( SingleLineBuffer, ENDNAME, strlen(ENDNAME)) != 0) 
			FormatError( LineCounter );

		/* now we should be reading the number of polygons in the group,
		 *  which is information we use to cycle through the list.
		 */
		fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
		LineCounter++;
		sscanf( SingleLineBuffer, "%d", &PolyCount );

		/* now we read in the lines of polygons */
		for( j=1; j<=PolyCount; j++)
			{
			/* read a line; number of sides and the verticies */
			fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
			LineCounter++;
			sscanf( SingleLineBuffer, "%d %d", &SideCount, &VertixID );
			/* write number of sides and first set of vertices  */
			sprintf( GeneralBuffer, "%d %s \\\n", SideCount,
			            &VertixStrings[MAX_LENGTH_VERTIX*VertixID]);
			WriteOutput( GeneralBuffer );
			/* for the rest of the line, skip past the number just read
			 *  and then output the corresponding vertix 
			 */
			/* calculate the position in the input string */
			/* to calculate the length of the vertix number in chars we
			 *  can fool aroung with int-to-ascii and strlen, or we can..
			 */
			if( SideCount < 10 ) PositionInLine = 2;
			else if( SideCount < 100) PositionInLine = 3;
			else PositionInLine = 4;  /* we assume a side count no. < 1000 */
			if( VertixID < 10 ) PositionInLine += 2;
			else if( VertixID < 100) PositionInLine += 3;
			else PositionInLine += 4;  /* we assume a vertix ID no. < 1000 */
			for( i=1; i<SideCount-1; i++)
				{
				/* if the current input line is used up, continue on the next
				 *  line (after allowing for the indent ) */
				if( PositionInLine >= strlen( SingleLineBuffer ) )
					{
					/* get another line of vertix IDs  */
					fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
					LineCounter++;
					PositionInLine = 3;
					}
				sscanf( &SingleLineBuffer[PositionInLine], "%d", &VertixID );
				/* to calculate the length of the vertix number in chars we
				 *  can fool aroung with int-to-ascii and strlen, or we can..
				 */
				if( VertixID < 10 ) PositionInLine += 2;
				else if( VertixID < 100) PositionInLine += 3;
				else PositionInLine += 4;  /* we assume a vertix ID no. < 1000 */
				sprintf( GeneralBuffer, "%s \\\n", 
					&VertixStrings[MAX_LENGTH_VERTIX*VertixID]);
				WriteOutput( GeneralBuffer );
				}
			/* last vertix is a special case for output (no '\') */
			sscanf( &SingleLineBuffer[PositionInLine], "%d", &VertixID );
			sprintf( GeneralBuffer, "%s\n",
				 &VertixStrings[MAX_LENGTH_VERTIX*VertixID]);
			WriteOutput( GeneralBuffer );
			} /* end of for all polygons */

		/* each 'set' of polygons is terminated */
        	WriteOutput("@\n");
			
		/* now we can read past the trailing line */
		fgets(SingleLineBuffer,MAX_LINE_LEN,InputFile);
		LineCounter++;
		if( strncmp( SingleLineBuffer, ENDNAME, strlen(ENDNAME)) != 0) 
			FormatError( LineCounter );

		/*  free the memory holding the vertix strings */
		free( VertixStrings );

		} /* end of outer while loop */

	/* close the output file, close input, exit */
	close(InputFile);
	close(OutputFile);
	fprintf(stderr,"Conversion complete, %d lines in input file\n", LineCounter);
	return 0;
	}
