#!/bin/sh
#
# @(#)install.sh	2.15 94/01/26
#
# Script to install xmcd software binary and support files on
# the target system.
#
#    xmcd - Motif(tm) CD Audio Player
#
#    Copyright (C) 1994  Ti Kan
#    E-mail: ti@amb.org
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

PATH=/bin:/usr/bin:/sbin:/usr/sbin:/etc:/usr/local/bin
export PATH

CATEGORIES="rock jazz newage classical soundtrack misc data"
XMCD_VER="1.1"
DEMODB=4102560a

#
# Utility functions
#

getstr()
{
	$ECHO "$* \c"
	read ANS
	if [ -n "$ANS" ]
	then
		return 0
	else
		return 1
	fi
}

getyn()
{
	if [ -z "$YNDEF" ]
	then
		YNDEF=y
	fi

	while :
	do
		$ECHO "$*? [${YNDEF}] \c"
		read ANS
		if [ -n "$ANS" ]
		then
			case $ANS in
			[yY])
				RET=0
				break
				;;
			[nN])
				RET=1
				break
				;;
			*)
				$ECHO "Please answer y or n"
				;;
			esac
		else
			if [ $YNDEF = y ]
			then
				RET=0
			else
				RET=1
			fi
			break
		fi
	done

	YNDEF=
	return $RET
}

dolink()
{
	# Try symlink first
	ln -s $1 $2 2>/dev/null
	if [ $? != 0 ]
	then
		# Use hard link
		ln $1 $2 2>/dev/null
	fi
	STATUS=$?
	if [ $STATUS != 0 ]
	then
		$ECHO "Error: Cannot link $1 -> $2"
	fi
}

makedir()
{
	$ECHO "\t$1"
	if [ ! -d $1 ]
	then
		mkdir -p $1
	fi
	chmod $2 $1 2>/dev/null
	chown $3 $1 2>/dev/null
	chgrp $4 $1 2>/dev/null
	return 0
}

instfile()
{
	TDIR=`dirname $2`

	if [ -n "$TDIR" -a -d "$TDIR" -a -w "$TDIR" ]
	then
		$ECHO "\t$2"
		if [ -f $2 ]
		then
			rm -f $2
		fi

		cp $1 $2

		if [ -f $2 ]
		then
			chmod $3 $2 2>/dev/null
			chown $4 $2 2>/dev/null
			chgrp $5 $2 2>/dev/null
		fi
		return 0
	else
		$ECHO "\t$2 NOT installed"
		ERROR=1
		return 1
	fi
}


#
# Main execution starts here
#

ERROR=0

# Use Sysv echo if possible
if [ -x /usr/5bin/echo ]				# SunOS SysV echo
then
	ECHO=/usr/5bin/echo
elif [ -z "`(echo -e a) 2>/dev/null | fgrep e`" ]	# GNU bash, etc.
then
	ECHO="echo -e"
else							# generic SysV
	ECHO=echo
fi

# If awk doesn't work well on your system, try changing the
# following to nawk or gawk.
AWK=awk

NOREMOVE=0
if [ $# -eq 1 -a "$1" = "-n" ]
then
	NOREMOVE=1
fi

(id | fgrep 'uid=0(root)') >/dev/null 2>&1
if [ $? != 0 ]
then
	$ECHO "Warning: You should be the super user to install xmcd."

	YNDEF=n
	if getyn "Proceed anyway"
	then
		$ECHO "\nSome files may not be successfully installed without"
		$ECHO "super user privilege.\n"
	else
		exit 1
	fi
fi

# Sanity check
if [ ! -f xmcd -o ! -f XMcd.ad -o ! -f dev.config -o ! -f configure.sh ]
then
	$ECHO "Error: missing files."
	exit 1
fi


# Implement platform-specific features and deal with OS quirks
SCO=0
SHELL=/bin/sh
if (uname -X | fgrep "Release = 3.2") >/dev/null 2>&1
then
	SCO=1
fi
if [ "`(uname -s) 2>/dev/null`" = ULTRIX ]
then
	SHELL=/bin/sh5
fi


$ECHO "Installing \"xmcd\" Motif CD Player version $XMCD_VER by Ti Kan"


# Determine BINDIR

if [ -z "$BINDIR" ]
then
	BINDIR=/usr/bin/X11

	if [ -d /usr/X/bin ]
	then
		BINDIR=/usr/X/bin
	elif [ -d /usr/X386/bin ]
	then
		BINDIR=/usr/X386/bin
	elif [ -d /usr/local/bin/X11 ]
	then
		BINDIR=/usr/local/bin/X11
	elif [ -d /usr/local/bin ]
	then
		BINDIR=/usr/local/bin
	elif [ -d /usr/lbin ]
	then
		BINDIR=/usr/lbin
	fi
else
	BINDIR=`echo $BINDIR | sed 's/\/\//\//g'`
fi

while :
do
	if getstr "\nEnter X binary directory [${BINDIR}]:"
	then
		if [ -d "$ANS" ]
		then
			BINDIR=$ANS
			break
		else
			$ECHO "Error: $ANS does not exist."
		fi
	else
		break
	fi
done


# Determine LIBDIR

if [ -z "$LIBDIR" ]
then
	LIBDIR=/usr/lib/X11

	if [ -d /usr/X/lib ]
	then
		LIBDIR=/usr/X/lib
	elif [ -d /usr/X386/lib/X11 ]
	then
		LIBDIR=/usr/X386/lib/X11
	elif [ -d /usr/local/lib/X11 ]
	then
		LIBDIR=/usr/local/lib/X11
	fi
else
	LIBDIR=`echo $LIBDIR | sed 's/\/\//\//g'`
fi

while :
do
	if getstr "\nEnter X library directory [${LIBDIR}]:"
	then
		if [ -d "$ANS" ]
		then
			LIBDIR=$ANS
			break
		else
			$ECHO "Error: $ANS does not exist."
		fi
	else
		break
	fi
done


# Determine MANFILE

if [ -z "$MANFILE" ]
then
	MANFILE=/usr/man/man1/xmcd.1

	if [ -d /usr/man/man.LOCAL ]
	then
		MANFILE=/usr/man/man.LOCAL/xmcd.LOCAL
	elif [ -d /usr/local/man/man1 ]
	then
		MANFILE=/usr/local/man/man1/xmcd.1
	fi
else
	MANFILE=`echo $MANFILE | sed 's/\/\//\//g'`
fi

if getstr "\nEnter xmcd on-line manual file path [${MANFILE}]:"
then
	MANFILE=$ANS
fi

MANDIR=`dirname $MANFILE`
if [ ! -d $MANDIR ]
then
	YNDEF=y
	if getyn "Directory $MANDIR does not exist.  Create it"
	then
		makedir $MANDIR 755 bin bin
	else
		$ECHO "The xmcd on-line manual will not be installed."
		MANFILE=
		MANDIR=
	fi
fi

# Determine WMANFILE

WMANFILE="`dirname $MANFILE`/`basename $MANFILE | sed 's/xmcd/wm2xmcd/'`"
if getstr "\nEnter wm2xmcd on-line manual file path [${WMANFILE}]:"
then
	WMANFILE=$ANS
fi

WMANDIR=`dirname $WMANFILE`
if [ ! -d $WMANDIR ]
then
	YNDEF=y
	if getyn "Directory $WMANDIR does not exist.  Create it"
	then
		makedir $WMANDIR 755 bin bin
	else
		$ECHO "The wm2xmcd on-line manual will not be installed."
		WMANFILE=
		WMANDIR=
	fi
fi


# Make all necessary directories

$ECHO "\nMaking directories..."

makedir $LIBDIR/xmcd 755 bin bin
makedir $LIBDIR/xmcd/config 755 bin bin
makedir $LIBDIR/xmcd/config/.tbl 755 bin bin
makedir $LIBDIR/xmcd/help 755 bin bin
makedir $LIBDIR/xmcd/cddb 755 bin bin

for i in $CATEGORIES
do
	makedir $LIBDIR/xmcd/cddb/$i 777 bin bin
done


# Install files
$ECHO "\nInstalling xmcd files..."

instfile xmcd $BINDIR/xmcd 4711 root bin
instfile wm2xmcd/wm2xmcd $BINDIR/wm2xmcd 711 bin bin

if instfile XMcd.ad $LIBDIR/app-defaults/XMcd 444 bin bin &&
   [ $LIBDIR != "/usr/lib/X11" -a -d /usr/lib/X11/app-defaults ]
then
	# Test LIBDIR
	rm -f /usr/lib/X11/app-defaults/._junk_

	>$LIBDIR/app-defaults/._junk_

	if [ ! -f /usr/lib/X11/app-defaults/._junk_ ]
	then
		rm -f /usr/lib/X11/app-defaults/XMcd
		dolink $LIBDIR/app-defaults/XMcd /usr/lib/X11/app-defaults/XMcd
	fi

	rm -f $LIBDIR/app-defaults/._junk_
fi

for i in helpfiles/*Btn helpfiles/*Ind helpfiles/*Txt \
	 helpfiles/*Scale helpfiles/*List helpfiles/*Box
do
	j=`echo $i | sed 's/helpfiles\///'`
	instfile $i $LIBDIR/xmcd/help/$j 444 bin bin
done

instfile demo.cddb $LIBDIR/xmcd/cddb/misc/$DEMODB 444 bin bin
instfile dev.config $LIBDIR/xmcd/config/dev.config 444 bin bin

ENTRIES=`(cd cfgtbl; echo * | \
	sed -e 's/Imakefile//' -e 's/Makefile//' -e 's/SCCS//' -e 's/RCS//')`
for i in $ENTRIES
do
	if (fgrep "tblver=" cfgtbl/$i) >/dev/null 2>&1
	then
		instfile cfgtbl/$i $LIBDIR/xmcd/config/.tbl/$i 444 bin bin
	fi
done

$AWK '
	/^LIBDIR=/	{ printf("LIBDIR=%s\n", libdir) }
	!/^LIBDIR=/	{ print $0 }
' libdir=$LIBDIR configure.sh >/tmp/xmcdcfg.$$

instfile /tmp/xmcdcfg.$$ $LIBDIR/xmcd/config/configure.sh 755 bin bin
rm -f /tmp/xmcdcfg.$$

if [ ! -f $LIBDIR/XKeysymDB ]
then
	instfile XKeysymDB $LIBDIR/XKeysymDB 644 bin bin
fi

if [ "$SCO" = 1 ]
then
	if [ -w /usr/lib/mkdev ]
	then
		$ECHO "\t/usr/lib/mkdev/xmcd"
		rm -f /usr/lib/mkdev/xmcd
		dolink $LIBDIR/xmcd/config/configure.sh /usr/lib/mkdev/xmcd
	fi
fi

if [ -n "$MANFILE" ]
then
	instfile xmcd.man $MANFILE 644 bin bin
fi
if [ -n "$WMANFILE" ]
then
	instfile wm2xmcd/wm2xmcd.man $WMANFILE 644 bin bin
fi


# Run device-dependent config script
if [ -r $LIBDIR/xmcd/config/configure.sh ]
then
	$SHELL $LIBDIR/xmcd/config/configure.sh
	if [ $? != 0 ]
	then
		ERROR=$?
	fi
else
	$ECHO "Error: Cannot execute $LIBDIR/xmcd/config/configure.sh."
	ERROR=1
fi

if [ $NOREMOVE = 0 ]
then
	rm -rf xmcd XMcd.ad cfgtbl demo.cddb dev.config helpfiles install.sh \
		configure.sh XKeysymDB xmcd.man xmcd.tar wm2xmcd
fi
if [ $ERROR = 0 ]
then
	$ECHO "\nInstallation of xmcd is now complete."
else
	$ECHO "\nErrors have occurred in the installation."
fi

exit $ERROR
